/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.Casing;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreePatternNode<Naming extends BaseNaming> {
    public static final Comparator<TreePatternNode<?>> BY_FIRST = (n1, n2) -> Comparing.compare((Comparable)((Comparable)ArrayUtil.getFirstElement((Object[])((BaseNaming)n1.naming).names)), (Comparable)((Comparable)ArrayUtil.getFirstElement((Object[])((BaseNaming)n2.naming).names)));
    public static final Group[] NO_GROUPS = new Group[0];
    public final Naming naming;
    @NotNull
    public final Group[] groups;

    public <N extends BaseNaming> TreePatternNode<N> tryCast(Class<? extends N> clazz) {
        if (!clazz.isAssignableFrom(this.naming.getClass())) {
            return null;
        }
        return this;
    }

    public TreePatternNode(@NotNull Naming naming, @NotNull Group[] groups) {
        if (naming == null) {
            TreePatternNode.$$$reportNull$$$0(0);
        }
        if (groups == null) {
            TreePatternNode.$$$reportNull$$$0(1);
        }
        this.naming = naming;
        this.groups = groups;
        assert (TreePatternUtils.isValid(this));
    }

    @Nullable
    public Group getGroup(@Nullable ObjectKind kind) {
        if (kind != null) {
            for (Group group2 : this.groups) {
                if (group2.kind != kind) continue;
                return group2;
            }
        }
        return null;
    }

    public boolean matchedChildren(@Nullable ObjectName name2, @NotNull Casing casing, @NotNull ObjectKind kind, @NotNull Collection<TreePatternNode<?>> matched) {
        Group group2;
        if (casing == null) {
            TreePatternNode.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            TreePatternNode.$$$reportNull$$$0(3);
        }
        if (matched == null) {
            TreePatternNode.$$$reportNull$$$0(4);
        }
        return (group2 = this.getGroup(kind)) != null && group2.matchedChildren(name2, casing, matched);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreePatternNode node = (TreePatternNode)o;
        if (!((BaseNaming)this.naming).equals(node.naming)) {
            return false;
        }
        return Arrays.equals(this.groups, node.groups);
    }

    public int hashCode() {
        int result2 = ((BaseNaming)this.naming).hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.groups);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "naming";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matched";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/util/TreePatternNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "matchedChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Group {
        public static final Comparator<Group> BY_KIND = (g1, g2) -> Comparing.compare((Comparable)g1.kind, (Comparable)g2.kind);
        public final ObjectKind kind;
        @Nullable
        public final TreePatternNode<PositiveNaming>[] positiveChildren;
        @Nullable
        public final TreePatternNode<NegativeNaming> negativeChild;
        private Integer myHashCode;

        public Group(@NotNull ObjectKind kind, @Nullable TreePatternNode<PositiveNaming>[] children2, @Nullable TreePatternNode<NegativeNaming> antiPattern) {
            if (kind == null) {
                Group.$$$reportNull$$$0(0);
            }
            this(kind, children2, antiPattern, true);
        }

        protected Group(@NotNull ObjectKind kind, @Nullable TreePatternNode<PositiveNaming>[] children2, @Nullable TreePatternNode<NegativeNaming> antiPattern, boolean validate) {
            if (kind == null) {
                Group.$$$reportNull$$$0(1);
            }
            this.kind = kind;
            this.positiveChildren = children2;
            this.negativeChild = antiPattern;
        }

        public boolean matchedChildren(@Nullable ObjectName name2, @Nullable(value="exact match") @Nullable(value="exact match") Casing casing, @Nullable Collection<TreePatternNode<?>> matched) {
            boolean m = false;
            if (this.positiveChildren != null) {
                for (TreePatternNode<PositiveNaming> child : this.positiveChildren) {
                    if (!((PositiveNaming)child.naming).matches(name2, casing)) continue;
                    if (matched != null) {
                        matched.add(child);
                    }
                    m = true;
                }
            }
            if (this.negativeChild != null && ((NegativeNaming)this.negativeChild.naming).matches(name2, casing)) {
                if (matched != null) {
                    matched.add(this.negativeChild);
                }
                m = true;
            }
            return m;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Group group2 = (Group)o;
            if (group2.hashCode() != this.hashCode()) {
                return false;
            }
            if (!this.kind.equals(group2.kind)) {
                return false;
            }
            if (this.negativeChild != null ? !this.negativeChild.equals(group2.negativeChild) : group2.negativeChild != null) {
                return false;
            }
            return Arrays.equals(this.positiveChildren, group2.positiveChildren);
        }

        public int hashCode() {
            if (this.myHashCode != null) {
                return this.myHashCode;
            }
            int result2 = this.kind.hashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.positiveChildren);
            result2 = 31 * result2 + (this.negativeChild != null ? this.negativeChild.hashCode() : 0);
            this.myHashCode = result2;
            return this.myHashCode;
        }

        public int size() {
            return (this.negativeChild == null ? 0 : 1) + (this.positiveChildren == null ? 0 : this.positiveChildren.length);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/util/TreePatternNode$Group", "<init>"));
        }
    }

    public static class NegativeNaming
    extends BaseNaming {
        public static final NegativeNaming WILDCARD = new NegativeNaming(ObjectName.EMPTY_ARRAY);

        public NegativeNaming(ObjectName ... antiNames) {
            if (antiNames == null) {
                NegativeNaming.$$$reportNull$$$0(0);
            }
            super(antiNames);
        }

        @Override
        public boolean matches(@Nullable ObjectName name2, @Nullable(value="exact match") @Nullable(value="exact match") Casing casing) {
            return name2 == null || this.find(name2, casing) == null;
        }

        @NotNull
        public ObjectName[] getAntiNames() {
            if (this.names == null) {
                NegativeNaming.$$$reportNull$$$0(1);
            }
            return this.names;
        }

        public String toString() {
            return this.names.length == 0 ? "*" : "*, -" + StringUtil.join((Object[])this.names, n -> n.name.length() == 0 ? "()" : n.toString(), (String)", -");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "antiNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/TreePatternNode$NegativeNaming";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/TreePatternNode$NegativeNaming";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAntiNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PositiveNaming
    extends BaseNaming {
        public PositiveNaming(ObjectName ... names) {
            if (names == null) {
                PositiveNaming.$$$reportNull$$$0(0);
            }
            super(names);
            assert (names.length != 0) : "Empty positive naming";
        }

        @Override
        public boolean matches(@Nullable ObjectName name2, @Nullable(value="exact match") @Nullable(value="exact match") Casing casing) {
            return name2 == null || this.find(name2, casing) != null;
        }

        @NotNull
        public ObjectName[] getNames() {
            if (this.names == null) {
                PositiveNaming.$$$reportNull$$$0(1);
            }
            return this.names;
        }

        public String toString() {
            return StringUtil.join((Object[])this.names, n -> n.name.length() == 0 ? "()" : n.toString(), (String)", ");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/TreePatternNode$PositiveNaming";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/TreePatternNode$PositiveNaming";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseNaming {
        public final ObjectName[] names;

        public BaseNaming(@NotNull ObjectName[] names) {
            if (names == null) {
                BaseNaming.$$$reportNull$$$0(0);
            }
            this.names = names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseNaming naming = (BaseNaming)o;
            return Arrays.equals(this.names, naming.names);
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }

        public abstract boolean matches(@Nullable ObjectName var1, @Nullable(value="exact match") @Nullable(value="exact match") Casing var2);

        public ObjectName find(@NotNull ObjectName name2, @Nullable(value="exact match") @Nullable(value="exact match") Casing casing) {
            if (name2 == null) {
                BaseNaming.$$$reportNull$$$0(1);
            }
            for (ObjectName n : this.names) {
                if (!(casing == null ? name2.equals((Object)n) : name2.equals(n, casing))) continue;
                return n;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/TreePatternNode$BaseNaming";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "find";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

