/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scopes;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.scopes.DataSourcePackageSet;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetParserExtension;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPackageSetParserExtension
implements PackageSetParserExtension {
    private static final Pattern UUID = Pattern.compile("ds\\[((?:[^]]|]])+)]");

    @Nullable
    public PackageSet parsePackageSet(Lexer lexer, String scope, String modulePattern) {
        if (modulePattern != null || scope == null) {
            return null;
        }
        return new DataSourcePackageSet(scope);
    }

    @Nullable
    public String parseScope(Lexer lexer) {
        int start = lexer.getTokenStart();
        CharSequence buf = lexer.getBufferSequence();
        if (!StringUtil.startsWith((CharSequence)buf, (int)start, (CharSequence)"ds[")) {
            return null;
        }
        Matcher matcher = UUID.matcher(buf);
        matcher.region(start, lexer.getBufferEnd());
        if (!matcher.lookingAt()) {
            return null;
        }
        lexer.start(buf, matcher.end(), lexer.getBufferEnd());
        return matcher.group(1).replace("]]", "]");
    }

    @NotNull
    public static String compose(@NotNull DasDataSource ds) {
        if (ds == null) {
            DbPackageSetParserExtension.$$$reportNull$$$0(0);
        }
        String string = DbPackageSetParserExtension.compose(ds.getName());
        if (string == null) {
            DbPackageSetParserExtension.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String compose(@NotNull String name2) {
        if (name2 == null) {
            DbPackageSetParserExtension.$$$reportNull$$$0(2);
        }
        String string = "ds[" + name2.replace("]", "]]") + "]";
        if (string == null) {
            DbPackageSetParserExtension.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/scopes/DbPackageSetParserExtension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/scopes/DbPackageSetParserExtension";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compose";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

