/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.TypePresentationService;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbFavoriteNodeProvider
extends FavoriteNodeProvider {
    private final Project myProject;

    public DbFavoriteNodeProvider(Project project) {
        this.myProject = project;
    }

    @Nullable
    public Collection<AbstractTreeNode> getFavoriteNodes(DataContext context, @NotNull ViewSettings viewSettings) {
        Project project;
        if (viewSettings == null) {
            DbFavoriteNodeProvider.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
            return Collections.emptyList();
        }
        return JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context))).filterMap(psi -> this.createNode(project, psi, viewSettings)).toList();
    }

    @Nullable
    public AbstractTreeNode createNode(Project project, Object element2, @NotNull ViewSettings viewSettings) {
        if (viewSettings == null) {
            DbFavoriteNodeProvider.$$$reportNull$$$0(1);
        }
        if (!(element2 instanceof DbElement)) {
            return null;
        }
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)((DbElement)element2).getVirtualFile();
        return file == null ? null : new DbElementNode(project, file, viewSettings);
    }

    public boolean elementContainsFile(Object element2, VirtualFile vFile) {
        return false;
    }

    public int getElementWeight(Object element2, boolean isSortByType) {
        return 0;
    }

    @Nullable
    public String getElementLocation(Object element2) {
        if (!(element2 instanceof DatabaseElementVirtualFileImpl)) {
            return null;
        }
        DbElement dbElement = ((DatabaseElementVirtualFileImpl)((Object)element2)).findElement(this.myProject);
        DbElement parent2 = dbElement == null ? null : dbElement.getDasParent();
        return parent2 == null ? null : ((DatabaseElementVirtualFileImpl)parent2.getVirtualFile()).getPresentablePath();
    }

    public boolean isInvalidElement(Object element2) {
        if (!(element2 instanceof DatabaseElementVirtualFileImpl)) {
            return false;
        }
        return !((DatabaseElementVirtualFileImpl)((Object)element2)).isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        if ("database" == null) {
            DbFavoriteNodeProvider.$$$reportNull$$$0(2);
        }
        return "database";
    }

    @Nullable
    public String getElementUrl(Object element2) {
        if (!(element2 instanceof DatabaseElementVirtualFileImpl)) {
            return null;
        }
        return ((DatabaseElementVirtualFileImpl)((Object)element2)).getUrl();
    }

    @Nullable
    public String getElementModuleName(Object element2) {
        if (!(element2 instanceof DatabaseElementVirtualFileImpl)) {
            return null;
        }
        DbElement dbElement = ((DatabaseElementVirtualFileImpl)((Object)element2)).findElement(this.myProject);
        SqlElement sql = dbElement != null ? DbSqlUtil.getSqlElement(dbElement) : null;
        Module module = sql == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)sql);
        return module != null && !ModuleType.isInternal((Module)module) ? module.getName() : null;
    }

    @Nullable
    public Object[] createPathFromUrl(Project project, String url, String moduleName) {
        Object[] objectArray;
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file instanceof DatabaseElementVirtualFileImpl) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = file;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @Nullable
    public PsiElement getPsiElement(Object element2) {
        if (!(element2 instanceof DatabaseElementVirtualFileImpl)) {
            return null;
        }
        return ((DatabaseElementVirtualFileImpl)((Object)element2)).findElement(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbFavoriteNodeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbFavoriteNodeProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoriteTypeId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFavoriteNodes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DbElementNode
    extends AbstractPsiBasedNode<DatabaseElementVirtualFileImpl> {
        public DbElementNode(Project project, @NotNull DatabaseElementVirtualFileImpl value, ViewSettings settings) {
            if (value == null) {
                DbElementNode.$$$reportNull$$$0(0);
            }
            super(project, (Object)value, settings);
        }

        @Nullable
        protected PsiElement extractPsiFromValue() {
            DatabaseElementVirtualFileImpl value = (DatabaseElementVirtualFileImpl)((Object)this.getValue());
            return value == null ? null : value.findElement(this.getProject());
        }

        @Nullable
        protected Collection<AbstractTreeNode> getChildrenImpl() {
            return null;
        }

        protected void updateImpl(@NotNull PresentationData presentation) {
            DatabaseElementVirtualFileImpl value;
            if (presentation == null) {
                DbElementNode.$$$reportNull$$$0(1);
            }
            if ((value = (DatabaseElementVirtualFileImpl)((Object)this.getValue())) == null) {
                return;
            }
            presentation.setPresentableText(value.getName());
            presentation.setIcon(TypePresentationService.getService().getIcon((Object)value));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/psi/DbFavoriteNodeProvider$DbElementNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

