/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.database.Dbms;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.CassIndexColumn;
import com.intellij.database.model.properties.CassKeyColumn;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Db2CommitOnReturnPolicy;
import com.intellij.database.model.properties.Db2DataTypeSubKind;
import com.intellij.database.model.properties.Db2GeneratedColumnKind;
import com.intellij.database.model.properties.Db2IndexXmlTypeModel;
import com.intellij.database.model.properties.Db2NullInputAction;
import com.intellij.database.model.properties.Db2ParameterStyle;
import com.intellij.database.model.properties.Db2PartitionMode;
import com.intellij.database.model.properties.Db2ProgramType;
import com.intellij.database.model.properties.Db2RoutineSqlAccess;
import com.intellij.database.model.properties.Db2SavepointLevel;
import com.intellij.database.model.properties.Db2TableClustering;
import com.intellij.database.model.properties.ExaScriptType;
import com.intellij.database.model.properties.GPlumExternalTableFormat;
import com.intellij.database.model.properties.GPlumExternalTableRejectLimitType;
import com.intellij.database.model.properties.GPlumPartitionKind;
import com.intellij.database.model.properties.GPlumPartitionTree;
import com.intellij.database.model.properties.HiveTableColumnSortingOrder;
import com.intellij.database.model.properties.HiveTableColumnType;
import com.intellij.database.model.properties.MsRoutineType;
import com.intellij.database.model.properties.MsServerType;
import com.intellij.database.model.properties.MysqlColumnKind;
import com.intellij.database.model.properties.MysqlEventStatus;
import com.intellij.database.model.properties.OraCollectionTypeKind;
import com.intellij.database.model.properties.OraMatViewRefreshMethod;
import com.intellij.database.model.properties.OraMatViewRefreshMode;
import com.intellij.database.model.properties.OraTableType;
import com.intellij.database.model.properties.PgAccessMethodType;
import com.intellij.database.model.properties.PgAggregateKind;
import com.intellij.database.model.properties.PgCheckOption;
import com.intellij.database.model.properties.PgDataTypeSubCategory;
import com.intellij.database.model.properties.PgDataTypeSubKind;
import com.intellij.database.model.properties.PgFireMode;
import com.intellij.database.model.properties.PgIdentityKind;
import com.intellij.database.model.properties.PgOperatorKind;
import com.intellij.database.model.properties.PgRelation;
import com.intellij.database.model.properties.PgRoutineConcurrencyKind;
import com.intellij.database.model.properties.PgVolatilityKind;
import com.intellij.database.model.properties.RsExternalTableStorageType;
import com.intellij.database.model.properties.RsTableBackupMode;
import com.intellij.database.model.properties.RsTableDistStyle;
import com.intellij.database.model.properties.SFlakeTableKind;
import com.intellij.database.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.model.properties.VertRoutineType;
import com.intellij.database.util.CalendarFun;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertyConverter {
    public static final Logger ourLog = Logger.getInstance(PropertyConverter.class);

    public static String export(boolean value) {
        return value ? "1" : "0";
    }

    public static String export(byte value) {
        return Byte.toString(value);
    }

    public static String export(short value) {
        return Short.toString(value);
    }

    public static String export(int value) {
        return Integer.toString(value);
    }

    public static String export(long value) {
        return Long.toString(value);
    }

    public static String export(float value) {
        return Float.toString(value);
    }

    public static String export(double value) {
        return Double.toString(value);
    }

    @Nullable
    public static String export(@NotNull String string) {
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(0);
        }
        return StringUtil.nullize((String)string);
    }

    public static String export(@NotNull Date timestamp) {
        if (timestamp == null) {
            PropertyConverter.$$$reportNull$$$0(1);
        }
        return CalendarFun.export(timestamp);
    }

    public static String export(@NotNull ObjectKind kind) {
        if (kind == null) {
            PropertyConverter.$$$reportNull$$$0(2);
        }
        return kind.code();
    }

    public static String export(@NotNull BigInteger bigInteger) {
        if (bigInteger == null) {
            PropertyConverter.$$$reportNull$$$0(3);
        }
        return bigInteger.toString();
    }

    public static String export(@NotNull DataType dt) {
        if (dt == null) {
            PropertyConverter.$$$reportNull$$$0(4);
        }
        return DataTypeFactory.serialize(dt);
    }

    public static String export(@NotNull SequenceIdentity si) {
        if (si == null) {
            PropertyConverter.$$$reportNull$$$0(5);
        }
        return si.getSpecification();
    }

    public static String export(@NotNull Enum item) {
        if (item == null) {
            PropertyConverter.$$$reportNull$$$0(6);
        }
        return StringUtil.toLowerCase((String)item.name()).replace('_', '-');
    }

    public static String export(@NotNull ArgumentDirection dir) {
        if (dir == null) {
            PropertyConverter.$$$reportNull$$$0(7);
        }
        return Character.toString(dir.code);
    }

    public static String export(@NotNull Casing casing) {
        if (casing == null) {
            PropertyConverter.$$$reportNull$$$0(8);
        }
        return casing.specification();
    }

    public static String export(@NotNull TableOrganization org) {
        if (org == null) {
            PropertyConverter.$$$reportNull$$$0(9);
        }
        return org.code;
    }

    public static String export(@NotNull Version version) {
        if (version == null) {
            PropertyConverter.$$$reportNull$$$0(10);
        }
        return version.toString();
    }

    public static String export(@NotNull Dbms dbms) {
        if (dbms == null) {
            PropertyConverter.$$$reportNull$$$0(11);
        }
        return dbms.getName();
    }

    public static String exportEnumCode(@NotNull Enum item) {
        Object value;
        if (item == null) {
            PropertyConverter.$$$reportNull$$$0(12);
        }
        Class<?> clazz = item.getClass();
        try {
            Field field = clazz.getField("code");
            value = field.get(item);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to serialize an item " + item.name() + " of class " + clazz.getName(), e);
        }
        return value != null ? value.toString() : null;
    }

    @Nullable
    public static String exportListOfShort(@NotNull List<Short> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(13);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportListOfLong(@NotNull List<Long> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(14);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportListOfInteger(@NotNull List<Integer> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(15);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportSetOfLong(@NotNull Set<Long> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(16);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportCollectionOfNumber(@NotNull Collection<? extends Number> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(17);
        }
        int n = numbers.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return numbers.iterator().next().toString();
            }
        }
        return StringUtil.join(numbers, (String)",");
    }

    @Nullable
    public static String exportListOfString(@NotNull List<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(18);
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportListOfNameValue(@NotNull List<NameValue> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(19);
        }
        if (strings.isEmpty()) {
            return null;
        }
        return StringUtil.join(strings, nv -> nv.getName() + "\n" + nv.getValue(), (String)"\n");
    }

    @Nullable
    public static String exportSetOfString(@NotNull Set<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(20);
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportCollectionOfString(@NotNull Collection<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(21);
        }
        int n = strings.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return PropertyConverter.escapeSlashN(strings.iterator().next());
            }
        }
        return StringUtil.join(strings, s -> PropertyConverter.escapeSlashN(s), (String)"\n");
    }

    @NotNull
    public static String escapeSlashN(String s) {
        String string = s.replace("\\", "\\\\").replace("\n", "\\n");
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(22);
        }
        return string;
    }

    public static String exportSetOfTrigEvent(@NotNull Set<TrigEvent> events) {
        if (events == null) {
            PropertyConverter.$$$reportNull$$$0(23);
        }
        StringBuilder b2 = new StringBuilder(events.size());
        for (TrigEvent event : events) {
            b2.append(event.code);
        }
        return b2.toString();
    }

    public static String exportSetOfPgRelation(@NotNull Set<PgRelation> dependencies) {
        if (dependencies == null) {
            PropertyConverter.$$$reportNull$$$0(24);
        }
        StringBuilder sb = new StringBuilder();
        for (PgRelation dependency : dependencies) {
            sb.append(dependency.export()).append("\n");
        }
        return sb.toString();
    }

    public static String export(@NotNull GPlumPartitionTree tree) {
        if (tree == null) {
            PropertyConverter.$$$reportNull$$$0(25);
        }
        return tree.serialize();
    }

    public static String exportListOfCassKeyColumn(List<CassKeyColumn> columns) {
        StringBuilder sb = new StringBuilder();
        for (CassKeyColumn column2 : columns) {
            sb.append(column2.export()).append("\n");
        }
        return sb.toString();
    }

    public static String exportListOfCassIndexColumn(List<CassIndexColumn> indexColumns) {
        StringBuilder sb = new StringBuilder();
        for (CassIndexColumn indexColumn : indexColumns) {
            sb.append(indexColumn.export()).append("\n");
        }
        return sb.toString();
    }

    public static boolean importBoolean(String text2) {
        char c2 = text2 != null && !text2.isEmpty() ? text2.charAt(0) : (char)'\u0000';
        c2 = Character.toUpperCase(c2);
        return c2 >= '1' && c2 <= '9' || c2 == 'Y' || c2 == 'T' || c2 == '+';
    }

    public static byte importByte(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Byte.parseByte(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static short importShort(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Short.parseShort(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int importInt(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long importLong(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static float importFloat(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static double importDouble(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static BigInteger importBigInteger(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return BigInteger.ZERO;
        }
        try {
            return new BigInteger(text2.trim());
        }
        catch (NumberFormatException e) {
            return BigInteger.ZERO;
        }
    }

    public static String importString(String text2) {
        return DbUtil.intern((String)text2);
    }

    public static ObjectKind importObjectKind(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return (ObjectKind)ObjectKind.ourKinds.get(StringUtil.toLowerCase((String)text2.trim()));
    }

    public static DataType importDataType(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return DataTypeFactory.deserialize(text2);
    }

    public static <E extends Enum> E importEnumByCode(Class<E> enumClass, String text2) {
        if (text2 == null) {
            return null;
        }
        int length = text2.length();
        Enum enumItem = null;
        try {
            Object o;
            Method methodWithChar = PropertyConverter.getStaticMethod(enumClass, "of", Character.TYPE);
            Method methodWithString = PropertyConverter.getStaticMethod(enumClass, "of", String.class);
            if (methodWithChar == null && methodWithString == null) {
                throw new IllegalArgumentException(String.format("Cannot import property of type %s: no static method of.", enumClass));
            }
            if (length == 1) {
                if (methodWithChar != null) {
                    Character c2 = Character.valueOf(text2.charAt(0));
                    o = methodWithChar.invoke(null, c2);
                } else {
                    o = methodWithString.invoke(null, text2);
                }
            } else if (methodWithString != null) {
                o = methodWithString.invoke(null, text2);
            } else {
                Character c3 = Character.valueOf(text2.charAt(0));
                o = methodWithChar.invoke(null, c3);
            }
            enumItem = (Enum)o;
        }
        catch (Exception e) {
            String message2 = String.format("Failed to import property value \"%s\" as enum %s: exception %s: %s", text2, enumClass.getSimpleName(), e.getClass().getSimpleName(), e.getMessage());
            if (ourLog.isDebugEnabled()) {
                ourLog.warn(message2, (Throwable)e);
            }
            ourLog.warn(message2);
        }
        return (E)enumItem;
    }

    public static DasRoutine.Kind importDasRoutineKind(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return DasRoutine.Kind.byChar((char)text2.charAt(0));
    }

    public static ArgumentDirection importArgumentDirection(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return ArgumentDirection.of((char)text2.charAt(0));
    }

    @Contract(value="null -> null")
    public static Date importDate(String text2) {
        if (text2 == null) {
            return null;
        }
        return CalendarFun.importSqlDateTime(text2);
    }

    @Contract(value="null -> null")
    public static Version importVersion(String text2) {
        if (text2 == null) {
            return null;
        }
        try {
            return Version.of((String)text2);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Contract(value="null -> null")
    public static Dbms importDbms(String text2) {
        if (text2 == null) {
            return null;
        }
        return Dbms.byName((String)text2);
    }

    @NotNull
    public static List<Short> importListOfShort(String text2) {
        List<Long> listOfLong = PropertyConverter.importListOfLong(text2);
        ArrayList<Short> listOfShort = new ArrayList<Short>(listOfLong.size());
        for (long value : listOfLong) {
            if (value < -32768L || value > 32767L) continue;
            listOfShort.add(new Short((short)value));
        }
        ArrayList<Short> arrayList = listOfShort;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    public static Set<Long> importSetOfLong(String text2) {
        Set<Long> set = PropertyConverter.convertListToSet(PropertyConverter.importListOfLong(text2));
        if (set == null) {
            PropertyConverter.$$$reportNull$$$0(27);
        }
        return set;
    }

    @NotNull
    public static List<Integer> importListOfInteger(String text2) {
        List<Integer> list = PropertyConverter.importList(text2, Integer::parseInt);
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public static List<Long> importListOfLong(String text2) {
        List<Long> list = PropertyConverter.importList(text2, Long::parseLong);
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> importList(@Nullable String text2, @NotNull Function<String, T> converter) {
        if (converter == null) {
            PropertyConverter.$$$reportNull$$$0(30);
        }
        if (text2 == null || text2.length() == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(31);
            }
            return list;
        }
        List strings = StringUtil.split((String)text2, (String)",");
        int n = strings.size();
        if (n == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(32);
            }
            return list;
        }
        ArrayList<Object> values2 = new ArrayList<Object>(n);
        for (String string : strings) {
            try {
                Object value = converter.fun((Object)string);
                values2.add(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        switch (values2.size()) {
            case 0: {
                List list = Collections.emptyList();
                if (list == null) {
                    PropertyConverter.$$$reportNull$$$0(33);
                }
                return list;
            }
            case 1: {
                List list = Collections.singletonList(values2.get(0));
                if (list == null) {
                    PropertyConverter.$$$reportNull$$$0(34);
                }
                return list;
            }
        }
        ArrayList<Object> arrayList = values2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @NotNull
    public static Set<String> importSetOfString(String text2) {
        if (text2 == null || text2.length() == 0) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(36);
            }
            return set;
        }
        List items = StringUtil.split((String)text2, (String)"\n");
        PropertyConverter.internElements(items);
        Set<String> set = PropertyConverter.convertListToSet(items);
        if (set == null) {
            PropertyConverter.$$$reportNull$$$0(37);
        }
        return set;
    }

    @NotNull
    public static <T> Set<T> convertListToSet(@NotNull List<T> items) {
        if (items == null) {
            PropertyConverter.$$$reportNull$$$0(38);
        }
        int n = items.size();
        switch (n) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    PropertyConverter.$$$reportNull$$$0(39);
                }
                return set;
            }
            case 1: {
                Set<T> set = Collections.singleton(items.get(0));
                if (set == null) {
                    PropertyConverter.$$$reportNull$$$0(40);
                }
                return set;
            }
        }
        TreeSet<T> treeSet = new TreeSet<T>(items);
        if (treeSet == null) {
            PropertyConverter.$$$reportNull$$$0(41);
        }
        return treeSet;
    }

    @NotNull
    public static List<String> importListOfString(String text2) {
        if (text2 == null || text2.length() == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(42);
            }
            return list;
        }
        List res2 = StringUtil.split((String)text2, (String)"\n");
        for (int i2 = 0; i2 < res2.size(); ++i2) {
            res2.set(i2, StringUtil.unescapeStringCharacters((String)((String)res2.get(i2))));
        }
        PropertyConverter.internElements(res2);
        List list = res2;
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(43);
        }
        return list;
    }

    @NotNull
    public static List<NameValue> importListOfNameValue(String text2) {
        if (text2 == null || text2.length() == 0) {
            List<NameValue> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(44);
            }
            return list;
        }
        ArrayList<NameValue> res2 = new ArrayList<NameValue>();
        StringTokenizer tok = new StringTokenizer(text2, "\n", false);
        while (tok.hasMoreTokens()) {
            String name2 = tok.nextToken();
            String value = tok.hasMoreTokens() ? tok.nextToken() : "";
            res2.add(new NameValue(DbUtil.intern((String)name2), DbUtil.intern((String)value)));
        }
        ArrayList<NameValue> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    public static SequenceIdentity importSequenceIdentity(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return SequenceIdentity.of(text2);
    }

    @NotNull
    public static Set<TrigEvent> importSetOfTrigEvent(String text2) {
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        for (TrigEvent e : TrigEvent.values()) {
            if (text2.indexOf(e.code) < 0) continue;
            events.add(e);
        }
        EnumSet<TrigEvent> enumSet = events;
        if (enumSet == null) {
            PropertyConverter.$$$reportNull$$$0(46);
        }
        return enumSet;
    }

    public static TrigEvent importTrigEvent(String text2) {
        return PropertyConverter.importEnum(TrigEvent.class, text2);
    }

    public static TrigTurn importTrigTurn(String text2) {
        return PropertyConverter.importEnum(TrigTurn.class, text2);
    }

    public static CascadeRule importCascadeRule(String text2) {
        return PropertyConverter.importEnumLC(CascadeRule.class, text2);
    }

    public static Casing importCasing(String text2) {
        return Casing.of((String)text2);
    }

    public static TableOrganization importTableOrganization(String text2) {
        return TableOrganization.byCode(text2);
    }

    public static ClusterType importClusterType(String text2) {
        return ClusterType.of((String)text2);
    }

    public static PgDataTypeSubKind importPgDataTypeSubKind(String text2) {
        return PropertyConverter.importEnum(PgDataTypeSubKind.class, text2);
    }

    public static PgDataTypeSubCategory importPgDataTypeSubCategory(String text2) {
        return PropertyConverter.importEnum(PgDataTypeSubCategory.class, text2);
    }

    public static PgCheckOption importPgCheckOption(String text2) {
        return PropertyConverter.importEnum(PgCheckOption.class, text2);
    }

    public static PgOperatorKind importPgOperatorKind(String text2) {
        return PropertyConverter.importEnum(PgOperatorKind.class, text2);
    }

    public static PgIdentityKind importPgIdentityKind(String text2) {
        return PropertyConverter.importEnum(PgIdentityKind.class, text2);
    }

    public static PgFireMode importPgFireMode(String text2) {
        return PropertyConverter.importEnum(PgFireMode.class, text2);
    }

    public static PgAggregateKind importPgAggregateKind(String text2) {
        return PropertyConverter.importEnum(PgAggregateKind.class, text2);
    }

    public static PgAccessMethodType importPgAccessMethodType(String text2) {
        return PropertyConverter.importEnum(PgAccessMethodType.class, text2);
    }

    public static MysqlEventStatus importMysqlEventStatus(String text2) {
        return PropertyConverter.importEnum(MysqlEventStatus.class, text2);
    }

    public static MsServerType importMsServerType(String text2) {
        return PropertyConverter.importEnum(MsServerType.class, text2);
    }

    public static MsRoutineType importMsRoutineType(String text2) {
        return PropertyConverter.importEnum(MsRoutineType.class, text2);
    }

    public static OraTableType importOraTableType(String text2) {
        return PropertyConverter.importEnum(OraTableType.class, text2);
    }

    public static OraMatViewRefreshMode importOraMatViewRefreshMode(String text2) {
        return PropertyConverter.importEnum(OraMatViewRefreshMode.class, text2);
    }

    public static OraMatViewRefreshMethod importOraMatViewRefreshMethod(String text2) {
        return PropertyConverter.importEnum(OraMatViewRefreshMethod.class, text2);
    }

    public static OraCollectionTypeKind importOraCollectionTypeKind(String text2) {
        return PropertyConverter.importEnum(OraCollectionTypeKind.class, text2);
    }

    public static HiveTableColumnType importHiveTableColumnType(String text2) {
        return PropertyConverter.importEnum(HiveTableColumnType.class, text2);
    }

    public static HiveTableColumnSortingOrder importHiveTableColumnSortingOrder(String text2) {
        return PropertyConverter.importEnum(HiveTableColumnSortingOrder.class, text2);
    }

    public static GPlumExternalTableFormat importGPlumExternalTableFormat(String text2) {
        return PropertyConverter.importEnum(GPlumExternalTableFormat.class, text2);
    }

    public static GPlumExternalTableRejectLimitType importGPlumExternalTableRejectLimitType(String text2) {
        return PropertyConverter.importEnum(GPlumExternalTableRejectLimitType.class, text2);
    }

    public static GPlumPartitionKind importGPlumPartitionKind(String text2) {
        return PropertyConverter.importEnum(GPlumPartitionKind.class, text2);
    }

    public static GPlumPartitionTree importGPlumPartitionTree(String text2) {
        GPlumPartitionTree tree = new GPlumPartitionTree();
        tree.deserialize(text2);
        return tree;
    }

    public static <E extends Enum<E>> E importEnum(Class<E> enumClass, String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        String big = StringUtil.toUpperCase((String)text2.trim().replace('-', '_'));
        return Enum.valueOf(enumClass, big);
    }

    public static <E extends Enum<E>> E importEnumLC(Class<E> enumClass, String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        String big = text2.trim().replace('-', '_');
        return Enum.valueOf(enumClass, big);
    }

    @Nullable
    public static RsTableDistStyle importRsTableDistStyle(String style) {
        return PropertyConverter.importEnum(RsTableDistStyle.class, style);
    }

    @Nullable
    public static PgVolatilityKind importPgVolatilityKind(String kind) {
        return PropertyConverter.importEnum(PgVolatilityKind.class, kind);
    }

    @NotNull
    public static Set<PgRelation> importSetOfPgRelation(String text2) {
        String[] lines;
        HashSet<PgRelation> dependencies = new HashSet<PgRelation>();
        for (String line : lines = StringUtil.splitByLines((String)text2)) {
            dependencies.add(PgRelation.read(line));
        }
        HashSet<PgRelation> hashSet = dependencies;
        if (hashSet == null) {
            PropertyConverter.$$$reportNull$$$0(47);
        }
        return hashSet;
    }

    @Nullable
    public static PgRoutineConcurrencyKind importPgRoutineConcurrencyKind(String kind) {
        return PropertyConverter.importEnum(PgRoutineConcurrencyKind.class, kind);
    }

    @Nullable
    public static RsTableBackupMode importRsTableBackupMode(String kind) {
        return PropertyConverter.importEnum(RsTableBackupMode.class, kind);
    }

    @Nullable
    public static RsExternalTableStorageType importRsExternalTableStorageType(String type) {
        return PropertyConverter.importEnum(RsExternalTableStorageType.class, type);
    }

    @Nullable
    public static SqliteOnConflictAlgorithm importSqliteOnConflictAlgorithm(String kind) {
        return PropertyConverter.importEnum(SqliteOnConflictAlgorithm.class, kind);
    }

    @Nullable
    public static MysqlColumnKind importMysqlColumnKind(String kind) {
        return PropertyConverter.importEnum(MysqlColumnKind.class, kind);
    }

    @Nullable
    public static SFlakeTableKind importSFlakeTableKind(String kind) {
        return PropertyConverter.importEnum(SFlakeTableKind.class, kind);
    }

    @Nullable
    public static VertRoutineType importVertRoutineType(String kind) {
        return PropertyConverter.importEnum(VertRoutineType.class, kind);
    }

    @Nullable
    public static ExaScriptType importExaScriptType(String kind) {
        return PropertyConverter.importEnum(ExaScriptType.class, kind);
    }

    @NotNull
    public static List<CassKeyColumn> importListOfCassKeyColumn(String text2) {
        String[] lines;
        if (text2 == null || text2.length() == 0) {
            List<CassKeyColumn> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(48);
            }
            return list;
        }
        ArrayList<CassKeyColumn> res2 = new ArrayList<CassKeyColumn>();
        for (String line : lines = StringUtil.splitByLines((String)text2)) {
            res2.add(CassKeyColumn.read(line));
        }
        ArrayList<CassKeyColumn> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(49);
        }
        return arrayList;
    }

    @NotNull
    public static List<CassIndexColumn> importListOfCassIndexColumn(String text2) {
        String[] lines;
        if (text2 == null || text2.length() == 0) {
            List<CassIndexColumn> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(50);
            }
            return list;
        }
        ArrayList<CassIndexColumn> res2 = new ArrayList<CassIndexColumn>();
        for (String line : lines = StringUtil.splitByLines((String)text2)) {
            res2.add(CassIndexColumn.read(line));
        }
        ArrayList<CassIndexColumn> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    public static Db2DataTypeSubKind importDb2DataTypeSubKind(String text2) {
        return PropertyConverter.importEnum(Db2DataTypeSubKind.class, text2);
    }

    public static Db2RoutineSqlAccess importDb2RoutineSqlAccess(String text2) {
        return PropertyConverter.importEnum(Db2RoutineSqlAccess.class, text2);
    }

    public static Db2ParameterStyle importDb2ParameterStyle(String text2) {
        return PropertyConverter.importEnum(Db2ParameterStyle.class, text2);
    }

    public static Db2NullInputAction importDb2NullInputAction(String text2) {
        return PropertyConverter.importEnum(Db2NullInputAction.class, text2);
    }

    public static Db2GeneratedColumnKind importDb2GeneratedColumnKind(String text2) {
        return PropertyConverter.importEnum(Db2GeneratedColumnKind.class, text2);
    }

    public static Db2PartitionMode importDb2PartitionMode(String text2) {
        return PropertyConverter.importEnum(Db2PartitionMode.class, text2);
    }

    public static Db2TableClustering importDb2TableClustering(String text2) {
        return PropertyConverter.importEnum(Db2TableClustering.class, text2);
    }

    public static Db2IndexXmlTypeModel importDb2IndexXmlTypeModel(String text2) {
        return PropertyConverter.importEnum(Db2IndexXmlTypeModel.class, text2);
    }

    public static Db2SavepointLevel importDb2SavepointLevel(String text2) {
        return PropertyConverter.importEnum(Db2SavepointLevel.class, text2);
    }

    public static Db2CommitOnReturnPolicy importDb2CommitOnReturnPolicy(String text2) {
        return PropertyConverter.importEnum(Db2CommitOnReturnPolicy.class, text2);
    }

    public static Db2ProgramType importDb2ProgramType(String text2) {
        return PropertyConverter.importEnum(Db2ProgramType.class, text2);
    }

    public static void internElements(@NotNull List<String> list) {
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(52);
        }
        int n = list.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String s = list.get(i2);
            if (s == null) continue;
            list.set(i2, DbUtil.intern((String)s));
        }
    }

    public static <E extends Enum> Method getStaticMethod(@NotNull Class<E> clazz, @NotNull String name2, Class<?> ... parameterTypes) {
        Method method;
        if (clazz == null) {
            PropertyConverter.$$$reportNull$$$0(53);
        }
        if (name2 == null) {
            PropertyConverter.$$$reportNull$$$0(54);
        }
        try {
            method = clazz.getMethod(name2, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalStateException(String.format("Method %s.%s(%s) must be static", clazz.getSimpleName(), name2, StringUtil.join((Object[])parameterTypes, t -> t.getSimpleName(), (String)", ")));
        }
        method.setAccessible(true);
        return method;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigInteger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dt";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "si";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numbers";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/PropertyConverter";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/PropertyConverter";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSlashN";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfShort";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfLong";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfInteger";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfLong";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "importList";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfString";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "convertListToSet";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfString";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfNameValue";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfTrigEvent";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfPgRelation";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfCassKeyColumn";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfCassIndexColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "exportEnumCode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfShort";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfLong";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfInteger";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfLong";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "exportCollectionOfNumber";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfString";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfNameValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfString";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "exportCollectionOfString";
                break;
            }
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfTrigEvent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfPgRelation";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "importList";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "convertListToSet";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "internElements";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getStaticMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

