/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift;

import com.intellij.database.dialects.postgresbase.PgBaseObjectBuilder;
import com.intellij.database.dialects.redshift.RsObjectBuilder;
import com.intellij.database.dialects.redshift.model.RsExternalSchema;
import com.intellij.database.dialects.redshift.model.RsExternalTable;
import com.intellij.database.dialects.redshift.model.RsExternalTableColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.properties.RsExternalTableStorageType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.redshift.RsTypes;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.impl.SqlCreateSchemaStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateStatementImpl;
import com.intellij.sql.psi.stubs.SqlColumnDefinitionElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0015H\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/redshift/RsObjectBuilder;", "Lcom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder;", "()V", "lazyCodeBlock", "Lcom/intellij/psi/tree/IElementType;", "getLazyCodeBlock", "()Lcom/intellij/psi/tree/IElementType;", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildExternalSchema", "Lcom/intellij/database/dialects/redshift/model/RsExternalSchema;", "buildExternalTable", "Lcom/intellij/database/dialects/redshift/model/RsExternalTable;", "findOptions", "", "", "element", "Lcom/intellij/psi/PsiElement;", "findTerminator", "setColumnsOrder", "table", "by", "intellij.database.dialects.redshift"})
public final class RsObjectBuilder
extends PgBaseObjectBuilder {
    @Nullable
    private final IElementType lazyCodeBlock;

    @Override
    @Nullable
    protected IElementType getLazyCodeBlock() {
        return this.lazyCodeBlock;
    }

    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof RsExternalSchema) {
            this.buildExternalSchema((RsExternalSchema)obj2, source);
        } else if (basicModElement instanceof RsExternalTable) {
            this.buildExternalTable((RsExternalTable)obj2, source);
        } else {
            super.build(obj2, source);
        }
    }

    private final void buildExternalTable(RsExternalTable obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            String serializationLib = null;
            String inputFormat = null;
            String outputFormat = null;
            String location = null;
            RsExternalTableStorageType storageType = RsExternalTableStorageType.UNKNOWN;
            List<String> serdeProperties = new ArrayList();
            List<String> properties2 = CollectionsKt.emptyList();
            RsObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            RsObjectBuilder rsObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                String terminator;
                List<String> $this$apply;
                boolean bl;
                boolean bl2;
                List<String> list;
                PsiElement it2 = tmp$iv$iv;
                boolean bl3 = false;
                IElementType iElementType = this.getElementType(it2);
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_SERDE)) {
                    serializationLib = this.findString(it2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_FIELDS)) {
                    List<String> list2 = serdeProperties;
                    if (!TypeIntrinsics.isMutableList((Object)list2)) {
                        list2 = null;
                    }
                    if (list2 != null) {
                        list = list2;
                        bl2 = false;
                        bl = false;
                        $this$apply = list;
                        boolean bl4 = false;
                        terminator = this.findTerminator(it2);
                        if (terminator != null) {
                            $this$apply.add("'field.delim'='" + terminator + '\'');
                            $this$apply.add("'serialization.format'='" + terminator + '\'');
                        }
                        serializationLib = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_LINES)) {
                    List<String> list3 = serdeProperties;
                    if (!TypeIntrinsics.isMutableList((Object)list3)) {
                        list3 = null;
                    }
                    if (list3 != null) {
                        list = list3;
                        bl2 = false;
                        bl = false;
                        $this$apply = list;
                        boolean bl5 = false;
                        terminator = this.findTerminator(it2);
                        if (terminator == null) continue;
                        $this$apply.add("'line.delim'='" + terminator + '\'');
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_LOCATION)) {
                    location = this.findString(it2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_INPUTFORMAT)) {
                    inputFormat = this.findString(it2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_OUTPUTFORMAT)) {
                    outputFormat = this.findString(it2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_PARQUET)) {
                    storageType = RsExternalTableStorageType.PARQUET;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_RCFILE)) {
                    storageType = RsExternalTableStorageType.RCFILE;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_SEQUENCEFILE)) {
                    storageType = RsExternalTableStorageType.SEQUENCEFILE;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_TEXTFILE)) {
                    storageType = RsExternalTableStorageType.TEXTFILE;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_ORC)) {
                    storageType = RsExternalTableStorageType.ORC;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_AVRO)) {
                    storageType = RsExternalTableStorageType.AVRO;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_SERDEPROPERTIES)) {
                    serdeProperties = this.findOptions(it2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_TABLE)) {
                    IElementType iElementType2 = RsTypes.RS_PROPERTIES;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"RsTypes.RS_PROPERTIES");
                    PsiElement props = this.findSibling(it2, iElementType2);
                    if (props == null) continue;
                    properties2 = this.findOptions(props);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_PARTITIONED)) continue;
                IElementType iElementType3 = RsTypes.RS_BY;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"RsTypes.RS_BY");
                PsiElement by = this.findSibling(it2, iElementType3);
                if (by == null) continue;
                this.setColumnsOrder(obj2, by);
            }
            obj2.setSerializationLib(serializationLib);
            obj2.setInputFormat(inputFormat);
            obj2.setOutputFormat(outputFormat);
            obj2.setLocation(location);
            obj2.setStorageType(storageType);
            obj2.setSerdeProperties(serdeProperties);
            obj2.setProps(properties2);
        }
    }

    private final void buildExternalSchema(RsExternalSchema obj2, DasObject source) {
        if (source instanceof SqlCreateSchemaStatementImpl) {
            String database = null;
            String iamRole = null;
            String uri = null;
            String port = null;
            String region = null;
            int schemaKind = 1;
            RsObjectBuilder this_$iv = this;
            boolean $i$f$forEachChild = false;
            RsObjectBuilder rsObjectBuilder = this_$iv;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it2 = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = this.getElementType(it2);
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_DATABASE)) {
                    database = this.findString(it2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_IAM_ROLE)) {
                    iamRole = this.findString(it2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_URI)) {
                    uri = this.findString(it2);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_PORT)) {
                    Float f = this.findNumberInSiblings(it2);
                    port = f != null ? String.valueOf((int)f.floatValue()) : null;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_REGION)) {
                    region = this.findString(it2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)RsTypes.RS_HIVE)) continue;
                IElementType iElementType2 = RsTypes.RS_METASTORE;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"RsTypes.RS_METASTORE");
                if (this.findSibling(it2, iElementType2) == null) continue;
                schemaKind = 2;
            }
            obj2.setDatabaseName(database);
            obj2.setIamRole(iamRole);
            obj2.setUri(uri);
            obj2.setPort(port);
            obj2.setRegion(region);
            obj2.setSchemaKind(schemaKind);
        }
    }

    private final String findTerminator(PsiElement element2) {
        IElementType iElementType = RsTypes.RS_TERMINATED;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"RsTypes.RS_TERMINATED");
        PsiElement psiElement = this.findSibling(element2, iElementType);
        if (psiElement == null) {
            return null;
        }
        PsiElement terminated = psiElement;
        IElementType iElementType2 = RsTypes.RS_BY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"RsTypes.RS_BY");
        PsiElement psiElement2 = this.findSibling(terminated, iElementType2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement by = psiElement2;
        return this.findString(by);
    }

    private final void setColumnsOrder(RsExternalTable table, PsiElement by) {
        SqlColumnDefinitionElementType sqlColumnDefinitionElementType = SqlCompositeElementTypes.SQL_COLUMN_DEFINITION;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlColumnDefinitionElementType), (String)"SqlCompositeElementTypes.SQL_COLUMN_DEFINITION");
        PsiElement psiElement = this.findSibling(by, (IElementType)sqlColumnDefinitionElementType);
        if (!(psiElement instanceof SqlColumnDefinition)) {
            psiElement = null;
        }
        SqlColumnDefinition def = (SqlColumnDefinition)psiElement;
        int order = 1;
        while (def != null) {
            RsExternalTableColumn column2;
            String name2;
            SqlNameElement sqlNameElement = def.getNameElement();
            String string = name2 = sqlNameElement != null ? sqlNameElement.getName() : null;
            if (name2 != null && (column2 = (RsExternalTableColumn)table.getColumns().find((Predicate)new Predicate<RsExternalTableColumn>(name2){
                final /* synthetic */ String $name;

                public final boolean test(RsExternalTableColumn it2) {
                    RsExternalTableColumn rsExternalTableColumn = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)rsExternalTableColumn, (String)"it");
                    return Intrinsics.areEqual((Object)rsExternalTableColumn.getName(), (Object)this.$name);
                }
                {
                    this.$name = string;
                }
            })) != null) {
                column2.setPartitionKeyOrder(order++);
            }
            PsiElement psiElement2 = def.getNextSibling();
            SqlColumnDefinitionElementType sqlColumnDefinitionElementType2 = SqlCompositeElementTypes.SQL_COLUMN_DEFINITION;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlColumnDefinitionElementType2), (String)"SqlCompositeElementTypes.SQL_COLUMN_DEFINITION");
            PsiElement psiElement3 = this.findSibling(psiElement2, (IElementType)sqlColumnDefinitionElementType2);
            if (!(psiElement3 instanceof SqlColumnDefinition)) {
                psiElement3 = null;
            }
            def = (SqlColumnDefinition)psiElement3;
        }
    }

    private final List<String> findOptions(PsiElement element2) {
        return this.findOptions(element2, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)new Function1<PsiElement, PsiElement>(this){
            final /* synthetic */ RsObjectBuilder this$0;

            @Nullable
            public final PsiElement invoke(@NotNull PsiElement current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_STRING_LITERAL;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_STRING_LITERAL");
                return RsObjectBuilder.access$findSibling(this.this$0, current, (IElementType)sqlCompositeElementType);
            }
            {
                this.this$0 = rsObjectBuilder;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)findOptions.2.INSTANCE));
    }

    public static final /* synthetic */ PsiElement access$findSibling(RsObjectBuilder $this, PsiElement element2, IElementType type) {
        return $this.findSibling(element2, type);
    }
}

