/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.tns.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.TextParamEditor;
import com.intellij.database.dataSource.url.ui.UniformLookSettingsProvider;
import com.intellij.database.dialects.oracle.tns.TnsNamesExtractor;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TnsNamesParamEditor
extends ParamEditorBase<TextFieldWithAutoCompletion<String>> {
    public static final String TNSADMIN_DIR = "TNSADMIN_DIR";
    private static final String ORACLE_REG_ROOT = "HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE";
    private final ActionGroup myContextMenu;

    public TnsNamesParamEditor(@NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(1);
        }
        this(label, interchange, new OraCompletionProvider(interchange));
    }

    private TnsNamesParamEditor(@NotNull String label, @NotNull DataInterchange interchange, @NotNull OraCompletionProvider comp) {
        if (label == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(2);
        }
        if (interchange == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(3);
        }
        if (comp == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(4);
        }
        super(new TextFieldWithAutoCompletion(interchange.getProject(), (TextFieldWithAutoCompletionListProvider)comp, false, null), interchange, TypesRegistry.ParamEditor.FieldSize.MEDIUM, label, new AnAction[0]);
        this.myContextMenu = new DefaultActionGroup(new AnAction[]{new DumbAwareAction("Reparse", "Reparse tnsnames.ora", AllIcons.Actions.Refresh){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String tnsadmin = TnsNamesParamEditor.this.getInterchange().getProperty(TnsNamesParamEditor.TNSADMIN_DIR);
                e.getPresentation().setEnabled(tnsadmin != null && TnsNamesParamEditor.hasTnsNamesOra(tnsadmin));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                TnsNamesParamEditor.this.getInterchange().forceUpdateProperty(TnsNamesParamEditor.TNSADMIN_DIR);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }});
        comp.init(this);
        interchange.addPersistentProperty(TNSADMIN_DIR);
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).ensureWillComputePreferredSize();
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                TnsNamesParamEditor.this.fireChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$2", "documentChanged"));
            }
        });
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).addSettingsProvider((EditorSettingsProvider)new UniformLookSettingsProvider());
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).addSettingsProvider(editor -> editor.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler.Simple(this.myContextMenu)));
    }

    private static boolean hasTnsNamesOra(@Nullable String path) {
        return path != null && new File(path, "tnsnames.ora").exists();
    }

    @Nullable
    private static String getEnvTnsAdminPath() {
        return System.getenv("TNS_ADMIN");
    }

    @Nullable
    private static String getEnvOracleHomePath() {
        String res2 = System.getenv("ORACLE_HOME");
        return res2 == null ? null : FileUtil.join((String[])new String[]{res2, "network", "admin"});
    }

    @Nullable
    private static String checkRegDefaultHome(@NotNull String defaultHomePath, @NotNull String defaultHomeKey, Function<String, String> ... homeCheckers) {
        String defaultHome;
        if (defaultHomePath == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(5);
        }
        if (defaultHomeKey == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(6);
        }
        if (homeCheckers == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(7);
        }
        if ((defaultHome = WindowsRegistryUtil.readRegistryValue((String)defaultHomePath, (String)defaultHomeKey)) == null) {
            return null;
        }
        for (Function<String, String> checker : homeCheckers) {
            String res2 = (String)checker.fun((Object)("HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE\\" + defaultHome));
            if (res2 == null) continue;
            return res2;
        }
        return null;
    }

    @Nullable
    private static String checkRegOracleHomes(Function<String, String> ... homeCheckers) {
        String res2;
        if (homeCheckers == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(8);
        }
        if ((res2 = TnsNamesParamEditor.checkRegDefaultHome("HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE\\ALL_HOMES", "DEFAULT_HOME", homeCheckers)) != null) {
            return res2;
        }
        res2 = TnsNamesParamEditor.checkRegDefaultHome(ORACLE_REG_ROOT, "DEFAULT_HOME", homeCheckers);
        if (res2 != null) {
            return res2;
        }
        List possibleHomes = WindowsRegistryUtil.readRegistryBranch((String)ORACLE_REG_ROOT);
        for (Function<String, String> checker : homeCheckers) {
            for (String possibleHome : possibleHomes) {
                res2 = (String)checker.fun((Object)("HKEY_LOCAL_MACHINE\\SOFTWARE\\ORACLE\\" + possibleHome));
                if (res2 == null) continue;
                return res2;
            }
        }
        return null;
    }

    @Nullable
    private static String getRegOraclePath() {
        return TnsNamesParamEditor.checkRegOracleHomes(new Function[]{new Function.Mono<String>(){

            public String fun(String homePath) {
                String res2 = WindowsRegistryUtil.readRegistryValue((String)homePath, (String)"TNS_ADMIN");
                return TnsNamesParamEditor.hasTnsNamesOra(res2) ? res2 : null;
            }
        }, new Function.Mono<String>(){

            public String fun(String homePath) {
                String res2 = WindowsRegistryUtil.readRegistryValue((String)homePath, (String)"ORACLE_HOME");
                return res2 != null && TnsNamesParamEditor.hasTnsNamesOra(FileUtil.join((String[])new String[]{res2, "network", "admin"})) ? res2 : null;
            }
        }});
    }

    @Nullable
    private static String findDirectoryWithTnsNamesOra() {
        String res2 = TnsNamesParamEditor.getEnvTnsAdminPath();
        if (TnsNamesParamEditor.hasTnsNamesOra(res2)) {
            return res2;
        }
        if (SystemInfo.isWindows) {
            res2 = TnsNamesParamEditor.getRegOraclePath();
            if (TnsNamesParamEditor.hasTnsNamesOra(res2)) {
                return res2;
            }
        } else if (SystemInfo.isSolaris) {
            res2 = "/var/opt/oracle";
            if (TnsNamesParamEditor.hasTnsNamesOra("/var/opt/oracle")) {
                return res2;
            }
        } else {
            res2 = "/etc";
            if (TnsNamesParamEditor.hasTnsNamesOra("/etc")) {
                return res2;
            }
        }
        if (TnsNamesParamEditor.hasTnsNamesOra(res2 = TnsNamesParamEditor.getEnvOracleHomePath())) {
            return res2;
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        String string = ((TextFieldWithAutoCompletion)this.getEditorComponent()).getText();
        if (string == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public void setText(@NotNull String text2) {
        if (text2 == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(10);
        }
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).setText(text2);
    }

    @Override
    public void setActive(boolean active) {
        ((TextFieldWithAutoCompletion)this.getEditorComponent()).setBackground(TnsNamesParamEditor.getBackground(active));
    }

    public static Collection<TypesRegistry.ParamEditor> createSatellites(@NotNull DataInterchange interchange) {
        if (interchange == null) {
            TnsNamesParamEditor.$$$reportNull$$$0(11);
        }
        return Collections.singletonList(new MyTnsAdminField(interchange));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHomePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHomeKey";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeCheckers";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkRegDefaultHome";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkRegOracleHomes";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSatellites";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class OraCompletionProvider
    extends TextFieldWithAutoCompletion.StringsCompletionProvider
    implements PropertyChangeListener {
        @NotNull
        private final DataInterchange myInterchange;
        private String myTnsAdminDir;
        private boolean myComputed;

        public OraCompletionProvider(@NotNull DataInterchange interchange) {
            if (interchange == null) {
                OraCompletionProvider.$$$reportNull$$$0(0);
            }
            super(null, null);
            this.myComputed = false;
            this.myInterchange = interchange;
            this.setTnsAdminDir(this.myInterchange.getProperty(TnsNamesParamEditor.TNSADMIN_DIR));
        }

        void init(@NotNull Disposable parent2) {
            if (parent2 == null) {
                OraCompletionProvider.$$$reportNull$$$0(1);
            }
            this.myInterchange.addPropertyChangeListener(TnsNamesParamEditor.TNSADMIN_DIR, this, parent2);
        }

        public void setTnsAdminDir(@Nullable String tnsAdminDir) {
            this.myTnsAdminDir = tnsAdminDir;
            this.reset();
        }

        public void reset() {
            this.myComputed = false;
            this.setItems(null);
        }

        @NotNull
        public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            if (!this.myComputed) {
                ArrayList items = new ArrayList();
                if (this.myTnsAdminDir != null) {
                    try {
                        TnsNamesExtractor.extract(FileUtil.loadFile((File)new File(this.myTnsAdminDir, "tnsnames.ora")), (Consumer<String>)((Consumer)s -> items.add(s)));
                    }
                    catch (IOException e) {
                        this.myInterchange.putProperty("TNSADMIN_ERROR", e.getMessage());
                    }
                }
                this.setItems(items);
                this.myComputed = true;
            }
            Collection collection = super.getItems(prefix, cached, parameters);
            if (collection == null) {
                OraCompletionProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setTnsAdminDir((String)evt.getNewValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$OraCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$OraCompletionProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "init";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTnsAdminField
    extends TextParamEditor
    implements PropertyChangeListener {
        private static final String TNSADMIN_ERROR = "TNSADMIN_ERROR";
        private final ActionGroup myContextMenu;

        MyTnsAdminField(final @NotNull DataInterchange interchange) {
            if (interchange == null) {
                MyTnsAdminField.$$$reportNull$$$0(0);
            }
            super(interchange, "TNSADMIN:", TypesRegistry.ParamEditor.FieldSize.LARGE, new AnAction[0]);
            this.myContextMenu = new DefaultActionGroup(new AnAction[]{new DumbAwareAction("Detect", "Detect one of standard directories, containing tnsnames.ora", AllIcons.Actions.Refresh){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    String dir;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((dir = TnsNamesParamEditor.findDirectoryWithTnsNamesOra()) == null) {
                        JBPopupFactory.getInstance().createBalloonBuilder(HintUtil.createErrorLabel((String)"tnsnames.ora not found")).setFadeoutTime(5000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint((Component)this.getComponent(), new Point()), Balloon.Position.above);
                        return;
                    }
                    this.getInterchange().putProperty(TnsNamesParamEditor.TNSADMIN_DIR, dir);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$MyTnsAdminField$1", "actionPerformed"));
                }
            }});
            this.setText(StringUtil.notNullize((String)interchange.getProperty(TnsNamesParamEditor.TNSADMIN_DIR)));
            interchange.addPropertyChangeListener(TnsNamesParamEditor.TNSADMIN_DIR, this, this);
            interchange.addPropertyChangeListener(TNSADMIN_ERROR, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() == null) {
                        return;
                    }
                    interchange.putProperty(MyTnsAdminField.TNSADMIN_ERROR, null);
                    GuiUtils.invokeLaterIfNeeded(() -> JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JBLabel((String)evt.getNewValue())).setFadeoutTime(5000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint((Component)this.getComponent(), new Point()), Balloon.Position.above), (ModalityState)ModalityState.defaultModalityState());
                }
            }, this);
            FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
            descriptor.setHideIgnored(false);
            descriptor.setTitle("Choose TNSADMIN Directory Location");
            this.addButton((AnAction)new ParamEditorBase.FMChooseAction(descriptor));
            DbUIUtil.invokeLater(() -> this.updateTnsAdmin());
            PopupHandler.installUnknownPopupHandler(this.getEditorComponent(), (ActionGroup)this.myContextMenu, (ActionManager)ActionManager.getInstance());
        }

        private void updateTnsAdmin() {
            String val = this.getInterchange().getProperty(TnsNamesParamEditor.TNSADMIN_DIR);
            boolean newVal = false;
            if (StringUtil.isEmpty((String)val)) {
                val = TnsNamesParamEditor.findDirectoryWithTnsNamesOra();
                boolean bl = newVal = !StringUtil.isEmpty((String)val);
            }
            if (newVal) {
                this.getInterchange().putProperty(TnsNamesParamEditor.TNSADMIN_DIR, val);
            } else {
                this.getInterchange().forceUpdateProperty(TnsNamesParamEditor.TNSADMIN_DIR);
            }
        }

        @Override
        protected void fireChanged() {
            this.getInterchange().putProperty(TnsNamesParamEditor.TNSADMIN_DIR, StringUtil.nullize((String)this.getText()));
            super.fireChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String text2 = StringUtil.notNullize((String)((String)evt.getNewValue()));
            if (!this.getText().equals(text2)) {
                this.setText(text2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$MyTnsAdminField", "<init>"));
        }
    }

    static class ParamProvider
    implements ConsoleRunConfiguration.ParamProvider {
        ParamProvider() {
        }

        @Override
        public void populate(@NotNull ParametersList params, @NotNull LocalDataSource dataSource) {
            String tns_admin;
            if (params == null) {
                ParamProvider.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                ParamProvider.$$$reportNull$$$0(1);
            }
            if ((tns_admin = dataSource.getAdditionalJdbcProperties().get(TnsNamesParamEditor.TNSADMIN_DIR)) != null) {
                params.replaceOrAppend("-Doracle.net.tns_admin=", "-Doracle.net.tns_admin=" + tns_admin);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "params";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$ParamProvider";
            objectArray[2] = "populate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Factory
    implements TypesRegistry.TypeDescriptorFactory {
        Factory() {
        }

        @Override
        public void createTypeDescriptor(@NotNull Consumer<? super TypesRegistry.TypeDescriptor> consumer2) {
            if (consumer2 == null) {
                Factory.$$$reportNull$$$0(0);
            }
            consumer2.consume((Object)new TypesRegistry.BaseTypeDescriptor("tns_name", "[\\p{L}\\p{M}\\p{N}[-_.#+]]+", "TNS name"){

                @Override
                @NotNull
                protected TypesRegistry.ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
                    if (caption == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (interchange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    TnsNamesParamEditor tnsNamesParamEditor = new TnsNamesParamEditor(1.formatFieldCaption(caption), interchange);
                    if (tnsNamesParamEditor == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return tnsNamesParamEditor;
                }

                @Override
                @NotNull
                public Collection<TypesRegistry.ParamEditor> createSatellites(@NotNull DataInterchange interchange) {
                    if (interchange == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    Collection<TypesRegistry.ParamEditor> collection = TnsNamesParamEditor.createSatellites(interchange);
                    if (collection == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return collection;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: 
                        case 4: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: 
                        case 4: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "caption";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "interchange";
                            break;
                        }
                        case 2: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$Factory$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$Factory$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createFieldImpl";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createSatellites";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createFieldImpl";
                            break;
                        }
                        case 2: 
                        case 4: {
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "createSatellites";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: 
                        case 4: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dialects/oracle/tns/ui/TnsNamesParamEditor$Factory", "createTypeDescriptor"));
        }
    }
}

