/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.plan;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.oracle.plan.OraPlanModelBuilder;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.util.Consumer;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraExplainPlanProvider
extends ExplainPlanProvider {
    private static final String DEFAULT_PLAN_TABLE = "PLAN_TABLE";

    public OraExplainPlanProvider() {
        super(Dbms.ORACLE);
    }

    @Override
    @NotNull
    public <V> ScriptModel<V> adjustModel(@NotNull ScriptModel<V> model) {
        if (model == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(0);
        }
        ScriptModel scriptModel = model.rawTransform(st -> {
            SyntaxTraverser.Api api = st.api;
            return (SyntaxTraverser)st.forceIgnore(v2 -> {
                if (!(v2 instanceof SqlParameter)) {
                    return false;
                }
                CharSequence text2 = api.textOf(v2);
                return text2.equals("?") || StringUtil.startsWith((CharSequence)text2, (CharSequence)":");
            });
        });
        if (scriptModel == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(1);
        }
        return scriptModel;
    }

    @Override
    @Nullable
    public DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer2, @NotNull LocalDataSource dataSource, @NotNull String statement, boolean run) {
        if (owner == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(4);
        }
        if (statement == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(5);
        }
        return new OraPlanModelBuilder(owner, consumer2, statement, DEFAULT_PLAN_TABLE);
    }

    protected String randomShorterUUID() {
        UUID uuid = UUID.randomUUID();
        return Base64.getEncoder().encodeToString(ByteBuffer.allocate(16).putLong(uuid.getLeastSignificantBits()).putLong(uuid.getMostSignificantBits()).array());
    }

    @Override
    public DdlBuilder sqlExplainPlan(@NotNull LocalDataSource dataSource, @NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (dataSource == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(7);
        }
        if (statement == null) {
            OraExplainPlanProvider.$$$reportNull$$$0(8);
        }
        if (analyze) {
            throw new UnsupportedOperationException("Oracle does not support EXPLAIN ANALYZE");
        }
        String uid = this.randomShorterUUID();
        builder.keywords("explain", "plan").space().keyword("set").space().plain("statement_id").symbol("=").symbol("'").plain(uid).symbol("'").space().keyword("for").space().plain(statement).newStatement();
        builder.keyword("select").space().symbol("*").space().keyword("from").space().keyword("table").symbol("(").plain("DBMS_XPLAN.DISPLAY").symbol("(").symbol("'").plain(DEFAULT_PLAN_TABLE).symbol("'").symbol(",").symbol("'").plain(uid).symbol("'").symbol(")").symbol(")");
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/plan/OraExplainPlanProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/plan/OraExplainPlanProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustModel";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createExplainRequest";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

