/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;

public interface OraMixinMatLog
extends BasicMinorObject,
BasicModNamedElement {
    @Override
    public OraSchema getSchema();

    public boolean isWithRowId();

    public boolean isWithObjectId();

    public boolean isWithPrimaryKey();

    public boolean isWithSequence();

    public boolean isWithNewValues();

    default public String withOptions() {
        OraTable table;
        StringBuilder b2 = new StringBuilder(60);
        ArrayList<String> opts = new ArrayList<String>(3);
        if (this.isWithRowId()) {
            opts.add("rowid");
        }
        if (this.isWithObjectId()) {
            opts.add("object id");
        }
        if (this.isWithPrimaryKey()) {
            opts.add("primary key");
        }
        if (this.isWithSequence()) {
            opts.add("sequence");
        }
        b2.append("with ");
        StringUtil.join(opts, (String)", ", (StringBuilder)b2);
        OraSchema schema = this.getSchema();
        if (schema != null && (table = (OraTable)schema.getTables().get(this.getName())) != null) {
            boolean was = false;
            for (OraTableColumn column2 : table.getColumns()) {
                String name2 = column2.getRealName();
                if (name2 == null || name2.endsWith("$$")) continue;
                b2.append(was ? ", " : " (").append(name2);
                was = true;
            }
            if (was) {
                b2.append(')');
            }
        }
        return b2.toString();
    }
}

