/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.google.common.collect.ImmutableList;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.oracle.introspector.OraIntroQueries;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector$OraDatabaseRetriever$WhenMappings;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector$OraSchemaRetriever$extractPackageChildren$;
import com.intellij.database.dialects.oracle.introspector.OraIntrospector$OraSchemaRetriever$retrieveSources$;
import com.intellij.database.dialects.oracle.introspector.OraIntrospectorFunctions;
import com.intellij.database.dialects.oracle.introspector.OraObjectCodes;
import com.intellij.database.dialects.oracle.introspector.OraSlowDependencyEntry;
import com.intellij.database.dialects.oracle.introspector.OraTypeAndName;
import com.intellij.database.dialects.oracle.introspector.PortionType;
import com.intellij.database.dialects.oracle.model.OraAliasType;
import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraCatalogObject;
import com.intellij.database.dialects.oracle.model.OraCheck;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraClusterIndex;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraConstraint;
import com.intellij.database.dialects.oracle.model.OraException;
import com.intellij.database.dialects.oracle.model.OraForeignKey;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraInfraColumn;
import com.intellij.database.dialects.oracle.model.OraInnerRoutine;
import com.intellij.database.dialects.oracle.model.OraKey;
import com.intellij.database.dialects.oracle.model.OraLikeColumn;
import com.intellij.database.dialects.oracle.model.OraLikeTable;
import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraMatLog;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraObjectTypeAttribute;
import com.intellij.database.dialects.oracle.model.OraObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageBody;
import com.intellij.database.dialects.oracle.model.OraPackageCollectionType;
import com.intellij.database.dialects.oracle.model.OraPackageVariable;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSchemaObject;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraSynonym;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.dialects.oracle.model.OraTableTrigger;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.OraVariable;
import com.intellij.database.dialects.oracle.model.OraView;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.introspection.StringListAggregator;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.OraCollectionTypeKind;
import com.intellij.database.model.properties.OraMatViewRefreshMethod;
import com.intellij.database.model.properties.OraMatViewRefreshMode;
import com.intellij.database.model.properties.OraTableType;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.StringFun;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.StringKt;
import gnu.trove.TLongHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.exceptions.NoTableOrViewException;
import org.jetbrains.dekaf.sql.SqlQuery;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0005:;<=>B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001c\u0010\u0014\u001a\u00060\u0015R\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\u001c\u0010\u0019\u001a\u00060\u001aR\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0003H\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0014J9\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&\"\u00020'H\u0016\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0017H\u0014J\u001e\u0010+\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u0014J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0017H\u0014J.\u0010.\u001a\u00020\u00102\f\u0010/\u001a\b\u0012\u0004\u0012\u00020'0\u00122\u000e\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0003012\u0006\u00102\u001a\u00020\nH\u0002J.\u00103\u001a\u00020\u00102\f\u0010/\u001a\b\u0012\u0004\u0012\u00020'0\u00122\u000e\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0003012\u0006\u00102\u001a\u00020\nH\u0002J\b\u00104\u001a\u00020\u0010H\u0016J\"\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\n062\f\u00108\u001a\b\u0012\u0004\u0012\u00020709H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "fast", "", "queries", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries;", "sessionInfo", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneSessionInfo;", "applySchemas", "", "scs", "", "Lcom/intellij/database/introspection/LongIdName;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseRetriever;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraSchemaRetriever;", "schema", "getDefaultScope", "Lcom/intellij/database/util/TreePattern;", "initConnectionRelatedState", "introspectFragment", "namespace", "Lcom/intellij/database/model/basic/BasicNamespace;", "withSources", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectNames", "", "", "(Lcom/intellij/database/model/basic/BasicNamespace;ZLcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "introspectNamespacesInTran", "tran", "introspectSchemasAuto", "schemas", "introspectSessionState", "processNames", "items", "modelSchemas", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "renew", "processTheNames", "retrieveAndApplySchemas", "retrieveInvalid", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "", "Factory", "OraDatabaseFirstRetriever", "OraDatabaseIncRetriever", "OraDatabaseRetriever", "OraSchemaRetriever", "intellij.database.dialects.oracle"})
public final class OraIntrospector
extends BaseSingleDatabaseIntrospector<OraRoot, OraSchema> {
    private final OraIntroQueries queries;
    private OraIntroQueries.OneSessionInfo sessionInfo;
    private boolean fast;

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        if (!this.getServerVersion().isOrGreater(new int[]{10}) && this.getDriverVersion().isOrGreater(new int[]{12})) {
            String message2 = String.format("Unsupported combination of server/driver versions: found Oracle server version %s with JDBC driver version %s that is not compatible. Oracle server version 9.x must be connected by JDBC driver versions 9.x to 11.x.", this.getServerVersion(), this.getDriverVersion());
            throw (Throwable)new IllegalStateException(message2);
        }
        this.fast = (Boolean)this.inTransaction((Function1)new Function1<DBTransaction, Boolean>(this){
            final /* synthetic */ OraIntrospector this$0;

            public final Boolean invoke(@NotNull DBTransaction tran) {
                Boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                try {
                    Object object = tran.query(OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0).checkBaseDictionariesAccess).run();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(queries.check\u2026DictionariesAccess).run()");
                    bl = (Boolean)object;
                }
                catch (NoTableOrViewException ntv) {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = oraIntrospector;
                super(1);
            }
        });
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 10, this.queryParameters);
        BaseIntrospectionFunctions.setOracleFastSlowModeParameters(this.fast, this.queryParameters);
        BaseIntrospectionFunctions.setOracleSpecificParameters(this.getServerVersion(), this.queryParameters);
        this.getLog().info(String.format("Oracle Introspector: initialized for Oracle version %s driver version %s using %s mode", this.getServerVersion(), this.getDriverVersion(), this.fast ? "FAST" : "SLOW"));
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        List schemas2;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        List list = schemas2 = (List)tran.query(this.queries.retrieveAllSchemas).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"schemas");
        this.applySchemas(list);
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemas2 = (List)this.inTransaction((Function1)new Function1<DBTransaction, List<LongIdName>>(this){
            final /* synthetic */ OraIntrospector this$0;

            public final List<LongIdName> invoke(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                Object object = tran.query(OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0).retrieveAllSchemas).run();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(queries.retrieveAllSchemas).run()");
                return (List)object;
            }
            {
                this.this$0 = oraIntrospector;
                super(1);
            }
        });
        this.applySchemas(schemas2);
    }

    private final void applySchemas(List<LongIdName> scs) {
        this.getModel().modify(OraRoot.class, (ModelModifier)new ModelModifier<OraRoot>(this, scs){
            final /* synthetic */ OraIntrospector this$0;
            final /* synthetic */ List $scs;

            /*
             * WARNING - void declaration
             */
            public final void perform(OraRoot root2) {
                OraRoot oraRoot = root2;
                Intrinsics.checkExpressionValueIsNotNull((Object)oraRoot, (String)"root");
                ModNamingFamily modNamingFamily = oraRoot.getSchemas();
                Intrinsics.checkExpressionValueIsNotNull((Object)modNamingFamily, (String)"root.schemas");
                ModNamingFamily schemas2 = modNamingFamily;
                schemas2.markChildrenAsSyncPending();
                OraIntroQueries.OneSessionInfo info = OraIntrospector.access$getSessionInfo$p(this.this$0);
                Iterable $this$forEachIndexed$iv = this.$scs;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void sc;
                    OraSchema schema;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    LongIdName longIdName = (LongIdName)item$iv;
                    int idx = n2;
                    boolean bl2 = false;
                    OraSchema oraSchema = schema = (OraSchema)schemas2.renew(sc.id, sc.name);
                    Intrinsics.checkExpressionValueIsNotNull((Object)oraSchema, (String)"schema");
                    oraSchema.setCurrent(info != null ? Intrinsics.areEqual((Object)schema.getName(), (Object)info.current_schema) : idx == 0);
                }
                schemas2.removeSyncPendingChildren();
                schemas2.sort();
            }
            {
                this.this$0 = oraIntrospector;
                this.$scs = list;
            }
        });
    }

    @Override
    protected void introspectSessionState(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Object object = tran.query(this.queries.retrieveSessionInfo).run();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        this.sessionInfo = (OraIntroQueries.OneSessionInfo)object;
    }

    @Override
    @NotNull
    public TreePattern getDefaultScope() {
        List names;
        block3: {
            Object object;
            names = CollectionsKt.mutableListOf((Object[])new ObjectName[]{DataSourceSchemaMapping.CURRENT_NAMESPACE_NAME, ObjectName.quoted((String)"PUBLIC")});
            OraIntroQueries.OneSessionInfo oneSessionInfo = this.sessionInfo;
            if (oneSessionInfo == null) break block3;
            OraIntroQueries.OneSessionInfo oneSessionInfo2 = oneSessionInfo;
            boolean bl = false;
            boolean bl2 = false;
            OraIntroQueries.OneSessionInfo i2 = oneSessionInfo2;
            boolean bl3 = false;
            String string = i2.current_user;
            if (string != null) {
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String it2 = string2;
                boolean bl6 = false;
                object = Intrinsics.areEqual((Object)it2, (Object)i2.current_schema) ^ true ? string2 : null;
            } else {
                object = oneSessionInfo = null;
            }
            if (object != null) {
                oneSessionInfo2 = oneSessionInfo;
                bl = false;
                bl2 = false;
                OraIntroQueries.OneSessionInfo it3 = oneSessionInfo2;
                boolean bl7 = false;
                names.add(ObjectName.quoted((String)((Object)it3)));
            }
        }
        return new TreePattern(TreePatternUtils.create(names, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends OraSchema> schemas2) {
        OraIntrospector this_$iv;
        String message$iv;
        boolean $i$f$handleErrors;
        String operationName$iv;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schemas2, (String)"schemas");
        ArrayList schemasToProcess = new ArrayList(schemas2);
        Iterator iterator = schemasToProcess.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"schemasToProcess.iterator()");
        Iterator it2 = iterator;
        while (it2.hasNext()) {
            OraSchema s;
            OraSchema oraSchema = s = (OraSchema)it2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraSchema, (String)"s");
            if (oraSchema.getObjectId() != Long.MIN_VALUE || !(Intrinsics.areEqual((Object)s.getName(), (Object)"SYS") ^ true)) continue;
            this.getLog().warn("Oracle schema " + s.getRealName() + " has no object Id");
            it2.remove();
        }
        ArrayList<Object> schemas1 = new ArrayList<Object>(schemasToProcess.size());
        ArrayList schemas22 = new ArrayList(schemasToProcess.size());
        for (Object schema : schemasToProcess) {
            OraSchema oraSchema = schema;
            Intrinsics.checkExpressionValueIsNotNull((Object)oraSchema, (String)"schema");
            (oraSchema.getIntrospectionTimestamp() == null ? schemas1 : schemas22).add(schema);
        }
        if (!schemas1.isEmpty()) {
            Object schema;
            schema = this;
            operationName$iv = "Introspect database stuff completely";
            $i$f$handleErrors = false;
            try {
                boolean bl = false;
                OraDatabaseFirstRetriever retriever1 = new OraDatabaseFirstRetriever(tran, (List<? extends OraSchema>)schemas1, false);
                retriever1.process();
            }
            catch (InterruptedException ie$iv) {
                throw (Throwable)ie$iv;
            }
            catch (DBException d$iv) {
                message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
            }
            catch (NullPointerException npe$iv) {
                message$iv = "NPE encountered when performing " + operationName$iv;
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
                BaseIntrospector.access$getLog$p(this_$iv).error(message$iv, (Throwable)npe$iv);
            }
            catch (Exception e$iv) {
                message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
            }
        }
        if (!schemas22.isEmpty()) {
            this_$iv = this;
            operationName$iv = "Introspect database stuff incrementally";
            $i$f$handleErrors = false;
            try {
                boolean bl = false;
                OraDatabaseIncRetriever retriever2 = new OraDatabaseIncRetriever(tran, schemas22, false);
                retriever2.process();
            }
            catch (InterruptedException ie$iv) {
                throw (Throwable)ie$iv;
            }
            catch (DBException d$iv) {
                message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
            }
            catch (NullPointerException npe$iv) {
                message$iv = "NPE encountered when performing " + operationName$iv;
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
                BaseIntrospector.access$getLog$p(this_$iv).error(message$iv, (Throwable)npe$iv);
            }
            catch (Exception e$iv) {
                message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
            }
        }
        for (Object schema : schemasToProcess) {
            void this_$iv2;
            String message$iv2;
            OraIntrospector $i$f$handleErrors2 = this;
            StringBuilder stringBuilder = new StringBuilder().append("Introspect the schema ");
            Object object = schema;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"schema");
            String operationName$iv2 = stringBuilder.append(object.getName()).append(" stuff completely").toString();
            boolean $i$f$handleErrors3 = false;
            try {
                boolean bl = false;
                OraSchemaRetriever oraSchemaRetriever = new OraSchemaRetriever(tran, (OraSchema)schema);
                boolean bl2 = false;
                boolean bl3 = false;
                OraSchemaRetriever $this$apply = oraSchemaRetriever;
                boolean bl4 = false;
                Date lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
                $this$apply.setMyFromTimestamp$intellij_database_dialects_oracle($this$apply.getMode().increment && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : BaseIntrospectionFunctions.AGES_AGO);
                Long srcExistentVersion = this.getModel().getSchemaSourcesVersion((BasicSchema)schema);
                $this$apply.setSrcFromTimestamp$intellij_database_dialects_oracle(srcExistentVersion != null && srcExistentVersion > 0L ? new Timestamp(srcExistentVersion) : BaseIntrospectionFunctions.AGES_AGO);
                OraSchemaRetriever retriever = oraSchemaRetriever;
                retriever.retrieveMain$intellij_database_dialects_oracle();
            }
            catch (InterruptedException ie$iv) {
                throw (Throwable)ie$iv;
            }
            catch (DBException d$iv) {
                message$iv2 = "Error encountered when performing " + operationName$iv2 + ": " + d$iv.getMessage();
                this_$iv2.getErrorSink().consume((Object)message$iv2, (Object)d$iv);
            }
            catch (NullPointerException npe$iv) {
                message$iv2 = "NPE encountered when performing " + operationName$iv2;
                this_$iv2.getErrorSink().consume((Object)message$iv2, (Object)npe$iv);
                BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv2).error(message$iv2, (Throwable)npe$iv);
            }
            catch (Exception e$iv) {
                message$iv2 = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv2 + ": " + e$iv.getMessage();
                this_$iv2.getErrorSink().consume((Object)message$iv2, (Object)e$iv);
            }
        }
    }

    @Override
    @NotNull
    public Map<BasicElement, Boolean> retrieveInvalid(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        boolean bl = false;
        LinkedHashMap ids = new LinkedHashMap();
        Iterable<? extends BasicElement> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator<? extends BasicElement> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            BasicElement element$iv;
            BasicElement it2 = element$iv = iterator.next();
            boolean bl2 = false;
            if (!OraIntrospectorFunctions.access$canCheckOutdated(it2)) continue;
            BasicElement basicElement = it2;
            if (basicElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraCatalogObject");
            }
            OraCatalogObject cfr_ignored_0 = (OraCatalogObject)basicElement;
            ((Map)ids).put(((OraCatalogObject)it2).getObjectId(), it2);
        }
        if (ids.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Set set = ids.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"ids.keys");
        this.setQueryParameter("OBJECT_IDS", CollectionsKt.toLongArray((Collection)set));
        SqlQuery<List<OraIntroQueries.OneState>> sqlQuery = this.fast ? this.queries.retrieveStatesFast : this.queries.retrieveStatesSlow;
        Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"if (fast) queries.retrie\u2026ueries.retrieveStatesSlow");
        List<OraIntroQueries.OneState> states2 = this.performQuery(sqlQuery);
        boolean bl3 = false;
        LinkedHashMap res2 = new LinkedHashMap();
        ids.forEach((BiConsumer)new BiConsumer<Long, OraCatalogObject>(res2){
            final /* synthetic */ LinkedHashMap $res;

            public final void accept(@NotNull Long $noName_0, @NotNull OraCatalogObject v2) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)v2, (String)"v");
                ((Map)this.$res).put(v2, false);
            }
            {
                this.$res = linkedHashMap;
            }
        });
        List<OraIntroQueries.OneState> list = states2;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"states");
        Iterable $this$forEach$iv2 = list;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            OraCatalogObject obj2;
            OraIntroQueries.OneState s = (OraIntroQueries.OneState)element$iv;
            boolean bl4 = false;
            if ((OraCatalogObject)ids.get(s.object_id) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)obj2, (String)"ids[s.object_id] ?: return@forEach");
            ((Map)res2).put(obj2, Intrinsics.areEqual((Object)obj2.getModifiedTimestamp(), (Object)s.modified_timestamp));
        }
        this.inModel((Function1)new Function1<OraRoot, Unit>(res2){
            final /* synthetic */ LinkedHashMap $res;

            public final void invoke(@NotNull OraRoot it2) {
                Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                Set<Map.Entry<K, V>> set = this.$res.entrySet();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"res.entries");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Map.Entry $dstr$obj$ok = (Map.Entry)element$iv;
                    boolean bl = false;
                    Map.Entry entry = $dstr$obj$ok;
                    boolean bl2 = false;
                    BasicElement obj2 = (BasicElement)entry.getKey();
                    entry = $dstr$obj$ok;
                    bl2 = false;
                    Boolean ok = (Boolean)entry.getValue();
                    BasicElement basicElement = obj2;
                    if (basicElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
                    }
                    ((BasicModElement)basicElement).setOutdated(ok == false);
                }
            }
            {
                this.$res = linkedHashMap;
                super(1);
            }
        });
        return res2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"objectKind");
        Intrinsics.checkParameterIsNotNull((Object)objectNames, (String)"objectNames");
        boolean bl = this.getModel().contains(namespace);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = namespace instanceof OraSchema;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        OraSchema schema = (OraSchema)namespace;
        OraIntrospector oraIntrospector = this;
        String operationName$iv = "Introspect fragments " + ArraysKt.joinToString$default((Object[])objectNames, null, null, null, (int)0, null, null, (int)63, null);
        boolean $i$f$handleErrors = false;
        try {
            boolean bl6 = false;
            this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, schema, objectKind, objectNames, withSources){
                final /* synthetic */ OraIntrospector this$0;
                final /* synthetic */ OraSchema $schema$inlined;
                final /* synthetic */ ObjectKind $objectKind$inlined;
                final /* synthetic */ String[] $objectNames$inlined;
                final /* synthetic */ boolean $withSources$inlined;
                {
                    this.this$0 = oraIntrospector;
                    this.$schema$inlined = oraSchema;
                    this.$objectKind$inlined = objectKind;
                    this.$objectNames$inlined = stringArray;
                    this.$withSources$inlined = bl;
                    super(1);
                }

                public final void invoke(@NotNull DBTransaction tran) {
                    Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                    OraSchemaRetriever retriever = this.this$0.new OraSchemaRetriever(tran, this.$schema$inlined);
                    retriever.setMode(IntrospectionMode.FRAGMENT);
                    retriever.setFragmentKind(this.$objectKind$inlined);
                    retriever.setFragmentNames(this.$objectNames$inlined);
                    retriever.setWithSources(this.$withSources$inlined);
                    retriever.setMyFromTimestamp$intellij_database_dialects_oracle(BaseIntrospectionFunctions.AGES_AGO);
                    retriever.setSrcFromTimestamp$intellij_database_dialects_oracle(BaseIntrospectionFunctions.AGES_AGO);
                    retriever.retrieveMain$intellij_database_dialects_oracle();
                }
            }));
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    private final void processNames(List<String> items, ModNamingIdentifyingFamily<? extends OraSchema> modelSchemas, boolean renew) {
        long time1 = System.currentTimeMillis();
        this.processTheNames(items, modelSchemas, renew);
        long time2 = System.currentTimeMillis();
        double delta = (double)(time2 - time1) / 1000.0;
        this.getLog().debug("Major names processing took " + delta + " s.");
    }

    private final void processTheNames(List<String> items, ModNamingIdentifyingFamily<? extends OraSchema> modelSchemas, boolean renew) {
        HashSet<ModNamingIdentifyingFamily> affectedFamilies = new HashSet<ModNamingIdentifyingFamily>();
        for (String item : items) {
            try {
                OraSchemaObject obj2;
                OraSchemaObject oraSchemaObject;
                String objectName;
                String kindCode;
                OraSchema schema;
                boolean isSecondary;
                String objectIdStr;
                String schemaIdStr;
                boolean bl = item.length() >= 24;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-OraIntrospector$processTheNames$322 = false;
                    String $i$a$-assert-OraIntrospector$processTheNames$322 = "The item should be at least 24 characters length";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-OraIntrospector$processTheNames$322));
                }
                String string = item;
                int $i$a$-assert-OraIntrospector$processTheNames$322 = 0;
                int n = 2;
                int n2 = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring($i$a$-assert-OraIntrospector$processTheNames$322, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String $i$a$-assert-OraIntrospector$processTheNames$322 = item;
                n = 2;
                n2 = 12;
                int n3 = 0;
                String string3 = $i$a$-assert-OraIntrospector$processTheNames$322;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string4 = item;
                n2 = 12;
                n3 = 22;
                int n4 = 0;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n2, n3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                char isSecondaryStr = item.charAt(22);
                String string6 = item;
                n4 = 23;
                boolean bl3 = false;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string7.substring(n4), (String)"(this as java.lang.String).substring(startIndex)");
                int schemaId = Integer.parseInt(schemaIdStr);
                int objectId = Integer.parseInt(objectIdStr);
                boolean bl4 = isSecondary = isSecondaryStr == 'Y';
                if ((OraSchema)modelSchemas.getByObjectId((long)schemaId) == null) {
                    String string8 = "Schema should exist, id:" + schemaId;
                    boolean bl5 = false;
                    throw (Throwable)new IllegalStateException(string8.toString());
                }
                ModNamingIdentifyingFamily family = OraIntrospectorFunctions.access$majorFamilyOf(schema, kindCode);
                if (renew) {
                    oraSchemaObject = (OraSchemaObject)family.renew(objectId, objectName);
                } else {
                    Object e = family.createOrGet(objectName);
                    boolean bl6 = false;
                    boolean bl7 = false;
                    OraSchemaObject $this$apply = (OraSchemaObject)e;
                    boolean bl8 = false;
                    OraSchemaObject oraSchemaObject2 = $this$apply;
                    Intrinsics.checkExpressionValueIsNotNull((Object)oraSchemaObject2, (String)"this");
                    oraSchemaObject2.setObjectId(objectId);
                    oraSchemaObject = obj2 = (OraSchemaObject)e;
                }
                if (obj2 instanceof OraTable) {
                    ((OraTable)obj2).setSecondary(isSecondary);
                }
                affectedFamilies.add(family);
            }
            catch (NumberFormatException e) {
                this.getLog().warn(String.format("Failed to handle item '%s': %s: %s", item, e.getClass().getSimpleName(), e.getMessage()));
            }
        }
        for (ModNamingIdentifyingFamily family : affectedFamilies) {
            family.sort();
        }
    }

    @NotNull
    protected OraDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull OraRoot database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new OraDatabaseFirstRetriever(transaction, CollectionsKt.emptyList(), false);
    }

    @NotNull
    protected OraSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull OraSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new OraSchemaRetriever(transaction, schema);
    }

    public OraIntrospector(@NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        Dbms dbms = Dbms.ORACLE;
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"Dbms.ORACLE");
        super(dbms, project, modelFactory);
        OraIntroQueries oraIntroQueries = OraIntroQueries.QUERIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)oraIntroQueries, (String)"QUERIES");
        this.queries = oraIntroQueries;
    }

    public static final /* synthetic */ void access$setFast$p(OraIntrospector $this, boolean bl) {
        $this.fast = bl;
    }

    public static final /* synthetic */ Version access$getServerVersion$p(OraIntrospector $this) {
        return $this.getServerVersion();
    }

    public static final /* synthetic */ void access$setServerVersion$p(OraIntrospector $this, Version version) {
        $this.setServerVersion(version);
    }

    public static final /* synthetic */ void access$writeSources(OraIntrospector $this, Function0 r) {
        $this.writeSources((Function0<Unit>)r);
    }

    public static final /* synthetic */ OraIntroQueries.OneSessionInfo access$getSessionInfo$p(OraIntrospector $this) {
        return $this.sessionInfo;
    }

    public static final /* synthetic */ void access$setSessionInfo$p(OraIntrospector $this, OraIntroQueries.OneSessionInfo oneSessionInfo) {
        $this.sessionInfo = oneSessionInfo;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.oracle"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            return version.isOrGreater(new int[]{9});
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
            return new OraIntrospector(project, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return OraIntrospectorFunctions.access$canCheckOutdated(e);
        }

        @Override
        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative(this);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.oracle"})
        public static final class VERSION
        extends PerObjectVersion {
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
                Map<ObjectKind, Integer> map2 = vERSION.getMyVersions();
                ObjectKind objectKind = ObjectKind.PACKAGE;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"PACKAGE");
                ObjectKind objectKind2 = ObjectKind.PACKAGE;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"PACKAGE");
                map2.put(objectKind, vERSION.get(objectKind2) + 1);
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u00a4\u0004\u0018\u00002\u0018\u0012\u0004\u0012\u00020\u00020\u0001R\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00160\u0014H\u0002J0\u0010\u0017\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00150\u00182\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00160\u0014H\u0014J0\u0010\u0019\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00160\u0014H\u0002J8\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00160\u0014H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "adjustNativeStatements", "", "", "text", "chopListAndRetrieveNativeDefinitions", "", "portionType", "Lcom/intellij/database/dialects/oracle/introspector/PortionType;", "elements", "", "Lcom/intellij/database/dialects/oracle/model/OraSchemaObject;", "result", "", "Lcom/intellij/database/model/basic/BasicElement;", "", "retrieveNativeDefinitions", "", "retrieveNativeDefinitionsPortion", "retrieveNativeDefinitionsPortionSafe", "intellij.database.dialects.oracle"})
    protected abstract class OraDatabaseRetriever
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever<OraRoot> {
        /*
         * WARNING - void declaration
         */
        @Override
        protected void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            List filteredElements = CollectionsKt.filterIsInstance(elements, OraSchemaObject.class);
            int n = filteredElements.size();
            if (n == 0) {
                return;
            }
            PortionType portionType = OraIntrospectorFunctions.access$applicablePortionTypeFor(n);
            if (portionType == PortionType.ALL) {
                int stepSize = PortionType.NORMAL.getSize();
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)n)), (int)stepSize);
                int n2 = intProgression.getFirst();
                int n3 = intProgression.getLast();
                int n4 = intProgression.getStep();
                int n5 = n2;
                int n6 = n3;
                if (n4 >= 0 ? n5 <= n6 : n5 >= n6) {
                    while (true) {
                        void offset;
                        List portion = filteredElements.subList((int)offset, Math.min((int)(offset + stepSize), n));
                        PortionType pt = OraIntrospectorFunctions.access$applicablePortionTypeFor(portion.size());
                        this.retrieveNativeDefinitionsPortionSafe(pt, portion, result2);
                        if (offset != n3) {
                            offset += n4;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.retrieveNativeDefinitionsPortionSafe(portionType, filteredElements, result2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void chopListAndRetrieveNativeDefinitions(PortionType portionType, List<? extends OraSchemaObject> elements, Map<BasicElement, String[]> result2) {
            PortionType portionType2;
            switch (OraIntrospector$OraDatabaseRetriever$WhenMappings.$EnumSwitchMapping$0[portionType.ordinal()]) {
                case 1: {
                    portionType2 = PortionType.NORMAL;
                    break;
                }
                case 2: {
                    portionType2 = PortionType.SMALL;
                    break;
                }
                case 3: {
                    portionType2 = PortionType.ONE;
                    break;
                }
                case 4: {
                    throw (Throwable)new IllegalArgumentException("A portion of one element cannot be split into several portions");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            PortionType nextPortion = portionType2;
            int stepSize = nextPortion.getSize();
            int n = elements.size();
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)n)), (int)stepSize);
            int n2 = intProgression.getFirst();
            int n3 = intProgression.getLast();
            int n4 = intProgression.getStep();
            int n5 = n2;
            int n6 = n3;
            if (n4 >= 0 ? n5 <= n6 : n5 >= n6) {
                while (true) {
                    void offset;
                    List<? extends OraSchemaObject> portion = elements.subList((int)offset, Math.min((int)(offset + stepSize), n));
                    PortionType pt = OraIntrospectorFunctions.access$applicablePortionTypeFor(portion.size());
                    this.retrieveNativeDefinitionsPortionSafe(pt, portion, result2);
                    if (offset == n3) break;
                    offset += n4;
                }
            }
        }

        private final void retrieveNativeDefinitionsPortionSafe(PortionType portionType, List<? extends OraSchemaObject> elements, Map<BasicElement, String[]> result2) {
            try {
                this.retrieveNativeDefinitionsPortion(elements, result2);
            }
            catch (DBException e) {
                if (portionType.compareTo((Enum)PortionType.ONE) > 0) {
                    this.chopListAndRetrieveNativeDefinitions(portionType, elements, result2);
                }
                OraSchemaObject element2 = (OraSchemaObject)CollectionsKt.first(elements);
                String comment = "-- failed to obtain definition for " + element2 + ":\n--\t" + e.getMessage();
                result2.put(element2, new String[]{comment});
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveNativeDefinitionsPortion(List<? extends OraSchemaObject> elements, Map<BasicElement, String[]> result2) {
            Object object;
            Object object2;
            Iterable $this$map$iv = elements;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : iterable) {
                void it2;
                OraSchemaObject oraSchemaObject = (OraSchemaObject)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object = it2.getObjectId();
                object2.add(object);
            }
            long[] identifiers = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
            this.setQueryParameter("identifiers", identifiers);
            SqlQuery<List<OraIntroQueries.OneNativeDefinition>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveNativeDefinitions;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveNativeDefinitions");
            List<OraIntroQueries.OneNativeDefinition> entries = this.performQuery(sqlQuery);
            MultiMap map2 = new MultiMap();
            for (OraIntroQueries.OneNativeDefinition oneNativeDefinition : entries) {
                Long l = oneNativeDefinition.object_id;
                String string = oneNativeDefinition.text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.text");
                map2.putValues((Object)l, this.adjustNativeStatements(string));
            }
            for (OraSchemaObject oraSchemaObject : elements) {
                String[] stringArray;
                void thisCollection$iv;
                void $this$toTypedArray$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)map2.get((Object)oraSchemaObject.getObjectId()), (String)"map[element.objectId]");
                object = oraSchemaObject;
                object2 = result2;
                boolean $i$f$toTypedArray = false;
                if ($this$toTypedArray$iv == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                if (thisCollection$iv.toArray(new String[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                object2.put(object, stringArray);
            }
        }

        private final Collection<String> adjustNativeStatements(String text2) {
            CharSequence charSequence = text2;
            boolean bl = false;
            String string = charSequence;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String txt = ((Object)StringsKt.trim((CharSequence)string)).toString();
            charSequence = txt;
            bl = false;
            if (charSequence.length() == 0) {
                return SetsKt.emptySet();
            }
            charSequence = txt;
            Regex regex = OraIntrospectorFunctions.access$getNATIVE_TRIGGER_DEFINITION_PATTERN$p();
            boolean bl2 = false;
            if (regex.matches(charSequence)) {
                int p2 = StringsKt.indexOf$default((CharSequence)txt, (String)"ALTER TRIGGER \"", (int)0, (boolean)false, (int)6, null);
                if (p2 > 0) {
                    String string2 = txt;
                    int n = 0;
                    boolean bl3 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n, p2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string2 = string4;
                    n = 0;
                    String string5 = string2;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String stmt1 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
                    String string6 = txt;
                    bl3 = false;
                    String string7 = string6;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.substring(p2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                    string6 = string8;
                    bl3 = false;
                    String string9 = string6;
                    if (string9 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String stmt2 = ((Object)StringsKt.trim((CharSequence)string9)).toString();
                    return CollectionsKt.listOf((Object[])new String[]{stmt1, stmt2});
                }
                Set<String> set = Collections.singleton(txt);
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"singleton(txt)");
                return set;
            }
            Set<String> set = Collections.singleton(txt);
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"singleton(txt)");
            return set;
        }

        public OraDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            super(OraIntrospector.this, transaction);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseFirstRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schemas", "", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "glutton", "", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Ljava/util/List;Z)V", "prepareParameters", "", "process", "retrieveAllOrdinaryNames", "retrieveAllSynonyms", "intellij.database.dialects.oracle"})
    private final class OraDatabaseFirstRetriever
    extends OraDatabaseRetriever {
        private final List<OraSchema> schemas;
        private final boolean glutton;

        protected void prepareParameters() {
            this.setQueryParameter(this.glutton ? "GLUTTON" : "ASCETIC", Boolean.TRUE);
            this.setQueryParameter("ALL_SCHEMA_IDS", this.schemas.stream().map(prepareParameters.1.INSTANCE).toArray());
            this.setQueryParameter("ALL_SCHEMA_NAMES", this.schemas.stream().map(prepareParameters.2.INSTANCE).toArray());
        }

        @Override
        public void process() {
            this.prepareParameters();
            this.retrieveAllOrdinaryNames();
            this.retrieveAllSynonyms();
        }

        private final void retrieveAllOrdinaryNames() {
            SqlQuery<List<String>> query;
            this.reportRetrieving("Major Object Names");
            SqlQuery<List<String>> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            List<String> items = this.performQueryForList(sqlQuery, 8192);
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(this, items){
                final /* synthetic */ OraDatabaseFirstRetriever this$0;
                final /* synthetic */ List $items;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    for (OraSchema schema : OraDatabaseFirstRetriever.access$getSchemas$p(this.this$0)) {
                        BasicModSchema basicModSchema = root2.mod(schema);
                        if (basicModSchema == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraSchema");
                        }
                        OraSchema ms = (OraSchema)basicModSchema;
                        ms.getSequences().clear();
                        ms.getObjectTypes().clear();
                        ms.getCollectionTypes().clear();
                        ms.getTables().clear();
                        ms.getMatViews().clear();
                        ms.getViews().clear();
                        ms.getPackages().clear();
                        ms.getRoutines().clear();
                    }
                    OraIntrospector oraIntrospector = this.this$0.OraIntrospector.this;
                    ModNamingFamily modNamingFamily = root2.getSchemas();
                    Intrinsics.checkExpressionValueIsNotNull((Object)modNamingFamily, (String)"root.schemas");
                    OraIntrospector.access$processNames(oraIntrospector, this.$items, (ModNamingIdentifyingFamily)modNamingFamily, false);
                }
                {
                    this.this$0 = oraDatabaseFirstRetriever;
                    this.$items = list;
                    super(1);
                }
            });
        }

        private final void retrieveAllSynonyms() {
            this.reportRetrieving("Synonyms");
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveAllSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveAllSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(ss){
                final /* synthetic */ List $ss;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    OraIntrospectorFunctions.access$processSynonyms(this.$ss, root2);
                }
                {
                    this.$ss = list;
                    super(1);
                }
            });
        }

        public OraDatabaseFirstRetriever(@NotNull DBTransaction transaction, List<? extends OraSchema> schemas2, boolean glutton) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schemas2, (String)"schemas");
            super(transaction);
            this.schemas = schemas2;
            this.glutton = glutton;
        }

        public static final /* synthetic */ List access$getSchemas$p(OraDatabaseFirstRetriever $this) {
            return $this.schemas;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseIncRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schemas", "", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "glutton", "", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Ljava/util/List;Z)V", "since", "Ljava/util/Date;", "determineAndRemoveAllDroppedStuff", "", "prepareParameters", "process", "retrieveAllOrdinaryNames", "root", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "retrieveAllSynonyms", "intellij.database.dialects.oracle"})
    private final class OraDatabaseIncRetriever
    extends OraDatabaseRetriever {
        private Date since;
        private final List<OraSchema> schemas;
        private final boolean glutton;

        /*
         * WARNING - void declaration
         */
        @Override
        public void process() {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            this.prepareParameters();
            this.determineAndRemoveAllDroppedStuff();
            Iterable $this$mapNotNull$iv = this.schemas;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                Date date;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                OraSchema it2 = (OraSchema)element$iv$iv;
                boolean bl2 = false;
                if (it2.getIntrospectionTimestamp() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                Date it$iv$iv = date;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                object = (Date)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v0 = it3;
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
                Long l = v0.getTime();
                collection.add(l);
            }
            Long l = (Long)CollectionsKt.min((Iterable)((List)destination$iv$iv));
            long sinceTime = l != null ? l : System.currentTimeMillis();
            this.since = new Timestamp(sinceTime);
            this.setQueryParameter("INC", Boolean.TRUE);
            this.setQueryParameter("SINCE", this.since);
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(this){
                final /* synthetic */ OraDatabaseIncRetriever this$0;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    OraDatabaseIncRetriever.access$retrieveAllOrdinaryNames(this.this$0, root2);
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                    super(1);
                }
            });
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(this){
                final /* synthetic */ OraDatabaseIncRetriever this$0;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    OraDatabaseIncRetriever.access$retrieveAllSynonyms(this.this$0, root2);
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                    super(1);
                }
            });
        }

        private final void prepareParameters() {
            this.setQueryParameter(this.glutton ? "GLUTTON" : "ASCETIC", Boolean.TRUE);
            this.setQueryParameter("ALL_SCHEMA_IDS", this.schemas.stream().map(prepareParameters.1.INSTANCE).toArray());
            this.setQueryParameter("ALL_SCHEMA_NAMES", this.schemas.stream().map(prepareParameters.2.INSTANCE).toArray());
        }

        private final void determineAndRemoveAllDroppedStuff() {
            SqlQuery<long[]> query;
            this.reportRetrieving("detect dropped objects");
            SqlQuery<long[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            long[] idsArray = this.performQuery(sqlQuery);
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(this, identifiers){
                final /* synthetic */ OraDatabaseIncRetriever this$0;
                final /* synthetic */ TLongHashSet $identifiers;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    for (OraSchema schema : OraDatabaseIncRetriever.access$getSchemas$p(this.this$0)) {
                        BasicModSchema basicModSchema = root2.mod(schema);
                        if (basicModSchema == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraSchema");
                        }
                        OraSchema s = (OraSchema)basicModSchema;
                        OraIntrospectorFunctions.access$dropUnexistentObjectsInSchema(s, this.$identifiers);
                    }
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                    this.$identifiers = tLongHashSet;
                    super(1);
                }
            });
        }

        private final void retrieveAllOrdinaryNames(OraRoot root2) {
            SqlQuery<List<String>> query;
            this.reportRetrieving("Major Object Names");
            ModNamingFamily modNamingFamily = root2.getSchemas();
            Intrinsics.checkExpressionValueIsNotNull((Object)modNamingFamily, (String)"root.schemas");
            ModNamingFamily modelSchemas = modNamingFamily;
            SqlQuery<List<String>> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            List items = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            OraIntrospector.this.processNames(items, (ModNamingIdentifyingFamily)modelSchemas, true);
        }

        private final void retrieveAllSynonyms(OraRoot root2) {
            this.reportRetrieving("Synonyms");
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveAllSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveAllSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            OraIntrospectorFunctions.access$processSynonyms(ss, root2);
        }

        public OraDatabaseIncRetriever(@NotNull DBTransaction transaction, List<? extends OraSchema> schemas2, boolean glutton) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schemas2, (String)"schemas");
            super(transaction);
            this.since = BaseIntrospectionFunctions.AGES_AGO;
            this.schemas = schemas2;
            this.glutton = glutton;
        }

        public static final /* synthetic */ void access$retrieveAllOrdinaryNames(OraDatabaseIncRetriever $this, OraRoot root2) {
            $this.retrieveAllOrdinaryNames(root2);
        }

        public static final /* synthetic */ void access$retrieveAllSynonyms(OraDatabaseIncRetriever $this, OraRoot root2) {
            $this.retrieveAllSynonyms(root2);
        }

        public static final /* synthetic */ List access$getSchemas$p(OraDatabaseIncRetriever $this) {
            return $this.schemas;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b0\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0014\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u00010FH\u0002J\b\u0010G\u001a\u00020HH\u0002J\u0018\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020LH\u0002J&\u0010M\u001a\u00020H2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020T0SH\u0002J\u0016\u0010U\u001a\u00020H2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020X0WH\u0002J\b\u0010Y\u001a\u00020HH\u0014J\b\u0010Z\u001a\u00020HH\u0002J\u001a\u0010[\u001a\u00020H2\u0006\u0010\\\u001a\u00020\u00112\b\u0010]\u001a\u0004\u0018\u00010TH\u0002J\u0018\u0010^\u001a\u00020H2\u0006\u0010J\u001a\u00020\u000b2\u0006\u0010]\u001a\u00020TH\u0002J\u0018\u0010_\u001a\u00020H2\u0006\u0010`\u001a\u00020a2\u0006\u0010]\u001a\u00020TH\u0002J$\u0010b\u001a\u0004\u0018\u0001Hc\"\n\b\u0000\u0010c\u0018\u0001*\u00020d2\u0006\u0010e\u001a\u00020TH\u0082\b\u00a2\u0006\u0002\u0010fJ\b\u0010g\u001a\u00020HH\u0014J\b\u0010h\u001a\u00020HH\u0016J\b\u0010i\u001a\u00020HH\u0002J\u0010\u0010j\u001a\u00020H2\u0006\u0010k\u001a\u00020TH\u0014J\b\u0010l\u001a\u00020HH\u0002J\b\u0010m\u001a\u00020HH\u0002J\b\u0010n\u001a\u00020HH\u0002J\b\u0010o\u001a\u00020HH\u0002J\b\u0010p\u001a\u00020HH\u0002J\b\u0010q\u001a\u00020HH\u0002J\b\u0010r\u001a\u00020HH\u0002J\b\u0010s\u001a\u00020HH\u0002J\b\u0010t\u001a\u00020HH\u0002J\b\u0010u\u001a\u00020HH\u0002J\b\u0010v\u001a\u00020HH\u0002J\b\u0010w\u001a\u00020HH\u0002J\b\u0010x\u001a\u00020HH\u0002J\b\u0010y\u001a\u00020HH\u0002J\b\u0010z\u001a\u00020HH\u0002J\b\u0010{\u001a\u00020HH\u0002J\b\u0010|\u001a\u00020HH\u0002J\b\u0010}\u001a\u00020HH\u0002J\b\u0010~\u001a\u00020HH\u0002J\b\u0010\u007f\u001a\u00020HH\u0002J\t\u0010\u0080\u0001\u001a\u00020HH\u0002J\u000f\u0010\u0081\u0001\u001a\u00020HH\u0000\u00a2\u0006\u0003\b\u0082\u0001J\t\u0010\u0083\u0001\u001a\u00020HH\u0014J\t\u0010\u0084\u0001\u001a\u00020HH\u0002J\t\u0010\u0085\u0001\u001a\u00020HH\u0002J\t\u0010\u0086\u0001\u001a\u00020HH\u0002J\t\u0010\u0087\u0001\u001a\u00020HH\u0002J\t\u0010\u0088\u0001\u001a\u00020HH\u0002J\u0018\u0010\u0089\u0001\u001a\u00020H2\r\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020T0SH\u0002J\t\u0010\u008b\u0001\u001a\u00020HH\u0002J\t\u0010\u008c\u0001\u001a\u00020HH\u0002J\t\u0010\u008d\u0001\u001a\u00020HH\u0002J\t\u0010\u008e\u0001\u001a\u00020HH\u0002J\t\u0010\u008f\u0001\u001a\u00020HH\u0002J\t\u0010\u0090\u0001\u001a\u00020HH\u0002J\t\u0010\u0091\u0001\u001a\u00020HH\u0002J\t\u0010\u0092\u0001\u001a\u00020HH\u0002J\t\u0010\u0093\u0001\u001a\u00020HH\u0002J\u0010\u0010\u0094\u0001\u001a\t\u0012\u0005\u0012\u00030\u0095\u00010WH\u0002J\t\u0010\u0096\u0001\u001a\u00020HH\u0002J\u0010\u0010\u0097\u0001\u001a\t\u0012\u0005\u0012\u00030\u0098\u00010WH\u0002J\t\u0010\u0099\u0001\u001a\u00020HH\u0002J\u0018\u0010\u009a\u0001\u001a\t\u0012\u0004\u0012\u00020?0\u009b\u00012\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0016\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u00012\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0002J$\u0010\u00a0\u0001\u001a\u00020H2\u000f\u0010\u00a1\u0001\u001a\n\u0012\u0005\u0012\u00030\u00a2\u00010\u009b\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u0001H\u0002J(\u0010\u00a5\u0001\u001a\u00020H*\u00020\u00022\u0007\u0010\u00a6\u0001\u001a\u00020T2\u0007\u0010\u00a7\u0001\u001a\u00020T2\u0007\u0010\u00a8\u0001\u001a\u00020TH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001a\"\u0004\b%\u0010\u001cR\u001a\u0010&\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001a\"\u0004\b(\u0010\u001cR\u001a\u0010)\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001a\"\u0004\b+\u0010\u001cR\u001a\u0010,\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001a\"\u0004\b.\u0010\u001cR\u001a\u0010/\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001a\"\u0004\b1\u0010\u001cR\u001c\u00102\u001a\u0004\u0018\u000103X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000203X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00105\"\u0004\b:\u00107R\u001c\u0010;\u001a\u0004\u0018\u000103X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u00105\"\u0004\b=\u00107R\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u001a\"\u0004\bB\u0010\u001c\u00a8\u0006\u00a9\u0001"}, d2={"Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector$OraSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/oracle/model/OraSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "Lcom/intellij/database/dialects/oracle/model/OraRoot;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/oracle/introspector/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/dialects/oracle/model/OraSchema;)V", "affectedClusters", "Ljava/util/HashSet;", "Lcom/intellij/database/dialects/oracle/model/OraCluster;", "affectedDepObjects", "Lcom/intellij/database/model/basic/BasicSchemaObject;", "affectedInnerRoutines", "Lcom/intellij/database/model/basic/BasicRoutine;", "affectedModuleBodies", "Lcom/intellij/database/dialects/oracle/model/OraBody;", "affectedModuleSpecs", "Lcom/intellij/database/dialects/oracle/model/OraModule;", "affectedSingleRoutines", "affectedTables", "Lcom/intellij/database/dialects/oracle/model/OraTable;", "affectsClusters", "", "getAffectsClusters$intellij_database_dialects_oracle", "()Z", "setAffectsClusters$intellij_database_dialects_oracle", "(Z)V", "affectsMatLogs", "getAffectsMatLogs$intellij_database_dialects_oracle", "setAffectsMatLogs$intellij_database_dialects_oracle", "affectsMatViews", "getAffectsMatViews$intellij_database_dialects_oracle", "setAffectsMatViews$intellij_database_dialects_oracle", "affectsModulesOrBodies", "getAffectsModulesOrBodies$intellij_database_dialects_oracle", "setAffectsModulesOrBodies$intellij_database_dialects_oracle", "affectsTables", "getAffectsTables$intellij_database_dialects_oracle", "setAffectsTables$intellij_database_dialects_oracle", "affectsTriggers", "getAffectsTriggers$intellij_database_dialects_oracle", "setAffectsTriggers$intellij_database_dialects_oracle", "affectsViews", "getAffectsViews$intellij_database_dialects_oracle", "setAffectsViews$intellij_database_dialects_oracle", "haveDefaults", "getHaveDefaults$intellij_database_dialects_oracle", "setHaveDefaults$intellij_database_dialects_oracle", "myBeginTimestamp", "Ljava/sql/Timestamp;", "getMyBeginTimestamp$intellij_database_dialects_oracle", "()Ljava/sql/Timestamp;", "setMyBeginTimestamp$intellij_database_dialects_oracle", "(Ljava/sql/Timestamp;)V", "myFromTimestamp", "getMyFromTimestamp$intellij_database_dialects_oracle", "setMyFromTimestamp$intellij_database_dialects_oracle", "srcFromTimestamp", "getSrcFromTimestamp$intellij_database_dialects_oracle", "setSrcFromTimestamp$intellij_database_dialects_oracle", "tablesToReorderDetails", "Lcom/intellij/database/dialects/oracle/model/OraLikeTable;", "toStop", "getToStop$intellij_database_dialects_oracle", "setToStop$intellij_database_dialects_oracle", "adjustBigIntegerForSequence", "Ljava/math/BigInteger;", "bigDecimalValue", "Ljava/math/BigDecimal;", "adjustInnerRoutines", "", "applyClusterInfo", "cluster", "c", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneCluster;", "applyIndexingItems", "table", "Lcom/intellij/database/model/basic/BasicTable;", "index", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "items", "", "", "applySourceLines", "lines", "", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneSrcLine;", "clearSchema", "determineAndRemoveDroppedStuff", "determineWhetherTheBodyObfuscated", "body", "text", "extractClusterColumns", "extractPackageChildren", "pkg", "Lcom/intellij/database/dialects/oracle/model/OraPackage;", "parseStatement", "T", "Lcom/intellij/sql/psi/SqlStatement;", "src", "(Ljava/lang/String;)Lcom/intellij/sql/psi/SqlStatement;", "prepareParameters", "process", "reorderTableDetails", "reportRetrieving", "what", "retrieveChecks", "retrieveClusterIndices", "retrieveClusters", "retrieveCollectionTypes", "retrieveColumnDefaults", "retrieveColumns", "retrieveComments", "retrieveConstraintColumns", "retrieveDependencies", "retrieveDependenciesFast", "retrieveDependenciesSlow", "retrieveEntireSchema", "retrieveErrors", "retrieveForeignKeys", "retrieveFragment", "retrieveFragmentNewObjectNames", "retrieveIndices", "retrieveIndicesColumns", "retrieveInnerRoutines", "retrieveInnerRoutinesArguments", "retrieveKeys", "retrieveMain", "retrieveMain$intellij_database_dialects_oracle", "retrieveMainContent", "retrieveMatLogs", "retrieveMatViews", "retrieveObjectTypeAttributes", "retrieveObjectTypes", "retrievePackages", "retrieveProgramSourcePortion", "names", "retrieveProgramSourcesByPortions", "retrieveSchemaInfo", "retrieveSequences", "retrieveSingleRoutines", "retrieveSingleRoutinesArguments", "retrieveSources", "retrieveSynonyms", "retrieveTableClusterColumns", "retrieveTables", "retrieveTriggerSources", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneTriggerSource;", "retrieveTriggers", "retrieveViewSources", "Lcom/intellij/database/dialects/oracle/introspector/OraIntroQueries$OneViewSource;", "retrieveViews", "seanceRelatedTablesAndViews", "", "trigTurnOf", "Lcom/intellij/database/model/TrigTurn;", "turn", "", "updateInvalidStatus", "family", "Lcom/intellij/database/model/basic/BasicModElement;", "invalids", "Lgnu/trove/TLongHashSet;", "applySources", "type", "name", "sourceText", "intellij.database.dialects.oracle"})
    protected final class OraSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever<OraSchema> {
        @NotNull
        private Timestamp myFromTimestamp;
        @Nullable
        private Timestamp myBeginTimestamp;
        @Nullable
        private Timestamp srcFromTimestamp;
        private boolean affectsClusters;
        private boolean affectsTables;
        private boolean affectsMatLogs;
        private boolean affectsMatViews;
        private boolean affectsViews;
        private boolean affectsTriggers;
        private boolean affectsModulesOrBodies;
        private boolean haveDefaults;
        private boolean toStop;
        private final HashSet<OraLikeTable> tablesToReorderDetails;
        private final HashSet<OraCluster> affectedClusters;
        private final HashSet<OraModule> affectedModuleSpecs;
        private final HashSet<OraBody> affectedModuleBodies;
        private final HashSet<BasicRoutine> affectedInnerRoutines;
        private final HashSet<BasicRoutine> affectedSingleRoutines;
        private final HashSet<BasicSchemaObject> affectedDepObjects;
        private final HashSet<OraTable> affectedTables;

        @NotNull
        public final Timestamp getMyFromTimestamp$intellij_database_dialects_oracle() {
            return this.myFromTimestamp;
        }

        public final void setMyFromTimestamp$intellij_database_dialects_oracle(@NotNull Timestamp timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"<set-?>");
            this.myFromTimestamp = timestamp;
        }

        @Nullable
        public final Timestamp getMyBeginTimestamp$intellij_database_dialects_oracle() {
            return this.myBeginTimestamp;
        }

        public final void setMyBeginTimestamp$intellij_database_dialects_oracle(@Nullable Timestamp timestamp) {
            this.myBeginTimestamp = timestamp;
        }

        @Nullable
        public final Timestamp getSrcFromTimestamp$intellij_database_dialects_oracle() {
            return this.srcFromTimestamp;
        }

        public final void setSrcFromTimestamp$intellij_database_dialects_oracle(@Nullable Timestamp timestamp) {
            this.srcFromTimestamp = timestamp;
        }

        public final boolean getAffectsClusters$intellij_database_dialects_oracle() {
            return this.affectsClusters;
        }

        public final void setAffectsClusters$intellij_database_dialects_oracle(boolean bl) {
            this.affectsClusters = bl;
        }

        public final boolean getAffectsTables$intellij_database_dialects_oracle() {
            return this.affectsTables;
        }

        public final void setAffectsTables$intellij_database_dialects_oracle(boolean bl) {
            this.affectsTables = bl;
        }

        public final boolean getAffectsMatLogs$intellij_database_dialects_oracle() {
            return this.affectsMatLogs;
        }

        public final void setAffectsMatLogs$intellij_database_dialects_oracle(boolean bl) {
            this.affectsMatLogs = bl;
        }

        public final boolean getAffectsMatViews$intellij_database_dialects_oracle() {
            return this.affectsMatViews;
        }

        public final void setAffectsMatViews$intellij_database_dialects_oracle(boolean bl) {
            this.affectsMatViews = bl;
        }

        public final boolean getAffectsViews$intellij_database_dialects_oracle() {
            return this.affectsViews;
        }

        public final void setAffectsViews$intellij_database_dialects_oracle(boolean bl) {
            this.affectsViews = bl;
        }

        public final boolean getAffectsTriggers$intellij_database_dialects_oracle() {
            return this.affectsTriggers;
        }

        public final void setAffectsTriggers$intellij_database_dialects_oracle(boolean bl) {
            this.affectsTriggers = bl;
        }

        public final boolean getAffectsModulesOrBodies$intellij_database_dialects_oracle() {
            return this.affectsModulesOrBodies;
        }

        public final void setAffectsModulesOrBodies$intellij_database_dialects_oracle(boolean bl) {
            this.affectsModulesOrBodies = bl;
        }

        public final boolean getHaveDefaults$intellij_database_dialects_oracle() {
            return this.haveDefaults;
        }

        public final void setHaveDefaults$intellij_database_dialects_oracle(boolean bl) {
            this.haveDefaults = bl;
        }

        public final boolean getToStop$intellij_database_dialects_oracle() {
            return this.toStop;
        }

        public final void setToStop$intellij_database_dialects_oracle(boolean bl) {
            this.toStop = bl;
        }

        @Override
        protected void prepareParameters() {
            super.prepareParameters();
            String[] fragmentKindTypeNames = OraObjectCodes.KIND_ORACLE_NAMES.get(this.getFragmentKind());
            this.setQueryParameter("major_object_type_names", fragmentKindTypeNames);
            this.setQueryParameter("major_object_names", this.getFragmentNames());
            this.setQueryParameter("src_since", this.srcFromTimestamp);
        }

        @Override
        public void process() {
            this.retrieveMain$intellij_database_dialects_oracle();
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveMain$intellij_database_dialects_oracle();
        }

        public final void retrieveMain$intellij_database_dialects_oracle() {
            this.prepareParameters();
            if (this.getMode().fragment) {
                this.retrieveFragment();
            } else {
                this.retrieveEntireSchema();
            }
        }

        private final void retrieveEntireSchema() {
            boolean skipSystemSchema;
            boolean bl = skipSystemSchema = this.getMode().increment && OraIntrospectorFunctions.access$getSYSTEM_SCHEMAS$p().contains(((OraSchema)this.getSchema()).getName()) && !OraIntrospector.this.getConsiderSystemSchemasReinstrospection() && !((OraSchema)this.getSchema()).isCurrent();
            if (skipSystemSchema) {
                return;
            }
            Timestamp beginTimestamp = (Timestamp)this.getTransaction().query(((OraIntrospector)OraIntrospector.this).queries.askForTimeNow).run();
            boolean bl2 = beginTimestamp != null;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string = "Failed to obtain the current timestamp from the database";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.myBeginTimestamp = beginTimestamp;
            this.reportRetrieving("schema information");
            this.retrieveSchemaInfo();
            if (this.toStop) {
                return;
            }
            Date modifiedTimestamp = ((OraSchema)this.getSchema()).getModifiedTimestamp();
            Timestamp srcFromTimestamp1 = this.srcFromTimestamp;
            boolean bl5 = this.toStop = modifiedTimestamp != null && modifiedTimestamp.before(this.myFromTimestamp) && (!this.getWithSources() || srcFromTimestamp1 != null && !srcFromTimestamp1.before(modifiedTimestamp));
            if (this.toStop) {
                this.retrieveComments();
                return;
            }
            this.retrieveSequences();
            this.retrieveObjectTypes();
            this.retrieveCollectionTypes();
            this.retrieveObjectTypeAttributes();
            this.retrieveClusters();
            this.retrieveTables();
            this.retrieveMatLogs();
            this.retrieveMatViews();
            this.retrieveViews();
            this.retrieveColumns();
            this.retrieveColumnDefaults();
            this.retrieveClusterIndices();
            this.retrieveTableClusterColumns();
            this.retrieveIndices();
            this.retrieveIndicesColumns();
            this.retrieveKeys();
            this.retrieveForeignKeys();
            this.retrieveChecks();
            this.retrieveConstraintColumns();
            this.reorderTableDetails();
            this.retrieveTriggers();
            this.retrievePackages();
            this.retrieveInnerRoutines();
            this.retrieveInnerRoutinesArguments();
            this.adjustInnerRoutines();
            this.retrieveSingleRoutines();
            this.retrieveSingleRoutinesArguments();
            this.retrieveComments();
            this.retrieveDependencies();
            this.retrieveSources();
            this.retrieveErrors();
            this.reportRetrieving("finishing the schema...");
            this.inSchema((Function1)new Function1<OraSchema, Unit>(beginTimestamp){
                final /* synthetic */ Timestamp $beginTimestamp;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    schema.setIntrospectionTimestamp(this.$beginTimestamp);
                }
                {
                    this.$beginTimestamp = timestamp;
                    super(1);
                }
            });
            if (this.getWithSources()) {
                BasicModModel basicModModel = this.getModel();
                BasicSchema basicSchema = (BasicSchema)this.getSchema();
                Timestamp timestamp = beginTimestamp;
                Intrinsics.checkExpressionValueIsNotNull((Object)timestamp, (String)"beginTimestamp");
                basicModModel.setSchemaSourcesVersion(basicSchema, timestamp.getTime());
            }
        }

        private final void retrieveFragment() {
            this.retrieveFragmentNewObjectNames();
            this.determineAndRemoveDroppedStuff();
            ObjectKind objectKind = this.getFragmentKind();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE)) {
                this.retrieveSequences();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.CLUSTER)) {
                this.retrieveClusters();
                this.retrieveColumns();
                this.retrieveClusterIndices();
                this.retrieveTableClusterColumns();
                this.retrieveIndicesColumns();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                this.retrieveTables();
                this.retrieveMatLogs();
                this.retrieveColumns();
                this.retrieveColumnDefaults();
                this.retrieveComments();
                this.retrieveIndices();
                this.retrieveIndicesColumns();
                this.retrieveKeys();
                this.retrieveForeignKeys();
                this.retrieveChecks();
                this.retrieveConstraintColumns();
                this.retrieveTriggers();
                this.reorderTableDetails();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_LOG)) {
                this.retrieveTables();
                this.retrieveMatLogs();
                this.retrieveColumns();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW)) {
                this.retrieveTables();
                this.retrieveMatLogs();
                this.retrieveMatViews();
                this.retrieveColumns();
                this.retrieveIndices();
                this.retrieveIndicesColumns();
                this.retrieveKeys();
                this.retrieveConstraintColumns();
                this.retrieveComments();
                this.retrieveTriggers();
                this.reorderTableDetails();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                this.retrieveViews();
                this.retrieveColumns();
                this.retrieveComments();
                this.retrieveTriggers();
                this.reorderTableDetails();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
                this.retrieveSingleRoutines();
                this.retrieveSingleRoutinesArguments();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.PACKAGE)) {
                this.retrievePackages();
                this.retrieveInnerRoutines();
                this.retrieveInnerRoutinesArguments();
                this.adjustInnerRoutines();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE)) {
                this.retrieveObjectTypes();
                this.retrieveObjectTypeAttributes();
                this.retrieveInnerRoutines();
                this.retrieveInnerRoutinesArguments();
                this.adjustInnerRoutines();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLLECTION_TYPE)) {
                this.retrieveCollectionTypes();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SYNONYM)) {
                this.retrieveSynonyms();
            }
        }

        private final void retrieveFragmentNewObjectNames() {
            SqlQuery<List<String>> listIdsQuery;
            ObjectKind fragmentKind = this.getFragmentKind();
            SqlQuery<List<String>> sqlQuery = listIdsQuery = fragmentKind == ObjectKind.OBJECT_TYPE || fragmentKind == ObjectKind.COLLECTION_TYPE ? ((OraIntrospector)OraIntrospector.this).queries.listFragmentTypeIds : ((OraIntrospector)OraIntrospector.this).queries.listFragmentRegularIds;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"listIdsQuery");
            List items = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.getModel().modify(OraRoot.class, (ModelModifier)new ModelModifier<OraRoot>(this, items){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $items;

                public final void perform(OraRoot root2) {
                    OraIntrospector oraIntrospector = this.this$0.OraIntrospector.this;
                    OraRoot oraRoot = root2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)oraRoot, (String)"root");
                    ModNamingFamily modNamingFamily = oraRoot.getSchemas();
                    Intrinsics.checkExpressionValueIsNotNull((Object)modNamingFamily, (String)"root.schemas");
                    OraIntrospector.access$processNames(oraIntrospector, this.$items, (ModNamingIdentifyingFamily)modNamingFamily, true);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$items = list;
                }
            });
        }

        private final void determineAndRemoveDroppedStuff() {
            SqlQuery<long[]> query;
            this.reportRetrieving("detect dropped objects");
            SqlQuery<long[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            long[] idsArray = this.performQuery(sqlQuery);
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(identifiers){
                final /* synthetic */ TLongHashSet $identifiers;

                public final void invoke(@NotNull OraSchema s) {
                    Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                    OraIntrospectorFunctions.access$dropUnexistentObjectsInSchema(s, this.$identifiers);
                }
                {
                    this.$identifiers = tLongHashSet;
                    super(1);
                }
            });
        }

        @Override
        protected void clearSchema() {
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    BasicModElement.dropChildren(schema);
                    schema.setCreatedTimestamp(null);
                    schema.setModifiedTimestamp(null);
                    schema.setIntrospectionTimestamp(null);
                    OraSchemaRetriever.access$getModel$p(this.this$0).setSchemaSourcesVersion(schema, null);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    super(1);
                }
            });
        }

        private final void retrieveSchemaInfo() {
            boolean schemaIsPublic = Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"PUBLIC");
            SqlQuery<OraIntroQueries.OneSchemaInfo> sqlQuery = schemaIsPublic ? ((OraIntrospector)OraIntrospector.this).queries.retrievePublicSchemaInfo : ((OraIntrospector)OraIntrospector.this).queries.retrieveSchemaInfo;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"if (schemaIsPublic) quer\u2026ueries.retrieveSchemaInfo");
            OraIntroQueries.OneSchemaInfo info = this.performQuery(sqlQuery);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(info){
                final /* synthetic */ OraIntroQueries.OneSchemaInfo $info;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    schema.setObjectId(this.$info.user_id);
                    schema.setCreatedTimestamp(this.$info.created_timestamp);
                    schema.setModifiedTimestamp(this.$info.modified_timestamp);
                }
                {
                    this.$info = oneSchemaInfo;
                    super(1);
                }
            });
            this.setQueryParameter("SCHEMA_ID", info.user_id);
        }

        private final void retrieveSequences() {
            ModNamingIdentifyingFamily<? extends OraSequence> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getSequences();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.sequences");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Sequences");
            SqlQuery<List<OraIntroQueries.OneSequence>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSequences;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSequences");
            List ss = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (ss.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, ss){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ss;

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneSequence s : this.$ss) {
                        v0 = sequence = schema.getSequences().renew(s.object_id, s.sequence_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"sequence");
                        v0.setSequenceIdentity(SequenceIdentity.of(OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.min_value), OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.last_number), BigInteger.valueOf(s.increment_by), OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.max_value)));
                        sequence.setOrdered(s.order_flag);
                        sequence.setCycled(s.cycle_flag);
                        v1 = s.cache_size;
                        sequence.setCacheSize(v1 != null ? v1 : 0);
                        sequence.setBelongsToColumn(s.generated);
                        v2 = sequence;
                        if (!s.generated) ** GOTO lbl-1000
                        v3 = s.sequence_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"s.sequence_name");
                        var5_5 = v3;
                        var6_6 = OraIntrospectorFunctions.access$getSEQUENCE_SURROGATE_NAME_PATTERN$p();
                        var8_8 = v2;
                        var7_7 = false;
                        var9_9 = var6_6.matches(var5_5);
                        v2 = var8_8;
                        if (var9_9) {
                            v4 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = false;
                        }
                        v2.setNameSurrogate(v4);
                        sequence.setCreatedTimestamp(s.created_timestamp);
                        sequence.setModifiedTimestamp(s.modified_timestamp);
                    }
                    schema.getSequences().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ss = list;
                    super(1);
                }
            });
        }

        private final BigInteger adjustBigIntegerForSequence(BigDecimal bigDecimalValue) {
            BigInteger bigInteger;
            String str;
            if (bigDecimalValue == null) {
                return null;
            }
            BigInteger bi = bigDecimalValue.toBigInteger();
            String string = bi.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bi.toString()");
            switch (str = string) {
                case "99999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "9999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-99999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-9999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "1000000000000000000000000000": {
                    bigInteger = null;
                    break;
                }
                case "-1000000000000000000000000000": {
                    bigInteger = null;
                    break;
                }
                default: {
                    bigInteger = bi;
                }
            }
            return bigInteger;
        }

        private final void retrieveObjectTypes() {
            ModNamingIdentifyingFamily<? extends OraObjectType> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getObjectTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.objectTypes");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Object Types");
            SqlQuery<List<OraIntroQueries.OneObjectType>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveObjectTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveObjectTypes");
            List ots = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (ots.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, ots){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ots;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneObjectType ot : this.$ots) {
                        OraObjectType oType;
                        OraObjectType oraObjectType = oType = schema.getObjectTypes().renew(ot.object_id, ot.type_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraObjectType, (String)"oType");
                        oraObjectType.setSuperSchemaName(ot.supertype_schema_name);
                        oType.setSuperObjectName(ot.supertype_name);
                        oType.setCreatedTimestamp(ot.created_timestamp);
                        oType.setModifiedTimestamp(ot.modified_timestamp);
                        oType.setIncomplete(ot.is_incomplete);
                        oType.setFinal(ot.is_final);
                        oType.setInstantiable(ot.is_instantiable);
                        if (ot.body_object_id != 0L) {
                            OraObjectTypeBody body2;
                            OraObjectTypeBody oraObjectTypeBody = body2 = oType.getBodies().createOrGet();
                            Intrinsics.checkExpressionValueIsNotNull((Object)oraObjectTypeBody, (String)"body");
                            oraObjectTypeBody.setObjectId(ot.body_object_id);
                            body2.setName(ot.type_name);
                            OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(body2, ot.body_created_timestamp, ot.body_modified_timestamp);
                            OraSchemaRetriever.access$getAffectedModuleBodies$p(this.this$0).add(body2);
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(body2);
                        } else {
                            oType.getBodies().clear();
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(oType);
                        }
                        OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).add(oType);
                    }
                    schema.getObjectTypes().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ots = list;
                    super(1);
                }
            });
            this.affectsModulesOrBodies = true;
        }

        private final void retrieveCollectionTypes() {
            ModNamingIdentifyingFamily<? extends OraCollectionType> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getCollectionTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.collectionTypes");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Collection Types");
            SqlQuery<List<OraIntroQueries.OneCollectionType>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveCollectionTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveCollectionTypes");
            List cts = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (cts.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(cts){
                final /* synthetic */ List $cts;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneCollectionType ct : this.$cts) {
                        OraCollectionType cType;
                        OraCollectionType oraCollectionType = cType = schema.getCollectionTypes().renew(ct.object_id, ct.type_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraCollectionType, (String)"cType");
                        oraCollectionType.setTypeKind(ct.collection_kind == 'A' ? OraCollectionTypeKind.VARIABLE_SIZE_ARRAY : OraCollectionTypeKind.NESTED_TABLE);
                        cType.setUpperBound(ct.upper_bound);
                        DataType type = OraIntrospectorFunctions.access$makeDataType(schema, ct.data_type_schema_name, null, ct.data_type, ct.data_size, ct.data_scale, ct.data_size_units);
                        cType.setElementType(type);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(cType, ct.created_timestamp, ct.modified_timestamp);
                    }
                    schema.getCollectionTypes().sort();
                }
                {
                    this.$cts = list;
                    super(1);
                }
            });
        }

        private final void retrieveObjectTypeAttributes() {
            ModNamingIdentifyingFamily<? extends OraObjectType> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getObjectTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.objectTypes");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Object Type Attributes");
            SqlQuery<List<OraIntroQueries.OneObjectTypeAttribute>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveObjectTypeAttributes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveObjectTypeAttributes");
            List attrs = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (attrs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(attrs){
                final /* synthetic */ List $attrs;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    HashSet<OraObjectType> affectedObjectTypes = new HashSet<OraObjectType>(schema.getObjectTypes().size());
                    for (OraIntroQueries.OneObjectTypeAttribute ota : this.$attrs) {
                        OraObjectTypeAttribute attr;
                        OraObjectType ot;
                        OraObjectType oraObjectType = ot = (OraObjectType)schema.getObjectTypes().createOrGet(ota.type_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraObjectType, (String)"ot");
                        OraObjectTypeAttribute oraObjectTypeAttribute = attr = (OraObjectTypeAttribute)oraObjectType.getAttributes().createOrGet(ota.attr_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraObjectTypeAttribute, (String)"attr");
                        oraObjectTypeAttribute.setPosition(ota.position);
                        DataType type = OraIntrospectorFunctions.access$makeDataType(schema, ota.data_type_schema, null, ota.data_type, ota.data_size, ota.data_scale, ota.data_size_units);
                        attr.setDataType(type);
                        affectedObjectTypes.add(ot);
                    }
                    Iterator<E> iterator = affectedObjectTypes.iterator();
                    while (iterator.hasNext()) {
                        OraObjectType objectType;
                        OraObjectType oraObjectType = objectType = (OraObjectType)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraObjectType, (String)"objectType");
                        oraObjectType.getAttributes().sort();
                    }
                }
                {
                    this.$attrs = list;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveClusters() {
            void cs;
            ModNamingIdentifyingFamily<? extends OraCluster> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getClusters();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.clusters");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Clusters");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = CollectionsKt.emptyList();
            boolean ora31603 = false;
            try {
                SqlQuery<List<OraIntroQueries.OneCluster>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusters;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveClusters");
                cs.element = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            }
            catch (DBException e) {
                if (e.vendorErrorCode == 31603) {
                    ora31603 = true;
                    String string = ((OraSchema)this.getSchema()).getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schema.name");
                    String schemaName = string;
                    OraIntrospector.this.getLog().warn("Oracle schema " + schemaName + ": Unable to retrieve CLUSTER details because the user has no SELECT_CATALOG_ROLE.");
                    Notification notification = new Notification("Oracle Introspector Unable To Retrieve Cluster Details", AllIcons.Ide.Notification.WarningEvents, "Cluster details not retrieved", null, "Oracle Introspector is unable to retrieve details of clusters in schema " + schemaName + ".\n" + "In order to retrieve these details, grant the user the SELECT_CATALOG_ROLE, " + "then refresh the data source again (use the 'Forget Cached Schemas' action).", NotificationType.WARNING, null);
                    Notifications.Bus.notify((Notification)notification);
                }
                throw (Throwable)e;
            }
            if (ora31603) {
                SqlQuery<List<OraIntroQueries.OneCluster>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClustersWhenNoPermissions;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveClustersWhenNoPermissions");
                cs.element = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            }
            if (((List)cs.element).isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, (Ref.ObjectRef)cs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Ref.ObjectRef $cs;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneCluster c2 : (List)this.$cs.element) {
                        OraCluster cluster;
                        OraCluster oraCluster = cluster = (OraCluster)schema.getClusters().createOrGet(c2.id);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraCluster, (String)"cluster");
                        OraSchemaRetriever.access$applyClusterInfo(this.this$0, oraCluster, c2);
                        OraSchemaRetriever.access$getAffectedClusters$p(this.this$0).add(cluster);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cs = objectRef;
                    super(1);
                }
            });
            this.affectsClusters = true;
        }

        private final void applyClusterInfo(OraCluster cluster, OraIntroQueries.OneCluster c2) {
            String string;
            cluster.setClusterType(ClusterType.of((char)c2.type_code));
            cluster.setSingleTable(c2.single_table);
            cluster.setBlockSize(c2.block_size);
            OraCluster oraCluster = cluster;
            String string2 = c2.hash_expression;
            if (string2 != null) {
                String string3 = string2;
                OraCluster oraCluster2 = oraCluster;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                oraCluster = oraCluster2;
                string = string5;
            } else {
                string = null;
            }
            oraCluster.setHashExpression(string);
            cluster.setHashCardinality(c2.hash_cardinality);
            cluster.setTablespaceName(c2.tablespace_name);
            String decompiled_text = c2.decompiled_text;
            if (decompiled_text != null) {
                String string6 = c2.decompiled_text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"c.decompiled_text");
                this.extractClusterColumns(cluster, string6);
            }
        }

        private final void extractClusterColumns(OraCluster cluster, String text2) {
            SqlStatement sqlStatement;
            ModPositioningNamingFamily<? extends OraClusterColumn> modPositioningNamingFamily = cluster.getColumns();
            Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"cluster.columns");
            ModPositioningNamingFamily<? extends OraClusterColumn> columns = modPositioningNamingFamily;
            OraSchemaRetriever this_$iv = this;
            boolean $i$f$parseStatement = false;
            try {
                IntrospectorSqlHelper this_$iv$iv = this_$iv.OraIntrospector.this.getSqlHelper();
                boolean $i$f$statements = false;
                sqlStatement = (SqlStatement)this_$iv$iv.statements(text2, SqlCreateStatement.class).first();
            }
            catch (Exception e$iv) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    this_$iv.OraIntrospector.this.getLog().error((Throwable)e$iv);
                }
                this_$iv.OraIntrospector.this.getLog().warn("Failed to parse sources", (Throwable)e$iv);
                sqlStatement = null;
            }
            SqlCreateStatement statement = (SqlCreateStatement)sqlStatement;
            if (statement == null || Intrinsics.areEqual((Object)statement.getKind(), (Object)ObjectKind.CLUSTER) ^ true) {
                columns.clear();
                return;
            }
            columns.markChildrenAsSyncPending();
            JBIterable jBIterable = statement.getDasChildren(ObjectKind.COLUMN);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"statement.getDasChildren(COLUMN)");
            JBIterable parsedColumns = jBIterable;
            Iterator iterator = parsedColumns.iterator();
            while (iterator.hasNext()) {
                DasObject c2;
                DasObject dasObject = c2 = (DasObject)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)dasObject, (String)"c");
                OraClusterColumn column2 = (OraClusterColumn)columns.createOrGet(dasObject.getName());
                OraIntrospector.this.getSqlHelper().getBuilder().partialBuild((DasObject)column2, c2);
            }
            columns.removeSyncPendingChildren();
            columns.sort();
        }

        private final void retrieveTables() {
            ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.tables");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Tables");
            SqlQuery<List<OraIntroQueries.OneTable>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTables;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTables");
            List<OraIntroQueries.OneTable> tabs = this.performQuery(sqlQuery);
            if (tabs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, tabs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $tabs;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneTable tab : this.$tabs) {
                        TableOrganization tableOrganization;
                        OraTable table;
                        String tableName = tab.table_name;
                        OraTable oraTable = table = schema.getTables().renew(tab.object_id, tableName);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraTable, (String)"table");
                        oraTable.setMasterTableName(tab.master_table_name);
                        table.setClusterName(tab.cluster_name);
                        table.setTemporary(tab.is_temp);
                        table.setTemporaryPreserve(tab.is_temp_preserved);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(table, tab.created_timestamp, tab.modified_timestamp);
                        OraCluster cluster = tab.cluster_name != null ? (OraCluster)schema.getClusters().get(tab.cluster_name) : null;
                        boolean clusterIsIndexed = cluster != null && cluster.getHashCardinality() == 0;
                        switch (tab.organization_kind) {
                            case 'I': {
                                tableOrganization = TableOrganization.INDEX;
                                break;
                            }
                            case 'C': {
                                if (clusterIsIndexed) {
                                    tableOrganization = TableOrganization.ORA_CLUSTERED_BY_INDEX;
                                    break;
                                }
                                tableOrganization = TableOrganization.ORA_CLUSTERED_BY_HASH;
                                break;
                            }
                            default: {
                                tableOrganization = TableOrganization.DEFAULT;
                            }
                        }
                        table.setOrganization(tableOrganization);
                        table.setRowTypeSchemaName(tab.row_type_schema_name);
                        table.setRowTypeObjectName(tab.row_type_name);
                        table.setTableType(tab.is_mat_log ? OraTableType.MAT_LOG : (tab.is_mat_view ? OraTableType.MAT_VIEW : OraTableType.BASIC));
                        table.setNameSurrogate(tab.is_mat_log);
                        if (tab.has_mat_log) {
                            table.getMatLogs().createOrGet();
                        } else {
                            table.getMatLogs().clear();
                        }
                        table.getChecks().clear();
                        table.getForeignKeys().clear();
                        table.getKeys().clear();
                        OraSchemaRetriever.access$getAffectedTables$p(this.this$0).add(table);
                        this.this$0.setAffectsMatLogs$intellij_database_dialects_oracle(this.this$0.getAffectsMatLogs$intellij_database_dialects_oracle() || tab.is_mat_log || tab.has_mat_log);
                        this.this$0.setAffectsMatViews$intellij_database_dialects_oracle(this.this$0.getAffectsMatViews$intellij_database_dialects_oracle() || tab.is_mat_view);
                    }
                    schema.getTables().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$tabs = list;
                    super(1);
                }
            });
            this.affectsTables = true;
        }

        private final void retrieveMatLogs() {
            if (!this.affectsMatLogs) {
                return;
            }
            this.reportRetrieving("Materialized Logs");
            SqlQuery<List<OraIntroQueries.OneMatLog>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveMatLogs;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveMatLogs");
            List<OraIntroQueries.OneMatLog> mls = this.performQuery(sqlQuery);
            if (mls.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(mls){
                final /* synthetic */ List $mls;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneMatLog m : this.$mls) {
                        OraTable table;
                        OraMatLog ml;
                        if ((OraTable)schema.getTables().get(m.table_name) == null) {
                            continue;
                        }
                        OraMatLog oraMatLog = ml = table.getMatLogs().createOrGet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraMatLog, (String)"ml");
                        oraMatLog.setName(m.log_name);
                        ml.setNameSurrogate(true);
                        ml.setWithRowId(m.with_rowid);
                        ml.setWithObjectId(m.with_object_id);
                        ml.setWithPrimaryKey(m.with_primary_key);
                        ml.setWithSequence(m.with_sequence);
                        ml.setWithNewValues(m.with_new_values);
                    }
                }
                {
                    this.$mls = list;
                    super(1);
                }
            });
        }

        private final void retrieveMatViews() {
            ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getMatViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.matViews");
            if (modNamingIdentifyingFamily.isEmpty() && !this.affectsMatViews) {
                return;
            }
            this.reportRetrieving("Materialized Views");
            SqlQuery<List<OraIntroQueries.OneMatView>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveMatViews;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveMatViews");
            List<OraIntroQueries.OneMatView> vs = this.performQuery(sqlQuery);
            if (vs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, vs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $vs;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneMatView v2 : this.$vs) {
                        OraMatView view2;
                        OraMatView oraMatView = view2 = schema.getMatViews().renew(v2.object_id, v2.view_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraMatView, (String)"view");
                        oraMatView.setPrebuilt(v2.prebuilt);
                        view2.setModifiable(v2.modifiable);
                        view2.setRefreshMode(OraMatViewRefreshMode.byCode(v2.refresh_mode));
                        view2.setRefreshMethod(OraMatViewRefreshMethod.byCode(v2.refresh_method));
                        view2.setInvalid(v2.is_invalid);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(view2, v2.created_timestamp, v2.modified_timestamp);
                        if (this.this$0.getMode() == IntrospectionMode.INCREMENT) {
                            OraTable oraTable = (OraTable)schema.getTables().get(v2.view_name);
                            if (oraTable != null) {
                                oraTable.setTableType(OraTableType.MAT_VIEW);
                            }
                        }
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(view2);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$vs = list;
                    super(1);
                }
            });
            this.affectsMatViews = true;
        }

        private final void retrieveViews() {
            ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getViews();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.views");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Views");
            SqlQuery<List<OraIntroQueries.OneView>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveViews;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveViews");
            List<OraIntroQueries.OneView> vs = this.performQuery(sqlQuery);
            if (vs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, vs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $vs;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneView v2 : this.$vs) {
                        OraView view2;
                        OraView oraView = view2 = schema.getViews().renew(v2.object_id, v2.view_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraView, (String)"view");
                        oraView.setModifiable(v2.modifiable);
                        view2.setInvalid(v2.is_invalid);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(view2, v2.created_timestamp, v2.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(view2);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$vs = list;
                    super(1);
                }
            });
            this.affectsViews = true;
        }

        private final void retrieveColumns() {
            this.haveDefaults = false;
            if (!(this.affectsClusters || this.affectsTables || this.affectsMatViews || this.affectsViews)) {
                return;
            }
            this.reportRetrieving("Table and View Columns");
            SqlQuery<List<OraIntroQueries.OneColumn>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveColumns");
            List cols2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (cols2.isEmpty()) {
                return;
            }
            HashSet affectedTables = new HashSet();
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, cols2, affectedTables){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $cols;
                final /* synthetic */ HashSet $affectedTables;

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    major = null;
                    major_id = -9223372036854775808L;
                    for (OraIntroQueries.OneColumn col : this.$cols) {
                        block10: {
                            if (col.major_id == major_id) break block10;
                            var7_6 = schema;
                            objectId$iv = col.major_id;
                            $i$f$findById = false;
                            v0 = $this$findById$iv.getDatabase();
                            if (v0 == null) ** GOTO lbl-1000
                            $this$findById$iv$iv = v0;
                            $i$f$findById = false;
                            v1 = $this$findById$iv$iv.findIdentifiedElement(objectId$iv);
                            if (!(v1 instanceof OraMajorObject)) {
                                v1 = null;
                            }
                            if ((v0 = (OraMajorObject)v1) != null) {
                                var11_16 = v0;
                                var12_17 = false;
                                var13_18 = false;
                                it$iv = var11_16;
                                $i$a$-takeIf-ModelFun$findById$1 = false;
                                v2 = Intrinsics.areEqual((Object)it$iv.getSchema(), (Object)$this$findById$iv) ? var11_16 : null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = major = null;
                            }
                            if (major == null) continue;
                            major_id = col.major_id;
                            $this$findById$iv = major;
                            if (!($this$findById$iv instanceof OraLikeTable)) continue;
                            ((OraLikeTable)major).getColumns().markChildrenAsSyncPending();
                            this.$affectedTables.add(major);
                        }
                        $this$findById$iv = major != null;
                        objectId$iv = false;
                        var9_12 = false;
                        if (_Assertions.ENABLED && !$this$findById$iv) {
                            var10_14 = false;
                            var10_15 = "Assertion failed";
                            throw (Throwable)new AssertionError((Object)var10_15);
                        }
                        objectId$iv = major;
                        if (!(objectId$iv instanceof OraLikeTable)) continue;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((OraLikeTable)major).getColumns(), (String)"when (major) {\n         \u2026e@columns\n              }");
                        v3 = tableColumns.createOrGet(col.column_name);
                        Intrinsics.checkExpressionValueIsNotNull(v3, (String)"tableColumns.createOrGet(col.column_name)");
                        column = (OraInfraColumn)v3;
                        column.resetSyncPending();
                        column.setPosition(col.column_position);
                        type = OraIntrospectorFunctions.access$makeDataType(schema, col.data_type_schema_name, null, col.data_type, col.data_size, col.data_scale, col.data_size_units);
                        column.setDataType(type);
                        if (column instanceof OraLikeColumn) {
                            ((OraLikeColumn)column).setNotNull(col.mandatory);
                        }
                        if (!(column instanceof OraTableColumn)) continue;
                        ((OraTableColumn)column).setAutoInc(col.identity_column);
                        ((OraTableColumn)column).setDefaultOnNull(col.default_on_null);
                        if (col.has_default_expression && !col.identity_column) {
                            this.this$0.setHaveDefaults$intellij_database_dialects_oracle(true);
                            continue;
                        }
                        ((OraTableColumn)column).setDefaultExpression(null);
                    }
                    if (this.this$0.getMode().increment || this.this$0.getMode().fragment) {
                        var6_4 = this.$affectedTables.iterator();
                        while (var6_4.hasNext()) {
                            v4 = affectedTable = (OraLikeTable)var6_4.next();
                            if (v4 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraLikeTable");
                            }
                            v4.getColumns().removeSyncPendingChildren();
                        }
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cols = list;
                    this.$affectedTables = hashSet;
                    super(1);
                }
            });
            this.tablesToReorderDetails.addAll(affectedTables);
        }

        private final void retrieveColumnDefaults() {
            if (!this.haveDefaults) {
                return;
            }
            this.reportRetrieving("Table and View Column Defaults");
            SqlQuery<List<OraIntroQueries.OneColumnDefault>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveColumnDefaults;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveColumnDefaults");
            List rows = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (rows.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(rows){
                final /* synthetic */ List $rows;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneColumnDefault col : this.$rows) {
                        String string;
                        OraTableColumn column2;
                        OraTable table;
                        if ((OraTable)schema.getTables().get(col.table_name) == null) {
                            continue;
                        }
                        if ((OraTableColumn)table.getColumns().get(col.column_name) == null) {
                            continue;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)col.default_expression, (String)"col.default_expression");
                        OraTableColumn oraTableColumn = column2;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                        oraTableColumn.setDefaultExpression(string3);
                    }
                }
                {
                    this.$rows = list;
                    super(1);
                }
            });
        }

        private final void retrieveClusterIndices() {
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> sqlQuery;
            ModNamingIdentifyingFamily<? extends OraCluster> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getClusters();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.clusters");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            if (OraIntrospector.this.fast) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusterIndicesFast;
            } else if (((OraSchema)this.getSchema()).isCurrent()) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusterIndicesUser;
            } else {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> query = sqlQuery;
            this.reportRetrieving("Cluster Indices");
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> sqlQuery2 = query;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"query");
            List<OraIntroQueries.OneClusterIndex> inds = this.performQuery(sqlQuery2);
            if (inds.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, inds){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $inds;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneClusterIndex ind : this.$inds) {
                        OraCluster cluster;
                        OraClusterIndex index2;
                        if ((OraCluster)schema.getClusters().get(ind.cluster_name) == null) {
                            continue;
                        }
                        OraClusterIndex oraClusterIndex = index2 = cluster.getIndices().createOrGet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraClusterIndex, (String)"index");
                        oraClusterIndex.setObjectId(ind.index_id);
                        index2.setName(ind.index_name);
                        String string = ind.index_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ind.index_name");
                        CharSequence charSequence = string;
                        Regex regex = OraIntrospectorFunctions.access$getSURROGATE_NAME_PATTERN$p();
                        OraClusterIndex oraClusterIndex2 = index2;
                        boolean bl = false;
                        boolean bl2 = regex.matches(charSequence);
                        oraClusterIndex2.setNameSurrogate(bl2);
                        index2.setTablespaceName(ind.tablespace_name);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(index2, ind.created_timestamp, ind.modified_timestamp);
                        if (!this.this$0.getMode().fragment) continue;
                        index2.setColNames(CollectionsKt.emptyList());
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$inds = list;
                    super(1);
                }
            });
        }

        private final void retrieveTableClusterColumns() {
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> query;
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> sqlQuery;
            ModNamingIdentifyingFamily<? extends OraCluster> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getClusters();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.clusters");
            if (modNamingIdentifyingFamily.isEmpty() || this.affectedTables.isEmpty()) {
                return;
            }
            this.reportRetrieving("Tables' clustered columns");
            if (OraIntrospector.this.fast) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTableClusterColumnsAdmin;
            } else if (((OraSchema)this.getSchema()).isCurrent()) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTableClusterColumnsUser;
            } else {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> sqlQuery2 = query = sqlQuery;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"query");
            List<OraIntroQueries.OneTableClusterColumn> cols2 = this.performQuery(sqlQuery2);
            if (cols2.isEmpty()) {
                return;
            }
            StringListAggregator g = new StringListAggregator();
            for (OraIntroQueries.OneTableClusterColumn col : cols2) {
                String string = col.table_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"col.table_name");
                String string2 = col.column_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"col.column_name");
                g.add(string, string2);
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(g){
                final /* synthetic */ StringListAggregator $g;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Map<K, CV> map2 = this.$g.getResult();
                    boolean bl = false;
                    Iterator<Map.Entry<K, CV>> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, CV> entry;
                        Map.Entry<K, CV> entry2 = entry = iterator.next();
                        boolean bl2 = false;
                        String tableName = (String)entry2.getKey();
                        entry2 = entry;
                        bl2 = false;
                        List colNames = (List)entry2.getValue();
                        OraTable oraTable = (OraTable)schema.getTables().get(tableName);
                        if (oraTable == null) continue;
                        oraTable.setClusterColNames(colNames);
                    }
                }
                {
                    this.$g = stringListAggregator;
                    super(1);
                }
            });
        }

        private final void retrieveIndices() {
            if (!this.affectsTables && !this.affectsMatViews) {
                return;
            }
            this.reportRetrieving("Indices");
            SqlQuery<List<OraIntroQueries.OneIndex>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveIndices");
            List indices = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (indices.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, indices){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $indices;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneIndex ind : this.$indices) {
                        OraIndex oraIndex;
                        OraTable table;
                        if ((OraTable)schema.getTables().get(ind.table_name) == null) {
                            continue;
                        }
                        OraIndex index2 = (OraIndex)table.getIndices().renew(ind.object_id, ind.index_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)index2, (String)"index");
                        String string = ind.index_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ind.index_name");
                        CharSequence charSequence = string;
                        Regex regex = OraIntrospectorFunctions.access$getSURROGATE_NAME_PATTERN$p();
                        boolean bl = false;
                        boolean bl2 = regex.matches(charSequence);
                        oraIndex.setNameSurrogate(bl2 || table.getTableType() == OraTableType.MAT_VIEW);
                        index2.setUnique(ind.uniqueness);
                        index2.setClustering(ind.clustering);
                        index2.setFunctionBased(ind.function_based);
                        index2.setBitmap(ind.bitmap);
                        index2.setTablespaceName(ind.tablespace_name);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(index2, ind.created_timestamp, ind.modified_timestamp);
                        index2.setIndextypeOwner(ind.indextype_owner);
                        index2.setIndextypeName(ind.indextype_name);
                        if (this.this$0.getMode().fragment) {
                            index2.setColNames(CollectionsKt.emptyList());
                        }
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$indices = list;
                    super(1);
                }
            });
        }

        private final void retrieveIndicesColumns() {
            boolean bl;
            Object object;
            StringListAggregator stringListAggregator;
            String string;
            if (!this.affectsTables && !this.affectsMatViews) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneIndexItem>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndicesColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveIndicesColumns");
            List<OraIntroQueries.OneIndexItem> ics = this.performQuery(sqlQuery);
            if (ics.isEmpty()) {
                return;
            }
            StringListAggregator columns = new StringListAggregator();
            boolean hasExpressions = false;
            for (OraIntroQueries.OneIndexItem ic : ics) {
                String key2 = ic.table_name + '\uffff' + ic.index_name;
                String string2 = ic.item;
                if (string2 == null) {
                    string2 = "???[" + ic.column_position + ']';
                }
                String item = string2;
                char c2 = ic.direction;
                string = key2;
                stringListAggregator = columns;
                boolean bl2 = false;
                String string3 = String.valueOf(c2) + item;
                stringListAggregator.add(string, string3);
                CharSequence charSequence = item;
                object = OraIntrospectorFunctions.access$getINDEX_EXPRESSION_STUB_PATTERN$p();
                bl = false;
                boolean isExpression = object.matches(charSequence);
                hasExpressions = hasExpressions || isExpression;
            }
            if (hasExpressions) {
                SqlQuery<List<OraIntroQueries.OneIndexItem>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndicesExpressions;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveIndicesExpressions");
                List<OraIntroQueries.OneIndexItem> ies = this.performQuery(sqlQuery2);
                for (OraIntroQueries.OneIndexItem ie : ies) {
                    String key3 = ie.table_name + '\uffff' + ie.index_name;
                    short position = ie.column_position;
                    char c3 = ie.direction;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ie.item, (String)"ie.item");
                    int n = position - 1;
                    string = key3;
                    stringListAggregator = columns;
                    bl = false;
                    String string4 = String.valueOf(c3) + (String)object;
                    stringListAggregator.set(string, n, string4);
                }
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, columns){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ StringListAggregator $columns;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Map<K, CV> map2 = this.$columns.getResult();
                    boolean bl = false;
                    Iterator<Map.Entry<K, CV>> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        OraIndex index2;
                        String indexName;
                        OraTable table;
                        String tableName;
                        Map.Entry<K, CV> entry;
                        Map.Entry<K, CV> entry2 = entry = iterator.next();
                        boolean bl2 = false;
                        String key2 = (String)entry2.getKey();
                        entry2 = entry;
                        bl2 = false;
                        List items = (List)entry2.getValue();
                        int d_pos = StringsKt.indexOf$default((CharSequence)key2, (char)'\uffff', (int)0, (boolean)false, (int)6, null);
                        if (d_pos < 0) continue;
                        String string = key2;
                        int n = 0;
                        int n2 = 0;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, d_pos), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string3 = key2;
                        n2 = d_pos + 1;
                        boolean bl3 = false;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                        if ((OraTable)schema.getTables().get(tableName) == null) {
                            continue;
                        }
                        if ((OraIndex)table.getIndices().get(indexName) == null) {
                            continue;
                        }
                        OraSchemaRetriever.access$applyIndexingItems(this.this$0, table, index2, items);
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$columns = stringListAggregator;
                    super(1);
                }
            });
        }

        private final void applyIndexingItems(BasicTable table, OraIndex index2, List<String> items) {
            int n = items.size();
            if (n == 0) {
                index2.setColNames(CollectionsKt.emptyList());
                index2.setReverseColNames(SetsKt.emptySet());
                return;
            }
            if (index2.isFunctionBased()) {
                ArrayList<String> expressions2 = new ArrayList<String>(n);
                TreeSet<String> reverse = new TreeSet<String>();
                PositioningNamingFamily positioningNamingFamily = table.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"table.columns");
                TreeSet tableColumnNames = new TreeSet(positioningNamingFamily.getNames());
                for (String item : items) {
                    String string;
                    if (item.length() < 2) continue;
                    String string2 = item;
                    int n2 = 1;
                    char c2 = '\u0000';
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    String c3 = OraIntrospectorFunctions.access$unquoteNameIfPossible(string4);
                    boolean isColumn = tableColumnNames.contains(c3);
                    if (isColumn) {
                        string = c3;
                    } else {
                        c2 = '\u001b';
                        boolean bl = false;
                        string = String.valueOf(c2) + c3;
                    }
                    String x = string;
                    expressions2.add(x);
                    if (item.charAt(0) != '-') continue;
                    reverse.add(x);
                }
                index2.setColNames((List<String>)expressions2);
                Collection collection = reverse;
                OraIndex oraIndex = index2;
                boolean bl = false;
                boolean bl2 = !collection.isEmpty();
                oraIndex.setReverseColNames(bl2 ? (Set)reverse : SetsKt.emptySet());
            } else {
                ArrayList<String> columns = new ArrayList<String>(n);
                TreeSet<String> reverse = new TreeSet<String>();
                for (String item : items) {
                    String c4;
                    if (item.length() < 2) continue;
                    String string = item;
                    int n3 = 1;
                    boolean bl = false;
                    String string5 = string;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
                    columns.add(c4);
                    if (item.charAt(0) != '-') continue;
                    reverse.add(c4);
                }
                index2.setColNames((List<String>)columns);
                Collection collection = reverse;
                OraIndex oraIndex = index2;
                boolean bl = false;
                boolean bl3 = !collection.isEmpty();
                oraIndex.setReverseColNames(bl3 ? (Set)reverse : SetsKt.emptySet());
            }
        }

        private final void retrieveKeys() {
            if (!this.affectsTables && !this.affectsMatViews) {
                return;
            }
            this.reportRetrieving("Keys");
            SqlQuery<List<OraIntroQueries.OneKey>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveKeys;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveKeys");
            List keys = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (keys.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(keys){
                final /* synthetic */ List $keys;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneKey k : this.$keys) {
                        OraKey key2;
                        OraTable table;
                        if (k.table_name == null || k.constraint_name == null) continue;
                        OraTable oraTable = table = (OraTable)schema.getTables().createOrGet(k.table_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraTable, (String)"table");
                        OraKey oraKey = key2 = (OraKey)oraTable.getKeys().createOrGet(k.constraint_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraKey, (String)"key");
                        oraKey.setColNames(CollectionsKt.emptyList());
                        key2.setNameSurrogate(k.is_surrogate_name);
                        key2.setPrimary(k.is_pk);
                        key2.setDeferrable(k.is_deferrable);
                        key2.setInitiallyDeferred(k.is_initially_deferred);
                        key2.setModifiedTimestamp(k.modified_timestamp);
                        key2.setUnderlyingIndexName(k.index_name);
                    }
                }
                {
                    this.$keys = list;
                    super(1);
                }
            });
        }

        private final void retrieveForeignKeys() {
            SqlQuery<List<OraIntroQueries.OneForeignKey>> query;
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Foreign Keys");
            SqlQuery<List<OraIntroQueries.OneForeignKey>> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveForeignKeysFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveForeignKeysSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            List fks = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (fks.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(fks){
                final /* synthetic */ List $fks;

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    database = schema.getParent();
                    for (OraIntroQueries.OneForeignKey fk : this.$fks) {
                        block9: {
                            if ((fk.table_id > 0L ? (OraTable)schema.getTables().getByObjectId(fk.table_id) : (OraTable)schema.getTables().get(fk.table_name)) == null) {
                                continue;
                            }
                            table = table;
                            v0 = fkey = (OraForeignKey)table.getForeignKeys().createOrGet(fk.constraint_name);
                            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"fkey");
                            v0.setColNames(CollectionsKt.emptyList());
                            v1 = fkey;
                            v2 = fk.ref_schema_name;
                            if (v2 != null) break block9;
                            v3 = database;
                            if (v3 == null) {
                                Intrinsics.throwNpe();
                            }
                            if ((v4 = (OraSchema)v3.getSchemas().getByObjectId(fk.ref_schema_id)) == null) ** GOTO lbl-1000
                            var7_7 = v4;
                            var12_12 = v1;
                            var8_8 = false;
                            var9_9 = false;
                            it = var7_7;
                            $i$a$-takeIf-OraIntrospector$OraSchemaRetriever$retrieveForeignKeys$1$1 = false;
                            var13_13 = (Intrinsics.areEqual((Object)it, (Object)schema) ^ true) != false ? var7_7 : null;
                            v1 = var12_12;
                            v4 = var13_13;
                            if (v4 != null) {
                                v2 = v4.getName();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = null;
                            }
                        }
                        v1.setRefSchemaName(v2);
                        fkey.setRefTableName(fk.ref_table_name);
                        fkey.setRefKeyName(fk.ref_key_name);
                        fkey.setNameSurrogate(fk.is_surrogate_name);
                        fkey.setDeferrable(fk.is_deferrable);
                        fkey.setInitiallyDeferred(fk.is_initially_deferred);
                        switch (fk.cascade_rule) {
                            case 'C': {
                                v5 = CascadeRule.cascade;
                                break;
                            }
                            case 'N': {
                                v5 = CascadeRule.set_null;
                                break;
                            }
                            default: {
                                v5 = CascadeRule.restrict;
                            }
                        }
                        fkey.setOnDelete(v5);
                        fkey.setModifiedTimestamp(fk.modified_timestamp);
                    }
                }
                {
                    this.$fks = list;
                    super(1);
                }
            });
        }

        private final void retrieveChecks() {
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Check Constraints");
            SqlQuery<List<OraIntroQueries.OneCheck>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveChecks;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveChecks");
            List cks = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (cks.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(cks){
                final /* synthetic */ List $cks;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneCheck ck : this.$cks) {
                        OraCheck check;
                        OraTable table;
                        if (ck.predicate == null) continue;
                        if (ck.is_surrogate_name) {
                            String string = ck.predicate;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ck.predicate");
                            CharSequence charSequence = string;
                            Regex regex = OraIntrospectorFunctions.access$getAUTO_NOT_NULL_CHECK_PATTERN$p();
                            boolean bl = false;
                            if (regex.matches(charSequence)) continue;
                        }
                        OraTable oraTable = table = (OraTable)schema.getTables().createOrGet(ck.table_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraTable, (String)"table");
                        OraCheck oraCheck = check = (OraCheck)oraTable.getChecks().createOrGet(ck.constraint_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraCheck, (String)"check");
                        oraCheck.setColNames(CollectionsKt.emptyList());
                        check.setNameSurrogate(ck.is_surrogate_name);
                        check.setPredicate(ck.predicate);
                        check.setModifiedTimestamp(ck.modified_timestamp);
                    }
                }
                {
                    this.$cks = list;
                    super(1);
                }
            });
        }

        private final void retrieveConstraintColumns() {
            if (!this.affectsTables) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneConstraintColumn>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveConstraintColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveConstraintColumns");
            List ccs = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (ccs.isEmpty()) {
                return;
            }
            StringListAggregator agg = new StringListAggregator();
            for (OraIntroQueries.OneConstraintColumn cc : ccs) {
                String key2 = cc.table_name + '\uffff' + cc.constraint_name;
                String string = cc.column_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cc.column_name");
                agg.add(key2, string);
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, agg){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ StringListAggregator $agg;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Map<K, CV> map2 = this.$agg.getResult();
                    boolean bl = false;
                    for (Map.Entry<K, CV> entry : map2.entrySet()) {
                        OraConstraint constraint;
                        OraTable table;
                        void tableName;
                        Object object = entry;
                        boolean bl2 = false;
                        String key2 = (String)object.getKey();
                        object = entry;
                        bl2 = false;
                        List colNames = (List)object.getValue();
                        Object object2 = StringFun.unPair(key2, '\uffff');
                        object = (String)object2.component1();
                        String constraintName = (String)object2.component2();
                        object2 = (CharSequence)tableName;
                        boolean bl3 = false;
                        if (object2.length() == 0) continue;
                        object2 = constraintName;
                        bl3 = false;
                        if (object2.length() == 0) continue;
                        if ((OraTable)schema.getTables().get((String)tableName) == null) {
                            continue;
                        }
                        if (OraIntrospectorFunctions.access$findModConstraint(table, constraintName) == null) {
                            continue;
                        }
                        constraint.setColNames(colNames);
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$agg = stringListAggregator;
                    super(1);
                }
            });
        }

        private final void reorderTableDetails() {
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraLikeTable table : OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0)) {
                        OraLikeTable oraLikeTable = table;
                        if (oraLikeTable instanceof OraTable) {
                            OraLikeTable oraLikeTable2 = table;
                            Intrinsics.checkExpressionValueIsNotNull((Object)oraLikeTable2, (String)"table");
                            ((OraTable)oraLikeTable2).getColumns().sort();
                            ((OraTable)table).getIndices().sort();
                            ((OraTable)table).getKeys().sort();
                            ((OraTable)table).getForeignKeys().sort();
                            ((OraTable)table).getChecks().sort();
                            continue;
                        }
                        if (!(oraLikeTable instanceof OraLikeTable)) continue;
                        OraLikeTable oraLikeTable3 = table;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraLikeTable3, (String)"table");
                        oraLikeTable3.getColumns().sort();
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggers() {
            void also_retrieve_update_columns;
            if (!(this.affectsTables || this.affectsMatViews || this.affectsViews)) {
                return;
            }
            this.reportRetrieving("Triggers");
            SqlQuery<List<OraIntroQueries.OneTrigger>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggers;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTriggers");
            List ts2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (ts2.isEmpty()) {
                return;
            }
            HashSet tables = new HashSet(ts2.size());
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, ts2, (Ref.BooleanRef)also_retrieve_update_columns, tables){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ts;
                final /* synthetic */ Ref.BooleanRef $also_retrieve_update_columns;
                final /* synthetic */ HashSet $tables;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneTrigger trig : this.$ts) {
                        OraLikeTable table;
                        OraTrigger trigger;
                        String string = trig.table_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trig.table_name");
                        if (OraIntrospectorFunctions.access$findTableOrViewByName(schema, string) == null) {
                            continue;
                        }
                        OraTrigger oraTrigger = trigger = table.getTriggers().renew(trig.trigger_id, trig.trigger_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraTrigger, (String)"trigger");
                        oraTrigger.setEvents(TrigEvent.of((String)trig.events));
                        trigger.setTurn(OraSchemaRetriever.access$trigTurnOf(this.this$0, trig.turn));
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(trigger, trig.created_timestamp, trig.modified_timestamp);
                        if (trigger instanceof OraTableTrigger) {
                            ((OraTableTrigger)trigger).setCondition(StringKt.nullize((String)trig.condition, (boolean)true));
                        }
                        this.$also_retrieve_update_columns.element |= trig.has_on_update_columns;
                        this.$tables.add(table);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(trigger);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ts = list;
                    this.$also_retrieve_update_columns = booleanRef;
                    this.$tables = hashSet;
                    super(1);
                }
            });
            if (also_retrieve_update_columns.element) {
                SqlQuery<List<String[]>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggerUpdateColumns;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveTriggerUpdateColumns");
                List cols2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery2, 0, 2, null);
                StringListAggregator columns = new StringListAggregator();
                for (String[] col : cols2) {
                    String tableName = col[0];
                    String triggerName = col[1];
                    String columnName = col[2];
                    if (tableName == null || triggerName == null || columnName == null) continue;
                    String key2 = tableName + '\uffff' + triggerName;
                    columns.add(key2, columnName);
                }
                this.inSchema((Function1)new Function1<OraSchema, Unit>(columns){
                    final /* synthetic */ StringListAggregator $columns;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull OraSchema schema) {
                        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                        Map<K, CV> map2 = this.$columns.getResult();
                        boolean bl = false;
                        for (Map.Entry<K, CV> entry : map2.entrySet()) {
                            OraTrigger trigger;
                            OraLikeTable table;
                            void tableName;
                            Object object = entry;
                            boolean bl2 = false;
                            String key2 = (String)object.getKey();
                            object = entry;
                            bl2 = false;
                            List names = (List)object.getValue();
                            Object object2 = StringFun.unPair(key2, '\uffff');
                            object = (String)object2.component1();
                            String triggerName = (String)object2.component2();
                            object2 = (CharSequence)tableName;
                            boolean bl3 = false;
                            if (object2.length() == 0) continue;
                            object2 = triggerName;
                            bl3 = false;
                            if (object2.length() == 0) continue;
                            if (OraIntrospectorFunctions.access$findTableOrViewByName(schema, (String)tableName) == null) {
                                continue;
                            }
                            if ((OraTrigger)table.getTriggers().get(triggerName) == null) {
                                continue;
                            }
                            trigger.setColNames(names);
                        }
                    }
                    {
                        this.$columns = stringListAggregator;
                        super(1);
                    }
                });
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(tables){
                final /* synthetic */ HashSet $tables;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Iterator<E> iterator = this.$tables.iterator();
                    while (iterator.hasNext()) {
                        OraLikeTable table;
                        OraLikeTable oraLikeTable = table = (OraLikeTable)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraLikeTable, (String)"table");
                        oraLikeTable.getTriggers().sort();
                    }
                }
                {
                    this.$tables = hashSet;
                    super(1);
                }
            });
            this.affectsTriggers = true;
        }

        private final TrigTurn trigTurnOf(short turn) {
            TrigTurn trigTurn;
            switch (turn) {
                case -2: {
                    trigTurn = TrigTurn.BEFORE_STMT;
                    break;
                }
                case -1: {
                    trigTurn = TrigTurn.BEFORE_ROW;
                    break;
                }
                case 1: {
                    trigTurn = TrigTurn.AFTER_ROW;
                    break;
                }
                case 2: {
                    trigTurn = TrigTurn.AFTER_STMT;
                    break;
                }
                case 0: {
                    trigTurn = TrigTurn.INSTEAD_OF;
                    break;
                }
                default: {
                    trigTurn = null;
                }
            }
            return trigTurn;
        }

        private final void retrievePackages() {
            ModNamingIdentifyingFamily<? extends OraPackage> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getPackages();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.packages");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Packages");
            SqlQuery<List<OraIntroQueries.OnePackage>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrievePackages;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrievePackages");
            List packages = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (packages.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, packages){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $packages;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OnePackage p2 : this.$packages) {
                        OraPackageBody body2;
                        OraPackage pack2;
                        if (!p2.is_body) {
                            OraPackage oraPackage = pack2 = schema.getPackages().renew(p2.object_id, p2.package_name);
                            Intrinsics.checkExpressionValueIsNotNull((Object)oraPackage, (String)"pack");
                            oraPackage.setInvalid(p2.is_invalid);
                            OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(pack2, p2.created_timestamp, p2.modified_timestamp);
                            OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).add(pack2);
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(pack2);
                            continue;
                        }
                        OraPackage oraPackage = pack2 = (OraPackage)schema.getPackages().createOrGet(p2.package_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraPackage, (String)"pack");
                        OraPackageBody oraPackageBody = body2 = oraPackage.getBodies().createOrGet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraPackageBody, (String)"body");
                        oraPackageBody.setObjectId(p2.object_id);
                        body2.setInvalid(p2.is_invalid);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(body2, p2.created_timestamp, p2.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedModuleBodies$p(this.this$0).add(body2);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(body2);
                    }
                    schema.getPackages().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$packages = list;
                    super(1);
                }
            });
            this.affectsModulesOrBodies = true;
        }

        private final void retrieveInnerRoutines() {
            if (this.affectedModuleSpecs.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions");
            SqlQuery<List<OraIntroQueries.OneInnerRoutine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveInnerRoutines;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveInnerRoutines");
            List routines = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, routines){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $routines;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Iterator<E> iterator = OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        OraModule module;
                        OraModule oraModule = module = (OraModule)iterator.next();
                        if (oraModule == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraModule");
                        }
                        oraModule.getRoutines().markChildrenAsSyncPending();
                    }
                    for (OraIntroQueries.OneInnerRoutine r : this.$routines) {
                        OraInnerRoutine routine;
                        OraModule module = null;
                        if (r.module_kind == 'T' || r.module_kind == 'Z') {
                            module = (OraModule)schema.getObjectTypes().get(r.module_name);
                        }
                        if (module == null && (r.module_kind == 'P' || r.module_kind == 'Z')) {
                            module = (OraModule)schema.getPackages().get(r.module_name);
                        }
                        if (module == null) continue;
                        OraInnerRoutine oraInnerRoutine = routine = module.getRoutines().createOrGet(r.routine_name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraInnerRoutine, (String)"routine");
                        oraInnerRoutine.setDeterministic(r.is_deterministic);
                        OraSchemaRetriever.access$getAffectedInnerRoutines$p(this.this$0).add(routine);
                    }
                    boolean toReorder = OraIntrospector.access$getServerVersion$p(this.this$0.OraIntrospector.this).get(0) < 11;
                    Iterator<E> iterator2 = OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).iterator();
                    while (iterator2.hasNext()) {
                        ModNamingFamily<? extends OraInnerRoutine> moduleRoutines;
                        OraModule module;
                        OraModule oraModule = module = (OraModule)iterator2.next();
                        if (oraModule == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraModule");
                        }
                        Intrinsics.checkExpressionValueIsNotNull(oraModule.getRoutines(), (String)"(module as OraModule).routines");
                        moduleRoutines.removeSyncPendingChildren();
                        if (!toReorder) continue;
                        moduleRoutines.sort();
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$routines = list;
                    super(1);
                }
            });
        }

        private final void retrieveInnerRoutinesArguments() {
            if (this.affectedModuleSpecs.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions (arguments and result types)");
            List list = this.affectedModuleSpecs.stream().flatMap(retrieveInnerRoutinesArguments.oldAffectedRoutines.1.INSTANCE).map(retrieveInnerRoutinesArguments.oldAffectedRoutines.2.INSTANCE).collect(Collectors.toList());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"affectedModuleSpecs.stre\u2026lect(Collectors.toList())");
            Iterable oldAffectedRoutines2 = list;
            SqlQuery<List<OraIntroQueries.OneInnerRoutineArgument>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveInnerRoutineArguments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveInnerRoutineArguments");
            List args2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(oldAffectedRoutines2, args2){
                final /* synthetic */ Iterable $oldAffectedRoutines;
                final /* synthetic */ List $args;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraRoutine r : this.$oldAffectedRoutines) {
                        r.getArguments().markChildrenAsSyncPending();
                    }
                    for (OraIntroQueries.OneInnerRoutineArgument a : this.$args) {
                        OraInnerRoutine routine;
                        OraModule m;
                        if (a.package_name == null || a.routine_name == null) continue;
                        String string = a.package_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"a.package_name");
                        if (OraIntrospectorFunctions.access$findModuleByName(schema, string) == null) {
                            continue;
                        }
                        if ((OraInnerRoutine)m.getRoutines().get(a.routine_name) == null) {
                            continue;
                        }
                        BasicSchema basicSchema = schema;
                        OraRoutine oraRoutine = routine;
                        short s = a.position;
                        String string2 = a.arg_name;
                        char c2 = a.arg_direction;
                        String string3 = a.data_type_schema_name;
                        String string4 = a.data_type_package_name;
                        String string5 = a.data_type;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"a.data_type");
                        OraIntrospectorFunctions.access$makeArgument(basicSchema, oraRoutine, s, string2, c2, string3, string4, string5);
                    }
                    for (OraRoutine r : this.$oldAffectedRoutines) {
                        r.getArguments().removeSyncPendingChildren();
                    }
                }
                {
                    this.$oldAffectedRoutines = iterable;
                    this.$args = list;
                    super(1);
                }
            });
        }

        private final void adjustInnerRoutines() {
            if (this.affectedInnerRoutines.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (BasicRoutine routine : OraSchemaRetriever.access$getAffectedInnerRoutines$p(this.this$0)) {
                        if (!(routine instanceof BasicModRoutine)) continue;
                        ((BasicModRoutine)routine).setRoutineKind(((BasicModRoutine)routine).getReturnArgument() == null ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    super(1);
                }
            });
        }

        private final void retrieveSingleRoutines() {
            ModNamingIdentifyingFamily<? extends OraSingleRoutine> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getRoutines();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.routines");
            if (modNamingIdentifyingFamily.isEmpty()) {
                return;
            }
            this.reportRetrieving("Procedures and functions");
            SqlQuery<List<OraIntroQueries.OneSingleRoutine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSingleRoutines;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSingleRoutines");
            List routines = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            if (routines.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, routines){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $routines;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    for (OraIntroQueries.OneSingleRoutine r : this.$routines) {
                        OraSingleRoutine routine;
                        OraSingleRoutine oraSingleRoutine = routine = schema.getRoutines().renew(r.object_id, r.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraSingleRoutine, (String)"routine");
                        oraSingleRoutine.setRoutineKind(DasRoutine.Kind.byChar((char)r.kind));
                        routine.setInvalid(r.is_invalid);
                        routine.setDeterministic(r.is_deterministic);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(routine, r.created_timestamp, r.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).add(routine);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(routine);
                    }
                    schema.getRoutines().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$routines = list;
                    super(1);
                }
            });
        }

        private final void retrieveSingleRoutinesArguments() {
            if (this.affectedSingleRoutines.isEmpty()) {
                return;
            }
            this.reportRetrieving("Procedures and functions (arguments and result types)");
            SqlQuery<List<OraIntroQueries.OneSingleRoutineArgument>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSingleRoutineArguments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSingleRoutineArguments");
            List args2 = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, args2){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $args;

                public final void invoke(@NotNull OraSchema schema) {
                    BasicRoutine r;
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    Iterator<E> iterator = OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        BasicRoutine basicRoutine = r = (BasicRoutine)iterator.next();
                        if (basicRoutine == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraRoutine");
                        }
                        ((OraRoutine)basicRoutine).getArguments().markChildrenAsSyncPending();
                    }
                    for (OraIntroQueries.OneSingleRoutineArgument a : this.$args) {
                        OraSingleRoutine routine;
                        if (a.routine_name == null) continue;
                        if ((OraSingleRoutine)schema.getRoutines().get(a.routine_name) == null) {
                            continue;
                        }
                        BasicSchema basicSchema = schema;
                        OraRoutine oraRoutine = routine;
                        short s = a.position;
                        String string = a.arg_name;
                        char c2 = a.arg_direction;
                        String string2 = a.data_type_schema_name;
                        String string3 = a.data_type_package_name;
                        String string4 = a.data_type;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"a.data_type");
                        OraIntrospectorFunctions.access$makeArgument(basicSchema, oraRoutine, s, string, c2, string2, string3, string4);
                    }
                    iterator = OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        BasicRoutine basicRoutine = r = (BasicRoutine)iterator.next();
                        if (basicRoutine == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.oracle.model.OraRoutine");
                        }
                        ((OraRoutine)basicRoutine).getArguments().removeSyncPendingChildren();
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$args = list;
                    super(1);
                }
            });
        }

        private final void retrieveComments() {
            long hash;
            ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily = ((OraSchema)this.getSchema()).getTables();
            Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.tables");
            if (modNamingIdentifyingFamily.isEmpty()) {
                ModNamingIdentifyingFamily<? extends OraMatView> modNamingIdentifyingFamily2 = ((OraSchema)this.getSchema()).getMatViews();
                Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily2, (String)"schema.matViews");
                if (modNamingIdentifyingFamily2.isEmpty()) {
                    ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily3 = ((OraSchema)this.getSchema()).getViews();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily3, (String)"schema.views");
                    if (modNamingIdentifyingFamily3.isEmpty()) {
                        if (((OraSchema)this.getSchema()).getCommentsHash() != 0L) {
                            this.inSchema(retrieveComments.1.INSTANCE);
                        }
                        return;
                    }
                }
            }
            this.reportRetrieving("Comments");
            SqlQuery<Long> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.calculateCommentsHash;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.calculateCommentsHash");
            Long l = this.performQuery(sqlQuery);
            long l2 = hash = l != null ? l : 0L;
            if (hash == ((OraSchema)this.getSchema()).getCommentsHash()) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneComment>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveComments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveComments");
            List<OraIntroQueries.OneComment> comments = this.performQuery(sqlQuery2);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, hash, comments){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ long $hash;
                final /* synthetic */ List $comments;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    schema.setCommentsHash(this.this$0.getMode() == IntrospectionMode.FRAGMENT ? -1L : this.$hash);
                    HashSet<BasicModNamedElement> touched = new HashSet<BasicModNamedElement>();
                    for (OraIntroQueries.OneComment c2 : this.$comments) {
                        OraLikeColumn column2;
                        OraLikeTable table;
                        String string = c2.table_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.table_name");
                        if (OraIntrospectorFunctions.access$findTableOrViewByName(schema, string) == null) {
                            continue;
                        }
                        if (c2.column_name == null) {
                            table.setComment(c2.comments);
                            touched.add(table);
                            continue;
                        }
                        if ((OraLikeColumn)table.getColumns().get(c2.column_name) == null) {
                            continue;
                        }
                        column2.setComment(c2.comments);
                        touched.add(column2);
                    }
                    for (OraLikeTable t : OraSchemaRetriever.access$seanceRelatedTablesAndViews(this.this$0, schema)) {
                        if (!touched.contains(t)) {
                            t.setComment(null);
                        }
                        for (OraLikeColumn column3 : t.getColumns()) {
                            if (touched.contains(column3)) continue;
                            OraLikeColumn oraLikeColumn = column3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)oraLikeColumn, (String)"column");
                            oraLikeColumn.setComment(null);
                        }
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$hash = l;
                    this.$comments = list;
                    super(1);
                }
            });
        }

        private final Iterable<OraLikeTable> seanceRelatedTablesAndViews(OraSchema schema) {
            if (this.getMode() == IntrospectionMode.FRAGMENT) {
                JBIterable jBIterable = JBIterable.empty().append((Iterable)JBIterable.from((Iterable)schema.getTables()).filter((Condition)new Condition<OraTable>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraTable it2) {
                        Object[] objectArray = this.this$0.getFragmentNames();
                        OraTable oraTable = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraTable, (String)"it");
                        return ArraysKt.contains((Object[])objectArray, (Object)oraTable.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                })).append((Iterable)JBIterable.from((Iterable)schema.getMatViews()).filter((Condition)new Condition<OraMatView>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraMatView it2) {
                        Object[] objectArray = this.this$0.getFragmentNames();
                        OraMatView oraMatView = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraMatView, (String)"it");
                        return ArraysKt.contains((Object[])objectArray, (Object)oraMatView.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                })).append((Iterable)JBIterable.from((Iterable)schema.getViews()).filter((Condition)new Condition<OraView>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraView it2) {
                        Object[] objectArray = this.this$0.getFragmentNames();
                        OraView oraView = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraView, (String)"it");
                        return ArraysKt.contains((Object[])objectArray, (Object)oraView.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                }));
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.empty<OraLike\u2026.name in fragmentNames })");
                return (Iterable)jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty().append((Iterable)JBIterable.from((Iterable)schema.getTables())).append((Iterable)JBIterable.from((Iterable)schema.getMatViews())).append((Iterable)JBIterable.from((Iterable)schema.getViews()));
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.empty<OraLike\u2026rable.from(schema.views))");
            return (Iterable)jBIterable;
        }

        private final void retrieveDependencies() {
            if (this.affectedDepObjects.isEmpty()) {
                return;
            }
            if (Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"SYS") || Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"PUBLIC")) {
                return;
            }
            this.reportRetrieving("Dependencies");
            if (OraIntrospector.this.fast) {
                this.retrieveDependenciesFast();
            } else {
                this.retrieveDependenciesSlow();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDependenciesFast() {
            void $this$groupByTo$iv$iv;
            SqlQuery<List<OraIntroQueries.OneDependency>> query;
            SqlQuery<List<OraIntroQueries.OneDependency>> sqlQuery = query = ((OraIntrospector)OraIntrospector.this).queries.retrieveDependenciesFast;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            List<OraIntroQueries.OneDependency> deps = this.performQuery(sqlQuery);
            if (deps.isEmpty()) {
                return;
            }
            List<OraIntroQueries.OneDependency> list = deps;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"deps");
            Iterable $this$groupBy$iv = list;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it2;
                Object object;
                OraIntroQueries.OneDependency it3 = (OraIntroQueries.OneDependency)element$iv$iv;
                boolean $i$a$-groupBy-OraIntrospector$OraSchemaRetriever$retrieveDependenciesFast$g$32 = false;
                Long key$iv$iv = it3.object_id;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                OraIntroQueries.OneDependency $i$a$-groupBy-OraIntrospector$OraSchemaRetriever$retrieveDependenciesFast$g$32 = (OraIntroQueries.OneDependency)element$iv$iv;
                List list2 = list$iv$iv;
                boolean bl = false;
                Long l = it2.referenced_id;
                list2.add(l);
            }
            Map g = destination$iv$iv;
            this.inSchema((Function1)new Function1<OraSchema, Unit>(g){
                final /* synthetic */ Map $g;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    BasicDatabase basicDatabase = schema.getDatabase();
                    if (basicDatabase == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModDatabase");
                    }
                    BasicModDatabase db = (BasicModDatabase)basicDatabase;
                    Map map2 = this.$g;
                    boolean bl = false;
                    for (Map.Entry<K, V> d2 : map2.entrySet()) {
                        BasicIdentifiedElement o = db.findIdentifiedElement(((Number)d2.getKey()).longValue());
                        if (!(o instanceof OraSourceAware) || ((OraSourceAware)o).getSchema() != schema) continue;
                        BasicElement parent2 = ((OraSourceAware)o).getParent();
                        BasicElement basicElement = parent2;
                        if (!(basicElement instanceof BasicIdentifiedElement)) {
                            basicElement = null;
                        }
                        BasicIdentifiedElement basicIdentifiedElement = (BasicIdentifiedElement)basicElement;
                        long parentId = basicIdentifiedElement != null ? basicIdentifiedElement.getObjectId() : Long.MIN_VALUE;
                        ((OraSourceAware)o).setDependsOnIds(SetsKt.minus((Set)CollectionsKt.toSortedSet((Iterable)((Iterable)d2.getValue())), (Object)parentId));
                    }
                }
                {
                    this.$g = map2;
                    super(1);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDependenciesSlow() {
            void $this$groupByTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            SqlQuery<List<OraIntroQueries.OneSlowDependency>> query;
            if (this.affectedDepObjects.isEmpty()) {
                return;
            }
            if (Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"SYS") || Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"PUBLIC")) {
                return;
            }
            this.reportRetrieving("Dependencies");
            SqlQuery<List<OraIntroQueries.OneSlowDependency>> sqlQuery = query = this.getMode().fragment ? ((OraIntrospector)OraIntrospector.this).queries.retrieveDependenciesSlowFrag : ((OraIntrospector)OraIntrospector.this).queries.retrieveDependenciesSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            List<OraIntroQueries.OneSlowDependency> deps = this.performQuery(sqlQuery);
            if (deps.isEmpty()) {
                return;
            }
            List<OraIntroQueries.OneSlowDependency> list = deps;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"deps");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                OraIntroQueries.OneSlowDependency oneSlowDependency = (OraIntroQueries.OneSlowDependency)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                OraTypeAndName oraTypeAndName = new OraTypeAndName(x.type, x.name);
                String string = x.referenced_schema_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"x.referenced_schema_name");
                OraSlowDependencyEntry oraSlowDependencyEntry = new OraSlowDependencyEntry(oraTypeAndName, string, new OraTypeAndName(x.referenced_type, x.referenced_name), x.referenced_id);
                collection.add(oraSlowDependencyEntry);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                OraSlowDependencyEntry d2 = (OraSlowDependencyEntry)element$iv$iv;
                boolean bl = false;
                OraTypeAndName key$iv$iv = d2.getDepObject();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object g = destination$iv$iv;
            this.inSchema((Function1)new Function1<OraSchema, Unit>((Map)g){
                final /* synthetic */ Map $g;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    BasicDatabase basicDatabase = schema.getDatabase();
                    if (basicDatabase == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModDatabase");
                    }
                    BasicModDatabase db = (BasicModDatabase)basicDatabase;
                    Map map2 = this.$g;
                    boolean bl = false;
                    for (Map.Entry<K, V> d2 : map2.entrySet()) {
                        BasicElement o = OraIntrospectorFunctions.access$findOracleObjectByStringTypeAndName(schema, (OraTypeAndName)d2.getKey());
                        if (o == null || !(o instanceof OraSourceAware)) continue;
                        List refIds = new ArrayList<E>(((List)d2.getValue()).size());
                        for (OraSlowDependencyEntry e : (List)d2.getValue()) {
                            long refObjectId = 0L;
                            if (e.getRefId() != 0L) {
                                refObjectId = e.getRefId();
                            } else {
                                BasicElement refObject;
                                BasicModSchema basicModSchema;
                                if (Intrinsics.areEqual((Object)e.getRefSchemaName(), (Object)"@")) {
                                    basicModSchema = schema;
                                } else {
                                    basicModSchema = (BasicModSchema)db.getSchemas().get(e.getRefSchemaName());
                                    if (basicModSchema == null) {
                                        continue;
                                    }
                                }
                                BasicModSchema refSchema = basicModSchema;
                                if (OraIntrospectorFunctions.access$findOracleObjectByStringTypeAndName(refSchema, e.getRefObject()) == null) {
                                    continue;
                                }
                                if (refObject instanceof BasicIdentifiedElement) {
                                    refObjectId = ((BasicIdentifiedElement)refObject).getObjectId();
                                }
                            }
                            if (refObjectId == 0L) continue;
                            refIds.add(refObjectId);
                        }
                        BasicElement parent2 = ((OraSourceAware)o).getParent();
                        BasicElement basicElement = parent2;
                        if (!(basicElement instanceof BasicIdentifiedElement)) {
                            basicElement = null;
                        }
                        BasicIdentifiedElement basicIdentifiedElement = (BasicIdentifiedElement)basicElement;
                        long parentId = basicIdentifiedElement != null ? basicIdentifiedElement.getObjectId() : Long.MIN_VALUE;
                        ((OraSourceAware)o).setDependsOnIds(SetsKt.minus((Set)CollectionsKt.toSortedSet((Iterable)refIds), (Object)parentId));
                    }
                }
                {
                    this.$g = map2;
                    super(1);
                }
            });
        }

        private final void retrieveSources() {
            boolean hP;
            if (!this.getWithSources()) {
                return;
            }
            boolean hV = ((OraSchema)this.getSchema()).getViews().hasChildren() || ((OraSchema)this.getSchema()).getMatViews().hasChildren();
            boolean hT = ModelFun.hasTriggers((BasicSchema)this.getSchema());
            boolean bl = hP = ((OraSchema)this.getSchema()).getPackages().hasChildren() || ((OraSchema)this.getSchema()).getRoutines().hasChildren() || ((OraSchema)this.getSchema()).getObjectTypes().hasChildren();
            if (!(hV || hT || hP)) {
                return;
            }
            this.retrieveProgramSourcesByPortions();
            Collection<OraIntroQueries.OneViewSource> viewBodies = this.retrieveViewSources();
            Collection<OraIntroQueries.OneTriggerSource> triggerBodies = this.retrieveTriggerSources();
            if (viewBodies.isEmpty() && triggerBodies.isEmpty()) {
                return;
            }
            this.reportRetrieving("applying sources");
            OraIntrospector this_$iv = OraIntrospector.this;
            boolean $i$f$writeSources = false;
            this_$iv.getModel().writeSources(new Runnable(this, viewBodies, triggerBodies){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Collection $viewBodies$inlined;
                final /* synthetic */ Collection $triggerBodies$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$viewBodies$inlined = collection;
                    this.$triggerBodies$inlined = collection2;
                }

                public final void run() {
                    boolean bl = false;
                    Collection collection = this.$viewBodies$inlined;
                    boolean bl2 = false;
                    if (!collection.isEmpty()) {
                        OraSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<OraSchema, Unit>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull OraSchema schema) {
                                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                                for (OraIntroQueries.OneViewSource v2 : this.this$0.$viewBodies$inlined) {
                                    OraView oraView = (OraView)schema.getViews().get(v2.view_name);
                                    BasicModSourceAware view2 = oraView != null ? (BasicModSourceAware)oraView : (BasicModSourceAware)schema.getMatViews().get(v2.view_name);
                                    if (view2 == null) continue;
                                    OraIntrospectorFunctions.access$applyViewSources(view2, v2.text);
                                }
                            }
                        });
                    }
                    collection = this.$triggerBodies$inlined;
                    bl2 = false;
                    if (!collection.isEmpty()) {
                        OraSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<OraSchema, Unit>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull OraSchema schema) {
                                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                                for (OraIntroQueries.OneTriggerSource trig : this.this$0.$triggerBodies$inlined) {
                                    OraTrigger trigger;
                                    OraLikeTable table;
                                    String string = trig.table_name;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trig.table_name");
                                    if (OraIntrospectorFunctions.access$findTableOrViewByName(schema, string) == null) {
                                        continue;
                                    }
                                    if ((OraTrigger)table.getTriggers().get(trig.trigger_name) == null) {
                                        continue;
                                    }
                                    String text2 = trig.trigger_body;
                                    trigger.setSourceText(text2 != null ? (CompositeText)new SimpleCompositeText(text2, CompositeText.Kind.ORIGINAL_TEXT) : null);
                                }
                            }
                        });
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveProgramSourcesByPortions() {
            Object[] names = null;
            if (this.getMode().fragment) {
                names = this.getFragmentNames();
            } else {
                this.reportRetrieving("listing sources to retrieve");
                SqlQuery<String[]> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.listSourceNames;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.listSourceNames");
                String[] stringArray = this.performQuery(sqlQuery);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"performQuery(queries.listSourceNames)");
                names = stringArray;
            }
            int n = names.length;
            if (n == 0) {
                return;
            }
            this.reportRetrieving("Program Sources");
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)n)), (int)100);
            int n2 = intProgression.getFirst();
            int n3 = intProgression.getLast();
            int n4 = intProgression.getStep();
            int n5 = n2;
            int n6 = n3;
            if (n4 >= 0 ? n5 <= n6 : n5 >= n6) {
                while (true) {
                    void offset;
                    List<String> portionOfNames = ArraysKt.asList((Object[])names).subList((int)offset, Math.min((int)(offset + 100), n));
                    this.retrieveProgramSourcePortion(portionOfNames);
                    if (offset == n3) break;
                    n2 = offset + n4;
                }
            }
        }

        private final void retrieveProgramSourcePortion(List<String> names) {
            this.setQueryParameter("portion_names", names);
            SqlQuery<List<OraIntroQueries.OneSrcLine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrievePortionOfSources;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrievePortionOfSources");
            List lines = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            Collection collection = lines;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.applySourceLines(lines);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void applySourceLines(Collection<OraIntroQueries.OneSrcLine> lines) {
            void theName;
            void theType;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "";
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            objectRef2.element = "";
            StringBuilder buf = new StringBuilder();
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, lines, (Ref.ObjectRef)theType, (Ref.ObjectRef)theName, buf){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Collection $lines;
                final /* synthetic */ Ref.ObjectRef $theType;
                final /* synthetic */ Ref.ObjectRef $theName;
                final /* synthetic */ StringBuilder $buf;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    OraIntrospector this_$iv = this.this$0.OraIntrospector.this;
                    boolean $i$f$writeSources = false;
                    this_$iv.getModel().writeSources(new Runnable(this, schema){
                        final /* synthetic */ applySourceLines.1 this$0;
                        final /* synthetic */ OraSchema $schema$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$schema$inlined = oraSchema;
                        }

                        public final void run() {
                            boolean bl = false;
                            for (OraIntroQueries.OneSrcLine line : this.this$0.$lines) {
                                boolean theSame;
                                boolean bl2 = theSame = Intrinsics.areEqual((Object)((String)this.this$0.$theType.element), (Object)line.type) && Intrinsics.areEqual((Object)((String)this.this$0.$theName.element), (Object)line.name);
                                if (!theSame) {
                                    OraSchemaRetriever oraSchemaRetriever = this.this$0.this$0;
                                    String string = (String)this.this$0.$theType.element;
                                    String string2 = (String)this.this$0.$theName.element;
                                    String string3 = this.this$0.$buf.toString();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"buf.toString()");
                                    OraSchemaRetriever.access$applySources(oraSchemaRetriever, this.$schema$inlined, string, string2, string3);
                                    Ref.ObjectRef objectRef = this.this$0.$theType;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)line.type, (String)"line.type");
                                    objectRef.element = objectRef.element;
                                    Ref.ObjectRef objectRef2 = this.this$0.$theName;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)line.name, (String)"line.name");
                                    objectRef2.element = objectRef2.element;
                                    this.this$0.$buf.delete(0, this.this$0.$buf.length());
                                }
                                this.this$0.$buf.append(line.text);
                            }
                            OraSchemaRetriever oraSchemaRetriever = this.this$0.this$0;
                            String string = (String)this.this$0.$theType.element;
                            String string4 = (String)this.this$0.$theName.element;
                            String string5 = this.this$0.$buf.toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"buf.toString()");
                            OraSchemaRetriever.access$applySources(oraSchemaRetriever, this.$schema$inlined, string, string4, string5);
                        }
                    });
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$lines = collection;
                    this.$theType = objectRef;
                    this.$theName = objectRef2;
                    this.$buf = stringBuilder;
                    super(1);
                }
            });
        }

        private final void applySources(@NotNull OraSchema $this$applySources, String type, String name2, String sourceText) {
            OraSourceAware oraSourceAware;
            CharSequence charSequence = sourceText;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return;
            }
            switch (type) {
                case "TYPE": {
                    Object e = $this$applySources.getObjectTypes().createOrGet(name2);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.objectTypes.createOrGet(name)");
                    oraSourceAware = (OraSourceAware)e;
                    break;
                }
                case "TYPE BODY": {
                    Object e = $this$applySources.getObjectTypes().createOrGet(name2);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.objectTypes.createOrGet(name)");
                    OraObjectTypeBody oraObjectTypeBody = ((OraObjectType)e).getBodies().createOrGet();
                    Intrinsics.checkExpressionValueIsNotNull((Object)oraObjectTypeBody, (String)"this.objectTypes.createO\u2026ame).bodies.createOrGet()");
                    oraSourceAware = oraObjectTypeBody;
                    break;
                }
                case "PACKAGE": {
                    Object e = $this$applySources.getPackages().createOrGet(name2);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.packages.createOrGet(name)");
                    oraSourceAware = (OraSourceAware)e;
                    break;
                }
                case "PACKAGE BODY": {
                    Object e = $this$applySources.getPackages().createOrGet(name2);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.packages.createOrGet(name)");
                    OraPackageBody oraPackageBody = ((OraPackage)e).getBodies().createOrGet();
                    Intrinsics.checkExpressionValueIsNotNull((Object)oraPackageBody, (String)"this.packages.createOrGe\u2026ame).bodies.createOrGet()");
                    oraSourceAware = oraPackageBody;
                    break;
                }
                case "PROCEDURE": 
                case "FUNCTION": {
                    Object e = $this$applySources.getRoutines().createOrGet(name2);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"this.routines.createOrGet(name)");
                    oraSourceAware = (OraSourceAware)e;
                    break;
                }
                default: {
                    return;
                }
            }
            OraSourceAware sourceAware = oraSourceAware;
            OraIntrospectorFunctions.access$applyStoredProgramSources(sourceAware, sourceText);
            Object object = sourceAware;
            if (object instanceof OraPackage) {
                this.extractPackageChildren((OraPackage)sourceAware, "CREATE " + sourceText);
            } else if (object instanceof OraBody) {
                this.determineWhetherTheBodyObfuscated((OraBody)sourceAware, sourceText);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void extractPackageChildren(OraPackage pkg, String text2) {
            SqlStatement sqlStatement;
            void this_$iv;
            boolean $i$f$cleanupFamilies = false;
            Function1 it2 = OraSchemaRetriever$extractPackageChildren$$inlined$cleanupFamilies$1.INSTANCE;
            boolean $i$a$-cleanupFamilies-OraIntrospector$OraSchemaRetriever$extractPackageChildren$32 = false;
            ModNamingFamily<? extends OraAliasType> modNamingFamily = pkg.getAliasTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily, (String)"pkg.aliasTypes");
            it2.invoke(modNamingFamily);
            ModNamingFamily<? extends OraPackageCollectionType> modNamingFamily2 = pkg.getCollectionTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily2, (String)"pkg.collectionTypes");
            it2.invoke(modNamingFamily2);
            ModPositioningNamingFamily<? extends OraPackageVariable> modPositioningNamingFamily = pkg.getVariables();
            Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily, (String)"pkg.variables");
            it2.invoke(modPositioningNamingFamily);
            ModNamingFamily<? extends OraException> modNamingFamily3 = pkg.getExceptions();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily3, (String)"pkg.exceptions");
            it2.invoke(modNamingFamily3);
            boolean bl = false;
            OraSchemaRetriever $i$a$-cleanupFamilies-OraIntrospector$OraSchemaRetriever$extractPackageChildren$32 = this;
            String src$iv = text2;
            boolean $i$f$parseStatement = false;
            try {
                IntrospectorSqlHelper this_$iv$iv = this_$iv.OraIntrospector.this.getSqlHelper();
                boolean $i$f$statements = false;
                sqlStatement = (SqlStatement)this_$iv$iv.statements(src$iv, SqlCreateStatement.class).first();
            }
            catch (Exception e$iv) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    this_$iv.OraIntrospector.this.getLog().error((Throwable)e$iv);
                }
                this_$iv.OraIntrospector.this.getLog().warn("Failed to parse sources", (Throwable)e$iv);
                sqlStatement = null;
            }
            SqlCreateStatement statement = (SqlCreateStatement)sqlStatement;
            if (statement == null || Intrinsics.areEqual((Object)statement.getKind(), (Object)ObjectKind.PACKAGE) ^ true) {
                return;
            }
            short vc = (short)0;
            Iterator iterator = statement.getDasChildren(null).iterator();
            while (iterator.hasNext()) {
                ModNamingFamily<? extends OraException> family;
                DasObject child;
                DasObject dasObject = child = (DasObject)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)dasObject, (String)"child");
                ObjectKind $i$f$statements = dasObject.getKind();
                if ((Intrinsics.areEqual((Object)$i$f$statements, (Object)ObjectKind.VARIABLE) ? (ModNamingFamily<? extends OraException>)pkg.getVariables() : (Intrinsics.areEqual((Object)$i$f$statements, (Object)ObjectKind.EXCEPTION) ? pkg.getExceptions() : (Intrinsics.areEqual((Object)$i$f$statements, (Object)ObjectKind.OBJECT_TYPE) ? pkg.getAliasTypes() : (Intrinsics.areEqual((Object)$i$f$statements, (Object)ObjectKind.COLLECTION_TYPE) ? pkg.getCollectionTypes() : null)))) == null) {
                    continue;
                }
                family = family;
                OraException obj2 = family.createOrGet(child.getName());
                OraIntrospector.this.getSqlHelper().getBuilder().build((DasObject)obj2, child);
                if (!(obj2 instanceof OraVariable)) continue;
                vc = (short)(vc + 1);
                ((OraVariable)((Object)obj2)).setPosition(vc);
            }
            it = OraSchemaRetriever$extractPackageChildren$$inlined$cleanupFamilies$2.INSTANCE;
            boolean bl2 = false;
            ModNamingFamily<? extends OraAliasType> modNamingFamily4 = pkg.getAliasTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily4, (String)"pkg.aliasTypes");
            it.invoke(modNamingFamily4);
            ModNamingFamily<? extends OraPackageCollectionType> modNamingFamily5 = pkg.getCollectionTypes();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily5, (String)"pkg.collectionTypes");
            it.invoke(modNamingFamily5);
            ModPositioningNamingFamily<? extends OraPackageVariable> modPositioningNamingFamily2 = pkg.getVariables();
            Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily2, (String)"pkg.variables");
            it.invoke(modPositioningNamingFamily2);
            ModNamingFamily<? extends OraException> modNamingFamily6 = pkg.getExceptions();
            Intrinsics.checkExpressionValueIsNotNull(modNamingFamily6, (String)"pkg.exceptions");
            it.invoke(modNamingFamily6);
        }

        private final void determineWhetherTheBodyObfuscated(OraBody body2, String text2) {
            if (text2 == null) {
                body2.setObfuscated(false);
                return;
            }
            body2.setObfuscated(Regex.find$default((Regex)OraIntrospectorFunctions.access$getObfuscationTextPattern$p(), (CharSequence)text2, (int)0, (int)2, null) != null);
        }

        private final Collection<OraIntroQueries.OneViewSource> retrieveViewSources() {
            Collection views = null;
            if (this.affectsMatViews || this.affectsViews) {
                this.reportRetrieving("View Sources");
                SqlQuery<List<OraIntroQueries.OneViewSource>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveViewSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveViewSources");
                views = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            } else {
                views = SetsKt.emptySet();
            }
            return views;
        }

        private final Collection<OraIntroQueries.OneTriggerSource> retrieveTriggerSources() {
            Collection triggers = null;
            if (this.affectsTables || this.affectsMatViews || this.affectsViews) {
                this.reportRetrieving("Trigger Sources");
                SqlQuery<List<OraIntroQueries.OneTriggerSource>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggerSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTriggerSources");
                triggers = BaseIntrospector.AbstractRetriever.performQueryForList$default(this, sqlQuery, 0, 2, null);
            } else {
                triggers = SetsKt.emptySet();
            }
            return triggers;
        }

        private final void retrieveSynonyms() {
            this.reportRetrieving("Synonyms");
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveFragmentSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveFragmentSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            if (ss.isEmpty()) {
                return;
            }
            OraIntrospector.this.inModel((Function1)new Function1<OraRoot, Unit>(ss){
                final /* synthetic */ List $ss;

                public final void invoke(@NotNull OraRoot root2) {
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    List list = this.$ss;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ss");
                    OraIntrospectorFunctions.access$processSynonyms(list, root2);
                }
                {
                    this.$ss = list;
                    super(1);
                }
            });
        }

        private final void retrieveErrors() {
            SqlQuery<long[]> invalidObjectsQuery;
            this.reportRetrieving("Statuses and Errors");
            SqlQuery<long[]> sqlQuery = invalidObjectsQuery = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.listInvalidObjectsFast : ((OraIntrospector)OraIntrospector.this).queries.listInvalidObjectsSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"invalidObjectsQuery");
            long[] invalidObjectsAr = this.performQuery(sqlQuery);
            TLongHashSet invalids = new TLongHashSet(invalidObjectsAr);
            this.inSchema((Function1)new Function1<OraSchema, Unit>(this, invalids){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ TLongHashSet $invalids;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    ModNamingIdentifyingFamily<? extends OraObjectType> modNamingIdentifyingFamily = schema.getObjectTypes();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"schema.objectTypes");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, modNamingIdentifyingFamily, this.$invalids);
                    ModNamingIdentifyingFamily<? extends OraPackage> modNamingIdentifyingFamily2 = schema.getPackages();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily2, (String)"schema.packages");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, modNamingIdentifyingFamily2, this.$invalids);
                    ModNamingIdentifyingFamily<? extends OraSingleRoutine> modNamingIdentifyingFamily3 = schema.getRoutines();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily3, (String)"schema.routines");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, modNamingIdentifyingFamily3, this.$invalids);
                    ModNamingIdentifyingFamily<? extends OraTable> modNamingIdentifyingFamily4 = schema.getTables();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily4, (String)"schema.tables");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, modNamingIdentifyingFamily4, this.$invalids);
                    ModNamingIdentifyingFamily<? extends OraView> modNamingIdentifyingFamily5 = schema.getViews();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily5, (String)"schema.views");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, modNamingIdentifyingFamily5, this.$invalids);
                    ModNamingIdentifyingFamily<? extends OraSynonym> modNamingIdentifyingFamily6 = schema.getSynonyms();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily6, (String)"schema.synonyms");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, modNamingIdentifyingFamily6, this.$invalids);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$invalids = tLongHashSet;
                    super(1);
                }
            });
            if (invalids.isEmpty()) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneError>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveErrors;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveErrors");
            List<OraIntroQueries.OneError> errs = this.performQuery(sqlQuery2);
            if (errs.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<OraSchema, Unit>(errs){
                final /* synthetic */ List $errs;

                public final void invoke(@NotNull OraSchema schema) {
                    Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                    MultiMap map2 = new MultiMap();
                    for (OraIntroQueries.OneError err : this.$errs) {
                        BasicModSourceAware src = null;
                        switch (err.type_code) {
                            case 'R': {
                                src = (BasicModSourceAware)schema.getRoutines().get(err.name);
                                break;
                            }
                            case 'V': {
                                src = (BasicModSourceAware)schema.getViews().get(err.name);
                                break;
                            }
                            case 'T': {
                                OraObjectType m = (OraObjectType)schema.getObjectTypes().get(err.name);
                                if (m == null) break;
                                src = err.is_body ? (BasicModSourceAware)m.getBodies().get() : (BasicModSourceAware)m;
                                break;
                            }
                            case 'P': {
                                OraPackage p2 = (OraPackage)schema.getPackages().get(err.name);
                                if (p2 == null) break;
                                src = err.is_body ? (BasicModSourceAware)p2.getBodies().get() : (BasicModSourceAware)p2;
                                break;
                            }
                            case 'G': {
                                String string = err.name;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"err.name");
                                src = OraIntrospectorFunctions.access$findTrigger(schema, string);
                            }
                        }
                        if (src == null) continue;
                        SourceError error2 = SourceError.of(err.line, err.position, err.message);
                        map2.putValue((Object)src, (Object)error2);
                    }
                    Iterator<E> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry;
                        Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                        boolean bl = false;
                        BasicModSourceAware key2 = (BasicModSourceAware)entry2.getKey();
                        entry2 = entry;
                        bl = false;
                        Collection value = (Collection)entry2.getValue();
                        BasicModSourceAware basicModSourceAware = key2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicModSourceAware, (String)"key");
                        basicModSourceAware.setErrors((List)ImmutableList.copyOf((Collection)value));
                    }
                }
                {
                    this.$errs = list;
                    super(1);
                }
            });
        }

        private final void updateInvalidStatus(Iterable<? extends BasicModElement> family, TLongHashSet invalids) {
            for (BasicModElement basicModElement : family) {
                BasicModElement basicModElement2;
                if (basicModElement instanceof BasicModSourceAware && basicModElement instanceof BasicIdentifiedElement) {
                    boolean invalid = invalids.contains(((BasicIdentifiedElement)((Object)basicModElement)).getObjectId());
                    ((BasicModSourceAware)basicModElement).setInvalid(invalid);
                    if (!invalid) {
                        ((BasicModSourceAware)basicModElement).setErrors(ModelConsts.NO_ERRORS);
                    }
                }
                if ((basicModElement2 = basicModElement) instanceof OraLikeTable) {
                    ModNamingIdentifyingFamily<? extends OraTrigger> modNamingIdentifyingFamily = ((OraLikeTable)basicModElement).getTriggers();
                    Intrinsics.checkExpressionValueIsNotNull(modNamingIdentifyingFamily, (String)"e.triggers");
                    this.updateInvalidStatus((Iterable<? extends BasicModElement>)modNamingIdentifyingFamily, invalids);
                    continue;
                }
                if (basicModElement2 instanceof OraObjectType) {
                    ModSingletonFamily<? extends OraObjectTypeBody> modSingletonFamily = ((OraObjectType)basicModElement).getBodies();
                    Intrinsics.checkExpressionValueIsNotNull(modSingletonFamily, (String)"e.bodies");
                    this.updateInvalidStatus((Iterable<? extends BasicModElement>)modSingletonFamily, invalids);
                    continue;
                }
                if (!(basicModElement2 instanceof OraPackage)) continue;
                ModSingletonFamily<? extends OraPackageBody> modSingletonFamily = ((OraPackage)basicModElement).getBodies();
                Intrinsics.checkExpressionValueIsNotNull(modSingletonFamily, (String)"e.bodies");
                this.updateInvalidStatus((Iterable<? extends BasicModElement>)modSingletonFamily, invalids);
            }
        }

        private final /* synthetic */ <T extends SqlStatement> T parseStatement(String src) {
            int $i$f$parseStatement = 0;
            try {
                IntrospectorSqlHelper this_$iv = OraIntrospector.this.getSqlHelper();
                boolean $i$f$statements = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return (T)((SqlStatement)this_$iv.statements(src, Object.class).first());
            }
            catch (Exception e) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    OraIntrospector.this.getLog().error((Throwable)e);
                }
                OraIntrospector.this.getLog().warn("Failed to parse sources", (Throwable)e);
                return null;
            }
        }

        @Override
        protected void reportRetrieving(@NotNull String what) {
            Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
            String modeStr = this.getMode().increment ? "incrementally" : "completely";
            String string = String.format("Introspecting schema %s (%s)", ((OraSchema)this.getSchema()).getName(), modeStr);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format(\"Introspecting sc\u2026)\", schema.name, modeStr)");
            OraIntrospector.this.updateStatus(string, what);
        }

        public OraSchemaRetriever(@NotNull DBTransaction transaction, OraSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)OraIntrospector.this, transaction, (BasicModSchema)schema);
            this.myFromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.tablesToReorderDetails = new HashSet();
            this.affectedClusters = new HashSet();
            this.affectedModuleSpecs = new HashSet();
            this.affectedModuleBodies = new HashSet();
            this.affectedInnerRoutines = new HashSet();
            this.affectedSingleRoutines = new HashSet();
            this.affectedDepObjects = new HashSet();
            this.affectedTables = new HashSet();
        }

        public static final /* synthetic */ BasicModModel access$getModel$p(OraSchemaRetriever $this) {
            return $this.getModel();
        }

        public static final /* synthetic */ BigInteger access$adjustBigIntegerForSequence(OraSchemaRetriever $this, BigDecimal bigDecimalValue) {
            return $this.adjustBigIntegerForSequence(bigDecimalValue);
        }

        public static final /* synthetic */ HashSet access$getAffectedModuleBodies$p(OraSchemaRetriever $this) {
            return $this.affectedModuleBodies;
        }

        public static final /* synthetic */ HashSet access$getAffectedDepObjects$p(OraSchemaRetriever $this) {
            return $this.affectedDepObjects;
        }

        public static final /* synthetic */ HashSet access$getAffectedModuleSpecs$p(OraSchemaRetriever $this) {
            return $this.affectedModuleSpecs;
        }

        public static final /* synthetic */ void access$applyClusterInfo(OraSchemaRetriever $this, OraCluster cluster, OraIntroQueries.OneCluster c2) {
            $this.applyClusterInfo(cluster, c2);
        }

        public static final /* synthetic */ HashSet access$getAffectedClusters$p(OraSchemaRetriever $this) {
            return $this.affectedClusters;
        }

        public static final /* synthetic */ HashSet access$getAffectedTables$p(OraSchemaRetriever $this) {
            return $this.affectedTables;
        }

        public static final /* synthetic */ HashSet access$getTablesToReorderDetails$p(OraSchemaRetriever $this) {
            return $this.tablesToReorderDetails;
        }

        public static final /* synthetic */ void access$applyIndexingItems(OraSchemaRetriever $this, BasicTable table, OraIndex index2, List items) {
            $this.applyIndexingItems(table, index2, items);
        }

        public static final /* synthetic */ TrigTurn access$trigTurnOf(OraSchemaRetriever $this, short turn) {
            return $this.trigTurnOf(turn);
        }

        public static final /* synthetic */ HashSet access$getAffectedInnerRoutines$p(OraSchemaRetriever $this) {
            return $this.affectedInnerRoutines;
        }

        public static final /* synthetic */ HashSet access$getAffectedSingleRoutines$p(OraSchemaRetriever $this) {
            return $this.affectedSingleRoutines;
        }

        public static final /* synthetic */ Iterable access$seanceRelatedTablesAndViews(OraSchemaRetriever $this, OraSchema schema) {
            return $this.seanceRelatedTablesAndViews(schema);
        }

        public static final /* synthetic */ void access$inSchema(OraSchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }

        public static final /* synthetic */ void access$applySources(OraSchemaRetriever $this, OraSchema $this$access_u24applySources, String type, String name2, String sourceText) {
            $this.applySources($this$access_u24applySources, type, name2, sourceText);
        }

        public static final /* synthetic */ void access$updateInvalidStatus(OraSchemaRetriever $this, Iterable family, TLongHashSet invalids) {
            $this.updateInvalidStatus(family, invalids);
        }
    }
}

