/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlBaseDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public MysqlBaseDialect() {
        super(new TypeHelper.MySQLTypeHelper(), Casing.create((Case)Case.LOWER, (Case)Case.LOWER));
    }

    @Override
    @NotNull
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            MysqlBaseDialect.$$$reportNull$$$0(0);
        }
        String string = kind == ObjectKind.SCHEDULED_EVENT ? "EVENT" : super.getNameForKind(kind);
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(2);
        }
        if (view2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(3);
        }
        if (definition == null) {
            MysqlBaseDialect.$$$reportNull$$$0(4);
        }
        builder.keywords("CREATE", "OR", "REPLACE", "VIEW").space();
        builder.qualifiedRef((DasObject)view2).space();
        builder.keyword("AS").space();
        builder.plain(definition);
        return builder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view2, boolean cascade) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(5);
        }
        if (view2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(6);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view2, cascade);
        if (ddlBuilder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(7);
        }
        return ddlBuilder;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(8);
        }
        return Pair.create((Object)("SELECT view_definition FROM information_schema.views WHERE table_name = '" + element2.getName() + "' AND table_schema = '" + MysqlBaseDialect.getDBName(element2) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(9);
        }
        Pair pair = Pair.create((Object)("SELECT routine_definition FROM information_schema.routines WHERE routine_name = '" + element2.getName() + "' AND routine_schema = '" + MysqlBaseDialect.getDBName((DasObject)element2) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            MysqlBaseDialect.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine procedure, @NotNull DatabaseConnection connection2) throws Exception {
        if (procedure == null) {
            MysqlBaseDialect.$$$reportNull$$$0(11);
        }
        if (connection2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(12);
        }
        String type = procedure.getRoutineKind().name();
        String query = new DdlBuilder().withDialect(this).qualifyReferences(true).keywords("SHOW", "CREATE", type).space().qualifiedRef((DasObject)procedure).getStatement();
        String string = SmartStatements.poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(rs -> {
            if (!rs.next()) {
                return "-- failed to load definition";
            }
            DdlBuilder builder = new DdlBuilder().withDialect(this).qualifyReferences(true).splitStatements(true);
            this.sqlDropProcedure(builder, procedure).newStatement().plain(rs.getString(3));
            return DialectUtils.sqlConcat(builder.getStatements());
        }, ""));
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public boolean supportsSystemViewDefinition() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(14);
        }
        if (procedure == null) {
            MysqlBaseDialect.$$$reportNull$$$0(15);
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure(builder, procedure, true);
        if (ddlBuilder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(16);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> getSupportedFkDeferrable() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class);
        if (valuesCapability == null) {
            MysqlBaseDialect.$$$reportNull$$$0(17);
        }
        return valuesCapability;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            MysqlBaseDialect.$$$reportNull$$$0(18);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                MysqlBaseDialect.$$$reportNull$$$0(19);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("DOUBLE".equals(typeName) && jdbcType == 8 && precision == 22 && scale == 0) {
            if ("double" == null) {
                MysqlBaseDialect.$$$reportNull$$$0(20);
            }
            return "double";
        }
        if ("MEDIUMINT".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            if ("mediumint" == null) {
                MysqlBaseDialect.$$$reportNull$$$0(21);
            }
            return "mediumint";
        }
        if ("MEDIUMINT UNSIGNED".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            if ("mediumint unsigned" == null) {
                MysqlBaseDialect.$$$reportNull$$$0(22);
            }
            return "mediumint unsigned";
        }
        if ("MEDIUMBLOB".equals(typeName) && jdbcType == -4 && precision == 0xFFFFFF && scale == 0) {
            if ("mediumblob" == null) {
                MysqlBaseDialect.$$$reportNull$$$0(23);
            }
            return "mediumblob";
        }
        if ("TINYBLOB".equals(typeName) && jdbcType == -2 && precision == 255 && scale == 0) {
            if ("tinyblob" == null) {
                MysqlBaseDialect.$$$reportNull$$$0(24);
            }
            return "tinyblob";
        }
        if ("DATETIME".equals(typeName) && jdbcType == 93 && precision == 19 && scale == 0) {
            if ("datetime" == null) {
                MysqlBaseDialect.$$$reportNull$$$0(25);
            }
            return "datetime";
        }
        String name2 = super.getTypeName(dataType);
        String unsigned = "unsigned";
        String string = StringUtil.endsWithIgnoreCase((String)typeName, (String)unsigned) && !StringUtil.endsWithIgnoreCase((String)name2, (String)unsigned) ? name2 + " " + unsigned : name2;
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(27);
        }
        if (sequence == null) {
            MysqlBaseDialect.$$$reportNull$$$0(28);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(29);
        }
        DdlBuilder builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
        Pair pair = Pair.create((Object)("SHOW CREATE TABLE " + builder.qualifiedRef(element2).getStatement()), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            MysqlBaseDialect.$$$reportNull$$$0(30);
        }
        return pair;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element2, @NotNull DatabaseConnection connection2) throws Exception {
        if (element2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(31);
        }
        if (connection2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(32);
        }
        Map<String, Object> map2 = DbImplUtil.resultRowAsMap(connection2, String.format("show table status from `%s` like '%s'", MysqlBaseDialect.getDBName((DasObject)element2), DbImplUtil.escapeStr(element2.getName())), "TABLE_ROWS", "rows", "ENGINE", "engine", "TABLE_COLLATION", "collation", "CREATE_TIME", "created");
        if (map2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(33);
        }
        return map2;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection2) throws Exception {
        if (table == null) {
            MysqlBaseDialect.$$$reportNull$$$0(34);
        }
        if (connection2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(35);
        }
        Dbms dbms = connection2.getDbms();
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection2, dbms, (String)pair.first, 2, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            MysqlBaseDialect.$$$reportNull$$$0(37);
        }
        if (connection2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(38);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection2, dbms = connection2.getDbms(), "select database()", 1, DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            MysqlBaseDialect.$$$reportNull$$$0(39);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("use %s", this.quoteIdentifier(current.getDisplayName(), false, false));
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @NotNull
    private static String getDBName(@NotNull DasObject qualifier) {
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(40);
        }
        String string = DasUtil.getName((DasObject)MysqlBaseDialect.getDB(qualifier));
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(41);
        }
        return string;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(42);
        }
        return (schema = DasUtil.getSchemaObject((DasObject)qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(43);
        }
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(44);
        }
        DasObject db = MysqlBaseDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(45);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            MysqlBaseDialect.$$$reportNull$$$0(46);
        }
        String string = "0x" + DialectUtils.toHexString(binaryData);
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(47);
        }
        return string;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection2) throws SQLException {
        if (connection2 == null) {
            MysqlBaseDialect.$$$reportNull$$$0(48);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection2, "SHOW DATABASES", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            MysqlBaseDialect.$$$reportNull$$$0(49);
        }
        return list;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 47: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 47: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDialect";
                break;
            }
            case 2: 
            case 5: 
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 8: 
            case 9: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 12: 
            case 32: 
            case 35: 
            case 38: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFkDeferrable";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDBName";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 47: 
            case 49: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDBName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 47: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

