/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum;

import com.intellij.database.dialects.greenplum.model.GPlumLocalTable;
import com.intellij.database.dialects.greenplum.model.GPlumPartition;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.GPlumPartitionTree;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GPlumDatabaseViewStructureProvider
implements DatabaseStructure.Provider {
    @Override
    @NotNull
    public JBIterable<? extends BasicElement> getChildren(@NotNull BasicElement element2, @Nullable ObjectKind kind) {
        if (element2 == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(0);
        }
        if (element2 instanceof GPlumPartition) {
            JBIterable<? extends BasicElement> jBIterable = GPlumDatabaseViewStructureProvider.getPartitionChildren((GPlumPartition)element2);
            if (jBIterable == null) {
                GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        JBIterable children2 = element2.getDasChildren(kind);
        JBIterable jBIterable = element2 instanceof GPlumLocalTable ? children2.filter((Condition)new RootPartitionsFilter((GPlumLocalTable)element2)) : children2;
        if (jBIterable == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public List<ObjectKind> getFamilyKinds(@NotNull BasicElement element2) {
        if (element2 == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(3);
        }
        List<ObjectKind> list = element2 instanceof GPlumPartition ? Collections.singletonList(ObjectKind.PARTITION) : element2.getFamilyKinds();
        if (list == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @Nullable
    public BasicElement getParent(@NotNull BasicElement element2) {
        if (element2 == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(5);
        }
        if (element2 instanceof GPlumPartition) {
            GPlumPartition partition = (GPlumPartition)element2;
            GPlumPartition parentPartition = partition.getParentPartition();
            return parentPartition == null ? partition.getParent() : parentPartition;
        }
        return element2.getParent();
    }

    @NotNull
    private static JBIterable<? extends BasicElement> getPartitionChildren(@NotNull GPlumPartition partition) {
        GPlumLocalTable table;
        if (partition == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(6);
        }
        GPlumPartitionTree tree = (table = partition.getLocalTable()) == null ? null : table.getPartitionsTree();
        long[] array = tree == null ? ArrayUtil.EMPTY_LONG_ARRAY : tree.getChildrenAsArray(partition.getObjectId());
        JBIterable jBIterable = JBIterable.from((Iterable)LongStream.of(array).mapToObj(id -> (GPlumPartition)table.getPartitions().getByObjectId(id)).filter(Objects::nonNull).collect(Collectors.toList()));
        if (jBIterable == null) {
            GPlumDatabaseViewStructureProvider.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/greenplum/GPlumDatabaseViewStructureProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/greenplum/GPlumDatabaseViewStructureProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartitionChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFamilyKinds";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPartitionChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RootPartitionsFilter
    implements Condition<BasicElement> {
        private final GPlumLocalTable myTable;

        RootPartitionsFilter(@NotNull GPlumLocalTable table) {
            if (table == null) {
                RootPartitionsFilter.$$$reportNull$$$0(0);
            }
            this.myTable = table;
        }

        public boolean value(@NotNull BasicElement element2) {
            if (element2 == null) {
                RootPartitionsFilter.$$$reportNull$$$0(1);
            }
            if (!(element2 instanceof GPlumPartition)) {
                return true;
            }
            GPlumPartition partition = (GPlumPartition)element2;
            GPlumPartitionTree tree = this.myTable.getPartitionsTree();
            return tree == null || tree.getParent(partition.getObjectId()) == 0L;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/greenplum/GPlumDatabaseViewStructureProvider$RootPartitionsFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "value";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

