/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J>\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/clickhouse/CHousePredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/model/DasColumn;", "value", "", "type", "Lcom/intellij/database/data/types/OperandType;", "version", "Lcom/intellij/database/util/Version;", "likePredicate", "likeType", "Lcom/intellij/database/data/types/domain/LikeOpType;", "matchCase", "", "canCastToText", "intellij.database.dialects.clickhouse"})
public final class CHousePredicatesHelper
extends BasePredicatesHelper {
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull DasColumn column2, @Nullable Object value, @NotNull OperandType type, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        if (Intrinsics.areEqual((Object)column2.getDataType().typeName, (Object)"FixedString")) {
            if (!(value instanceof String)) {
                return null;
            }
            return PredicatesUtilKt.equalsPredicate(column2, (String)value, this.getDbms());
        }
        return PredicatesUtilKt.defaultEqualsPredicate(column2, value, type, this.getDbms(), version);
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull DasColumn column2, @Nullable Object value, @NotNull LikeOpType likeType, boolean matchCase, boolean canCastToText, @Nullable Version version) {
        boolean canCast;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull((Object)((Object)likeType), (String)"likeType");
        if (!(value instanceof String)) {
            return null;
        }
        boolean typeSupportsOperation = PredicatesUtilKt.supportsOperation(OperationKt.LIKE_OPERATION, column2, this.getDbms(), version);
        boolean bl = canCast = canCastToText && column2.isNotNull() && !PredicatesUtilKt.supportsOperation(OperationKt.EQUALS_TO_NUMBER_OPERATION, column2, this.getDbms(), version);
        if (!canCast && !typeSupportsOperation) {
            return null;
        }
        String likeWord = matchCase || !DbImplUtil.getJdbcHelper(this.getDbms()).supportsIlike() ? "LIKE" : "ILIKE";
        String string = likeType.getDecorator().decorate(StringUtil.notNullize((String)((String)value)), this.getDbms());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"likeType.decorator.decor\u2026.notNullize(value), dbms)");
        String literal = string;
        return new PredicatesHelper.PredicateProducer(typeSupportsOperation, column2, likeWord, literal){
            final /* synthetic */ boolean $typeSupportsOperation;
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ String $likeWord;
            final /* synthetic */ String $literal;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                if (!this.$typeSupportsOperation) {
                    builder.keyword("CAST").symbol("(").identifier((DasObject)this.$column).space().keyword("AS").space().type("String").symbol(")");
                } else {
                    builder.identifier((DasObject)this.$column);
                }
                builder.space().keyword(this.$likeWord).space().literal(this.$literal);
            }
            {
                this.$typeSupportsOperation = bl;
                this.$column = dasColumn;
                this.$likeWord = string;
                this.$literal = string2;
            }
        };
    }

    public CHousePredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
    }
}

