/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.cassandra.CassPredicatesHelper$WhenMappings;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.families.Family;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JD\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J6\u0010\u001d\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\fH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getBestLikeOp", "Lcom/intellij/database/data/types/domain/LikeOpType;", "column", "Lcom/intellij/database/model/DasColumn;", "wantedLikeOp", "getIndices", "", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "c", "Lcom/intellij/database/dialects/cassandra/model/CassTableColumn;", "table", "Lcom/intellij/database/dialects/cassandra/model/CassTable;", "getPredicateProducer", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "value", "", "types", "", "Lcom/intellij/database/data/types/OperandType;", "likeType", "matchCase", "", "version", "Lcom/intellij/database/util/Version;", "likePredicate", "getMode", "Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper$SASIIndexMode;", "SASIIndexMode", "intellij.database.dialects.cassandra"})
public final class CassPredicatesHelper
extends BasePredicatesHelper {
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer getPredicateProducer(@NotNull DasColumn column2, @Nullable Object value, @NotNull List<? extends OperandType> types, @NotNull LikeOpType likeType, boolean matchCase, @Nullable Version version) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)((Object)likeType), (String)"likeType");
        for (OperandType operandType : types) {
            PredicatesHelper.PredicateProducer predicate;
            PredicatesHelper.PredicateProducer predicateProducer;
            switch (CassPredicatesHelper$WhenMappings.$EnumSwitchMapping$0[operandType.ordinal()]) {
                case 1: {
                    predicateProducer = this.likePredicate(column2, value, likeType, this.getDbms(), version);
                    break;
                }
                case 2: {
                    predicateProducer = null;
                    break;
                }
                case 3: 
                case 4: {
                    predicateProducer = PredicatesUtilKt.defaultEqualsPredicate(column2, value, operandType, this.getDbms(), version);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if ((predicate = predicateProducer) == null) continue;
            return predicate;
        }
        return null;
    }

    private final PredicatesHelper.PredicateProducer likePredicate(DasColumn column2, Object value, LikeOpType likeType, Dbms dbms, Version version) {
        Object object = value;
        if (!(object != null ? object instanceof String : true) || !PredicatesUtilKt.supportsOperation(OperationKt.LIKE_OPERATION, column2, dbms, version)) {
            return null;
        }
        LikeOpType likeOp = this.getBestLikeOp(column2, likeType);
        String string = likeOp.getDecorator().decorate(StringUtil.notNullize((String)((String)value)), dbms);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"likeOp.decorator.decorat\u2026.notNullize(value), dbms)");
        String literal = string;
        return new PredicatesHelper.PredicateProducer(column2, likeOp, literal){
            final /* synthetic */ DasColumn $column;
            final /* synthetic */ LikeOpType $likeOp;
            final /* synthetic */ String $literal;

            public final void produce(@NotNull DdlBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                builder.identifier((DasObject)this.$column).space();
                if (this.$likeOp == LikeOpType.MATCHES) {
                    builder.symbol("=");
                } else {
                    builder.keyword("LIKE");
                }
                builder.space().literal(this.$literal);
            }
            {
                this.$column = dasColumn;
                this.$likeOp = likeOpType;
                this.$literal = string;
            }
        };
    }

    private final LikeOpType getBestLikeOp(DasColumn column2, LikeOpType wantedLikeOp) {
        if (!(column2 instanceof CassTableColumn)) {
            return LikeOpType.MATCHES;
        }
        CassTable cassTable = ((CassTableColumn)column2).getTable();
        if (cassTable == null) {
            return LikeOpType.MATCHES;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)cassTable, (String)"column.table ?: return MATCHES");
        CassTable t = cassTable;
        Collection<CassIndex> indices = this.getIndices((CassTableColumn)column2, t);
        Object bestOp = LikeOpType.MATCHES;
        for (CassIndex index2 : indices) {
            Object currentBestOp;
            Object object = this.getMode(index2);
            if (object == null || (object = object.getBestOp()) == null || (object = (LikeOpType)((Object)object.get((Object)wantedLikeOp))) == null) {
                object = currentBestOp = LikeOpType.MATCHES;
            }
            if (currentBestOp == wantedLikeOp) {
                return wantedLikeOp;
            }
            if (((Enum)currentBestOp).compareTo((Enum)bestOp) >= 0) continue;
            bestOp = currentBestOp;
        }
        return bestOp;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CassIndex> getIndices(CassTableColumn c2, CassTable table) {
        void $this$filterTo$iv$iv;
        Family family = table.getIndices();
        Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"table.indices");
        Iterable $this$filter$iv = family;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CassIndex index2 = (CassIndex)element$iv$iv;
            boolean bl = false;
            CassIndex cassIndex = index2;
            Intrinsics.checkExpressionValueIsNotNull((Object)cassIndex, (String)"index");
            if (!(cassIndex.getColumns().size() == 1 && Intrinsics.areEqual((Object)c2.getName(), (Object)index2.getColumns().get(0).getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final SASIIndexMode getMode(@NotNull CassIndex $this$getMode) {
        if (Intrinsics.areEqual((Object)$this$getMode.getClassName(), (Object)"org.apache.cassandra.index.sasi.SASIIndex") ^ true) {
            return null;
        }
        String string = $this$getMode.getOptions();
        if (string == null) {
            return SASIIndexMode.PREFIX;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.options ?: return SASIIndexMode.PREFIX");
        String options = string;
        return StringUtil.containsIgnoreCase((String)options, (String)"'mode': 'contains'") ? SASIIndexMode.CONTAINS : (StringUtil.containsIgnoreCase((String)options, (String)"'mode': 'sparse'") ? SASIIndexMode.SPARSE : SASIIndexMode.PREFIX);
    }

    public CassPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/cassandra/CassPredicatesHelper$SASIIndexMode;", "", "bestOp", "", "Lcom/intellij/database/data/types/domain/LikeOpType;", "(Ljava/lang/String;ILjava/util/Map;)V", "getBestOp", "()Ljava/util/Map;", "PREFIX", "CONTAINS", "SPARSE", "intellij.database.dialects.cassandra"})
    private static final class SASIIndexMode
    extends Enum<SASIIndexMode> {
        public static final /* enum */ SASIIndexMode PREFIX;
        public static final /* enum */ SASIIndexMode CONTAINS;
        public static final /* enum */ SASIIndexMode SPARSE;
        private static final /* synthetic */ SASIIndexMode[] $VALUES;
        @NotNull
        private final Map<LikeOpType, LikeOpType> bestOp;

        static {
            SASIIndexMode[] sASIIndexModeArray = new SASIIndexMode[3];
            SASIIndexMode[] sASIIndexModeArray2 = sASIIndexModeArray;
            sASIIndexModeArray[0] = PREFIX = new SASIIndexMode(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)LikeOpType.CONTAINS), (Object)((Object)LikeOpType.STARTS_WITH)), TuplesKt.to((Object)((Object)LikeOpType.STARTS_WITH), (Object)((Object)LikeOpType.STARTS_WITH)), TuplesKt.to((Object)((Object)LikeOpType.ENDS_WITH), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.MATCHES), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.CUSTOM_LIKE_PATTERN), (Object)((Object)LikeOpType.MATCHES))}));
            sASIIndexModeArray[1] = CONTAINS = new SASIIndexMode(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)LikeOpType.CONTAINS), (Object)((Object)LikeOpType.CONTAINS)), TuplesKt.to((Object)((Object)LikeOpType.STARTS_WITH), (Object)((Object)LikeOpType.CONTAINS)), TuplesKt.to((Object)((Object)LikeOpType.ENDS_WITH), (Object)((Object)LikeOpType.ENDS_WITH)), TuplesKt.to((Object)((Object)LikeOpType.MATCHES), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.CUSTOM_LIKE_PATTERN), (Object)((Object)LikeOpType.MATCHES))}));
            sASIIndexModeArray[2] = SPARSE = new SASIIndexMode(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)LikeOpType.CONTAINS), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.STARTS_WITH), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.ENDS_WITH), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.MATCHES), (Object)((Object)LikeOpType.MATCHES)), TuplesKt.to((Object)((Object)LikeOpType.CUSTOM_LIKE_PATTERN), (Object)((Object)LikeOpType.MATCHES))}));
            $VALUES = sASIIndexModeArray;
        }

        @NotNull
        public final Map<LikeOpType, LikeOpType> getBestOp() {
            return this.bestOp;
        }

        private SASIIndexMode(Map<LikeOpType, ? extends LikeOpType> bestOp) {
            this.bestOp = bestOp;
        }

        public static SASIIndexMode[] values() {
            return (SASIIndexMode[])$VALUES.clone();
        }

        public static SASIIndexMode valueOf(String string) {
            return Enum.valueOf(SASIIndexMode.class, string);
        }
    }
}

