/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.base.introspector.BaseIntroQueries;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.DBFacadeProvider;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.base.introspector.query.CommonPreprocessor;
import com.intellij.database.dialects.base.introspector.query.Evaluator;
import com.intellij.database.dialects.base.introspector.query.MapEvaluator;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBQueryRunner;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InSession;
import org.jetbrains.dekaf.core.InSessionNoResult;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.StringOperator;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u00020\u00072\u00020\b:\u0006\u00b9\u0001\u00ba\u0001\u00bb\u0001B\u001f\b\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\u0015H\u0016J;\u0010Y\u001a \u0012\u0006\b\u0001\u0012\u00028\u00010ZR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010^J;\u0010_\u001a \u0012\u0006\b\u0001\u0012\u00028\u00020`R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010[\u001a\u00020\\2\u0006\u0010a\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010bJ\b\u0010c\u001a\u00020WH\u0016J\n\u0010d\u001a\u0004\u0018\u00010'H\u0016J!\u0010e\u001a\u00020W2\u0006\u0010f\u001a\u00020'2\u000e\b\u0004\u0010g\u001a\b\u0012\u0004\u0012\u00020W0hH\u0084\bJ\u001c\u0010i\u001a\u00020W2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020W0kH\u0004J\u0010\u0010l\u001a\u00020\u00112\u0006\u0010m\u001a\u00020nH\u0004J6\u0010o\u001a\u0002Hp\"\u0004\b\u0003\u0010p2!\u0010q\u001a\u001d\u0012\u0013\u0012\u00110r\u00a2\u0006\f\bs\u0012\b\bt\u0012\u0004\b\b(u\u0012\u0004\u0012\u0002Hp0kH\u0004\u00a2\u0006\u0002\u0010vJ0\u0010o\u001a\u00020W2!\u0010q\u001a\u001d\u0012\u0013\u0012\u00110r\u00a2\u0006\f\bs\u0012\b\bt\u0012\u0004\b\b(u\u0012\u0004\u0012\u00020W0kH\u0005\u00a2\u0006\u0002\bwJ6\u0010x\u001a\u0002Hp\"\u0004\b\u0003\u0010p2!\u0010q\u001a\u001d\u0012\u0013\u0012\u00110\\\u00a2\u0006\f\bs\u0012\b\bt\u0012\u0004\b\b(y\u0012\u0004\u0012\u0002Hp0kH\u0004\u00a2\u0006\u0002\u0010vJ0\u0010x\u001a\u00020W2!\u0010q\u001a\u001d\u0012\u0013\u0012\u00110\\\u00a2\u0006\f\bs\u0012\b\bt\u0012\u0004\b\b(y\u0012\u0004\u0012\u00020W0kH\u0005\u00a2\u0006\u0002\bzJ>\u0010x\u001a\u0002Hp\"\u0004\b\u0003\u0010p2\u0006\u0010\u001d\u001a\u00020\u001e2!\u0010q\u001a\u001d\u0012\u0013\u0012\u00110\\\u00a2\u0006\f\bs\u0012\b\bt\u0012\u0004\b\b(y\u0012\u0004\u0012\u0002Hp0kH\u0004\u00a2\u0006\u0002\u0010{J\u0012\u0010|\u001a\u0002012\b\u00104\u001a\u0004\u0018\u000101H\u0016J\b\u0010}\u001a\u00020WH\u0014J\b\u0010~\u001a\u00020WH\u0014J&\u0010\u007f\u001a\u00020W2\u0016\u0010\u0080\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u0082\u00010\u0081\u0001\"\u00030\u0082\u0001H\u0016\u00a2\u0006\u0003\u0010\u0083\u0001J$\u0010\u0084\u0001\u001a\u00020W2\u0006\u0010y\u001a\u00020\\2\u0011\u0010\u0080\u0001\u001a\f\u0012\u0005\u0012\u00030\u0082\u0001\u0018\u00010\u0085\u0001H$JB\u0010\u0086\u0001\u001a\u00020W2\b\u0010\u0087\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u0088\u0001\u001a\u00020\u00112\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0014\u0010\u008b\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020'0\u0081\u0001\"\u00020'H\u0016\u00a2\u0006\u0003\u0010\u008c\u0001J\t\u0010\u008d\u0001\u001a\u00020WH\u0016J\u0011\u0010\u008e\u0001\u001a\u00020W2\u0006\u0010y\u001a\u00020\\H$J6\u0010\u008f\u0001\u001a\u0016\u0012\u0004\u0012\u00020n\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020'0\u0081\u00010\u0090\u00012\u000e\u0010\u0091\u0001\u001a\t\u0012\u0004\u0012\u00020n0\u0092\u00012\u0007\u0010\u0093\u0001\u001a\u00020\u0011H\u0016J>\u0010\u008f\u0001\u001a\u00020W2\u000e\u0010\u0091\u0001\u001a\t\u0012\u0004\u0012\u00020n0\u0092\u00012\u0007\u0010\u0093\u0001\u001a\u00020\u00112\u001a\u0010\u0094\u0001\u001a\u0015\u0012\u0004\u0012\u00020n\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020'0\u0081\u00010LH&J\t\u0010\u0095\u0001\u001a\u00020WH\u0004J \u0010\u0095\u0001\u001a\u00020W2\u0007\u0010\u0096\u0001\u001a\u00028\u00002\u0006\u0010X\u001a\u00020\u0015H\u0014\u00a2\u0006\u0003\u0010\u0097\u0001J\t\u0010\u0098\u0001\u001a\u00020WH\u0016J\t\u0010\u0099\u0001\u001a\u00020WH\u0016J\u0011\u0010\u0099\u0001\u001a\u00020W2\u0006\u0010y\u001a\u00020\\H\u0014J\u0011\u0010\u009a\u0001\u001a\u00020\u00112\u0006\u0010m\u001a\u00020nH\u0004J\u0011\u0010\u009b\u0001\u001a\u00020\u00112\u0006\u00104\u001a\u000201H\u0014J-\u0010\u009c\u0001\u001a\u0002H\u0001\"\u0004\b\u0003\u0010\u00012\u0006\u0010[\u001a\u00020\\2\u000e\u0010\u009d\u0001\u001a\t\u0012\u0004\u0012\u0002H\u00010\u009e\u0001H\u0004\u00a2\u0006\u0003\u0010\u009f\u0001J%\u0010\u009c\u0001\u001a\u0002H\u0001\"\u0004\b\u0003\u0010\u00012\u000e\u0010\u009d\u0001\u001a\t\u0012\u0004\u0012\u0002H\u00010\u009e\u0001H\u0004\u00a2\u0006\u0003\u0010\u00a0\u0001JL\u0010\u00a1\u0001\u001a\u00020W\"\u0005\b\u0003\u0010\u00a2\u00012\u0018\u0010\u009d\u0001\u001a\u0013\u0012\u000e\b\u0001\u0012\n\u0012\u0005\u0012\u0003H\u00a2\u00010\u0092\u00010\u009e\u00012\n\b\u0002\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\u0014\u0010\u00a5\u0001\u001a\u000f\u0012\u0005\u0012\u0003H\u00a2\u0001\u0012\u0004\u0012\u00020W0kH\u0004J\t\u0010\u00a6\u0001\u001a\u00020WH\u0004J\u0012\u0010\u00a7\u0001\u001a\u00020W2\u0007\u0010\u0096\u0001\u001a\u00020\u0002H\u0004J&\u0010\u00a8\u0001\u001a\u000f\u0012\u0004\u0012\u00020n\u0012\u0004\u0012\u00020\u00110\u0090\u00012\u000e\u0010\u0091\u0001\u001a\t\u0012\u0004\u0012\u00020n0\u0092\u0001H\u0016J\u001c\u0010\u00a9\u0001\u001a\u00020W2\u0006\u0010t\u001a\u00020'2\t\u0010\u00aa\u0001\u001a\u0004\u0018\u00010MH\u0004J\u0012\u0010\u00ab\u0001\u001a\u00020W2\u0007\u0010\u00ac\u0001\u001a\u00020'H\u0004J\u001b\u0010\u00ad\u0001\u001a\u00020W2\u0007\u0010\u00ae\u0001\u001a\u00020'2\u0007\u0010\u00ac\u0001\u001a\u00020'H\u0004J\u001b\u0010\u00af\u0001\u001a\u00020W2\u000f\b\u0004\u0010\u00b0\u0001\u001a\b\u0012\u0004\u0012\u00020W0hH\u0084\bJ\r\u0010\u00b1\u0001\u001a\u00020'*\u00020'H\u0004JC\u0010\u00b2\u0001\u001a\u00020W\"\u0004\b\u0003\u0010\u0005*\u0012\u0012\r\b\u0001\u0012\t\u0012\u0004\u0012\u0002H\u00050\u0092\u00010\u00b3\u00012\b\u0010\u00b4\u0001\u001a\u00030\u00a4\u00012\u0013\u0010\u00a5\u0001\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020W0kH\u0084\bJ=\u0010\u00b5\u0001\u001a\t\u0012\u0004\u0012\u0002Hp0\u0081\u0001\"\u0004\b\u0003\u0010p*\t\u0012\u0004\u0012\u0002Hp0\u0081\u00012\u0013\u0010\u00b6\u0001\u001a\u000e\u0012\u0004\u0012\u0002Hp\u0012\u0004\u0012\u0002Hp0kH\u0084\b\u00a2\u0006\u0003\u0010\u00b7\u0001J7\u0010\u00b5\u0001\u001a\t\u0012\u0004\u0012\u0002Hp0\u00b8\u0001\"\u0004\b\u0003\u0010p*\t\u0012\u0004\u0012\u0002Hp0\u00b8\u00012\u0013\u0010\u00b6\u0001\u001a\u000e\u0012\u0004\u0012\u0002Hp\u0012\u0004\u0012\u0002Hp0kH\u0084\bR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010\"\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020!@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R&\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0013R\u001c\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020100X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u0002018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\"\u00109\u001a\u0004\u0018\u0001012\b\u0010\u0014\u001a\u0004\u0018\u000101@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00106R\u001a\u0010;\u001a\u00020<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0010\u0010A\u001a\u00020B8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010C\u001a\u0004\u0018\u00010DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u001c\u0010K\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020M0L8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010N\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020!@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010$R\u001b\u0010P\u001a\u00020Q8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bT\u0010U\u001a\u0004\bR\u0010S\u00a8\u0006\u00bc\u0001"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "R", "Lcom/intellij/database/model/basic/BasicModRoot;", "D", "Lcom/intellij/database/model/basic/BasicModDatabase;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntroQueries;", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/Dbms;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "considerSystemSchemasReinstrospection", "", "getConsiderSystemSchemasReinstrospection", "()Z", "<set-?>", "Lcom/intellij/database/dataSource/DatabaseConnection;", "dbConnection", "getDbConnection", "()Lcom/intellij/database/dataSource/DatabaseConnection;", "dbConnectionInfo", "Lorg/jetbrains/dekaf/core/ConnectionInfo;", "getDbConnectionInfo", "()Lorg/jetbrains/dekaf/core/ConnectionInfo;", "dbFacade", "Lorg/jetbrains/dekaf/core/DBFacade;", "getDbms", "()Lcom/intellij/database/Dbms;", "Lcom/intellij/database/util/Version;", "driverVersion", "getDriverVersion", "()Lcom/intellij/database/util/Version;", "errorSink", "Lcom/intellij/util/PairConsumer;", "", "", "getErrorSink", "()Lcom/intellij/util/PairConsumer;", "setErrorSink", "(Lcom/intellij/util/PairConsumer;)V", "initialized", "getInitialized", "modModelClass", "Ljava/lang/Class;", "Lcom/intellij/database/model/basic/BasicModModel;", "getModModelClass", "()Ljava/lang/Class;", "model", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "getModelFactory", "()Lcom/intellij/database/model/ModelFactory;", "myModel", "getMyModel", "options", "Lcom/intellij/database/introspection/DBIntrospectionOptions;", "getOptions", "()Lcom/intellij/database/introspection/DBIntrospectionOptions;", "setOptions", "(Lcom/intellij/database/introspection/DBIntrospectionOptions;)V", "preprocessor", "Lcom/intellij/database/dialects/base/introspector/query/CommonPreprocessor;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getProgressIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "setProgressIndicator", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "queryParameters", "", "", "serverVersion", "getServerVersion", "sqlHelper", "Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;", "getSqlHelper", "()Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;", "sqlHelper$delegate", "Lkotlin/Lazy;", "attachToDB", "", "connection", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractDatabaseRetriever;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractDatabaseRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "schema", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "detachFromDB", "getCurrentDatabase", "handleErrors", "operationName", "operation", "Lkotlin/Function0;", "inModel", "modifier", "Lkotlin/Function1;", "inScope", "e", "Lcom/intellij/database/model/basic/BasicElement;", "inSession", "T", "block", "Lorg/jetbrains/dekaf/core/DBSession;", "Lkotlin/ParameterName;", "name", "session", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "inSessionUnit", "inTransaction", "tran", "inTransactionUnit", "(Lorg/jetbrains/dekaf/core/DBFacade;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "init", "initConnectionRelatedState", "initModelRelatedState", "introspectAuto", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "([Lcom/intellij/database/model/basic/BasicNamespace;)V", "introspectAutoInTran", "", "introspectFragment", "namespace", "withSources", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectNames", "(Lcom/intellij/database/model/basic/BasicNamespace;ZLcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "introspectNamespaces", "introspectNamespacesInTran", "introspectNativeDefinitions", "", "elements", "", "withNestedElements", "result", "introspectServerInfo", "root", "(Lcom/intellij/database/model/basic/BasicModRoot;Lcom/intellij/database/dataSource/DatabaseConnection;)V", "introspectServerObjects", "introspectSessionState", "isIntrospected", "modelCanBeAccepted", "performQuery", "query", "Lorg/jetbrains/dekaf/sql/SqlQuery;", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lorg/jetbrains/dekaf/sql/SqlQuery;)Ljava/lang/Object;", "(Lorg/jetbrains/dekaf/sql/SqlQuery;)Ljava/lang/Object;", "performQueryByPack", "X", "packSize", "", "action", "postIntrospectionProcess", "postIntrospectionProcessWithModel", "retrieveInvalid", "setQueryParameter", "value", "updateDetails", "details", "updateStatus", "status", "writeSources", "r", "dbIntern", "forEachByPack", "Lorg/jetbrains/dekaf/core/DBQueryRunner;", "limit", "inplace", "t", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "", "AbstractDatabaseRetriever", "AbstractRetriever", "AbstractSchemaRetriever", "intellij.database.dialects.base"})
public abstract class BaseIntrospector<R extends BasicModRoot, D extends BasicModDatabase, S extends BasicModSchema>
extends BaseIntroQueries
implements DBIntrospector {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private PairConsumer<String, Throwable> errorSink;
    private final boolean considerSystemSchemasReinstrospection;
    @NotNull
    private final Class<? extends BasicModModel> modModelClass;
    @Nullable
    private BasicModModel myModel;
    @NotNull
    private DBIntrospectionOptions options;
    @Nullable
    private ProgressIndicator progressIndicator;
    @Nullable
    private DatabaseConnection dbConnection;
    private DBFacade dbFacade;
    @NotNull
    private Version serverVersion;
    @NotNull
    private Version driverVersion;
    @JvmField
    @NotNull
    protected final Map<String, Object> queryParameters;
    @JvmField
    @NotNull
    protected final CommonPreprocessor preprocessor;
    @NotNull
    private final Lazy sqlHelper$delegate;
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final Project project;
    @NotNull
    private final ModelFactory modelFactory;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BaseIntrospector.class), "sqlHelper", "getSqlHelper()Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;"))};
    }

    @Override
    @NotNull
    public PairConsumer<String, Throwable> getErrorSink() {
        return this.errorSink;
    }

    @Override
    public void setErrorSink(@NotNull PairConsumer<String, Throwable> pairConsumer) {
        Intrinsics.checkParameterIsNotNull(pairConsumer, (String)"<set-?>");
        this.errorSink = pairConsumer;
    }

    protected final boolean getConsiderSystemSchemasReinstrospection() {
        return this.considerSystemSchemasReinstrospection;
    }

    @NotNull
    protected final Class<? extends BasicModModel> getModModelClass() {
        return this.modModelClass;
    }

    @Nullable
    protected final BasicModModel getMyModel() {
        return this.myModel;
    }

    @Override
    @NotNull
    public final DBIntrospectionOptions getOptions() {
        return this.options;
    }

    @Override
    public final void setOptions(@NotNull DBIntrospectionOptions dBIntrospectionOptions) {
        Intrinsics.checkParameterIsNotNull((Object)dBIntrospectionOptions, (String)"<set-?>");
        this.options = dBIntrospectionOptions;
    }

    @Override
    @Nullable
    public final ProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    @Override
    public final void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    @Nullable
    protected final DatabaseConnection getDbConnection() {
        return this.dbConnection;
    }

    @NotNull
    protected final Version getServerVersion() {
        return this.serverVersion;
    }

    @NotNull
    protected final Version getDriverVersion() {
        return this.driverVersion;
    }

    protected final boolean getInitialized() {
        return this.myModel != null && this.dbConnection != null;
    }

    @NotNull
    protected final IntrospectorSqlHelper getSqlHelper() {
        Lazy lazy = this.sqlHelper$delegate;
        BaseIntrospector baseIntrospector = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (IntrospectorSqlHelper)lazy.getValue();
    }

    @Override
    @NotNull
    public BasicModModel init(@Nullable BasicModModel model) {
        if (this.myModel != null) {
            throw (Throwable)new IllegalStateException(this.getClass().getSimpleName() + " is already initialized");
        }
        this.myModel = model != null && this.modelCanBeAccepted(model) ? model : this.modelFactory.createModel(this.dbms, this.modModelClass);
        this.initModelRelatedState();
        BasicModModel basicModModel = this.myModel;
        if (basicModModel == null) {
            Intrinsics.throwNpe();
        }
        return basicModModel;
    }

    protected boolean modelCanBeAccepted(@NotNull BasicModModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        return this.modModelClass.isAssignableFrom(model.getClass());
    }

    protected void initModelRelatedState() {
    }

    protected void initConnectionRelatedState() {
        DatabaseConnection databaseConnection = this.dbConnection;
        boolean bl = Intrinsics.areEqual((Object)this.dbms, (Object)(databaseConnection != null ? databaseConnection.getDbms() : null));
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            DatabaseConnection databaseConnection2 = this.dbConnection;
            String string = "Introspector for " + this.dbms.getDisplayName() + ", but connection for " + (databaseConnection2 != null ? databaseConnection2.getDbms() : null);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @Override
    @NotNull
    public BasicModModel getModel() {
        BasicModModel basicModModel;
        if (this.myModel != null) {
            basicModModel = this.myModel;
            if (basicModModel == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)new IllegalStateException("The introspector is not initialized yet: model is not created");
        }
        return basicModModel;
    }

    @Override
    public void attachToDB(@NotNull DatabaseConnection connection2) {
        DBFacade db;
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        boolean bl = Intrinsics.areEqual((Object)this.dbms, (Object)connection2.getDbms());
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = this.getClass().getSimpleName() + " expects a connection to " + this.dbms + " but got to " + connection2.getDbms() + " that is not good";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.dbConnection != null) {
            this.detachFromDB();
        }
        this.dbConnection = connection2;
        this.dbFacade = db = DBFacadeProvider.createFacadeWithSingleLeasedConnection(connection2);
        Version version = connection2.getVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"connection.version");
        this.serverVersion = version;
        int[] nArray = db.getConnectionInfo().driverVersion.toArray();
        Version version2 = Version.of((int[])Arrays.copyOf(nArray, nArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"Version.of(*db.connectio\u2026.driverVersion.toArray())");
        this.driverVersion = version2;
        this.initConnectionRelatedState();
    }

    @Override
    public void detachFromDB() {
        this.dbConnection = null;
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade != null) {
            dBFacade.disconnect();
        }
        this.dbFacade = null;
        Version version = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"Version.ZERO");
        this.serverVersion = version;
        Version version2 = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"Version.ZERO");
        this.driverVersion = version2;
    }

    @NotNull
    protected final ConnectionInfo getDbConnectionInfo() {
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        ConnectionInfo connectionInfo = dbf.getConnectionInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)connectionInfo, (String)"dbf.connectionInfo");
        return connectionInfo;
    }

    protected final <T> T inSession(@NotNull Function1<? super DBSession, ? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        Object result2 = dbf.inSession(new InSession<T>(block){
            final /* synthetic */ Function1 $block;

            public final T run(@NotNull DBSession session2) {
                Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                return (T)this.$block.invoke((Object)session2);
            }
            {
                this.$block = function1;
            }
        });
        return (T)result2;
    }

    @JvmName(name="inSessionUnit")
    protected final void inSessionUnit(@NotNull Function1<? super DBSession, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        dbf.inSession(new InSessionNoResult(block){
            final /* synthetic */ Function1 $block;

            public final void run(@NotNull DBSession session2) {
                Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                this.$block.invoke((Object)session2);
            }
            {
                this.$block = function1;
            }
        });
    }

    protected final <T> T inTransaction(@NotNull Function1<? super DBTransaction, ? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        return this.inTransaction(dbf, block);
    }

    @JvmName(name="inTransactionUnit")
    protected final void inTransactionUnit(@NotNull Function1<? super DBTransaction, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        this.inTransaction(dbf, block);
    }

    protected final <T> T inTransaction(@NotNull DBFacade dbFacade, @NotNull Function1<? super DBTransaction, ? extends T> block) {
        Intrinsics.checkParameterIsNotNull((Object)dbFacade, (String)"dbFacade");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        return (T)dbFacade.inSession(new InSession<T>(block){
            final /* synthetic */ Function1 $block;

            public final T run(@NotNull DBSession session2) {
                Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                return (T)this.$block.invoke((Object)session2);
            }
            {
                this.$block = function1;
            }
        });
    }

    protected final void setQueryParameter(@NotNull String name2, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (value != null) {
            this.queryParameters.put(name2, value);
        } else {
            this.queryParameters.remove(name2);
        }
    }

    protected final <R> R performQuery(@NotNull SqlQuery<R> query) {
        Intrinsics.checkParameterIsNotNull(query, (String)"query");
        SqlQuery sqlQuery = query.rewrite((StringOperator)this.preprocessor);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlQuery, (String)"query.rewrite(preprocessor)");
        SqlQuery preprocessedQuery = sqlQuery;
        return (R)this.inTransaction((Function1)new Function1<DBTransaction, R>(this, preprocessedQuery){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ SqlQuery $preprocessedQuery;

            public final R invoke(@NotNull DBTransaction transaction) {
                Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
                return this.this$0.performTheQuery(transaction, this.$preprocessedQuery, this.this$0.preprocessor.getBindableParameters());
            }
            {
                this.this$0 = baseIntrospector;
                this.$preprocessedQuery = sqlQuery;
                super(1);
            }
        });
    }

    protected final <X> void performQueryByPack(@NotNull SqlQuery<? extends Iterable<? extends X>> query, int packSize, @NotNull Function1<? super X, Unit> action2) {
        Intrinsics.checkParameterIsNotNull(query, (String)"query");
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        SqlQuery sqlQuery = query.rewrite((StringOperator)this.preprocessor);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlQuery, (String)"query.rewrite(preprocessor)");
        SqlQuery preprocessedQuery = sqlQuery;
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, preprocessedQuery, packSize, action2){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ SqlQuery $preprocessedQuery;
            final /* synthetic */ int $packSize;
            final /* synthetic */ Function1 $action;

            public final void invoke(@NotNull DBTransaction transaction) {
                Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
                this.this$0.performTheQueryByPackIterateRow(transaction, this.$preprocessedQuery, this.this$0.preprocessor.getBindableParameters(), this.$packSize, this.$action);
            }
            {
                this.this$0 = baseIntrospector;
                this.$preprocessedQuery = sqlQuery;
                this.$packSize = n;
                this.$action = function1;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void performQueryByPack$default(BaseIntrospector baseIntrospector, SqlQuery sqlQuery, int n, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryByPack");
        }
        if ((n2 & 2) != 0) {
            n = 4096;
        }
        baseIntrospector.performQueryByPack(sqlQuery, n, function1);
    }

    protected final <R> R performQuery(@NotNull DBTransaction transaction, @NotNull SqlQuery<R> query) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(query, (String)"query");
        SqlQuery sqlQuery = query.rewrite((StringOperator)this.preprocessor);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlQuery, (String)"query.rewrite(preprocessor)");
        SqlQuery preprocessedQuery = sqlQuery;
        return this.performTheQuery(transaction, preprocessedQuery, this.preprocessor.getBindableParameters());
    }

    protected final void introspectServerInfo() {
        if (!this.getInitialized()) {
            throw (Throwable)new IllegalStateException("Introspector is not initialized yet.");
        }
        DatabaseConnection databaseConnection = this.dbConnection;
        if (databaseConnection == null) {
            throw (Throwable)new IllegalStateException("Database is not attached yet.");
        }
        DatabaseConnection dbConnection = databaseConnection;
        this.inModel((Function1)new Function1<R, Unit>(this, dbConnection){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ DatabaseConnection $dbConnection;

            public final void invoke(@NotNull R root2) {
                Intrinsics.checkParameterIsNotNull(root2, (String)"root");
                this.this$0.introspectServerInfo(root2, this.$dbConnection);
            }
            {
                this.this$0 = baseIntrospector;
                this.$dbConnection = databaseConnection;
                super(1);
            }
        });
    }

    protected void introspectServerInfo(@NotNull R root2, @NotNull DatabaseConnection connection2) {
        Intrinsics.checkParameterIsNotNull(root2, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        root2.setDbms(connection2.getDbms());
        root2.setServerVersion(connection2.getVersion());
    }

    @Override
    public void introspectAuto(BasicNamespace ... namespaces) {
        Intrinsics.checkParameterIsNotNull((Object)namespaces, (String)"namespaces");
        this.introspectServerInfo();
        int n = namespaces.length;
        ArrayList<BasicNamespace> theNamespaces = new ArrayList<BasicNamespace>(n);
        if (n > 0) {
            for (BasicNamespace ns : namespaces) {
                boolean bl = this.getModel().contains(ns);
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Namespaces must be from this model";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                theNamespaces.add(ns);
            }
        }
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this, theNamespaces){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ ArrayList $theNamespaces;

            public final void invoke(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                this.this$0.introspectAutoInTran(tran, this.$theNamespaces);
            }
            {
                this.this$0 = baseIntrospector;
                this.$theNamespaces = arrayList;
                super(1);
            }
        }));
    }

    protected abstract void introspectAutoInTran(@NotNull DBTransaction var1, @Nullable Collection<? extends BasicNamespace> var2);

    @Override
    public void introspectNamespaces() {
        this.introspectServerInfo();
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ BaseIntrospector this$0;

            public final void invoke(@NotNull DBTransaction it2) {
                Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                this.this$0.introspectNamespacesInTran(it2);
            }
            {
                this.this$0 = baseIntrospector;
                super(1);
            }
        }));
    }

    protected abstract void introspectNamespacesInTran(@NotNull DBTransaction var1);

    @Override
    public void introspectSessionState() {
        this.introspectServerInfo();
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ BaseIntrospector this$0;

            public final void invoke(@NotNull DBTransaction it2) {
                Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                this.this$0.introspectSessionState(it2);
            }
            {
                this.this$0 = baseIntrospector;
                super(1);
            }
        }));
    }

    protected void introspectSessionState(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
    }

    @Override
    public void introspectServerObjects() {
    }

    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"objectKind");
        Intrinsics.checkParameterIsNotNull((Object)objectNames, (String)"objectNames");
    }

    @Override
    @NotNull
    public Map<BasicElement, String[]> introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Map result2 = new LinkedHashMap();
        this.introspectNativeDefinitions(elements, withNestedElements, result2);
        return result2;
    }

    public abstract void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> var1, boolean var2, @NotNull Map<BasicElement, String[]> var3);

    @NotNull
    protected abstract AbstractDatabaseRetriever<? extends D> createDatabaseRetriever(@NotNull DBTransaction var1, @NotNull D var2);

    @NotNull
    protected abstract AbstractSchemaRetriever<? extends S> createSchemaRetriever(@NotNull DBTransaction var1, @NotNull S var2);

    protected final void postIntrospectionProcess() {
        this.getModel().modify(BasicModRoot.class, (ModelModifier)new ModelModifier<BasicModRoot>(this){
            final /* synthetic */ BaseIntrospector this$0;

            public final void perform(BasicModRoot r) {
                BasicModRoot basicModRoot = r;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicModRoot, (String)"r");
                this.this$0.postIntrospectionProcessWithModel(basicModRoot);
            }
            {
                this.this$0 = baseIntrospector;
            }
        });
    }

    protected final void postIntrospectionProcessWithModel(@NotNull BasicModRoot root2) {
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        Iterator<? extends BasicModSchema> iterator = root2.getAllSchemas().iterator();
        while (iterator.hasNext()) {
            BasicModSchema schema;
            BasicModSchema basicModSchema = schema = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicModSchema, (String)"schema");
            BaseIntrospectionFunctions.derefAll(basicModSchema);
        }
    }

    protected final void updateStatus(@NotNull String status, @NotNull String details) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            this.getLog().debug("Working on: " + status + " (" + details + ')');
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            ProgressIndicator progressIndicator2 = this.progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText(status);
            }
            ProgressIndicator progressIndicator3 = this.progressIndicator;
            if (progressIndicator3 == null) break block2;
            progressIndicator3.setText2(StringUtil.capitalize((String)Case.LOWER.apply(details)));
        }
    }

    protected final void updateDetails(@NotNull String details) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            ProgressIndicator progressIndicator2 = this.progressIndicator;
            if (progressIndicator2 == null) break block1;
            progressIndicator2.setText2(StringUtil.capitalize((String)Case.LOWER.apply(details)));
        }
    }

    protected final void writeSources(@NotNull Function0<Unit> r) {
        int $i$f$writeSources = 0;
        Intrinsics.checkParameterIsNotNull(r, (String)"r");
        this.getModel().writeSources(new Runnable(r){
            final /* synthetic */ Function0 $r;

            public final void run() {
                this.$r.invoke();
            }
            {
                this.$r = function0;
            }
        });
    }

    @Override
    @Nullable
    public String getCurrentDatabase() {
        return this.getDbConnectionInfo().databaseName;
    }

    protected final void handleErrors(@NotNull String operationName, @NotNull Function0<Unit> operation2) {
        int $i$f$handleErrors = 0;
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        Intrinsics.checkParameterIsNotNull(operation2, (String)"operation");
        try {
            operation2.invoke();
        }
        catch (InterruptedException ie) {
            throw (Throwable)ie;
        }
        catch (DBException d2) {
            String message2 = "Error encountered when performing " + operationName + ": " + d2.getMessage();
            this.getErrorSink().consume((Object)message2, (Object)d2);
        }
        catch (NullPointerException npe) {
            String message3 = "NPE encountered when performing " + operationName;
            this.getErrorSink().consume((Object)message3, (Object)npe);
            this.getLog().error(message3, (Throwable)npe);
        }
        catch (Exception e) {
            String message4 = "Unexpected error (" + e.getClass().getSimpleName() + ") encountered when performing " + operationName + ": " + e.getMessage();
            this.getErrorSink().consume((Object)message4, (Object)e);
        }
    }

    @Override
    @NotNull
    public Map<BasicElement, Boolean> retrieveInvalid(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Map<BasicElement, Boolean> map2 = Collections.emptyMap();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.emptyMap()");
        return map2;
    }

    protected final void inModel(@NotNull Function1<? super R, Unit> modifier) {
        Intrinsics.checkParameterIsNotNull(modifier, (String)"modifier");
        this.getModel().modify(BasicModRoot.class, (ModelModifier)new ModelModifier<BasicModRoot>(modifier){
            final /* synthetic */ Function1 $modifier;

            public final void perform(BasicModRoot root2) {
                BasicModRoot basicModRoot = root2;
                if (basicModRoot == null) {
                    throw new TypeCastException("null cannot be cast to non-null type R");
                }
                this.$modifier.invoke((Object)basicModRoot);
            }
            {
                this.$modifier = function1;
            }
        });
    }

    protected final <S> void forEachByPack(@NotNull DBQueryRunner<? extends Iterable<? extends S>> $this$forEachByPack, int limit, @NotNull Function1<? super S, Unit> action2) {
        int $i$f$forEachByPack = 0;
        Intrinsics.checkParameterIsNotNull($this$forEachByPack, (String)"$this$forEachByPack");
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        DBQueryRunner dBQueryRunner = $this$forEachByPack.packBy(limit);
        Intrinsics.checkExpressionValueIsNotNull((Object)dBQueryRunner, (String)"packBy(limit)");
        DBQueryRunner r = dBQueryRunner;
        Iterable pack2 = (Iterable)r.run();
        while (pack2 != null) {
            Iterable $this$forEach$iv = pack2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action2.invoke(element$iv);
            }
            pack2 = (Iterable)r.nextPack();
        }
    }

    @NotNull
    protected final String dbIntern(@NotNull String $this$dbIntern) {
        Intrinsics.checkParameterIsNotNull((Object)$this$dbIntern, (String)"$this$dbIntern");
        String string = DbUtil.intern((String)$this$dbIntern);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DbUtil.intern(this)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T> T[] inplace(@NotNull T[] $this$inplace, @NotNull Function1<? super T, ? extends T> t) {
        int $i$f$inplace = 0;
        Intrinsics.checkParameterIsNotNull($this$inplace, (String)"$this$inplace");
        Intrinsics.checkParameterIsNotNull(t, (String)"t");
        T[] TArray = $this$inplace;
        boolean bl = false;
        boolean bl2 = false;
        T[] $this$apply = TArray;
        boolean bl3 = false;
        T[] $this$forEachIndexed$iv = $this$apply;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (T item$iv : $this$forEachIndexed$iv) {
            void s;
            int n = index$iv++;
            T t2 = item$iv;
            int i2 = n;
            boolean bl4 = false;
            $this$apply[i2] = t.invoke((Object)s);
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T> List<T> inplace(@NotNull List<T> $this$inplace, @NotNull Function1<? super T, ? extends T> t) {
        int $i$f$inplace = 0;
        Intrinsics.checkParameterIsNotNull($this$inplace, (String)"$this$inplace");
        Intrinsics.checkParameterIsNotNull(t, (String)"t");
        List<T> list = $this$inplace;
        boolean bl = false;
        boolean bl2 = false;
        List<T> $this$apply = list;
        boolean bl3 = false;
        Iterable $this$forEachIndexed$iv = $this$apply;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n = index$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Object t2 = item$iv;
            int i2 = n2;
            boolean bl5 = false;
            $this$apply.set(i2, t.invoke((Object)s));
        }
        return list;
    }

    protected final boolean inScope(@NotNull BasicElement e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return DataSourceSchemaMapping.matches(this.options.getScope(), e);
    }

    protected final boolean isIntrospected(@NotNull BasicElement e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return this.inScope(e) || this.options.getScope().isEmpty() && DataSourceSchemaMapping.matches(this.getDefaultScope(), e);
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final ModelFactory getModelFactory() {
        return this.modelFactory;
    }

    protected BaseIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        this.dbms = dbms;
        this.project = project;
        this.modelFactory = modelFactory;
        this.errorSink = errorSink.1.INSTANCE;
        ModelFacade modelFacade = ModelFacade.forDbms(this.dbms);
        Intrinsics.checkExpressionValueIsNotNull((Object)modelFacade, (String)"ModelFacade.forDbms(dbms)");
        MetaModel metaModel = modelFacade.getMetaModel();
        if (metaModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.meta.BasicMetaModel");
        }
        Class<? extends BasicModModel> clazz = ((BasicMetaModel)metaModel).apiClass;
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"(ModelFacade.forDbms(dbm\u2026 BasicMetaModel).apiClass");
        this.modModelClass = clazz;
        Version version = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"Version.ZERO");
        this.serverVersion = version;
        Version version2 = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"Version.ZERO");
        this.driverVersion = version2;
        this.queryParameters = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        this.preprocessor = new CommonPreprocessor(true, new MapEvaluator(this.queryParameters));
        this.sqlHelper$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IntrospectorSqlHelper>(this){
            final /* synthetic */ BaseIntrospector this$0;

            @NotNull
            public final IntrospectorSqlHelper invoke() {
                return new IntrospectorSqlHelper(this.this$0.getProject(), this.this$0.getDbms());
            }
            {
                this.this$0 = baseIntrospector;
                super(0);
            }
        }));
        this.options = BaseIntrospectionFunctions.DEFAULT_OPTIONS;
        Version version3 = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version3, (String)"Version.ZERO");
        this.serverVersion = version3;
        Version version4 = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version4, (String)"Version.ZERO");
        this.driverVersion = version4;
        this.considerSystemSchemasReinstrospection = BaseIntrospectionFunctions.stringToBoolean(System.getProperty("dbe.always.reintrospect.system.schemas"));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\f\b\u00a4\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J!\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0003\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0004\u00a2\u0006\u0002\u0010\u001dJ8\u0010\u001e\u001a\u00020\u001f\"\u0004\b\u0003\u0010\u001a2\u0014\u0010 \u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u001a0!0\u001c2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u001f0#H\u0004J@\u0010\u001e\u001a\u00020\u001f\"\u0004\b\u0003\u0010\u001a2\u0014\u0010 \u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u001a0!0\u001c2\u0006\u0010$\u001a\u00020%2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u001f0#H\u0004J4\u0010&\u001a\b\u0012\u0004\u0012\u0002H(0'\"\u0004\b\u0003\u0010(2\u0014\u0010\u001b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H(0!0\u001c2\b\b\u0002\u0010$\u001a\u00020%H\u0014J/\u0010)\u001a\u0004\u0018\u0001H\u001a\"\b\b\u0003\u0010\u001a*\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\u0006\u0010*\u001a\u00020\u0011H\u0004\u00a2\u0006\u0002\u0010+J2\u0010,\u001a\b\u0012\u0004\u0012\u0002H(0'\"\u0004\b\u0003\u0010(2\u0014\u0010\u001b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H(0!0\u001c2\u0006\u0010*\u001a\u00020\u0011H\u0004J\b\u0010-\u001a\u00020\u001fH&J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u0011H\u0014J\u0018\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u00112\b\u00102\u001a\u0004\u0018\u00010\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00063"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/query/Evaluator;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "preprocessor", "Lcom/intellij/database/dialects/base/introspector/query/CommonPreprocessor;", "getPreprocessor", "()Lcom/intellij/database/dialects/base/introspector/query/CommonPreprocessor;", "setPreprocessor", "(Lcom/intellij/database/dialects/base/introspector/query/CommonPreprocessor;)V", "queryParameters", "", "", "", "getQueryParameters", "()Ljava/util/Map;", "getTransaction", "()Lorg/jetbrains/dekaf/core/DBTransaction;", "evaluate", "expression", "performQuery", "X", "query", "Lorg/jetbrains/dekaf/sql/SqlQuery;", "(Lorg/jetbrains/dekaf/sql/SqlQuery;)Ljava/lang/Object;", "performQueryByPack", "", "_query", "", "action", "Lkotlin/Function1;", "packSize", "", "performQueryForList", "", "R", "performQuerySafe", "introspectionScopeRemark", "(Lorg/jetbrains/dekaf/sql/SqlQuery;Ljava/lang/String;)Ljava/lang/Object;", "performQuerySafeList", "process", "reportRetrieving", "what", "setQueryParameter", "name", "value", "intellij.database.dialects.base"})
    protected abstract class AbstractRetriever
    implements Evaluator {
        @NotNull
        private final BasicModModel model;
        @NotNull
        private final Map<String, Object> queryParameters;
        @NotNull
        private CommonPreprocessor preprocessor;
        @NotNull
        private final DBTransaction transaction;

        @NotNull
        protected final BasicModModel getModel() {
            return this.model;
        }

        @NotNull
        protected final Map<String, Object> getQueryParameters() {
            return this.queryParameters;
        }

        @NotNull
        protected final CommonPreprocessor getPreprocessor() {
            return this.preprocessor;
        }

        protected final void setPreprocessor(@NotNull CommonPreprocessor commonPreprocessor) {
            Intrinsics.checkParameterIsNotNull((Object)commonPreprocessor, (String)"<set-?>");
            this.preprocessor = commonPreprocessor;
        }

        public abstract void process();

        public final void setQueryParameter(@NotNull String name2, @Nullable Object value) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            if (value != null) {
                this.queryParameters.put(name2, value);
            } else {
                this.queryParameters.remove(name2);
            }
        }

        @Override
        @Nullable
        public Object evaluate(@NotNull String expression) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            return this.queryParameters.get(expression);
        }

        protected final <X> X performQuery(@NotNull SqlQuery<X> query) {
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            SqlQuery sqlQuery = query.rewrite((StringOperator)this.preprocessor);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlQuery, (String)"query.rewrite(preprocessor)");
            SqlQuery preprocessedQuery = sqlQuery;
            return (X)BaseIntrospector.this.performTheQuery(this.transaction, preprocessedQuery, this.preprocessor.getBindableParameters());
        }

        @NotNull
        protected <R> List<R> performQueryForList(@NotNull SqlQuery<? extends Iterable<? extends R>> query, int packSize) {
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            SqlQuery sqlQuery = query.rewrite((StringOperator)this.preprocessor);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlQuery, (String)"query.rewrite(preprocessor)");
            SqlQuery preprocessedQuery = sqlQuery;
            return BaseIntroQueries.performTheQueryForList$default(BaseIntrospector.this, this.transaction, preprocessedQuery, this.preprocessor.getBindableParameters(), packSize, null, 8, null);
        }

        public static /* synthetic */ List performQueryForList$default(AbstractRetriever abstractRetriever, SqlQuery sqlQuery, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryForList");
            }
            if ((n2 & 2) != 0) {
                n = 4096;
            }
            return abstractRetriever.performQueryForList(sqlQuery, n);
        }

        @Nullable
        protected final <X> X performQuerySafe(@NotNull SqlQuery<X> query, @NotNull String introspectionScopeRemark) {
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            Intrinsics.checkParameterIsNotNull((Object)introspectionScopeRemark, (String)"introspectionScopeRemark");
            try {
                return this.performQuery(query);
            }
            catch (DBException e) {
                BaseIntrospector.this.getLog().error("Error occurred when introspected " + introspectionScopeRemark + ", query " + query.getDisplayName() + ":\n" + e.getMessage() + "\nSQL statement:\n" + e.statementText);
                return null;
            }
        }

        @NotNull
        protected final <R> List<R> performQuerySafeList(@NotNull SqlQuery<? extends Iterable<? extends R>> query, @NotNull String introspectionScopeRemark) {
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            Intrinsics.checkParameterIsNotNull((Object)introspectionScopeRemark, (String)"introspectionScopeRemark");
            try {
                return AbstractRetriever.performQueryForList$default(this, query, 0, 2, null);
            }
            catch (DBException e) {
                BaseIntrospector.this.getLog().error("Error occurred when introspected " + introspectionScopeRemark + ", query " + query.getDisplayName() + ":\n" + e.getMessage() + "\nSQL statement:\n" + e.statementText);
                return CollectionsKt.emptyList();
            }
        }

        protected final <X> void performQueryByPack(@NotNull SqlQuery<? extends Iterable<? extends X>> _query, @NotNull Function1<? super X, Unit> action2) {
            Intrinsics.checkParameterIsNotNull(_query, (String)"_query");
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            this.performQueryByPack(_query, 1000, action2);
        }

        protected final <X> void performQueryByPack(@NotNull SqlQuery<? extends Iterable<? extends X>> _query, int packSize, @NotNull Function1<? super X, Unit> action2) {
            Intrinsics.checkParameterIsNotNull(_query, (String)"_query");
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            SqlQuery sqlQuery = _query.rewrite((StringOperator)this.preprocessor);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlQuery, (String)"_query.rewrite(preprocessor)");
            BaseIntrospector.this.performTheQueryByPackIterateRow(this.transaction, sqlQuery, this.preprocessor.getBindableParameters(), packSize, action2);
        }

        protected void reportRetrieving(@NotNull String what) {
            Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
            BaseIntrospector.this.updateStatus("Introspecting database", what);
        }

        @NotNull
        protected final DBTransaction getTransaction() {
            return this.transaction;
        }

        public AbstractRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            this.transaction = transaction;
            this.model = BaseIntrospector.this.getModel();
            this.queryParameters = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
            this.preprocessor = new CommonPreprocessor(true, this);
            this.queryParameters.putAll(BaseIntrospector.this.queryParameters);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u00180\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\u001c\u0010\u0012\u001a\u00020\r2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\r0\u0014H\u0004J8\u0010\u0015\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019H\u0016J0\u0010\u0015\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019H\u0014J8\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019H\u0014J\b\u0010\u001f\u001a\u00020\rH\u0016J\b\u0010 \u001a\u00020\rH\u0016R\u0016\u0010\u0007\u001a\u00028\u0003X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractDatabaseRetriever;", "D", "Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "(Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicModDatabase;)V", "getDatabase", "()Lcom/intellij/database/model/basic/BasicModDatabase;", "Lcom/intellij/database/model/basic/BasicModDatabase;", "checkFingerprint", "", "expandElementsBeforeRetrievingNativeDefinitions", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "inDatabase", "modifier", "Lkotlin/Function1;", "retrieveNativeDefinitions", "withNestedElements", "", "result", "", "", "", "retrieveNativeDefinitionsFor", "kind", "Lcom/intellij/database/model/ObjectKind;", "retrieveObjects", "retrieveSchemas", "intellij.database.dialects.base"})
    protected static abstract class AbstractDatabaseRetriever<D extends BasicModDatabase>
    extends AbstractRetriever {
        @NotNull
        private final D database;
        final /* synthetic */ BaseIntrospector this$0;

        public void checkFingerprint() {
        }

        public void retrieveSchemas() {
        }

        public void retrieveObjects() {
        }

        protected final void inDatabase(@NotNull Function1<? super D, Unit> modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, (String)"modifier");
            this.getModel().modify((BasicElement)this.database, BasicModDatabase.class, (ModelModifier)new ModelModifier<BasicModDatabase>(modifier){
                final /* synthetic */ Function1 $modifier;

                public final void perform(BasicModDatabase it2) {
                    BasicModDatabase basicModDatabase = it2;
                    if (basicModDatabase == null) {
                        throw new TypeCastException("null cannot be cast to non-null type D");
                    }
                    this.$modifier.invoke((Object)basicModDatabase);
                }
                {
                    this.$modifier = function1;
                }
            });
        }

        public void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            Iterable<? extends BasicElement> elementsToProcess = withNestedElements ? this.expandElementsBeforeRetrievingNativeDefinitions(elements) : elements;
            this.retrieveNativeDefinitions(elementsToProcess, result2);
        }

        @NotNull
        protected Iterable<BasicElement> expandElementsBeforeRetrievingNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return CollectionsKt.toList(elements);
        }

        protected void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Map groups;
            Map $this$groupByTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            Iterable<? extends BasicElement> $this$groupBy$iv = elements;
            boolean $i$f$groupBy = false;
            Iterable<? extends BasicElement> iterable = $this$groupBy$iv;
            Map destination$iv$iv22 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object element$iv$iv = iterator.next();
                BasicElement it2 = (BasicElement)element$iv$iv;
                boolean bl = false;
                ObjectKind key$iv$iv = it2.getKind();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv22;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupByTo$iv$iv = groups = destination$iv$iv22;
            boolean destination$iv$iv22 = false;
            Iterator iterator2 = $this$groupByTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator2.next();
                boolean bl = false;
                ObjectKind kind = (ObjectKind)entry2.getKey();
                entry2 = entry;
                bl = false;
                List kindElements = (List)entry2.getValue();
                ObjectKind objectKind = kind;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"kind");
                this.retrieveNativeDefinitionsFor(objectKind, kindElements, result2);
            }
        }

        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        }

        @NotNull
        protected final D getDatabase() {
            return this.database;
        }

        protected AbstractDatabaseRetriever(@NotNull DBTransaction transaction, D database) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(database, (String)"database");
            this.this$0 = $outer;
            super(transaction);
            this.database = database;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u00180\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bB!\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u00100\u001a\u000201H\u0014J\b\u00102\u001a\u000201H\u0014J\b\u00103\u001a\u000201H\u0014J\b\u00104\u001a\u000201H\u0014J\b\u00105\u001a\u000206H\u0014J\u001c\u00107\u001a\u0002012\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020109H\u0004J\u001d\u0010:\u001a\u00020+2\u0006\u0010;\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010<J'\u0010=\u001a\u0004\u0018\u0001H>\"\b\b\u0004\u0010>*\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H>0AH\u0004\u00a2\u0006\u0002\u0010BJ*\u0010C\u001a\b\u0012\u0004\u0012\u0002HE0D\"\u0004\b\u0004\u0010E2\u0014\u0010@\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002HE0F0AH\u0004J\b\u0010G\u001a\u000201H\u0014J\b\u0010H\u001a\u000201H\u0016J\u0006\u0010I\u001a\u000201J\u0006\u0010J\u001a\u000201J\b\u0010K\u001a\u000201H\u0014J\b\u0010L\u001a\u000201H\u0014J\u0015\u0010M\u001a\u00020+2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010NJ\u0010\u0010O\u001a\u0002012\u0006\u0010P\u001a\u00020QH\u0015J\u0010\u0010O\u001a\u0002012\u0006\u0010R\u001a\u00020SH\u0005R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0013\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010)\u001a\u0004\b'\u0010(R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006T"}, d2={"Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "S", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)V", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "(Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;Lcom/intellij/database/introspection/IntrospectionMode;)V", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "getFragmentKind", "()Lcom/intellij/database/model/ObjectKind;", "setFragmentKind", "(Lcom/intellij/database/model/ObjectKind;)V", "fragmentNames", "", "", "getFragmentNames", "()[Ljava/lang/String;", "setFragmentNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "fromTimestamp", "Ljava/sql/Timestamp;", "getFromTimestamp", "()Ljava/sql/Timestamp;", "setFromTimestamp", "(Ljava/sql/Timestamp;)V", "introspectionBeginTimestamp", "getIntrospectionBeginTimestamp", "setIntrospectionBeginTimestamp", "getMode", "()Lcom/intellij/database/introspection/IntrospectionMode;", "setMode", "(Lcom/intellij/database/introspection/IntrospectionMode;)V", "getSchema", "()Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/model/basic/BasicModSchema;", "withSources", "", "getWithSources", "()Z", "setWithSources", "(Z)V", "analyzeBriefInfo", "", "analyzeCurrentContent", "clearSchema", "finishSchema", "getSchemaStateNumber", "", "inSchema", "modifier", "Lkotlin/Function1;", "isPossibleToIntrospectSchemaIncrementally", "tran", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicModSchema;)Z", "performQuerySafe", "X", "", "query", "Lorg/jetbrains/dekaf/sql/SqlQuery;", "(Lorg/jetbrains/dekaf/sql/SqlQuery;)Ljava/lang/Object;", "performQuerySafeList", "", "R", "", "prepareParameters", "process", "processMainPhase", "processPreliminaryPhase", "retrieveMainContent", "retrieveMajorNames", "whetherSourcesActual", "(Lcom/intellij/database/model/basic/BasicModSchema;)Z", "work", "runnable", "Ljava/lang/Runnable;", "block", "Lorg/jetbrains/dekaf/core/InTransactionNoResult;", "intellij.database.dialects.base"})
    protected abstract class AbstractSchemaRetriever<S extends BasicModSchema>
    extends AbstractRetriever {
        @NotNull
        private final S schema;
        @NotNull
        private IntrospectionMode mode;
        private boolean withSources;
        @NotNull
        private ObjectKind fragmentKind;
        @NotNull
        private String[] fragmentNames;
        @NotNull
        private Timestamp fromTimestamp;
        @Nullable
        private Timestamp introspectionBeginTimestamp;
        final /* synthetic */ BaseIntrospector this$0;

        @NotNull
        public final S getSchema() {
            return this.schema;
        }

        @NotNull
        public final IntrospectionMode getMode() {
            return this.mode;
        }

        public final void setMode(@NotNull IntrospectionMode introspectionMode) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)introspectionMode), (String)"<set-?>");
            this.mode = introspectionMode;
        }

        public final boolean getWithSources() {
            return this.withSources;
        }

        public final void setWithSources(boolean bl) {
            this.withSources = bl;
        }

        @NotNull
        public final ObjectKind getFragmentKind() {
            return this.fragmentKind;
        }

        public final void setFragmentKind(@NotNull ObjectKind objectKind) {
            Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"<set-?>");
            this.fragmentKind = objectKind;
        }

        @NotNull
        public final String[] getFragmentNames() {
            return this.fragmentNames;
        }

        public final void setFragmentNames(@NotNull String[] stringArray) {
            Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"<set-?>");
            this.fragmentNames = stringArray;
        }

        @NotNull
        public final Timestamp getFromTimestamp() {
            return this.fromTimestamp;
        }

        public final void setFromTimestamp(@NotNull Timestamp timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"<set-?>");
            this.fromTimestamp = timestamp;
        }

        @Nullable
        public final Timestamp getIntrospectionBeginTimestamp() {
            return this.introspectionBeginTimestamp;
        }

        public final void setIntrospectionBeginTimestamp(@Nullable Timestamp timestamp) {
            this.introspectionBeginTimestamp = timestamp;
        }

        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            return schema.getIntrospectionTimestamp() != null && (this.this$0.getOptions().getSources() == DBIntrospectionOptions.SourceLoading.NO_SOURCES || this.whetherSourcesActual(schema));
        }

        protected boolean whetherSourcesActual(@NotNull S schema) {
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            Date date = schema.getIntrospectionTimestamp();
            return Intrinsics.areEqual((Object)this.getModel().getSchemaSourcesVersion((BasicSchema)schema), (Object)(date != null ? Long.valueOf(date.getTime()) : null));
        }

        protected void prepareParameters() {
            this.getQueryParameters().putAll(this.this$0.queryParameters);
            this.setQueryParameter("SCHEMA_NAME", this.schema.getRealName());
            this.setQueryParameter("SCHEMA_ID", this.schema instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)this.schema).getObjectId() != Long.MIN_VALUE ? Long.valueOf(((BasicIdentifiedElement)this.schema).getObjectId()) : null);
            String string = this.mode.code;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mode.code");
            this.setQueryParameter(string, Boolean.TRUE);
            this.setQueryParameter("SINCE", this.fromTimestamp);
        }

        protected final void inSchema(@NotNull Function1<? super S, Unit> modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, (String)"modifier");
            this.getModel().modify((BasicElement)this.schema, this.schema.getMetaObject().apiClass, (ModelModifier)new ModelModifier<BasicElement>(modifier){
                final /* synthetic */ Function1 $modifier;

                public final void perform(BasicElement schema) {
                    BasicElement basicElement = schema;
                    if (basicElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type S");
                    }
                    this.$modifier.invoke((Object)((BasicModSchema)basicElement));
                }
                {
                    this.$modifier = function1;
                }
            });
        }

        @Nullable
        protected final <X> X performQuerySafe(@NotNull SqlQuery<X> query) {
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            return this.performQuerySafe(query, "schema " + this.schema.getRealName());
        }

        @NotNull
        protected final <R> List<R> performQuerySafeList(@NotNull SqlQuery<? extends Iterable<? extends R>> query) {
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            return this.performQuerySafeList(query, "schema " + this.schema.getRealName());
        }

        @Override
        public void process() {
            this.prepareParameters();
            this.processPreliminaryPhase();
            this.processMainPhase();
        }

        public final void processPreliminaryPhase() {
            if (this.mode.fragment) {
                return;
            }
            this.analyzeBriefInfo();
            if (this.mode.increment) {
                this.analyzeCurrentContent();
            } else {
                this.clearSchema();
                this.retrieveMajorNames();
            }
        }

        public final void processMainPhase() {
            this.retrieveMainContent();
            this.finishSchema();
        }

        @Deprecated(message="use inModel,inSchema instead", replaceWith=@ReplaceWith(imports={}, expression="inSchema"))
        protected void work(@NotNull Runnable runnable) {
            Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
            this.getModel().modify(BasicModRoot.class, (ModelModifier)new ModelModifier<BasicModRoot>(runnable){
                final /* synthetic */ Runnable $runnable;

                public final void perform(BasicModRoot it2) {
                    this.$runnable.run();
                }
                {
                    this.$runnable = runnable;
                }
            });
        }

        @Deprecated(message="use inModel,inSchema instead", replaceWith=@ReplaceWith(imports={}, expression="inSchema"))
        protected final void work(@NotNull InTransactionNoResult block) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            this.getModel().modify(BasicModRoot.class, (ModelModifier)new ModelModifier<BasicModRoot>(this, block){
                final /* synthetic */ AbstractSchemaRetriever this$0;
                final /* synthetic */ InTransactionNoResult $block;

                public final void perform(BasicModRoot it2) {
                    this.$block.run(this.this$0.getTransaction());
                }
                {
                    this.this$0 = abstractSchemaRetriever;
                    this.$block = inTransactionNoResult;
                }
            });
        }

        protected void analyzeBriefInfo() {
        }

        protected void analyzeCurrentContent() {
        }

        protected void retrieveMajorNames() {
        }

        protected void retrieveMainContent() {
        }

        protected void finishSchema() {
            if (this.withSources && this.mode != IntrospectionMode.FRAGMENT) {
                this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, this.getSchemaStateNumber());
            }
        }

        protected long getSchemaStateNumber() {
            Timestamp timestamp = this.introspectionBeginTimestamp;
            return timestamp != null ? timestamp.getTime() : 0L;
        }

        protected void clearSchema() {
            this.getModel().modify((BasicElement)this.schema, BasicModSchema.class, clearSchema.1.INSTANCE);
            this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, null);
        }

        protected AbstractSchemaRetriever(@NotNull DBTransaction transaction, S schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            this($outer, transaction, (BasicModSchema)schema, null);
        }

        protected AbstractSchemaRetriever(@NotNull DBTransaction transaction, @Nullable S schema, IntrospectionMode mode) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            super(transaction);
            this.this$0 = $outer;
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                Intrinsics.throwNpe();
            }
            this.fragmentKind = objectKind;
            AbstractSchemaRetriever abstractSchemaRetriever = this;
            String[] stringArray = new String[]{};
            abstractSchemaRetriever.fragmentNames = stringArray;
            this.fromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.schema = schema;
            IntrospectionMode introspectionMode = mode;
            if (introspectionMode == null) {
                introspectionMode = schema.hasChildren() && this.isPossibleToIntrospectSchemaIncrementally(transaction, schema) ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
            }
            this.mode = introspectionMode;
            this.withSources = $outer.getOptions().getSources().compareTo((Enum)DBIntrospectionOptions.SourceLoading.USER_SOURCES) >= 0;
            Date lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
            this.fromTimestamp = this.mode.increment && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : BaseIntrospectionFunctions.AGES_AGO;
        }
    }
}

