/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDatabaseDialect
extends DatabaseDialectEx {
    private final TypeHelper myTypeHelper;
    private final Casing myCasing;
    private volatile NamingService myNamingService;

    protected AbstractDatabaseDialect(TypeHelper typeHelper, Casing casing) {
        this.myTypeHelper = typeHelper;
        this.myCasing = casing;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(0);
        }
        Casing casing = this.myCasing;
        if (casing == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(1);
        }
        return casing;
    }

    @NotNull
    private NamingService getNamingService() {
        if (this.myNamingService == null) {
            this.myNamingService = NamingServices.INSTANCE.getNamingService(this.getDbms(), null, null);
        }
        NamingService namingService = this.myNamingService;
        if (namingService == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(2);
        }
        return namingService;
    }

    @Override
    public final boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(3);
        }
        return this.getNamingService().isPlain(identifier, true);
    }

    public String quoteIdentifier(String identifier, boolean force, boolean suppress) {
        return this.quoteIdentifier(identifier, force, suppress, this.myCasing);
    }

    public String unquoteIdentifier(String identifier) {
        if (!this.isQuotedIdentifier(identifier)) {
            return identifier;
        }
        return AbstractDatabaseDialect.unescapeCharSql(identifier.substring(1, identifier.length() - 1), identifier.charAt(identifier.length() - 1));
    }

    public boolean isQuotedIdentifier(@Nullable String identifier) {
        if (StringUtil.isEmpty((String)identifier) || identifier.length() < 2) {
            return false;
        }
        return StringUtil.startsWithChar((CharSequence)identifier, (char)this.openQuote()) && StringUtil.endsWithChar((CharSequence)identifier, (char)this.closeQuote()) || this.openQuote() != '\"' && StringUtil.startsWithChar((CharSequence)identifier, (char)'\"') && StringUtil.endsWithChar((CharSequence)identifier, (char)'\"');
    }

    public boolean canUnquoteAlias(@NotNull String alias, boolean afterAS) {
        if (alias == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(4);
        }
        return StringUtil.equals((CharSequence)this.quoteIdentifier(alias, false, false), (CharSequence)alias);
    }

    @Override
    public String quoteIdentifier(String identifier, boolean force, boolean suppress, @NotNull Casing casing) {
        if (casing == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(5);
        }
        if (this.isQuotedIdentifier(identifier)) {
            return identifier;
        }
        if (StringUtil.isEmpty((String)identifier)) {
            return force ? this.openQuote() + identifier + this.closeQuote() : identifier;
        }
        force |= !this.isValidPlainIdentifier(identifier);
        if (!(force |= this.isReservedKeyword(identifier)) && !suppress && casing.quoted == Case.EXACT && casing.plain != Case.EXACT && casing.plain != Case.MIXED) {
            Case identifierCase = Case.forString((String)identifier);
            force = identifierCase == Case.MIXED || identifierCase != casing.plain;
        }
        return force ? this.openQuote() + AbstractDatabaseDialect.escapeCharSql(identifier, this.closeQuote()) + this.closeQuote() : identifier;
    }

    private boolean isReservedKeyword(String name2) {
        return DbSqlUtil.getSqlDialect(this.getDbms()).getReservedKeywords().contains(name2);
    }

    @NotNull
    private static String escapeCharSql(@NotNull String s, char c2) {
        if (s == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(6);
        }
        if (s.indexOf(c2) == -1) {
            String string = s;
            if (string == null) {
                AbstractDatabaseDialect.$$$reportNull$$$0(7);
            }
            return string;
        }
        String cs = String.valueOf(c2);
        String string = StringUtil.replace((String)s, (String)cs, (String)(cs + cs));
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String unescapeCharSql(@NotNull String s, char c2) {
        if (s == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(9);
        }
        if (s.indexOf(c2) == -1) {
            String string = s;
            if (string == null) {
                AbstractDatabaseDialect.$$$reportNull$$$0(10);
            }
            return string;
        }
        String cs = String.valueOf(c2);
        String string = StringUtil.replace((String)s, (String)(cs + cs), (String)cs);
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(12);
        }
        if (view2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(13);
        }
        if (definition == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(14);
        }
        return DialectUtils.getCreateViewSQL(builder, view2, definition);
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view2, boolean cascade) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(15);
        }
        if (view2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(16);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view2, null);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    public boolean supportsSystemViewDefinition() {
        return this.supportsViewDefinition();
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(18);
        }
        if (procedure == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(19);
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure(builder, procedure, false);
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(20);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlInsertInto(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull List<String> columns, @NotNull List<Consumer<DdlBuilder>> values2) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(21);
        }
        if (table == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(22);
        }
        if (columns == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(23);
        }
        if (values2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(24);
        }
        builder.keyword("INSERT").space().keyword("INTO").space().qualifiedRef((DasObject)table);
        if (!columns.isEmpty()) {
            builder.space().symbol("(");
            DialectUtils.appendStringList(builder, columns);
            builder.symbol(")");
        }
        if (values2.isEmpty() && this.supportsInsertDefaultValues()) {
            builder.space().keyword("DEFAULT").space().keyword("VALUES");
        } else {
            builder.space().keyword("VALUES").space().symbol("(");
            DialectUtils.appendCommaSeparated(builder, values2);
            builder.symbol(")");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(25);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return false;
    }

    @Override
    public boolean supportsInsertDefaultIntoAutoVal() {
        return false;
    }

    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        String typeName;
        if (dataType == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(26);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                AbstractDatabaseDialect.$$$reportNull$$$0(27);
            }
            return string;
        }
        int jdbcType = dataType.jdbcType;
        int length = dataType.getLength();
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if (jdbcType == 1111) {
            jdbcType = this.getJavaTypeForNativeType(dataType.getSpecification());
        }
        String string = (typeName = this.myTypeHelper.getTypeName(jdbcType, length, precision, scale)) != null ? typeName : JdbcUtil.getJdbcTypeName((DataType)dataType);
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public TypeHelper getTypeHelper() {
        TypeHelper typeHelper = this.myTypeHelper;
        if (typeHelper == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(29);
        }
        return typeHelper;
    }

    @NotNull
    public String getTypeWithSubstitution(@NotNull String name2, int length, int precision, int scale) {
        if (name2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(30);
        }
        String string = this.myTypeHelper.getTypeWithSubstitution(name2, length, precision, scale);
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(31);
        }
        return string;
    }

    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(32);
        }
        return this.myTypeHelper.findJdbcType(nativeColumnTypeName);
    }

    public boolean supportsTableDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(33);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.table.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection2) throws Exception {
        if (table == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(34);
        }
        if (connection2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(35);
        }
        if ("" == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(36);
        }
        return "";
    }

    public boolean supportsTableInfo() {
        return false;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element2, @NotNull DatabaseConnection connection2) throws Exception {
        if (element2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(37);
        }
        if (connection2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(38);
        }
        Map<String, Object> map2 = Collections.emptyMap();
        if (map2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(39);
        }
        return map2;
    }

    @Override
    public boolean supportsSearchPath() {
        return false;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return ObjectKind.SCHEMA;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        if (system == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(40);
        }
        if (connection2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(41);
        }
        return null;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(42);
        }
        return null;
    }

    public boolean supportsInsertInto() {
        return true;
    }

    public final char closeQuote() {
        return this.getNamingService().closeQuote();
    }

    public final char openQuote() {
        return this.getNamingService().openQuote();
    }

    @NotNull
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(43);
        }
        String string = kind == ObjectKind.ROOT ? "DATA SOURCE" : kind.name();
        if (string == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(44);
        }
        return string;
    }

    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(45);
        }
        return "'" + DialectUtils.toHexString(binaryData) + "'";
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnection connection2) throws Exception {
        if (proc == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(46);
        }
        if (connection2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(47);
        }
        if ("" == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(48);
        }
        return "";
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(49);
        }
        throw new UnsupportedOperationException("Package body definition is not supported");
    }

    public boolean supportsPackageDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(50);
        }
        throw new UnsupportedOperationException("Package definition is not supported");
    }

    public boolean supportsSequenceDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(51);
        }
        throw new UnsupportedOperationException("Sequence definition is not supported");
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSynonymDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(52);
        }
        throw new UnsupportedOperationException("Synonym definition is not supported");
    }

    @Override
    @NotNull
    public String tryToLoadSynonymDefinition(DasTable tableElement, DatabaseConnection connection2) throws Exception {
        if ("" == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(53);
        }
        return "";
    }

    public boolean supportsSynonymDefinition() {
        return false;
    }

    public boolean supportsQualifiedAsteriskInCalls() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine, boolean longMode, boolean withReturn) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(54);
        }
        if (routine == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(55);
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)routine).filter(a -> a.getArgumentDirection() != ArgumentDirection.SELF);
        DasArgument returnArg = routine.getReturnArgument();
        builder.symbol("(");
        boolean first2 = true;
        for (DasArgument parameter : parameters) {
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            this.sqlParameter(builder, parameter, longMode);
        }
        builder.symbol(")");
        if (returnArg != null && withReturn) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type((DasTypedObject)returnArg);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(56);
        }
        return ddlBuilder;
    }

    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(57);
        }
        DialectUtils.sqlParameter(builder, parameter, longMode, 0, false);
    }

    public boolean supportsAutoIncrement() {
        return false;
    }

    public boolean supportsAlterAutoIncrement() {
        return this.supportsAutoIncrement();
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return false;
    }

    public boolean supportsNotNullColumns() {
        return true;
    }

    public boolean supportsDefaults() {
        return true;
    }

    public boolean supportsUniqueIndices() {
        return true;
    }

    public boolean supportsIndexColumnOrdering() {
        return true;
    }

    public boolean supportsOffset() {
        return false;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection2) throws Exception {
        if (connection2 == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(58);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(59);
        }
        return list;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        return false;
    }

    @Override
    @Nullable
    public String sqlResetSearchPath() {
        return null;
    }

    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            AbstractDatabaseDialect.$$$reportNull$$$0(60);
        }
        return dialect == this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 39: 
            case 44: 
            case 48: 
            case 53: 
            case 56: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 39: 
            case 44: 
            case 48: 
            case 53: 
            case 56: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 39: 
            case 44: 
            case 48: 
            case 53: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/AbstractDatabaseDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 21: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 33: 
            case 37: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: 
            case 38: 
            case 41: 
            case 47: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/AbstractDatabaseDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamingService";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharSql";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeCharSql";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlInsertInto";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHelper";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithSubstitution";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForKind";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadSynonymDefinition";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrototype";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 39: 
            case 44: 
            case 48: 
            case 53: 
            case 56: 
            case 59: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canUnquoteAlias";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharSql";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unescapeCharSql";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sqlInsertInto";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithSubstitution";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "sqlSynonymDefinition";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrototype";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 20: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 39: 
            case 44: 
            case 48: 
            case 53: 
            case 56: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

