/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ExecutionResult;
import com.intellij.database.dataSource.connection.statements.JdbcBasedSmartStatement;
import com.intellij.database.dataSource.connection.statements.NoisyStatement;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.dataSource.connection.statements.UniversalResultsProducer;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 M*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005:\u0005LMNOPB\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ+\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u00012\u0006\u0010*\u001a\u00020'H$\u00a2\u0006\u0002\u0010+J#\u0010,\u001a\b\u0012\u0004\u0012\u00020-0&2\u0006\u0010(\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020-H\u0016J\u0015\u00100\u001a\u00020-2\u0006\u00101\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u00102J\u001d\u00103\u001a\u00020-2\u0006\u0010(\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u00104J\u001d\u00105\u001a\u00028\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010(\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00106J#\u00107\u001a\b\u0012\u0004\u0012\u0002080&2\u0006\u0010(\u001a\u00028\u00002\u0006\u00109\u001a\u00020:H\u0016\u00a2\u0006\u0002\u0010;J=\u00107\u001a\b\u0012\u0004\u0012\u0002H<0&\"\u0004\b\u0002\u0010<2\u0006\u0010(\u001a\u00028\u00002\u0006\u00109\u001a\u00020:2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u0002H<0>H\u0016\u00a2\u0006\u0002\u0010@J#\u0010A\u001a\b\u0012\u0004\u0012\u0002080&2\u0006\u0010(\u001a\u00028\u00002\u0006\u00109\u001a\u00020:H\u0002\u00a2\u0006\u0002\u0010;J%\u0010B\u001a\u00020'2\u0006\u0010(\u001a\u00028\u00002\u0006\u00109\u001a\u00020:2\u0006\u0010)\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010CJ!\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010E0&2\u0006\u0010(\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010FJ1\u0010G\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00028\u00002\u0006\u00109\u001a\u00020:2\f\u0010H\u001a\b\u0012\u0004\u0012\u00028\u00010EH\u0002\u00a2\u0006\u0002\u0010IJ\u0016\u0010J\u001a\u00020-2\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00010EH\u0002J\u001b\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00010&2\u0006\u0010(\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010FR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\"X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006Q"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement;", "INPUT", "STATEMENT", "Ljava/sql/Statement;", "Lcom/intellij/database/dataSource/connection/statements/SmartStatement;", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "getAuditService", "()Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "getConfiguration", "()Lcom/intellij/database/dataSource/connection/statements/Configuration;", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnection;", "currentStatement", "Ljava/sql/Statement;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "getDepartment", "()Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "running", "", "getRunning", "()Z", "source", "Lcom/intellij/database/dataSource/connection/statements/SmartStatements$Source;", "getSource", "()Lcom/intellij/database/dataSource/connection/statements/SmartStatements$Source;", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder;", "after", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "input", "statement", "result", "(Ljava/lang/Object;Ljava/sql/Statement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)Lcom/intellij/database/dataSource/connection/Either;", "before", "", "(Ljava/lang/Object;Ljava/sql/Statement;)Lcom/intellij/database/dataSource/connection/Either;", "cancel", "closeStatement", "it", "(Ljava/sql/Statement;)V", "configure", "(Ljava/lang/Object;Ljava/sql/Statement;)V", "createStatement", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/Object;)Ljava/sql/Statement;", "execute", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "mode", "Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;)Lcom/intellij/database/dataSource/connection/Either;", "T", "callback", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer;", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Lkotlin/jvm/functions/Function1;)Lcom/intellij/database/dataSource/connection/Either;", "executeInCommonWay", "executeJdbcStatement", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Ljava/sql/Statement;)Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "getCurrentStatement", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;", "(Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/Either;", "memorizeAndExecute", "ref", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;)Lcom/intellij/database/dataSource/connection/Either;", "reportProcessed", "statementInstance", "Call", "Companion", "ExceptionTransformer", "Parameterized", "Simple", "intellij.database.impl"})
public abstract class JdbcBasedSmartStatement<INPUT, STATEMENT extends Statement>
implements SmartStatement<INPUT>,
SmartStatementMark {
    private STATEMENT currentStatement;
    @NotNull
    private final DatabaseConnection connection;
    @NotNull
    private final ListenerAuditService auditService;
    @NotNull
    private final Configuration configuration;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    protected abstract StatementHolder<STATEMENT> getStatementHolder();

    @Override
    @NotNull
    public SmartStatements.Source getSource() {
        return this.configuration.getSource();
    }

    @Override
    public boolean getRunning() {
        return this.currentStatement != null;
    }

    @Override
    @NotNull
    public DatabaseDepartment getDepartment() {
        return this.configuration.getDepartment();
    }

    @Override
    @NotNull
    public <T> Either<T> execute(INPUT input, @NotNull ExecutionMode mode, @NotNull Function1<? super ResultsProducer, ? extends T> callback) {
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        return this.executeInCommonWay(input, mode).transform((Function1)new Function1<ClosableResultsProducer, Either<T>>(this, callback){
            final /* synthetic */ JdbcBasedSmartStatement this$0;
            final /* synthetic */ Function1 $callback;

            @NotNull
            public final Either<T> invoke(@NotNull ClosableResultsProducer it2) {
                Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                return SmartStatementsUtil.runReporting(this.this$0.getConnection(), StagedException.Stage.RESULTS_PROCESSING, this.this$0, (Function0)new Function0<T>(this, it2){
                    final /* synthetic */ execute.1 this$0;
                    final /* synthetic */ ClosableResultsProducer $it;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final T invoke() {
                        Object object;
                        AutoCloseable autoCloseable = this.$it;
                        Function1 function1 = this.this$0.$callback;
                        boolean bl = false;
                        Throwable throwable = null;
                        try {
                            object = function1.invoke((Object)autoCloseable);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return (T)object;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$it = closableResultsProducer;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = jdbcBasedSmartStatement;
                this.$callback = function1;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public Either<ClosableResultsProducer> execute(INPUT input, @NotNull ExecutionMode mode) {
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        return this.executeInCommonWay(input, mode).shelter(execute.2.INSTANCE);
    }

    @Override
    public void cancel() {
        STATEMENT current = this.currentStatement;
        if (current != null) {
            SmartStatementsUtil.runReporting(this.connection, StagedException.Stage.CANCEL, this, (Function0)new Function0<Unit>(current){
                final /* synthetic */ Statement $current;

                public final void invoke() {
                    this.$current.cancel();
                }
                {
                    this.$current = statement;
                    super(0);
                }
            });
        }
    }

    protected void configure(INPUT input, @NotNull STATEMENT statement) throws SQLException {
        Intrinsics.checkParameterIsNotNull(statement, (String)"statement");
        JdbcHelper jdbcHelper = DbImplUtil.getJdbcHelper(this.connection.getDbms());
        Intrinsics.checkExpressionValueIsNotNull((Object)jdbcHelper, (String)"DbImplUtil.getJdbcHelper(connection.dbms)");
        JdbcHelper helper = jdbcHelper;
        if (this.configuration.getMaxRows() != null && helper.supportsLimitMaxRows()) {
            statement.setMaxRows(this.configuration.getMaxRows());
        }
        if (this.configuration.getFetchSize() != null) {
            statement.setFetchSize(this.configuration.getFetchSize());
        }
    }

    private final Either<ClosableResultsProducer> executeInCommonWay(INPUT input, ExecutionMode mode) {
        Either<StatementHolder.CloseableRef<STATEMENT>> statementEither = this.getCurrentStatement(input);
        StatementHolder.CloseableRef<STATEMENT> statement = statementEither.getRight();
        return statementEither.transform((Function1)new Function1<StatementHolder.CloseableRef<STATEMENT>, Either<ExecutionResult>>(this, input, mode){
            final /* synthetic */ JdbcBasedSmartStatement this$0;
            final /* synthetic */ Object $input;
            final /* synthetic */ ExecutionMode $mode;

            @NotNull
            public final Either<ExecutionResult> invoke(@NotNull StatementHolder.CloseableRef<STATEMENT> it2) {
                Intrinsics.checkParameterIsNotNull(it2, (String)"it");
                return JdbcBasedSmartStatement.access$memorizeAndExecute(this.this$0, this.$input, this.$mode, it2);
            }
            {
                this.this$0 = jdbcBasedSmartStatement;
                this.$input = object;
                this.$mode = executionMode;
                super(1);
            }
        }).shelter((Function1)new Function1<ExecutionResult, UniversalResultsProducer<STATEMENT>>(this, statement){
            final /* synthetic */ JdbcBasedSmartStatement this$0;
            final /* synthetic */ StatementHolder.CloseableRef $statement;

            @NotNull
            public final UniversalResultsProducer<STATEMENT> invoke(@NotNull ExecutionResult it2) {
                Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                StatementHolder.CloseableRef closeableRef = this.$statement;
                if (closeableRef == null) {
                    Intrinsics.throwNpe();
                }
                return new UniversalResultsProducer<T>(closeableRef, this.this$0, this.this$0.getConfiguration(), this.this$0.getConnection(), it2);
            }
            {
                this.this$0 = jdbcBasedSmartStatement;
                this.$statement = closeableRef;
                super(1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Either<ExecutionResult> memorizeAndExecute(INPUT input, ExecutionMode mode, StatementHolder.CloseableRef<STATEMENT> ref) {
        Either either;
        Statement statement = (Statement)ref.getValue();
        boolean error2 = false;
        try {
            this.currentStatement = statement;
            either = this.before(input, statement).transform((Function1)new Function1<Unit, Either<ExecutionResult>>(this, input, mode, statement){
                final /* synthetic */ JdbcBasedSmartStatement this$0;
                final /* synthetic */ Object $input;
                final /* synthetic */ ExecutionMode $mode;
                final /* synthetic */ Statement $statement;

                @NotNull
                public final Either<ExecutionResult> invoke(@NotNull Unit it2) {
                    Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                    return SmartStatementsUtil.runReporting(this.this$0.getConnection(), StagedException.Stage.EXECUTE, this.this$0, (Function0)new Function0<ExecutionResult>(this){
                        final /* synthetic */ memorizeAndExecute.1 this$0;

                        @NotNull
                        public final ExecutionResult invoke() {
                            return this.this$0.this$0.executeJdbcStatement(this.this$0.$input, this.this$0.$mode, this.this$0.$statement);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                {
                    this.this$0 = jdbcBasedSmartStatement;
                    this.$input = object;
                    this.$mode = executionMode;
                    this.$statement = statement;
                    super(1);
                }
            }).transform((Function1)new Function1<ExecutionResult, Either<ExecutionResult>>(this, input, statement){
                final /* synthetic */ JdbcBasedSmartStatement this$0;
                final /* synthetic */ Object $input;
                final /* synthetic */ Statement $statement;

                @NotNull
                public final Either<ExecutionResult> invoke(@NotNull ExecutionResult it2) {
                    Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                    return this.this$0.after(this.$input, this.$statement, it2);
                }
                {
                    this.this$0 = jdbcBasedSmartStatement;
                    this.$input = object;
                    this.$statement = statement;
                    super(1);
                }
            });
        }
        catch (Throwable t) {
            try {
                error2 = true;
                throw t;
            }
            catch (Throwable throwable) {
                this.auditService.afterStatement(this);
                this.currentStatement = null;
                if (error2) {
                    this.reportProcessed(ref);
                }
                throw throwable;
            }
        }
        this.auditService.afterStatement(this);
        this.currentStatement = null;
        return either.ifLeft((Function0<Unit>)((Function0)new Function0<Unit>(this, ref){
            final /* synthetic */ JdbcBasedSmartStatement this$0;
            final /* synthetic */ StatementHolder.CloseableRef $ref;

            public final void invoke() {
                JdbcBasedSmartStatement.access$reportProcessed(this.this$0, this.$ref);
            }
            {
                this.this$0 = jdbcBasedSmartStatement;
                this.$ref = closeableRef;
                super(0);
            }
        }));
    }

    private final Either<STATEMENT> statementInstance(INPUT input) {
        return SmartStatementsUtil.runReporting(this.connection, StagedException.Stage.CREATE_STATEMENT, this, (Function0)new Function0<STATEMENT>(this, input){
            final /* synthetic */ JdbcBasedSmartStatement this$0;
            final /* synthetic */ Object $input;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final STATEMENT invoke() {
                void var1_1;
                STATEMENT statement = this.this$0.createStatement(this.this$0.getConnection(), this.$input);
                this.this$0.getConnection().getAuditService().statementOpened((Statement)statement, this.this$0);
                return var1_1;
            }
            {
                this.this$0 = jdbcBasedSmartStatement;
                this.$input = object;
                super(0);
            }
        }).transform((Function1)new Function1<STATEMENT, Either<STATEMENT>>(this, input){
            final /* synthetic */ JdbcBasedSmartStatement this$0;
            final /* synthetic */ Object $input;

            @NotNull
            public final Either<STATEMENT> invoke(@NotNull STATEMENT it2) {
                Either<T> either;
                Intrinsics.checkParameterIsNotNull(it2, (String)"it");
                try {
                    either = SmartStatementsUtil.runReporting(this.this$0.getConnection(), StagedException.Stage.CONFIGURE_STATEMENT, this.this$0, (Function0)new Function0<STATEMENT>(this, it2){
                        final /* synthetic */ statementInstance.2 this$0;
                        final /* synthetic */ Statement $it;

                        @NotNull
                        public final STATEMENT invoke() {
                            this.this$0.this$0.configure(this.this$0.$input, this.$it);
                            return (STATEMENT)this.$it;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$it = statement;
                            super(0);
                        }
                    }).ifLeft((Function0<Unit>)((Function0)new Function0<Unit>(this, it2){
                        final /* synthetic */ statementInstance.2 this$0;
                        final /* synthetic */ Statement $it;

                        public final void invoke() {
                            JdbcBasedSmartStatement.access$closeStatement(this.this$0.this$0, this.$it);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$it = statement;
                            super(0);
                        }
                    }));
                }
                catch (Throwable t) {
                    JdbcBasedSmartStatement.access$closeStatement(this.this$0, it2);
                    throw t;
                }
                return either;
            }
            {
                this.this$0 = jdbcBasedSmartStatement;
                this.$input = object;
                super(1);
            }
        });
    }

    @NotNull
    protected final Either<StatementHolder.CloseableRef<STATEMENT>> getCurrentStatement(INPUT input) {
        return (Either)this.getStatementHolder().invoke(new Function0<Either<STATEMENT>>(this, input){
            final /* synthetic */ JdbcBasedSmartStatement this$0;
            final /* synthetic */ Object $input;

            @NotNull
            public final Either<STATEMENT> invoke() {
                return JdbcBasedSmartStatement.access$statementInstance(this.this$0, this.$input);
            }
            {
                this.this$0 = jdbcBasedSmartStatement;
                this.$input = object;
                super(0);
            }
        });
    }

    @NotNull
    protected abstract Either<ExecutionResult> after(INPUT var1, @NotNull STATEMENT var2, @NotNull ExecutionResult var3);

    @NotNull
    protected abstract ExecutionResult executeJdbcStatement(INPUT var1, @NotNull ExecutionMode var2, @NotNull STATEMENT var3) throws SQLException;

    @NotNull
    protected abstract STATEMENT createStatement(@NotNull DatabaseConnection var1, INPUT var2) throws SQLException;

    @NotNull
    protected abstract Either<Unit> before(INPUT var1, @NotNull STATEMENT var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reportProcessed(StatementHolder.CloseableRef<STATEMENT> statement) {
        try {
            this.auditService.resultsProcessed(this);
        }
        finally {
            JdbcUtil.closeSafe((AutoCloseable)statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeStatement(STATEMENT it2) {
        try {
            this.connection.getAuditService().beforeStatementClosing((Statement)it2, this);
        }
        finally {
            JdbcUtil.closeSafe((AutoCloseable)((AutoCloseable)it2));
        }
    }

    @NotNull
    protected final DatabaseConnection getConnection() {
        return this.connection;
    }

    @NotNull
    protected final ListenerAuditService getAuditService() {
        return this.auditService;
    }

    @NotNull
    protected final Configuration getConfiguration() {
        return this.configuration;
    }

    public JdbcBasedSmartStatement(@NotNull DatabaseConnection connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)auditService, (String)"auditService");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.connection = connection2;
        this.auditService = auditService;
        this.configuration = configuration;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(JdbcBasedSmartStatement.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(JdbcB\u2026artStatement::class.java)");
        LOG = logger;
    }

    @Override
    @NotNull
    public <T> Either<T> execute(INPUT input, @NotNull ResultsProducer.VoidReadyProcessor<T> processor) {
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        return SmartStatement.DefaultImpls.execute(this, input, processor);
    }

    @Override
    @NotNull
    public <T> Either<T> execute(INPUT input, @NotNull ExecutionMode mode, @NotNull ResultsProducer.VoidReadyProcessor<T> processor) {
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        return SmartStatement.DefaultImpls.execute(this, input, mode, processor);
    }

    @Override
    @NotNull
    public <T> Either<T> execute(INPUT input, @NotNull Function1<? super ResultsProducer, ? extends T> processor) {
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        return SmartStatement.DefaultImpls.execute(this, input, processor);
    }

    @Override
    @NotNull
    public NoisyStatement<INPUT> noisy() {
        return SmartStatement.DefaultImpls.noisy(this);
    }

    @Override
    @NotNull
    public BarrenStatement<INPUT> barren() {
        return SmartStatement.DefaultImpls.barren(this);
    }

    public static final /* synthetic */ Either access$memorizeAndExecute(JdbcBasedSmartStatement $this, Object input, ExecutionMode mode, StatementHolder.CloseableRef ref) {
        return $this.memorizeAndExecute(input, mode, ref);
    }

    public static final /* synthetic */ void access$reportProcessed(JdbcBasedSmartStatement $this, StatementHolder.CloseableRef statement) {
        $this.reportProcessed(statement);
    }

    public static final /* synthetic */ void access$closeStatement(JdbcBasedSmartStatement $this, Statement it2) {
        $this.closeStatement(it2);
    }

    public static final /* synthetic */ Either access$statementInstance(JdbcBasedSmartStatement $this, Object input) {
        return $this.statementInstance(input);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ+\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u0011J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f2\u0006\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00028\u0002H\u0004\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u001fJ%\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010&\u00a8\u0006'"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized;", "INPUT", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement;", "Ljava/sql/PreparedStatement;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "after", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "input", "statement", "result", "(Ljava/lang/Object;Ljava/sql/PreparedStatement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)Lcom/intellij/database/dataSource/connection/Either;", "before", "", "(Ljava/lang/Object;Ljava/sql/PreparedStatement;)Lcom/intellij/database/dataSource/connection/Either;", "completeStatement", "data", "(Ljava/sql/PreparedStatement;Ljava/lang/Object;)V", "createStatement", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/Object;)Ljava/sql/PreparedStatement;", "decoration", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "(Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "escapeIndex", "", "(Ljava/lang/Object;)I", "executeJdbcStatement", "mode", "Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Ljava/sql/PreparedStatement;)Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "extract", "", "(Ljava/lang/Object;)Ljava/lang/String;", "intellij.database.impl"})
    public static abstract class Parameterized<INPUT>
    extends JdbcBasedSmartStatement<INPUT, PreparedStatement> {
        @NotNull
        public abstract String extract(INPUT var1);

        public abstract int escapeIndex(INPUT var1);

        @NotNull
        public abstract ParameterizedStatementDecoration decoration(INPUT var1);

        @Override
        @NotNull
        protected PreparedStatement createStatement(@NotNull DatabaseConnection connection2, INPUT input) {
            Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
            PreparedStatement preparedStatement = connection2.getJdbcConnection().prepareStatement(this.extract(input));
            Intrinsics.checkExpressionValueIsNotNull((Object)preparedStatement, (String)"connection.jdbcConnectio\u2026Statement(extract(input))");
            return preparedStatement;
        }

        @Override
        @NotNull
        protected Either<Unit> before(INPUT input, @NotNull PreparedStatement statement) {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            return SmartStatementsUtil.runReporting(this.getConnection(), StagedException.Stage.PARAMETERS_COMPLETION, this, (Function0)new Function0<Unit>(this, statement, input){
                final /* synthetic */ Parameterized this$0;
                final /* synthetic */ PreparedStatement $statement;
                final /* synthetic */ Object $input;

                public final void invoke() {
                    this.this$0.completeStatement(this.$statement, this.$input);
                }
                {
                    this.this$0 = parameterized;
                    this.$statement = preparedStatement;
                    this.$input = object;
                    super(0);
                }
            });
        }

        @Override
        @NotNull
        protected Either<ExecutionResult> after(INPUT input, @NotNull PreparedStatement statement, @NotNull ExecutionResult result2) {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            return new Either.Right<ExecutionResult>(result2);
        }

        @Override
        @NotNull
        protected ExecutionResult executeJdbcStatement(INPUT input, @NotNull ExecutionMode mode, @NotNull PreparedStatement statement) {
            Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            return mode.execute(statement);
        }

        protected final void completeStatement(@NotNull PreparedStatement statement, INPUT data) throws Exception {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            int escape = this.escapeIndex(data);
            for (CallableStatementData.InParameter parameter : this.decoration(data).getInParameters()) {
                DbImplUtil.setStatementParameter(statement, parameter.getData(), parameter.getData().getObject(), this.getConnection().getDbms(), parameter.getIndex() > escape, parameter.getIndex());
            }
        }

        public Parameterized(@NotNull DatabaseConnection connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
            Intrinsics.checkParameterIsNotNull((Object)auditService, (String)"auditService");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            super(connection2, auditService, configuration);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ+\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00028\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0014\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00028\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Call;", "INPUT", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "after", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "input", "statement", "Ljava/sql/PreparedStatement;", "result", "(Ljava/lang/Object;Ljava/sql/PreparedStatement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)Lcom/intellij/database/dataSource/connection/Either;", "basis", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementBasis;", "(Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/CallableStatementBasis;", "configure", "", "(Ljava/lang/Object;Ljava/sql/PreparedStatement;)V", "createStatement", "Ljava/sql/CallableStatement;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/Object;)Ljava/sql/CallableStatement;", "intellij.database.impl"})
    public static abstract class Call<INPUT>
    extends Parameterized<INPUT> {
        @NotNull
        public abstract CallableStatementBasis basis(INPUT var1);

        @Override
        @NotNull
        protected Either<ExecutionResult> after(INPUT input, @NotNull PreparedStatement statement, @NotNull ExecutionResult result2) {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            return super.after(input, statement, result2).shelter((Function1)new Function1<ExecutionResult, ExecutionResult>(this, input){
                final /* synthetic */ Call this$0;
                final /* synthetic */ Object $input;

                @NotNull
                public final ExecutionResult invoke(@NotNull ExecutionResult executionResult) {
                    Intrinsics.checkParameterIsNotNull((Object)executionResult, (String)"executionResult");
                    return executionResult.parametrize(this.this$0.basis(this.$input).getOutParameters());
                }
                {
                    this.this$0 = call2;
                    this.$input = object;
                    super(1);
                }
            });
        }

        @Override
        protected void configure(INPUT input, @NotNull PreparedStatement statement) {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            super.configure(input, (Statement)statement);
            List<OutParameter<?>> outParameters = this.basis(input).getOutParameters();
            Collection collection = outParameters;
            boolean bl = false;
            if (!collection.isEmpty()) {
                CallableStatement callableStatement = (CallableStatement)statement;
                for (OutParameter<?> parameter : outParameters) {
                    parameter.register(callableStatement);
                }
            }
        }

        @Override
        @NotNull
        protected CallableStatement createStatement(@NotNull DatabaseConnection connection2, INPUT input) {
            Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
            CallableStatement callableStatement = connection2.getJdbcConnection().prepareCall(this.basis(input).getSql());
            Intrinsics.checkExpressionValueIsNotNull((Object)callableStatement, (String)"connection.jdbcConnectio\u2026areCall(basis(input).sql)");
            return callableStatement;
        }

        public Call(@NotNull DatabaseConnection connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
            Intrinsics.checkParameterIsNotNull((Object)auditService, (String)"auditService");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            super(connection2, auditService, configuration);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\rH\u0014J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Simple;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement;", "", "Ljava/sql/Statement;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "after", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "input", "statement", "result", "before", "", "createStatement", "executeJdbcStatement", "mode", "Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;", "scrollableIfPossible", "intellij.database.impl"})
    public static abstract class Simple
    extends JdbcBasedSmartStatement<String, Statement> {
        @Override
        @NotNull
        protected ExecutionResult executeJdbcStatement(@NotNull String input, @NotNull ExecutionMode mode, @NotNull Statement statement) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            return mode.execute(input, statement);
        }

        @Override
        @NotNull
        protected Either<Unit> before(@NotNull String input, @NotNull Statement statement) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            return new Either.UnitRight();
        }

        @Override
        @NotNull
        protected Either<ExecutionResult> after(@NotNull String input, @NotNull Statement statement, @NotNull ExecutionResult result2) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            return new Either.Right<ExecutionResult>(result2);
        }

        @Override
        @NotNull
        protected Statement createStatement(@NotNull DatabaseConnection connection2, @NotNull String input) {
            Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Statement statement = this.scrollableIfPossible(connection2, this.getConfiguration());
            if (statement == null) {
                Statement statement2 = connection2.getJdbcConnection().createStatement();
                statement = statement2;
                Intrinsics.checkExpressionValueIsNotNull((Object)statement2, (String)"connection.jdbcConnection.createStatement()");
            }
            return statement;
        }

        private final Statement scrollableIfPossible(DatabaseConnection connection2, Configuration configuration) {
            if (!configuration.getScrollable() || !Registry.is((String)"database.scrollable.result.sets")) {
                return null;
            }
            try {
                Dbms dbms = connection2.getDbms();
                Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"connection.dbms");
                if (dbms.isDb2()) {
                    return null;
                }
                DatabaseMetaData metaData = connection2.getMetaData();
                if (metaData != null && metaData.supportsResultSetType(1004)) {
                    return connection2.getJdbcConnection().createStatement(1004, 1007);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to create a statement with a scrollable result set type", (Throwable)e);
            }
            return null;
        }

        public Simple(@NotNull DatabaseConnection connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
            Intrinsics.checkParameterIsNotNull((Object)auditService, (String)"auditService");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            super(connection2, auditService, configuration);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J!\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0002\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J!\u0010\u0012\u001a\u0002H\u000b\"\u0004\b\u0002\u0010\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$ExceptionTransformer;", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "delegate", "(Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;)V", "getDelegate", "()Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "advance", "", "close", "", "getParameterValue", "T", "parameter", "Lcom/intellij/database/dataSource/connection/statements/OutParameter;", "(Lcom/intellij/database/dataSource/connection/statements/OutParameter;)Ljava/lang/Object;", "", "index", "", "processCurrent", "processor", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;", "(Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;)Ljava/lang/Object;", "processRemaining", "intellij.database.impl"})
    private static final class ExceptionTransformer
    implements ClosableResultsProducer {
        @NotNull
        private final ClosableResultsProducer delegate;

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean advance() {
            try {
                return this.delegate.advance();
            }
            catch (StagedException e) {
                throw (Throwable)e.getBase();
            }
        }

        @Override
        public <T> T processCurrent(@NotNull ResultsProducer.Processor<T> processor) {
            Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
            try {
                return this.delegate.processCurrent(processor);
            }
            catch (StagedException e) {
                throw (Throwable)e.getBase();
            }
        }

        @Override
        public void processRemaining(@NotNull ResultsProducer.Processor<Unit> processor) {
            Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
            try {
                this.delegate.processRemaining(processor);
                return;
            }
            catch (StagedException e) {
                throw (Throwable)e.getBase();
            }
        }

        @Override
        public <T> T getParameterValue(@NotNull OutParameter<T> parameter) {
            Intrinsics.checkParameterIsNotNull(parameter, (String)"parameter");
            try {
                return this.delegate.getParameterValue(parameter);
            }
            catch (StagedException e) {
                throw (Throwable)e.getBase();
            }
        }

        @Override
        @Nullable
        public Object getParameterValue(int index2) {
            try {
                return this.delegate.getParameterValue(index2);
            }
            catch (StagedException e) {
                throw (Throwable)e.getBase();
            }
        }

        @NotNull
        public final ClosableResultsProducer getDelegate() {
            return this.delegate;
        }

        public ExceptionTransformer(@NotNull ClosableResultsProducer delegate) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @Override
        public boolean advanceSafe() {
            return ClosableResultsProducer.DefaultImpls.advanceSafe(this);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

