/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshTunnelConfiguration {
    public static final String ELEMENT_NAME = "ssh-properties";
    private final String myProxyHost;
    private final String myProxyPort;
    private final String myLocalPort;
    private final LocalDataSource.Storage myPasswordStorage;
    private final String myUser;
    private final AuthType myAuthType;
    private final String myPrivateKeyPath;
    private final boolean myEnabled;

    public DataSourceSshTunnelConfiguration(@NotNull String proxyHost, @NotNull String proxyPort, @NotNull String localPort, @NotNull LocalDataSource.Storage passwordStorage, @NotNull String user, @NotNull AuthType authType, @NotNull String privateKeyPath, boolean enabled) {
        if (proxyHost == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(0);
        }
        if (proxyPort == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(1);
        }
        if (localPort == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(2);
        }
        if (passwordStorage == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(3);
        }
        if (user == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(4);
        }
        if (authType == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(5);
        }
        if (privateKeyPath == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(6);
        }
        this.myProxyHost = proxyHost;
        this.myProxyPort = proxyPort;
        this.myLocalPort = localPort;
        this.myPasswordStorage = passwordStorage;
        this.myUser = user;
        this.myPrivateKeyPath = privateKeyPath;
        this.myEnabled = enabled;
        this.myAuthType = authType;
    }

    public static boolean equal(@Nullable DataSourceSshTunnelConfiguration c1, @Nullable DataSourceSshTunnelConfiguration c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equalConfiguration(c2);
    }

    @Nullable
    public static DataSourceSshTunnelConfiguration deserialize(@NotNull HierarchicalStreamReader xmlReader, @NotNull LocalDataSource dataSource) {
        DataSourceSshTunnelConfiguration configuration;
        if (xmlReader == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(7);
        }
        if (dataSource == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(8);
        }
        String proxyHost = "";
        String proxyPort = "";
        String user = "";
        String privateKeyPath = "";
        String remoteHost = "";
        String remotePort = "";
        String localPort = "";
        boolean enabled = false;
        AuthType authType = AuthType.PASSWORD;
        LocalDataSource.Storage passwordStorage = LocalDataSource.Storage.MEMORY;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String name2 = xmlReader.getNodeName();
            String value = xmlReader.getValue();
            if ("proxy-host".equals(name2)) {
                proxyHost = value;
            } else if ("proxy-port".equals(name2)) {
                proxyPort = value;
            } else if ("secret-storage".equals(name2)) {
                passwordStorage = LocalDataSource.Storage.deserialize(xmlReader.getValue());
            } else if ("user".equals(name2)) {
                user = value;
            } else if ("use-password".equals(name2)) {
                authType = Boolean.parseBoolean(value) ? AuthType.PASSWORD : AuthType.KEY_PAIR;
            } else if ("auth-type".equals(name2)) {
                authType = (AuthType)StringUtil.parseEnum((String)value, (Enum)AuthType.PASSWORD, AuthType.class);
            } else if ("private-key-path".equals(name2)) {
                privateKeyPath = value;
            } else if ("remote-host".equals(name2)) {
                remoteHost = value;
            } else if ("remote-port".equals(name2)) {
                remotePort = value;
            } else if ("local-port".equals(name2)) {
                localPort = value;
            } else if ("enabled".equals(name2)) {
                enabled = Boolean.parseBoolean(value);
            }
            xmlReader.moveUp();
        }
        if (!(StringUtil.isEmpty((String)remoteHost) || StringUtil.isEmpty((String)remotePort) || StringUtil.isEmpty((String)localPort))) {
            String url = dataSource.getUrl();
            url = url.replace(localPort, remotePort);
            url = url.replace("localhost", remoteHost);
            url = url.replace("127.0.0.1", remoteHost);
            dataSource.setUrl(url);
        }
        return (configuration = new DataSourceSshTunnelConfiguration(proxyHost, proxyPort, localPort, passwordStorage, user, authType, privateKeyPath, enabled)).isEmpty() ? null : configuration;
    }

    public void serialize(@NotNull HierarchicalStreamWriter serializer) {
        if (serializer == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(9);
        }
        serializer.startNode(ELEMENT_NAME);
        LocalDataSource.writeTag(serializer, "enabled", Boolean.toString(this.myEnabled));
        LocalDataSource.writeTag(serializer, "proxy-host", this.myProxyHost);
        LocalDataSource.writeTag(serializer, "proxy-port", this.myProxyPort);
        LocalDataSource.writeTag(serializer, "local-port", this.myLocalPort);
        LocalDataSource.writeTag(serializer, "secret-storage", this.myPasswordStorage.serialize());
        LocalDataSource.writeTag(serializer, "user", this.myUser);
        LocalDataSource.writeTag(serializer, "use-password", Boolean.toString(this.myAuthType == AuthType.PASSWORD));
        LocalDataSource.writeTag(serializer, "auth-type", this.myAuthType.name());
        LocalDataSource.writeTag(serializer, "private-key-path", this.myPrivateKeyPath);
        serializer.endNode();
    }

    @NotNull
    public String getProxyHost() {
        String string = this.myProxyHost;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getUser() {
        String string = this.myUser;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.myAuthType;
        if (authType == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(12);
        }
        return authType;
    }

    @NotNull
    public String getProxyPort() {
        String string = this.myProxyPort;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getLocalPort() {
        String string = this.myLocalPort;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getPrivateKeyPath() {
        String string = this.myPrivateKeyPath;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(15);
        }
        return string;
    }

    public LocalDataSource.Storage getPasswordStorage() {
        return this.myPasswordStorage;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean equalConfiguration(@NotNull DataSourceSshTunnelConfiguration configuration) {
        if (configuration == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(16);
        }
        if (this.myEnabled != configuration.myEnabled) {
            return false;
        }
        if (this.myAuthType != configuration.myAuthType) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myProxyHost), (CharSequence)StringUtil.nullize((String)configuration.myProxyHost))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myProxyPort), (CharSequence)StringUtil.nullize((String)configuration.myProxyPort))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myLocalPort), (CharSequence)StringUtil.nullize((String)configuration.myLocalPort))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myUser), (CharSequence)StringUtil.nullize((String)configuration.myUser))) {
            return false;
        }
        if (this.myPasswordStorage != configuration.getPasswordStorage()) {
            return false;
        }
        return StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myPrivateKeyPath), (CharSequence)StringUtil.nullize((String)configuration.myPrivateKeyPath));
    }

    public boolean isEmpty() {
        if (this.myEnabled) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myProxyHost)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myUser)) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)this.myPrivateKeyPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyPort";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPort";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passwordStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateKeyPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyHost";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUser";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyPort";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPort";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrivateKeyPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

