/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.component;

import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.component.CliUneditableTextField;
import com.intellij.database.dataSource.url.ui.UniformLookSettingsProvider;
import com.intellij.database.psi.DbElement;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class CliMultiParametersUneditableTextField
extends CliUneditableTextField {
    private final TextFieldWithBrowseButton myFieldWithBrowseButton;
    private final List<String> myStrings = new ArrayList<String>();

    public CliMultiParametersUneditableTextField(StringCliArgument argument) {
        super(argument);
        this.myFieldWithBrowseButton = new TextFieldWithBrowseButton(this.myField, (ActionListener)new MyActionListener());
        this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CliMultiParametersUneditableTextField.this.updateButton();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField$1", "textChanged"));
            }
        });
        this.myField.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CliMultiParametersUneditableTextField.this.updateButton();
            }
        });
    }

    private void updateButton() {
        int count2 = this.getRowCount(this.myField.getText());
        this.myFieldWithBrowseButton.getButton().setVisible(count2 > 1);
    }

    private int getRowCount(@NotNull String text2) {
        int fieldWidth;
        if (text2 == null) {
            CliMultiParametersUneditableTextField.$$$reportNull$$$0(0);
        }
        if ((fieldWidth = this.myField.getWidth()) == 0) {
            return 0;
        }
        int stringWidth = GraphicsUtil.stringWidth((String)text2, (Font)this.myField.getFont());
        return Math.min(stringWidth / fieldWidth + (stringWidth % fieldWidth > 0 ? 1 : 0), 6);
    }

    @Override
    public boolean configure(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
        if (elements == null) {
            CliMultiParametersUneditableTextField.$$$reportNull$$$0(1);
        }
        if (cd == null) {
            CliMultiParametersUneditableTextField.$$$reportNull$$$0(2);
        }
        this.myStrings.clear();
        this.myStrings.addAll(((StringCliArgument)this.getArgument()).getStringsFromElements(elements, cd));
        this.myField.setText(StringUtil.join(this.myStrings, (String)", "));
        return true;
    }

    @Override
    public void changeState(@NotNull String text2, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        String value;
        if (text2 == null) {
            CliMultiParametersUneditableTextField.$$$reportNull$$$0(3);
        }
        if (current == null) {
            CliMultiParametersUneditableTextField.$$$reportNull$$$0(4);
        }
        if (next == null) {
            CliMultiParametersUneditableTextField.$$$reportNull$$$0(5);
        }
        if (cd == null) {
            CliMultiParametersUneditableTextField.$$$reportNull$$$0(6);
        }
        if (!cd.checkedOut(this)) {
            this.myField.setText("");
            this.myStrings.clear();
        }
        if ((value = ((StringCliArgument)this.getArgument()).getComponentValue(text2, current, next, cd)) == null) {
            return;
        }
        String parameter = DbCliUtil.clearString(value, ((StringCliArgument)this.getArgument()).getUnquoter());
        this.myStrings.add(parameter);
        this.myField.setText(StringUtil.join(this.myStrings, (String)", "));
    }

    @Override
    public void reset(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            CliMultiParametersUneditableTextField.$$$reportNull$$$0(7);
        }
        super.reset(cd);
        this.myStrings.clear();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myFieldWithBrowseButton;
        if (textFieldWithBrowseButton == null) {
            CliMultiParametersUneditableTextField.$$$reportNull$$$0(8);
        }
        return textFieldWithBrowseButton;
    }

    @Override
    @NotNull
    public String getFullArgument(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            CliMultiParametersUneditableTextField.$$$reportNull$$$0(9);
        }
        Function<String, String> quoter = ((StringCliArgument)this.getArgument()).getQuoter();
        String string = this.myStrings.isEmpty() ? "" : DbCliUtil.fromListToArgument(this.myStrings, ((StringCliArgument)this.getArgument()).getPrefix(), quoter);
        if (string == null) {
            CliMultiParametersUneditableTextField.$$$reportNull$$$0(10);
        }
        return string;
    }

    private void showFullText() {
        String text2 = this.myField.getText();
        EditorTextField field = new EditorTextField(EditorFactory.getInstance().createDocument((CharSequence)text2), null, (FileType)FileTypes.PLAIN_TEXT, true, false);
        field.addSettingsProvider(editor -> {
            editor.getSettings().setUseSoftWraps(true);
            editor.setVerticalScrollbarVisible(true);
        });
        field.addSettingsProvider((EditorSettingsProvider)new UniformLookSettingsProvider());
        int count2 = this.getRowCount(text2);
        field.setPreferredWidth(this.myField.getWidth());
        Dimension size = new Dimension(this.myField.getWidth(), this.myField.getHeight() * count2);
        field.setPreferredSize(size);
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)field, null).setRequestFocus(false).createPopup().showUnderneathOf((Component)this.myField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/component/CliMultiParametersUneditableTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/component/CliMultiParametersUneditableTextField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRowCount";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changeState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFullArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CliMultiParametersUneditableTextField.this.showFullText();
        }
    }
}

