/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.debugger.SqlDebugRunner;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.ScriptModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugQueryAction
extends QueryActionBase {
    @Override
    protected boolean isApplicable(@Nullable JdbcConsole console) {
        if (console == null) {
            return false;
        }
        SqlDebugRunner.SqlDebugAvailability availability = SqlDebugRunner.checkDebuggerAvailability(console.getDataSource());
        return availability != SqlDebugRunner.SqlDebugAvailability.DEBUGGER_ABSENT;
    }

    @Override
    protected boolean isEnabled(@Nullable JdbcConsole console) {
        if (console == null) {
            return false;
        }
        SqlDebugRunner.SqlDebugAvailability availability = SqlDebugRunner.checkDebuggerAvailability(console.getDataSource());
        return availability == SqlDebugRunner.SqlDebugAvailability.DEBUGGER_ENABLED;
    }

    @Override
    protected void invokeImpl(@Nullable JdbcConsole console, @NotNull ScriptModel<?> scriptModel, @NotNull JdbcConsoleProvider.Info info) {
        SqlDebugController controller;
        if (scriptModel == null) {
            DebugQueryAction.$$$reportNull$$$0(0);
        }
        if (info == null) {
            DebugQueryAction.$$$reportNull$$$0(1);
        }
        if (console == null) {
            return;
        }
        if (!console.beforeExecuteQueries(scriptModel)) {
            return;
        }
        Document document = console.getDocument();
        int firstLineNr = document.getLineNumber(scriptModel.getTextRange().getStartOffset());
        VirtualFile virtualFile = scriptModel.getVirtualFile();
        SqlDebugController sqlDebugController = controller = SqlDebugRunner.startDebugProcess(console.getProject(), console.getDataSource(), virtualFile, firstLineNr, console.getTitle());
        sqlDebugController.getClass();
        SqlDebugController.AuxiliaryRequest preparationRequest = new SqlDebugController.AuxiliaryRequest(sqlDebugController, console);
        ConsoleDataRequest executingRequest = ConsoleDataRequest.newConsoleRequest(console, (Editor)info.editor, scriptModel, controller, true);
        DataProducer dataProducer = console.getMessageBus().getDataProducer();
        preparationRequest.getPromise().onSuccess(__ -> dataProducer.processRequest(executingRequest));
        executingRequest.getPromise().onProcessed(__ -> controller.close());
        dataProducer.processRequest(preparationRequest);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "scriptModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/actions/DebugQueryAction";
        objectArray[2] = "invokeImpl";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

