/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LineTokenizer {
    private int myOffset;
    private int myLength;
    private int myLineSeparatorLength;
    private boolean atEnd;
    private final CharSequence myText;

    @NotNull
    public static String[] tokenize(CharSequence chars, boolean includeSeparators) {
        String[] stringArray = LineTokenizer.tokenize(chars, includeSeparators, true);
        if (stringArray == null) {
            LineTokenizer.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @NotNull
    public static String[] tokenize(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        List<String> strings = LineTokenizer.tokenizeIntoList(chars, includeSeparators, skipLastEmptyLine);
        String[] stringArray = strings.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : ArrayUtilRt.toStringArray(strings);
        if (stringArray == null) {
            LineTokenizer.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public static List<String> tokenizeIntoList(CharSequence chars, boolean includeSeparators) {
        List<String> list = LineTokenizer.tokenizeIntoList(chars, includeSeparators, true);
        if (list == null) {
            LineTokenizer.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<String> tokenizeIntoList(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null || chars.length() == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                LineTokenizer.$$$reportNull$$$0(3);
            }
            return list;
        }
        LineTokenizer tokenizer = new LineTokenizer(chars);
        ArrayList<String> lines = new ArrayList<String>();
        while (!tokenizer.atEnd()) {
            int offset = tokenizer.getOffset();
            String line = includeSeparators ? chars.subSequence(offset, offset + tokenizer.getLength() + tokenizer.getLineSeparatorLength()).toString() : chars.subSequence(offset, offset + tokenizer.getLength()).toString();
            lines.add(line);
            tokenizer.advance();
        }
        if (!skipLastEmptyLine && LineTokenizer.stringEndsWithSeparator(tokenizer)) {
            lines.add("");
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            LineTokenizer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static int calcLineCount(@NotNull CharSequence chars, boolean skipLastEmptyLine) {
        if (chars == null) {
            LineTokenizer.$$$reportNull$$$0(5);
        }
        int lineCount = 0;
        if (chars.length() != 0) {
            LineTokenizer tokenizer = new LineTokenizer(chars);
            while (!tokenizer.atEnd()) {
                ++lineCount;
                tokenizer.advance();
            }
            if (!skipLastEmptyLine && LineTokenizer.stringEndsWithSeparator(tokenizer)) {
                ++lineCount;
            }
        }
        return lineCount;
    }

    @NotNull
    public static String[] tokenize(@NotNull char[] chars, boolean includeSeparators) {
        if (chars == null) {
            LineTokenizer.$$$reportNull$$$0(6);
        }
        String[] stringArray = LineTokenizer.tokenize(chars, includeSeparators, true);
        if (stringArray == null) {
            LineTokenizer.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    @NotNull
    public static String[] tokenize(@NotNull char[] chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null) {
            LineTokenizer.$$$reportNull$$$0(8);
        }
        String[] stringArray = LineTokenizer.tokenize(chars, 0, chars.length, includeSeparators, skipLastEmptyLine);
        if (stringArray == null) {
            LineTokenizer.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @NotNull
    public static String[] tokenize(@NotNull char[] chars, int startOffset, int endOffset, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null) {
            LineTokenizer.$$$reportNull$$$0(10);
        }
        String[] stringArray = LineTokenizer.tokenize(new CharArrayCharSequence(chars, startOffset, endOffset), includeSeparators, skipLastEmptyLine);
        if (stringArray == null) {
            LineTokenizer.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    private static boolean stringEndsWithSeparator(@NotNull LineTokenizer tokenizer) {
        if (tokenizer == null) {
            LineTokenizer.$$$reportNull$$$0(12);
        }
        return tokenizer.getLineSeparatorLength() > 0;
    }

    @NotNull
    public static String[] tokenize(@NotNull char[] chars, int startOffset, int endOffset, boolean includeSeparators) {
        if (chars == null) {
            LineTokenizer.$$$reportNull$$$0(13);
        }
        String[] stringArray = LineTokenizer.tokenize(chars, startOffset, endOffset, includeSeparators, true);
        if (stringArray == null) {
            LineTokenizer.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    public LineTokenizer(@NotNull CharSequence text) {
        if (text == null) {
            LineTokenizer.$$$reportNull$$$0(15);
        }
        this.myText = text;
        this.myOffset = 0;
        this.advance();
    }

    public LineTokenizer(@NotNull char[] text, int startOffset, int endOffset) {
        if (text == null) {
            LineTokenizer.$$$reportNull$$$0(16);
        }
        this(new CharArrayCharSequence(text, startOffset, endOffset));
    }

    public final boolean atEnd() {
        return this.atEnd;
    }

    public final int getOffset() {
        return this.myOffset;
    }

    public final int getLength() {
        return this.myLength;
    }

    public final int getLineSeparatorLength() {
        return this.myLineSeparatorLength;
    }

    public void advance() {
        char c;
        int i = this.myOffset + this.myLength + this.myLineSeparatorLength;
        int textLength = this.myText.length();
        if (i >= textLength) {
            this.atEnd = true;
            return;
        }
        while (i < textLength && (c = this.myText.charAt(i)) != '\r' && c != '\n') {
            ++i;
        }
        this.myOffset += this.myLength + this.myLineSeparatorLength;
        this.myLength = i - this.myOffset;
        this.myLineSeparatorLength = 0;
        if (i == textLength) {
            return;
        }
        char first = this.myText.charAt(i);
        if (first == '\r' || first == '\n') {
            this.myLineSeparatorLength = 1;
        }
        if (++i == textLength) {
            return;
        }
        char second = this.myText.charAt(i);
        if (first == '\r' && second == '\n') {
            this.myLineSeparatorLength = 2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/LineTokenizer";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenizeIntoList";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/LineTokenizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcLineCount";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "stringEndsWithSeparator";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

