/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.performancePlugin.LabelsBundle;
import com.jetbrains.performancePlugin.profilers.AsyncProfilerHandler;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAsyncRunParametersDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private RawCommandLineEditor myAsyncProfilerParameters;
    private JBLabel myInfoJBLabel;
    private final AsyncProfilerHandler asyncProfiler;

    public ConfigureAsyncRunParametersDialog(@Nullable Project project) {
        super(project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(LabelsBundle.message("async.profiler.parameters.title", objectArray));
        this.asyncProfiler = AsyncProfilerHandler.getInstance();
        this.myInfoJBLabel.setText(String.format(LabelsBundle.message("async.profiler.parameters.help.text", new Object[0]), this.asyncProfiler.isProfilingStarted() ? "stop" : "start"));
        this.myAsyncProfilerParameters.setText(this.asyncProfiler.isProfilingStarted() ? "flat=1000,svg,collapsed,traces=5000,summary" : "interval=10000000");
        this.myInfoJBLabel.setLabelFor((Component)this.myAsyncProfilerParameters);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @NotNull
    protected Action[] createActions() {
        DialogWrapper.DialogWrapperAction execute = new DialogWrapper.DialogWrapperAction(this.asyncProfiler.isProfilingStarted() ? "&Stop" : "&Start"){

            protected void doAction(ActionEvent e) {
                List<String> parameters = Arrays.asList(ConfigureAsyncRunParametersDialog.this.myAsyncProfilerParameters.getText().trim().split(","));
                ActionCallbackProfilerStopper myActionCallback = new ActionCallbackProfilerStopper();
                ConfigureAsyncRunParametersDialog.this.doOKAction();
                try {
                    if (ConfigureAsyncRunParametersDialog.this.asyncProfiler.isProfilingStarted()) {
                        ConfigureAsyncRunParametersDialog.this.asyncProfiler.stopProfiling(parameters);
                        ConfigureAsyncRunParametersDialog.this.asyncProfiler.showCompleteNotification();
                    } else {
                        ConfigureAsyncRunParametersDialog.this.asyncProfiler.startProfiling("UserActivity", parameters);
                    }
                }
                catch (Exception exception) {
                    myActionCallback.reject(exception.getMessage());
                }
            }
        };
        Action[] actionArray = new Action[]{execute, this.getCancelAction()};
        if (actionArray == null) {
            ConfigureAsyncRunParametersDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/performancePlugin/ui/ConfigureAsyncRunParametersDialog", "createActions"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myAsyncProfilerParameters = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myInfoJBLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("Labels").getString("input.below.parameters.for.async.profiler"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)rawCommandLineEditor);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

