/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubCommit;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.GithubPullRequest;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailed;
import org.jetbrains.plugins.github.pullrequest.action.ui.GithubMergeCommitMessageDialog;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsBusyStateTracker;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsDataLoader;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsListLoader;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsStateService;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsStateServiceImpl;
import org.jetbrains.plugins.github.util.GithubAsyncUtil;
import org.jetbrains.plugins.github.util.GithubNotifications;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001BG\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsStateServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsStateService;", "project", "Lcom/intellij/openapi/project/Project;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "listLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsListLoader;", "dataLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader;", "busyStateTracker", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTracker;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "repoPath", "Lorg/jetbrains/plugins/github/api/GithubFullPath;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsListLoader;Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader;Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTracker;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/api/GithubServerPath;Lorg/jetbrains/plugins/github/api/GithubFullPath;)V", "close", "", "pullRequest", "", "merge", "rebaseMerge", "releaseAndRefreshData", "reopen", "squashMerge", "intellij.vcs.github"})
public final class GithubPullRequestsStateServiceImpl
implements GithubPullRequestsStateService {
    private final Project project;
    private final ProgressManager progressManager;
    private final GithubPullRequestsListLoader listLoader;
    private final GithubPullRequestsDataLoader dataLoader;
    private final GithubPullRequestsBusyStateTracker busyStateTracker;
    private final GithubApiRequestExecutor requestExecutor;
    private final GithubServerPath serverPath;
    private final GithubFullPath repoPath;

    @Override
    public void close(long pullRequest) {
        if (!this.busyStateTracker.acquire(pullRequest)) {
            return;
        }
        this.progressManager.run((Task)new Task.Backgroundable(this, pullRequest, this.project, "Closing Pull Request...", true){
            final /* synthetic */ GithubPullRequestsStateServiceImpl this$0;
            final /* synthetic */ long $pullRequest;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                GithubApiRequestExecutor githubApiRequestExecutor = GithubPullRequestsStateServiceImpl.access$getRequestExecutor$p(this.this$0);
                GithubServerPath githubServerPath = GithubPullRequestsStateServiceImpl.access$getServerPath$p(this.this$0);
                String string = GithubPullRequestsStateServiceImpl.access$getRepoPath$p(this.this$0).getUser();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repoPath.user");
                String string2 = GithubPullRequestsStateServiceImpl.access$getRepoPath$p(this.this$0).getRepository();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"repoPath.repository");
                githubApiRequestExecutor.execute(indicator, GithubApiRequests.Repos.PullRequests.update$default(githubServerPath, string, string2, this.$pullRequest, null, null, GithubIssueState.closed, null, null, 432, null));
            }

            public void onSuccess() {
                GithubNotifications.showInfo(this.getProject(), "Pull Request Closed", "Successfully closed pull request #" + this.$pullRequest);
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GithubNotifications.showError(this.getProject(), "Failed To Close Pull Request", error);
            }

            public void onFinished() {
                GithubPullRequestsStateServiceImpl.access$releaseAndRefreshData(this.this$0, this.$pullRequest);
            }
            {
                this.this$0 = $outer;
                this.$pullRequest = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
    }

    @Override
    public void reopen(long pullRequest) {
        if (!this.busyStateTracker.acquire(pullRequest)) {
            return;
        }
        this.progressManager.run((Task)new Task.Backgroundable(this, pullRequest, this.project, "Reopening Pull Request...", true){
            final /* synthetic */ GithubPullRequestsStateServiceImpl this$0;
            final /* synthetic */ long $pullRequest;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                GithubApiRequestExecutor githubApiRequestExecutor = GithubPullRequestsStateServiceImpl.access$getRequestExecutor$p(this.this$0);
                GithubServerPath githubServerPath = GithubPullRequestsStateServiceImpl.access$getServerPath$p(this.this$0);
                String string = GithubPullRequestsStateServiceImpl.access$getRepoPath$p(this.this$0).getUser();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repoPath.user");
                String string2 = GithubPullRequestsStateServiceImpl.access$getRepoPath$p(this.this$0).getRepository();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"repoPath.repository");
                githubApiRequestExecutor.execute(indicator, GithubApiRequests.Repos.PullRequests.update$default(githubServerPath, string, string2, this.$pullRequest, null, null, GithubIssueState.open, null, null, 432, null));
            }

            public void onSuccess() {
                GithubNotifications.showInfo(this.getProject(), "Pull Request Reopened", "Successfully reopened pull request #" + this.$pullRequest);
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GithubNotifications.showError(this.getProject(), "Failed To Reopen Pull Request", error);
            }

            public void onFinished() {
                GithubPullRequestsStateServiceImpl.access$releaseAndRefreshData(this.this$0, this.$pullRequest);
            }
            {
                this.this$0 = $outer;
                this.$pullRequest = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
    }

    @Override
    public void merge(long pullRequest) {
        if (!this.busyStateTracker.acquire(pullRequest)) {
            return;
        }
        GithubPullRequestDataProvider dataProvider = this.dataLoader.getDataProvider(pullRequest);
        this.progressManager.run((Task)new Task.Backgroundable(this, dataProvider, pullRequest, this.project, "Merging Pull Request...", true){
            private GithubPullRequestDetailed details;
            final /* synthetic */ GithubPullRequestsStateServiceImpl this$0;
            final /* synthetic */ GithubPullRequestDataProvider $dataProvider;
            final /* synthetic */ long $pullRequest;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setText2("Loading details");
                T t = GithubAsyncUtil.awaitFuture(indicator, this.$dataProvider.getDetailsRequest());
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"GithubAsyncUtil.awaitFut\u2026aProvider.detailsRequest)");
                this.details = (GithubPullRequestDetailed)t;
                indicator.checkCanceled();
                indicator.setText2("Acquiring commit message");
                Pair pair = (Pair)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Pair<? extends String, ? extends String>>(this){
                    final /* synthetic */ merge.1 this$0;

                    @Nullable
                    public final Pair<String, String> invoke() {
                        Project project = this.this$0.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        String string = "Merge pull request #" + this.this$0.$pullRequest;
                        String string2 = merge.1.access$getDetails$p(this.this$0).getTitle();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"details.title");
                        GithubMergeCommitMessageDialog dialog2 = new GithubMergeCommitMessageDialog(project, "Merge Pull Request", string, string2);
                        return dialog2.showAndGet() ? dialog2.getMessage() : null;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }), (int)1, null);
                if (pair == null) {
                    throw (Throwable)new ProcessCanceledException();
                }
                Pair commitMessage2 = pair;
                indicator.setText2("Merging");
                GithubApiRequestExecutor githubApiRequestExecutor = GithubPullRequestsStateServiceImpl.access$getRequestExecutor$p(this.this$0);
                GithubPullRequestDetailed githubPullRequestDetailed = this.details;
                if (githubPullRequestDetailed == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                GithubPullRequest githubPullRequest = githubPullRequestDetailed;
                String string = (String)commitMessage2.getFirst();
                String string2 = (String)commitMessage2.getSecond();
                GithubPullRequestDetailed githubPullRequestDetailed2 = this.details;
                if (githubPullRequestDetailed2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                GithubPullRequest.Tag tag = githubPullRequestDetailed2.getHead();
                Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"details.head");
                String string3 = tag.getSha();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"details.head.sha");
                githubApiRequestExecutor.execute(indicator, GithubApiRequests.Repos.PullRequests.merge(githubPullRequest, string, string2, string3));
            }

            public void onSuccess() {
                Project project = this.getProject();
                StringBuilder stringBuilder = new StringBuilder().append("Successfully merged pull request #");
                GithubPullRequestDetailed githubPullRequestDetailed = this.details;
                if (githubPullRequestDetailed == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                GithubNotifications.showInfo(project, "Pull Request Merged", stringBuilder.append(githubPullRequestDetailed.getNumber()).toString());
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GithubNotifications.showError(this.getProject(), "Failed To Merge Pull Request", error);
            }

            public void onFinished() {
                GithubPullRequestsStateServiceImpl.access$releaseAndRefreshData(this.this$0, this.$pullRequest);
            }
            {
                this.this$0 = $outer;
                this.$dataProvider = $captured_local_variable$1;
                this.$pullRequest = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }

            public static final /* synthetic */ GithubPullRequestDetailed access$getDetails$p(merge.1 $this) {
                GithubPullRequestDetailed githubPullRequestDetailed = $this.details;
                if (githubPullRequestDetailed == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                return githubPullRequestDetailed;
            }

            public static final /* synthetic */ void access$setDetails$p(merge.1 $this, GithubPullRequestDetailed githubPullRequestDetailed) {
                $this.details = githubPullRequestDetailed;
            }
        });
    }

    @Override
    public void rebaseMerge(long pullRequest) {
        if (!this.busyStateTracker.acquire(pullRequest)) {
            return;
        }
        GithubPullRequestDataProvider dataProvider = this.dataLoader.getDataProvider(pullRequest);
        this.progressManager.run((Task)new Task.Backgroundable(this, dataProvider, pullRequest, this.project, "Merging Pull Request...", true){
            @NotNull
            public GithubPullRequestDetailed details;
            final /* synthetic */ GithubPullRequestsStateServiceImpl this$0;
            final /* synthetic */ GithubPullRequestDataProvider $dataProvider;
            final /* synthetic */ long $pullRequest;

            @NotNull
            public final GithubPullRequestDetailed getDetails() {
                GithubPullRequestDetailed githubPullRequestDetailed = this.details;
                if (githubPullRequestDetailed == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                return githubPullRequestDetailed;
            }

            public final void setDetails(@NotNull GithubPullRequestDetailed githubPullRequestDetailed) {
                Intrinsics.checkParameterIsNotNull((Object)githubPullRequestDetailed, (String)"<set-?>");
                this.details = githubPullRequestDetailed;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setText2("Loading details");
                T t = GithubAsyncUtil.awaitFuture(indicator, this.$dataProvider.getDetailsRequest());
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"GithubAsyncUtil.awaitFut\u2026aProvider.detailsRequest)");
                this.details = (GithubPullRequestDetailed)t;
                indicator.checkCanceled();
                indicator.setText2("Merging");
                GithubApiRequestExecutor githubApiRequestExecutor = GithubPullRequestsStateServiceImpl.access$getRequestExecutor$p(this.this$0);
                GithubPullRequestDetailed githubPullRequestDetailed = this.details;
                if (githubPullRequestDetailed == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                GithubPullRequest githubPullRequest = githubPullRequestDetailed;
                GithubPullRequestDetailed githubPullRequestDetailed2 = this.details;
                if (githubPullRequestDetailed2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                GithubPullRequest.Tag tag = githubPullRequestDetailed2.getHead();
                Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"details.head");
                String string = tag.getSha();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"details.head.sha");
                githubApiRequestExecutor.execute(indicator, GithubApiRequests.Repos.PullRequests.rebaseMerge(githubPullRequest, string));
            }

            public void onSuccess() {
                Project project = this.getProject();
                StringBuilder stringBuilder = new StringBuilder().append("Successfully rebased and merged pull request #");
                GithubPullRequestDetailed githubPullRequestDetailed = this.details;
                if (githubPullRequestDetailed == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                GithubNotifications.showInfo(project, "Pull Request Rebased and Merged", stringBuilder.append(githubPullRequestDetailed.getNumber()).toString());
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GithubNotifications.showError(this.getProject(), "Failed To Rebase and Merge Pull Request", error);
            }

            public void onFinished() {
                GithubPullRequestsStateServiceImpl.access$releaseAndRefreshData(this.this$0, this.$pullRequest);
            }
            {
                this.this$0 = $outer;
                this.$dataProvider = $captured_local_variable$1;
                this.$pullRequest = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    @Override
    public void squashMerge(long pullRequest) {
        if (!this.busyStateTracker.acquire(pullRequest)) {
            return;
        }
        GithubPullRequestDataProvider dataProvider = this.dataLoader.getDataProvider(pullRequest);
        this.progressManager.run((Task)new Task.Backgroundable(this, dataProvider, pullRequest, this.project, "Merging Pull Request...", true){
            @NotNull
            public GithubPullRequestDetailed details;
            @NotNull
            public List<? extends GithubCommit> commits;
            final /* synthetic */ GithubPullRequestsStateServiceImpl this$0;
            final /* synthetic */ GithubPullRequestDataProvider $dataProvider;
            final /* synthetic */ long $pullRequest;

            @NotNull
            public final GithubPullRequestDetailed getDetails() {
                GithubPullRequestDetailed githubPullRequestDetailed = this.details;
                if (githubPullRequestDetailed == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                return githubPullRequestDetailed;
            }

            public final void setDetails(@NotNull GithubPullRequestDetailed githubPullRequestDetailed) {
                Intrinsics.checkParameterIsNotNull((Object)githubPullRequestDetailed, (String)"<set-?>");
                this.details = githubPullRequestDetailed;
            }

            @NotNull
            public final List<GithubCommit> getCommits() {
                List<GithubCommit> list = this.commits;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"commits");
                }
                return list;
            }

            public final void setCommits(@NotNull List<? extends GithubCommit> list) {
                Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
                this.commits = list;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setText2("Loading details");
                T t = GithubAsyncUtil.awaitFuture(indicator, this.$dataProvider.getDetailsRequest());
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"GithubAsyncUtil.awaitFut\u2026aProvider.detailsRequest)");
                this.details = (GithubPullRequestDetailed)t;
                indicator.checkCanceled();
                indicator.setText2("Loading commits");
                T t2 = GithubAsyncUtil.awaitFuture(indicator, this.$dataProvider.getApiCommitsRequest());
                Intrinsics.checkExpressionValueIsNotNull(t2, (String)"GithubAsyncUtil.awaitFut\u2026ovider.apiCommitsRequest)");
                this.commits = (List)t2;
                indicator.checkCanceled();
                indicator.setText2("Acquiring commit message");
                StringBuilder stringBuilder = new StringBuilder().append("* ");
                List<? extends GithubCommit> list = this.commits;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"commits");
                }
                String body2 = stringBuilder.append(StringUtil.join((Collection)list, (Function)squashMerge.run.body.1.INSTANCE, (String)"\n\n* ")).toString();
                Pair pair = (Pair)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Pair<? extends String, ? extends String>>(this, body2){
                    final /* synthetic */ squashMerge.1 this$0;
                    final /* synthetic */ String $body;

                    @Nullable
                    public final Pair<String, String> invoke() {
                        Project project = this.this$0.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        GithubMergeCommitMessageDialog dialog2 = new GithubMergeCommitMessageDialog(project, "Merge Pull Request", "Merge pull request #" + this.this$0.$pullRequest, this.$body);
                        return dialog2.showAndGet() ? dialog2.getMessage() : null;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$body = string;
                        super(0);
                    }
                }), (int)1, null);
                if (pair == null) {
                    throw (Throwable)new ProcessCanceledException();
                }
                Pair commitMessage2 = pair;
                indicator.setText2("Merging");
                GithubApiRequestExecutor githubApiRequestExecutor = GithubPullRequestsStateServiceImpl.access$getRequestExecutor$p(this.this$0);
                GithubPullRequestDetailed githubPullRequestDetailed = this.details;
                if (githubPullRequestDetailed == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                GithubPullRequest githubPullRequest = githubPullRequestDetailed;
                String string = (String)commitMessage2.getFirst();
                String string2 = (String)commitMessage2.getSecond();
                GithubPullRequestDetailed githubPullRequestDetailed2 = this.details;
                if (githubPullRequestDetailed2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                GithubPullRequest.Tag tag = githubPullRequestDetailed2.getHead();
                Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"details.head");
                String string3 = tag.getSha();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"details.head.sha");
                githubApiRequestExecutor.execute(indicator, GithubApiRequests.Repos.PullRequests.squashMerge(githubPullRequest, string, string2, string3));
            }

            public void onSuccess() {
                Project project = this.getProject();
                StringBuilder stringBuilder = new StringBuilder().append("Successfully squashed amd merged pull request #");
                GithubPullRequestDetailed githubPullRequestDetailed = this.details;
                if (githubPullRequestDetailed == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"details");
                }
                GithubNotifications.showInfo(project, "Pull Request Squashed and Merged", stringBuilder.append(githubPullRequestDetailed.getNumber()).toString());
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                GithubNotifications.showError(this.getProject(), "Failed To Squash and Merge Pull Request", error);
            }

            public void onFinished() {
                GithubPullRequestsStateServiceImpl.access$releaseAndRefreshData(this.this$0, this.$pullRequest);
            }
            {
                this.this$0 = $outer;
                this.$dataProvider = $captured_local_variable$1;
                this.$pullRequest = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    private final void releaseAndRefreshData(long pullRequest) {
        this.busyStateTracker.release(pullRequest);
        GithubPullRequestDataProvider githubPullRequestDataProvider = this.dataLoader.findDataProvider(pullRequest);
        if (githubPullRequestDataProvider != null) {
            githubPullRequestDataProvider.reloadDetails();
        }
        this.listLoader.setOutdated(true);
    }

    public GithubPullRequestsStateServiceImpl(@NotNull Project project, @NotNull ProgressManager progressManager, @NotNull GithubPullRequestsListLoader listLoader, @NotNull GithubPullRequestsDataLoader dataLoader, @NotNull GithubPullRequestsBusyStateTracker busyStateTracker, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GithubServerPath serverPath, @NotNull GithubFullPath repoPath) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        Intrinsics.checkParameterIsNotNull((Object)listLoader, (String)"listLoader");
        Intrinsics.checkParameterIsNotNull((Object)dataLoader, (String)"dataLoader");
        Intrinsics.checkParameterIsNotNull((Object)busyStateTracker, (String)"busyStateTracker");
        Intrinsics.checkParameterIsNotNull((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)serverPath, (String)"serverPath");
        Intrinsics.checkParameterIsNotNull((Object)repoPath, (String)"repoPath");
        this.project = project;
        this.progressManager = progressManager;
        this.listLoader = listLoader;
        this.dataLoader = dataLoader;
        this.busyStateTracker = busyStateTracker;
        this.requestExecutor = requestExecutor;
        this.serverPath = serverPath;
        this.repoPath = repoPath;
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GithubPullRequestsStateServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GithubServerPath access$getServerPath$p(GithubPullRequestsStateServiceImpl $this) {
        return $this.serverPath;
    }

    public static final /* synthetic */ GithubFullPath access$getRepoPath$p(GithubPullRequestsStateServiceImpl $this) {
        return $this.repoPath;
    }

    public static final /* synthetic */ void access$releaseAndRefreshData(GithubPullRequestsStateServiceImpl $this, long pullRequest) {
        $this.releaseAndRefreshData(pullRequest);
    }
}

