/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.util;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthorization;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.api.requests.GithubRequestPagination;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u001e\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u000e\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/authentication/util/GithubTokenCreator;", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "createMaster", "Lorg/jetbrains/plugins/github/api/data/GithubAuthorization;", "noteSuffix", "", "createUniqueNote", "note", "safeCreate", "scopes", "", "Companion", "intellij.vcs.github"})
public final class GithubTokenCreator {
    private final GithubServerPath server;
    private final GithubApiRequestExecutor executor;
    private final ProgressIndicator indicator;
    private static final List<String> MASTER_SCOPES;
    @NotNull
    public static final String DEFAULT_CLIENT_NAME = "Github Integration Plugin";
    public static final Companion Companion;

    @NotNull
    public final GithubAuthorization createMaster(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String noteSuffix) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)noteSuffix, (String)"noteSuffix");
        StringBuilder stringBuilder = new StringBuilder();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        return this.safeCreate(MASTER_SCOPES, stringBuilder.append(applicationNamesInfo.getFullProductName()).append(" ").append(noteSuffix).append(" access token").toString());
    }

    private final GithubAuthorization safeCreate(List<String> scopes, String note) throws IOException {
        try {
            return this.executor.execute(this.indicator, GithubApiRequests.Auth.create(this.server, scopes, note));
        }
        catch (GithubStatusCodeException e) {
            if (e.getError() != null) {
                GithubErrorMessage githubErrorMessage = e.getError();
                if (githubErrorMessage == null) {
                    Intrinsics.throwNpe();
                }
                if (githubErrorMessage.containsErrorCode("already_exists")) {
                    String newNote = this.createUniqueNote(note);
                    return this.executor.execute(this.indicator, GithubApiRequests.Auth.create(this.server, scopes, newNote));
                }
            }
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String createUniqueNote(String note) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = GithubApiPagesLoader.loadAll(this.executor, this.indicator, GithubApiRequests.Auth.pages(this.server, new GithubRequestPagination(0, 0, 3, null)));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GithubAuthorization it = (GithubAuthorization)element$iv$iv;
            boolean bl2 = false;
            if (it.getNote() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List existingNotes = (List)destination$iv$iv;
        int index = Companion.findNextDeduplicationIndex$intellij_vcs_github(note, existingNotes);
        return index == 0 ? note : note + '_' + index;
    }

    public GithubTokenCreator(@NotNull GithubServerPath server, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        this.server = server;
        this.executor = executor;
        this.indicator = indicator;
    }

    static {
        Companion = new Companion(null);
        MASTER_SCOPES = CollectionsKt.listOf((Object[])new String[]{"repo", "gist"});
    }

    @JvmStatic
    public static final int findNextDeduplicationIndex$intellij_vcs_github(@NotNull String note, @NotNull List<String> existingNotes) {
        return Companion.findNextDeduplicationIndex$intellij_vcs_github(note, existingNotes);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0001\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/authentication/util/GithubTokenCreator$Companion;", "", "()V", "DEFAULT_CLIENT_NAME", "", "MASTER_SCOPES", "", "findNextDeduplicationIndex", "", "note", "existingNotes", "findNextDeduplicationIndex$intellij_vcs_github", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        public final int findNextDeduplicationIndex$intellij_vcs_github(@NotNull String note, @NotNull List<String> existingNotes) {
            Intrinsics.checkParameterIsNotNull((Object)note, (String)"note");
            Intrinsics.checkParameterIsNotNull(existingNotes, (String)"existingNotes");
            TreeSet<Integer> existingIndices = new TreeSet<Integer>();
            for (String existingNote : existingNotes) {
                String indexPart;
                if (!StringsKt.startsWith((String)existingNote, (String)note, (boolean)true)) continue;
                String string = existingNote;
                int n = note.length();
                int n2 = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                int index = 0;
                CharSequence charSequence = indexPart;
                n2 = 0;
                if (charSequence.length() == 0) {
                    index = 0;
                } else {
                    if (!StringsKt.startsWith$default((CharSequence)indexPart, (char)'_', (boolean)false, (int)2, null)) continue;
                    charSequence = indexPart;
                    n2 = 1;
                    boolean bl = false;
                    CharSequence charSequence2 = charSequence;
                    if (charSequence2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = ((String)charSequence2).substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    Integer n3 = StringsKt.toIntOrNull((String)string3);
                    if (n3 == null) {
                        continue;
                    }
                    index = n3;
                }
                existingIndices.add(index);
            }
            if (existingIndices.isEmpty()) {
                return 0;
            }
            int lastIndex = -1;
            for (Integer index : existingIndices) {
                if (index - lastIndex > 1) {
                    return lastIndex + 1;
                }
                Integer n = index;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"index");
                lastIndex = n;
            }
            return ((Number)existingIndices.last()).intValue() + 1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

