/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.google.common.base.Preconditions;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.RegexUtil;
import org.joni.Region;

public class MatchData {
    public static final MatchData NOT_MATCHED = new MatchData(false, Collections.emptyList());
    private final boolean matched;
    private final List<TextRange> offsets;

    private MatchData(boolean matched, List<TextRange> offsets) {
        this.matched = matched;
        this.offsets = offsets;
    }

    public static MatchData fromRegion(@Nullable Region matchedRegion) {
        if (matchedRegion != null) {
            ArrayList<TextRange> offsets = new ArrayList<TextRange>(matchedRegion.numRegs);
            for (int i = 0; i < matchedRegion.numRegs; ++i) {
                offsets.add(i, TextRange.create((int)Math.max(matchedRegion.beg[i], 0), (int)Math.max(matchedRegion.end[i], 0)));
            }
            return new MatchData(true, offsets);
        }
        return NOT_MATCHED;
    }

    public int count() {
        return this.offsets.size();
    }

    public TextRange byteOffset() {
        return this.byteOffset(0);
    }

    @NotNull
    public TextRange byteOffset(int group) {
        Preconditions.checkElementIndex((int)group, (int)this.offsets.size());
        TextRange textRange = this.offsets.get(group);
        if (textRange == null) {
            MatchData.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    public TextRange charOffset(byte[] stringBytes) {
        return this.charOffset(stringBytes, 0);
    }

    @NotNull
    public TextRange charOffset(byte[] stringBytes, int group) {
        TextRange textRange = RegexUtil.charRangeByByteRange(stringBytes, this.byteOffset(group));
        if (textRange == null) {
            MatchData.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public boolean matched() {
        return this.matched;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchData matchData = (MatchData)o;
        if (this.matched != matchData.matched) {
            return false;
        }
        return Objects.equals(this.offsets, matchData.offsets);
    }

    public int hashCode() {
        int result = this.matched ? 1 : 0;
        result = 31 * result + (this.offsets != null ? this.offsets.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{ matched=" + this.matched + ", offsets=" + this.offsets + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/textmate/regex/MatchData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "byteOffset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "charOffset";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

