/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.FramelessNotificationPopup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class NotificationPopup {
    public NotificationPopup(JComponent owner, JComponent content2, Color background) {
        this(owner, content2, background, true);
    }

    public NotificationPopup(JComponent owner, JComponent content2, Color background, boolean useDefaultPreferredSize) {
        this(owner, content2, background, useDefaultPreferredSize, null, false);
    }

    public NotificationPopup(JComponent owner, JComponent content2, Color background, final boolean useDefaultPreferredSize, ActionListener clickHandler, boolean closeOnClick) {
        IdeFrame frame = NotificationPopup.findFrame(owner);
        if (frame == null || !((Window)frame).isShowing() || frame.getBalloonLayout() == null) {
            new FramelessNotificationPopup(owner, content2, background, useDefaultPreferredSize, clickHandler);
        } else {
            NonOpaquePanel wrapper2 = new NonOpaquePanel(content2){

                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    if (useDefaultPreferredSize && (size.width > 400 || size.height > 200)) {
                        size.width = 400;
                        size.height = 200;
                    }
                    return size;
                }
            };
            Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)wrapper2).setFadeoutTime(5000L).setHideOnClickOutside(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).setCloseButtonEnabled(true).setFillColor(background).setShowCallout(false).setClickHandler(clickHandler, closeOnClick).createBalloon();
            BalloonLayout layout = frame.getBalloonLayout();
            assert (layout != null);
            layout.add(balloon);
        }
    }

    private static IdeFrame findFrame(JComponent owner) {
        Window frame = SwingUtilities.getWindowAncestor(owner);
        if (frame instanceof IdeFrame) {
            return (IdeFrame)frame;
        }
        return null;
    }

    public JBPopup getPopup() {
        return null;
    }
}

