/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ElementColorProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorPicker;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.ColorsIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class ColorLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public static final ColorLineMarkerProvider INSTANCE = new ColorLineMarkerProvider();
    private final ElementColorProvider[] myExtensions = (ElementColorProvider[])ElementColorProvider.EP_NAME.getExtensions();

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            ColorLineMarkerProvider.$$$reportNull$$$0(0);
        }
        for (ElementColorProvider colorProvider : this.myExtensions) {
            Color color = colorProvider.getColorFrom(element);
            if (color == null) continue;
            MyInfo info = new MyInfo(element, color, colorProvider);
            NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)"Choose color", null);
            return info;
        }
        return null;
    }

    public String getName() {
        return "Color preview";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Gutter.Colors;
        if (icon == null) {
            ColorLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ColorLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ColorLineMarkerProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private final Color myColor;

        MyInfo(@NotNull PsiElement element, Color color, ElementColorProvider colorProvider) {
            if (element == null) {
                MyInfo.$$$reportNull$$$0(0);
            }
            super(element, element.getTextRange(), (Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(12, color)), 11, (Function)FunctionUtil.nullConstant(), (e, elt) -> {
                if (!elt.isWritable()) {
                    return;
                }
                Editor editor = PsiUtilBase.findEditor((PsiElement)elt);
                assert (editor != null);
                if (Registry.is((String)"ide.new.color.picker")) {
                    ColorPicker.showColorPickerPopup(color, (c2, l) -> WriteAction.run(() -> colorProvider.setColorTo(elt, c2)));
                } else {
                    Color c3 = ColorChooser.chooseColor((Project)editor.getProject(), (Component)editor.getComponent(), (String)"Choose Color", (Color)color, (boolean)true);
                    if (c3 != null) {
                        WriteAction.run(() -> colorProvider.setColorTo(elt, c3));
                    }
                }
            }, GutterIconRenderer.Alignment.LEFT);
            this.myColor = color;
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (info == null) {
                MyInfo.$$$reportNull$$$0(1);
            }
            return info instanceof MyInfo;
        }

        public Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                MyInfo.$$$reportNull$$$0(2);
            }
            return JBUI.scale((JBUI.JBIcon)new ColorsIcon(12, (Color[])infos.stream().map(_info -> ((MyInfo)_info).myColor).toArray(Color[]::new)));
        }

        @NotNull
        public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
            if (infos == null) {
                MyInfo.$$$reportNull$$$0(3);
            }
            NullableFunction nullableFunction = FunctionUtil.nullConstant();
            if (nullableFunction == null) {
                MyInfo.$$$reportNull$$$0(4);
            }
            return nullableFunction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColorLineMarkerProvider$MyInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColorLineMarkerProvider$MyInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canMergeWith";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonTooltip";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

