/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.IntEnumerator;
import com.intellij.psi.stubs.LazyStubData;
import com.intellij.psi.stubs.LazyStubList;
import com.intellij.psi.stubs.MostlyUShortIntList;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RecentStringInterner;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentStringEnumerator;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubSerializationHelper {
    private static final Logger LOG = Logger.getInstance(StubSerializationHelper.class);
    private final PersistentStringEnumerator myNameStorage;
    private final TIntObjectHashMap<String> myIdToName;
    private final TObjectIntHashMap<String> myNameToId;
    private final THashMap<String, Computable<ObjectStubSerializer>> myNameToLazySerializer;
    private final ConcurrentIntObjectMap<ObjectStubSerializer> myIdToSerializer;
    private final Map<ObjectStubSerializer, Integer> mySerializerToId;
    private final boolean myUnmodifiable;
    private final RecentStringInterner myStringInterner;
    private static final ThreadLocal<ObjectStubSerializer> ourRootStubSerializer = new ThreadLocal();

    StubSerializationHelper(@NotNull PersistentStringEnumerator nameStorage, boolean unmodifiable, @NotNull Disposable parentDisposable) {
        if (nameStorage == null) {
            StubSerializationHelper.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            StubSerializationHelper.$$$reportNull$$$0(1);
        }
        this.myIdToName = new TIntObjectHashMap();
        this.myNameToId = new TObjectIntHashMap();
        this.myNameToLazySerializer = new THashMap();
        this.myIdToSerializer = ContainerUtil.createConcurrentIntObjectMap();
        this.mySerializerToId = ContainerUtil.newConcurrentMap();
        this.myNameStorage = nameStorage;
        this.myUnmodifiable = unmodifiable;
        this.myStringInterner = new RecentStringInterner(parentDisposable);
    }

    void assignId(@NotNull Computable<ObjectStubSerializer> serializer, String name) throws IOException {
        int id;
        Computable old;
        if (serializer == null) {
            StubSerializationHelper.$$$reportNull$$$0(2);
        }
        if ((old = (Computable)this.myNameToLazySerializer.put((Object)name, serializer)) != null) {
            ObjectStubSerializer computed;
            ObjectStubSerializer existing = (ObjectStubSerializer)old.compute();
            if (existing != (computed = (ObjectStubSerializer)serializer.compute())) {
                throw new AssertionError((Object)("ID: " + name + " is not unique, but found in both " + existing.getClass().getName() + " and " + computed.getClass().getName()));
            }
            return;
        }
        if (this.myUnmodifiable) {
            id = this.myNameStorage.tryEnumerate((Object)name);
            if (id == 0) {
                LOG.info("serialized " + name + " is ignored in unmodifiable stub serialization manager");
                return;
            }
        } else {
            id = this.myNameStorage.enumerate(name);
        }
        this.myIdToName.put(id, (Object)name);
        this.myNameToId.put((Object)name, id);
    }

    void copyFrom(@Nullable StubSerializationHelper helper) throws IOException {
        if (helper == null) {
            return;
        }
        for (String name : helper.myNameToLazySerializer.keySet()) {
            this.assignId((Computable<ObjectStubSerializer>)((Computable)helper.myNameToLazySerializer.get((Object)name)), name);
        }
    }

    private ObjectStubSerializer<Stub, Stub> writeSerializerId(Stub stub, @NotNull DataOutput stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(3);
        }
        ObjectStubSerializer serializer = StubSerializationUtil.getSerializer((Stub)stub);
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)serializerLocalEnumerator.enumerate(this.getClassId(serializer)));
        return serializer;
    }

    private void serializeSelf(Stub stub, @NotNull StubOutputStream stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(4);
        }
        if (((ObjectStubBase)stub).isDangling()) {
            stream.writeByte(0);
        }
        this.writeSerializerId(stub, (DataOutput)stream, serializerLocalEnumerator).serialize(stub, stream);
    }

    private void serializeChildren(@NotNull Stub parent, @NotNull StubOutputStream stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (parent == null) {
            StubSerializationHelper.$$$reportNull$$$0(5);
        }
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(6);
        }
        List children2 = parent.getChildrenStubs();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)children2.size());
        for (Stub child2 : children2) {
            this.serializeSelf(child2, stream, serializerLocalEnumerator);
            this.serializeChildren(child2, stream, serializerLocalEnumerator);
        }
    }

    void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        if (rootStub == null) {
            StubSerializationHelper.$$$reportNull$$$0(7);
        }
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(8);
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(true);
        IntEnumerator selializerIdLocalEnumerator = new IntEnumerator();
        StubOutputStream stubOutputStream = new StubOutputStream((OutputStream)out, (AbstractStringEnumerator)storage);
        boolean doDefaultSerialization = true;
        if (rootStub instanceof PsiFileStubImpl) {
            PsiFileStub[] roots = ((PsiFileStubImpl)rootStub).getStubRoots();
            if (roots.length == 0) {
                Logger.getInstance(this.getClass()).error("Incorrect stub files count during serialization:" + rootStub + "," + rootStub.getStubType());
            } else {
                doDefaultSerialization = false;
                DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)roots.length);
                for (PsiFileStub root : roots) {
                    this.serializeRoot(stubOutputStream, (Stub)root, storage, selializerIdLocalEnumerator);
                }
            }
        }
        if (doDefaultSerialization) {
            DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)1);
            this.serializeRoot(stubOutputStream, rootStub, storage, selializerIdLocalEnumerator);
        }
        DataOutputStream resultStream = new DataOutputStream(stream);
        selializerIdLocalEnumerator.dump(resultStream);
        storage.write(resultStream);
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    private int getClassId(ObjectStubSerializer serializer) {
        Integer idValue = this.mySerializerToId.get(serializer);
        if (idValue == null) {
            String name = serializer.getExternalId();
            idValue = this.myNameToId.get((Object)name);
            assert (idValue > 0) : "No ID found for serializer " + LogUtil.objectAndClass((Object)serializer) + ", external id:" + name + (serializer instanceof IElementType ? ", language:" + ((IElementType)serializer).getLanguage() + ", " + serializer : "");
            this.mySerializerToId.put(serializer, idValue);
        }
        return idValue;
    }

    @NotNull
    Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        PsiFileStub[] stubsArray;
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(9);
        }
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(false);
        StubInputStream inputStream = new StubInputStream(stream, (AbstractStringEnumerator)storage);
        IntEnumerator serializerLocalEnumerator = IntEnumerator.read((DataInputStream)inputStream);
        this.readEnumeratedStrings(storage, (DataInputStream)inputStream);
        int stubFilesCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (stubFilesCount <= 0) {
            Logger.getInstance(this.getClass()).error("Incorrect stub files count during deserialization:" + stubFilesCount);
        }
        Stub baseStub = this.deserializeRoot(inputStream, storage, serializerLocalEnumerator);
        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubFilesCount);
        if (baseStub instanceof PsiFileStub) {
            stubs.add((PsiFileStub)baseStub);
        }
        for (int j = 1; j < stubFilesCount; ++j) {
            Stub deserialize2 = this.deserializeRoot(inputStream, storage, serializerLocalEnumerator);
            if (deserialize2 instanceof PsiFileStub) {
                PsiFileStub fileStub = (PsiFileStub)deserialize2;
                stubs.add(fileStub);
                continue;
            }
            Logger.getInstance(this.getClass()).error("Stub root must be PsiFileStub for files with several stub roots");
        }
        for (PsiFileStub stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
            if (!(stub instanceof PsiFileStubImpl)) continue;
            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
        }
        Stub stub = baseStub;
        if (stub == null) {
            StubSerializationHelper.$$$reportNull$$$0(10);
        }
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stub deserializeRoot(StubInputStream inputStream, FileLocalStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        ObjectStubSerializer<?, Stub> serializer = this.getClassById(DataInputOutputUtil.readINT((DataInput)inputStream), null, serializerLocalEnumerator);
        ourRootStubSerializer.set(serializer);
        try {
            Stub stub = serializer.deserialize(inputStream, null);
            if (stub instanceof StubBase) {
                this.deserializeStubList((StubBase)stub, serializer, inputStream, storage, serializerLocalEnumerator);
            } else {
                this.deserializeChildren(inputStream, stub, serializerLocalEnumerator);
            }
            Stub stub2 = stub;
            return stub2;
        }
        finally {
            ourRootStubSerializer.set(null);
        }
    }

    private void serializeRoot(StubOutputStream out, Stub root, AbstractStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException {
        this.serializeSelf(root, out, serializerLocalEnumerator);
        if (root instanceof StubBase) {
            StubList stubList = ((StubBase)root).myStubList;
            if (root != stubList.get(0)) {
                throw new IllegalArgumentException("Serialization is supported only for root stubs");
            }
            this.serializeStubList(stubList, (DataOutput)out, storage, serializerLocalEnumerator);
        } else {
            this.serializeChildren(root, out, serializerLocalEnumerator);
        }
    }

    private void deserializeStubList(StubBase<?> root, final ObjectStubSerializer rootType, final StubInputStream inputStream, FileLocalStringEnumerator storage, final IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        int stubCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        final LazyStubList stubList = new LazyStubList(stubCount, root, rootType);
        final MostlyUShortIntList parentsAndStarts = new MostlyUShortIntList(stubCount * 2);
        final BitSet allStarts = new BitSet();
        new Object(){
            int currentIndex = 1;

            private void deserializeStub(int parentIndex) throws IOException, SerializerNotFoundException {
                int index = this.currentIndex++;
                int serializerId = DataInputOutputUtil.readINT((DataInput)inputStream);
                int start2 = DataInputOutputUtil.readINT((DataInput)inputStream);
                allStarts.set(start2);
                this.addStub(parentIndex, index, start2, (IElementType)StubSerializationHelper.this.getClassById(serializerId, null, serializerLocalEnumerator));
                this.deserializeChildren(index);
            }

            private void addStub(int parentIndex, int index, int start2, IElementType type) {
                parentsAndStarts.add(parentIndex);
                parentsAndStarts.add(start2);
                stubList.addLazyStub(type, index, parentIndex);
            }

            private void deserializeChildren(int parentIndex) throws IOException, SerializerNotFoundException {
                int childrenCount = DataInputOutputUtil.readINT((DataInput)inputStream);
                stubList.prepareForChildren(parentIndex, childrenCount);
                for (int i = 0; i < childrenCount; ++i) {
                    this.deserializeStub(parentIndex);
                }
            }

            void deserializeRoot() throws IOException, SerializerNotFoundException {
                this.addStub(0, 0, 0, (IElementType)rootType);
                this.deserializeChildren(0);
            }
        }.deserializeRoot();
        byte[] serializedStubs = this.readByteArray(inputStream);
        stubList.setStubData(new LazyStubData(storage, parentsAndStarts, serializedStubs, allStarts));
    }

    private void serializeStubList(StubList stubList, DataOutput out, AbstractStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (!stubList.isChildrenLayoutOptimal()) {
            throw new IllegalArgumentException("Manually assembled stubs should be normalized before serialization, consider wrapping them into StubTree");
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.size());
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.getChildrenCount(0));
        BufferExposingByteArrayOutputStream tempBuffer = new BufferExposingByteArrayOutputStream();
        ByteArrayInterner interner = new ByteArrayInterner();
        for (int i = 1; i < stubList.size(); ++i) {
            StubBase stub = (StubBase)stubList.get(i);
            ObjectStubSerializer<Stub, Stub> serializer = this.writeSerializerId((Stub)stub, out, serializerLocalEnumerator);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)interner.internBytes(StubSerializationHelper.serializeStub(serializer, storage, stub, tempBuffer)));
            DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.getChildrenCount(stub.id));
        }
        StubSerializationHelper.writeByteArray(out, interner.joinedBuffer.getInternalBuffer(), interner.joinedBuffer.size());
    }

    private static byte[] serializeStub(ObjectStubSerializer<Stub, Stub> serializer, AbstractStringEnumerator storage, StubBase<?> stub, BufferExposingByteArrayOutputStream tempBuffer) throws IOException {
        tempBuffer.reset();
        StubOutputStream stubOut = new StubOutputStream((OutputStream)tempBuffer, storage);
        serializer.serialize(stub, stubOut);
        if (stub.isDangling()) {
            stubOut.writeByte(0);
        }
        return tempBuffer.size() == 0 ? ArrayUtilRt.EMPTY_BYTE_ARRAY : tempBuffer.toByteArray();
    }

    private byte[] readByteArray(StubInputStream inputStream) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (length == 0) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] array = new byte[length];
        int read2 = inputStream.read(array);
        if (read2 != array.length) {
            Logger.getInstance(this.getClass()).error("Serialized array length mismatch");
        }
        return array;
    }

    private static void writeByteArray(DataOutput out, byte[] array, int len) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)len);
        out.write(array, 0, len);
    }

    String intern(String str) {
        return this.myStringInterner.get(str);
    }

    private ObjectStubSerializer<?, Stub> getClassById(int localId, @Nullable Stub parentStub, IntEnumerator enumerator) throws SerializerNotFoundException {
        int id = enumerator.valueOf(localId);
        ObjectStubSerializer serializer = (ObjectStubSerializer)this.myIdToSerializer.get(id);
        if (serializer == null) {
            serializer = this.instantiateSerializer(id, parentStub);
            this.myIdToSerializer.put(id, (Object)serializer);
        }
        return serializer;
    }

    @NotNull
    private ObjectStubSerializer instantiateSerializer(int id, @Nullable Stub parentStub) throws SerializerNotFoundException {
        ObjectStubSerializer serializer;
        String name = (String)this.myIdToName.get(id);
        Computable lazy = name == null ? null : (Computable)this.myNameToLazySerializer.get((Object)name);
        ObjectStubSerializer objectStubSerializer = serializer = lazy == null ? null : (ObjectStubSerializer)lazy.compute();
        if (serializer == null) {
            throw this.reportMissingSerializer(id, parentStub);
        }
        ObjectStubSerializer objectStubSerializer2 = serializer;
        if (objectStubSerializer2 == null) {
            StubSerializationHelper.$$$reportNull$$$0(11);
        }
        return objectStubSerializer2;
    }

    private SerializerNotFoundException reportMissingSerializer(int id, @Nullable Stub parentStub) {
        String externalId = null;
        try {
            externalId = this.myNameStorage.valueOf(id);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SerializerNotFoundException(StubSerializationHelper.brokenStubFormat(ourRootStubSerializer.get()) + "Internal details, no serializer registered for stub: ID=" + id + ", externalId:" + externalId + "; parent stub class=" + (parentStub != null ? parentStub.getClass().getName() + ", parent stub type:" + parentStub.getStubType() : "null"));
    }

    static String brokenStubFormat(ObjectStubSerializer root) {
        return "Broken stub format, most likely version of " + root + " was not updated after serialization changes\n";
    }

    private void deserializeChildren(StubInputStream stream, Stub parent, IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        int childCount = DataInputOutputUtil.readINT((DataInput)stream);
        for (int i = 0; i < childCount; ++i) {
            boolean dangling = false;
            int id = DataInputOutputUtil.readINT((DataInput)stream);
            if (id == 0) {
                dangling = true;
                id = DataInputOutputUtil.readINT((DataInput)stream);
            }
            Stub child2 = this.getClassById(id, parent, serializerLocalEnumerator).deserialize(stream, parent);
            if (dangling) {
                ((ObjectStubBase)child2).markDangling();
            }
            this.deserializeChildren(stream, child2, serializerLocalEnumerator);
        }
    }

    private void readEnumeratedStrings(FileLocalStringEnumerator enumerator, @NotNull DataInputStream stream) throws IOException {
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(12);
        }
        int numberOfStrings = DataInputOutputUtil.readINT((DataInput)stream);
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        enumerator.myStrings.ensureCapacity(numberOfStrings);
        for (int i = 0; i < numberOfStrings; ++i) {
            String s = this.intern(IOUtil.readUTFFast((byte[])buffer, (DataInput)stream));
            enumerator.myStrings.add(s);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStorage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubSerializationHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubSerializationHelper";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assignId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSerializerId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serializeSelf";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializeChildren";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readEnumeratedStrings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileLocalStringEnumerator
    implements AbstractStringEnumerator {
        private final TObjectIntHashMap<String> myEnumerates;
        private final ArrayList<String> myStrings = new ArrayList();

        FileLocalStringEnumerator(boolean forSavingStub) {
            this.myEnumerates = forSavingStub ? new TObjectIntHashMap() : null;
        }

        public int enumerate(@Nullable String value) {
            if (value == null) {
                return 0;
            }
            assert (this.myEnumerates != null);
            int i = this.myEnumerates.get((Object)value);
            if (i == 0) {
                i = this.myStrings.size() + 1;
                this.myEnumerates.put((Object)value, i);
                this.myStrings.add(value);
            }
            return i;
        }

        public String valueOf(int idx) {
            if (idx == 0) {
                return null;
            }
            return this.myStrings.get(idx - 1);
        }

        private void write(@NotNull DataOutputStream stream) throws IOException {
            if (stream == null) {
                FileLocalStringEnumerator.$$$reportNull$$$0(0);
            }
            assert (this.myEnumerates != null);
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.myStrings.size());
            byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
            for (String s : this.myStrings) {
                IOUtil.writeUTFFast((byte[])buffer, (DataOutput)stream, (String)s);
            }
        }

        public void markCorrupted() {
        }

        public void close() throws IOException {
        }

        public boolean isDirty() {
            return false;
        }

        public void force() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/psi/stubs/StubSerializationHelper$FileLocalStringEnumerator", "write"));
        }
    }

    private static class ByteArrayInterner {
        private static final TObjectHashingStrategy<byte[]> BYTE_ARRAY_STRATEGY = new TObjectHashingStrategy<byte[]>(){

            public int computeHashCode(byte[] object) {
                return Arrays.hashCode(object);
            }

            public boolean equals(byte[] o1, byte[] o2) {
                return Arrays.equals(o1, o2);
            }
        };
        private final TObjectIntHashMap<byte[]> arrayToStart = new TObjectIntHashMap(BYTE_ARRAY_STRATEGY);
        final BufferExposingByteArrayOutputStream joinedBuffer = new BufferExposingByteArrayOutputStream();

        private ByteArrayInterner() {
        }

        int internBytes(byte[] bytes) {
            if (bytes.length == 0) {
                return 0;
            }
            int start2 = this.arrayToStart.get((Object)bytes);
            if (start2 == 0) {
                start2 = this.joinedBuffer.size() + 1;
                this.arrayToStart.put((Object)bytes, start2);
                this.joinedBuffer.write(bytes, 0, bytes.length);
            }
            return start2;
        }
    }
}

