/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.stubs.IndexedStubs;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTree;
import com.intellij.util.CompressionUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Map;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializedStubTree {
    private static final Logger LOG = Logger.getInstance(SerializedStubTree.class);
    private static final ThreadLocalCachedValue<MessageDigest> HASHER = new ThreadLocalCachedValue<MessageDigest>(){

        @NotNull
        protected MessageDigest create() {
            MessageDigest messageDigest = DigestUtil.sha256();
            if (messageDigest == null) {
                1.$$$reportNull$$$0(0);
            }
            return messageDigest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/SerializedStubTree$1", "create"));
        }
    };
    private final byte[] myBytes;
    private final int myLength;
    private Stub myStubElement;
    private IndexedStubs myIndexedStubs;

    public SerializedStubTree(byte[] bytes, int length, @Nullable Stub stubElement) {
        this.myBytes = bytes;
        this.myLength = length;
        this.myStubElement = stubElement;
    }

    public SerializedStubTree(DataInput in) throws IOException {
        if (PersistentHashMapValueStorage.COMPRESSION_ENABLED) {
            int serializedStubsLength = DataInputOutputUtil.readINT((DataInput)in);
            byte[] bytes = new byte[serializedStubsLength];
            in.readFully(bytes);
            this.myBytes = bytes;
            this.myLength = this.myBytes.length;
        } else {
            this.myBytes = CompressionUtil.readCompressed((DataInput)in);
            this.myLength = this.myBytes.length;
        }
    }

    public void write(DataOutput out) throws IOException {
        if (PersistentHashMapValueStorage.COMPRESSION_ENABLED) {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myLength);
            out.write(this.myBytes, 0, this.myLength);
        } else {
            CompressionUtil.writeCompressed((DataOutput)out, (byte[])this.myBytes, (int)0, (int)this.myLength);
        }
    }

    @NotNull
    public Stub getStub(boolean willIndexStub) throws SerializerNotFoundException {
        Stub stub = this.getStub(willIndexStub, SerializationManagerEx.getInstanceEx());
        if (stub == null) {
            SerializedStubTree.$$$reportNull$$$0(0);
        }
        return stub;
    }

    @NotNull
    public Stub getStub(boolean willIndexStub, @NotNull SerializationManagerEx serializationManager) throws SerializerNotFoundException {
        Stub stubElement;
        if (serializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(1);
        }
        if ((stubElement = this.myStubElement) != null) {
            this.myStubElement = null;
            if (willIndexStub) {
                Stub stub = stubElement;
                if (stub == null) {
                    SerializedStubTree.$$$reportNull$$$0(2);
                }
                return stub;
            }
        }
        Stub stub = serializationManager.deserialize((InputStream)new UnsyncByteArrayInputStream(this.myBytes));
        if (stub == null) {
            SerializedStubTree.$$$reportNull$$$0(3);
        }
        return stub;
    }

    void indexTree() throws SerializerNotFoundException {
        ObjectStubBase root = (ObjectStubBase)this.getStub(true);
        ObjectStubTree objectStubTree = root instanceof PsiFileStub ? new StubTree((PsiFileStub)root, false) : new ObjectStubTree(root, false);
        Map<StubIndexKey, Map<Object, StubIdList>> map2 = objectStubTree.indexStubTree();
        for (StubIndexKey key : map2.keySet()) {
            Map<Object, int[]> value = map2.get(key);
            for (Object k : value.keySet()) {
                int[] ints = value.get(k);
                StubIdList stubList = ints.length == 1 ? new StubIdList(ints[0]) : new StubIdList(ints, ints.length);
                value.put(k, (int[])stubList);
            }
        }
        this.myIndexedStubs = new IndexedStubs(SerializedStubTree.calculateHash(this.myBytes), map2);
    }

    @NotNull
    IndexedStubs getIndexedStubs() {
        IndexedStubs indexedStubs = this.myIndexedStubs;
        if (indexedStubs == null) {
            SerializedStubTree.$$$reportNull$$$0(4);
        }
        return indexedStubs;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof SerializedStubTree)) {
            return false;
        }
        SerializedStubTree thatTree = (SerializedStubTree)that;
        int length = this.myLength;
        if (length != thatTree.myLength) {
            return false;
        }
        byte[] thisBytes = this.myBytes;
        byte[] thatBytes = thatTree.myBytes;
        for (int i = 0; i < length; ++i) {
            if (thisBytes[i] == thatBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.myBytes == null) {
            return 0;
        }
        int result2 = 1;
        for (int i = 0; i < this.myLength; ++i) {
            result2 = 31 * result2 + this.myBytes[i];
        }
        return result2;
    }

    @NotNull
    private String dumpStub() {
        String deserialized;
        try {
            deserialized = "stub: " + DebugUtil.stubTreeToString(this.getStub(true));
        }
        catch (SerializerNotFoundException e) {
            LOG.error((Throwable)e);
            deserialized = "error while stub deserialization: " + e.getMessage();
        }
        String string = deserialized + "\n bytes: " + SerializedStubTree.toHexString(this.myBytes, this.myLength);
        if (string == null) {
            SerializedStubTree.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static byte[] calculateHash(@NotNull byte[] content2) {
        if (content2 == null) {
            SerializedStubTree.$$$reportNull$$$0(6);
        }
        MessageDigest digest = (MessageDigest)HASHER.getValue();
        digest.update(content2);
        byte[] byArray = digest.digest();
        if (byArray == null) {
            SerializedStubTree.$$$reportNull$$$0(7);
        }
        return byArray;
    }

    static void reportStubTreeHashCollision(@NotNull SerializedStubTree newTree, @NotNull SerializedStubTree existingTree, @NotNull byte[] hash) {
        if (newTree == null) {
            SerializedStubTree.$$$reportNull$$$0(8);
        }
        if (existingTree == null) {
            SerializedStubTree.$$$reportNull$$$0(9);
        }
        if (hash == null) {
            SerializedStubTree.$$$reportNull$$$0(10);
        }
        String oldTreeDump = "\nexisting tree " + existingTree.dumpStub();
        String newTreeDump = "\nnew tree " + newTree.dumpStub();
        LOG.info("Stub tree hashing collision. Different trees have the same hash = " + SerializedStubTree.toHexString(hash, hash.length) + ". Hashing algorithm = " + ((MessageDigest)HASHER.getValue()).getAlgorithm() + "." + oldTreeDump + newTreeDump, (Throwable)new Exception());
    }

    private static String toHexString(byte[] hash, int length) {
        return IntStreamEx.of((byte[])hash).limit((long)length).mapToObj(b -> String.format("%02x", b & 0xFF)).joining();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/SerializedStubTree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingTree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStub";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/SerializedStubTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedStubs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStub";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateHash";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStub";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateHash";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportStubTreeHashCollision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

