/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileSystemBase
extends LocalFileSystem {
    protected static final Logger LOG = Logger.getInstance(LocalFileSystemBase.class);
    private static final FileAttributes FAKE_ROOT_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false);
    private final List<LocalFileOperationsHandler> myHandlers = new ArrayList<LocalFileOperationsHandler>();
    private static final List<String> ourRootPaths = StringUtil.split((String)System.getProperty("idea.persistentfs.roots", ""), (String)File.pathSeparator);

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            LocalFileSystemBase.$$$reportNull$$$0(0);
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            LocalFileSystemBase.$$$reportNull$$$0(1);
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            LocalFileSystemBase.$$$reportNull$$$0(2);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByIoFile(@NotNull File file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(3);
        }
        return this.findFileByPath(FileUtil.toSystemIndependentName((String)file2.getAbsolutePath()));
    }

    @NotNull
    private static File convertToIOFile(@NotNull VirtualFile file2) {
        String path;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(4);
        }
        if (StringUtil.endsWithChar((CharSequence)(path = file2.getPath()), (char)':') && path.length() == 2 && SystemInfo.isWindows) {
            path = path + "/";
        }
        File file3 = new File(path);
        if (file3 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(5);
        }
        return file3;
    }

    @NotNull
    private static File convertToIOFileAndCheck(@NotNull VirtualFile file2) throws FileNotFoundException {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(6);
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (SystemInfo.isUnix && (attributes = FileSystemUtil.getAttributes((File)ioFile)) != null && !attributes.isFile()) {
            throw new FileNotFoundException("Not a file: " + ioFile + " (type=" + attributes.type + ')');
        }
        File file3 = ioFile;
        if (file3 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(7);
        }
        return file3;
    }

    public boolean exists(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(8);
        }
        return this.getAttributes(file2) != null;
    }

    public long getLength(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(9);
        }
        return (attributes = this.getAttributes(file2)) != null ? attributes.length : 0L;
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(10);
        }
        return (attributes = this.getAttributes(file2)) != null ? attributes.lastModified : 0L;
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(11);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(12);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isWritable();
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(13);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isSymLink();
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(14);
        }
        return FileSystemUtil.resolveSymLink((String)file2.getPath());
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file2) {
        String[] names2;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(15);
        }
        if (file2.getParent() == null) {
            File[] roots = File.listRoots();
            if (roots.length == 1 && roots[0].getName().isEmpty()) {
                String[] list2 = roots[0].list();
                if (list2 != null) {
                    if (list2 == null) {
                        LocalFileSystemBase.$$$reportNull$$$0(16);
                    }
                    return list2;
                }
                LOG.warn("Root '" + roots[0] + "' has no children - is it readable?");
                if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                    LocalFileSystemBase.$$$reportNull$$$0(17);
                }
                return ArrayUtilRt.EMPTY_STRING_ARRAY;
            }
            if (file2.getName().isEmpty()) {
                String[] names3 = new String[roots.length];
                for (int i = 0; i < names3.length; ++i) {
                    String name = roots[i].getPath();
                    names3[i] = name = StringUtil.trimTrailing((String)name, (char)File.separatorChar);
                }
                if (names3 == null) {
                    LocalFileSystemBase.$$$reportNull$$$0(18);
                }
                return names3;
            }
        }
        String[] stringArray = (names2 = LocalFileSystemBase.convertToIOFile(file2).list()) == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : names2;
        if (stringArray == null) {
            LocalFileSystemBase.$$$reportNull$$$0(19);
        }
        return stringArray;
    }

    @NotNull
    public String getProtocol() {
        if ("file" == null) {
            LocalFileSystemBase.$$$reportNull$$$0(20);
        }
        return "file";
    }

    public boolean isReadOnly() {
        return false;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        if (path == null) {
            LocalFileSystemBase.$$$reportNull$$$0(21);
        }
        if (path.isEmpty()) {
            try {
                path = new File("").getCanonicalPath();
            }
            catch (IOException e) {
                return path;
            }
        }
        if (SystemInfo.isWindows) {
            if (path.charAt(0) == '/' && !path.startsWith("//")) {
                path = path.substring(1);
            }
            try {
                path = FileUtil.resolveShortWindowsName((String)path);
            }
            catch (IOException e) {
                return null;
            }
        }
        File file2 = new File(path);
        if (!LocalFileSystemBase.isAbsoluteFileOrDriveLetter(file2)) {
            path = file2.getAbsolutePath();
        }
        return FileUtil.normalize((String)path);
    }

    private static boolean isAbsoluteFileOrDriveLetter(@NotNull File file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(22);
        }
        String path = file2.getPath();
        if (SystemInfo.isWindows && path.length() == 2 && path.charAt(1) == ':') {
            return true;
        }
        return file2.isAbsolute();
    }

    public VirtualFile refreshAndFindFileByIoFile(@NotNull File file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(23);
        }
        String path = FileUtil.toSystemIndependentName((String)file2.getAbsolutePath());
        return this.refreshAndFindFileByPath(path);
    }

    public void refreshIoFiles(@NotNull Iterable<? extends File> files2) {
        if (files2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(24);
        }
        this.refreshIoFiles(files2, false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIoFiles(@NotNull Iterable<? extends File> files2, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        boolean fireCommonRefreshSession;
        if (files2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(25);
        }
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        Application app = ApplicationManager.getApplication();
        boolean bl = fireCommonRefreshSession = app.isDispatchThread() || app.isWriteAccessAllowed();
        if (fireCommonRefreshSession) {
            manager.fireBeforeRefreshStart(false);
        }
        try {
            ArrayList<VirtualFile> filesToRefresh = new ArrayList<VirtualFile>();
            for (File file2 : files2) {
                VirtualFile virtualFile = this.refreshAndFindFileByIoFile(file2);
                if (virtualFile == null) continue;
                filesToRefresh.add(virtualFile);
            }
            RefreshQueue.getInstance().refresh(async, recursive, onFinish, filesToRefresh);
        }
        finally {
            if (fireCommonRefreshSession) {
                manager.fireAfterRefreshFinish(false);
            }
        }
    }

    public void refreshFiles(@NotNull Iterable<? extends VirtualFile> files2) {
        if (files2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(26);
        }
        this.refreshFiles(files2, false, false, null);
    }

    public void refreshFiles(@NotNull Iterable<? extends VirtualFile> files2, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        if (files2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(27);
        }
        RefreshQueue.getInstance().refresh(async, recursive, onFinish, ContainerUtil.toCollection(files2));
    }

    public void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler2) {
        if (handler2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(28);
        }
        if (this.myHandlers.contains(handler2)) {
            LOG.error("Handler " + handler2 + " already registered.");
        }
        this.myHandlers.add(handler2);
    }

    public void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler2) {
        if (handler2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(29);
        }
        if (!this.myHandlers.remove(handler2)) {
            LOG.error("Handler " + handler2 + " haven't been registered or already unregistered.");
        }
    }

    private boolean auxDelete(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(30);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.delete(file2)) continue;
            return true;
        }
        return false;
    }

    private boolean auxMove(@NotNull VirtualFile file2, @NotNull VirtualFile toDir) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(31);
        }
        if (toDir == null) {
            LocalFileSystemBase.$$$reportNull$$$0(32);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.move(file2, toDir)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCopy(@NotNull VirtualFile file2, @NotNull VirtualFile toDir, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(33);
        }
        if (toDir == null) {
            LocalFileSystemBase.$$$reportNull$$$0(34);
        }
        if (copyName == null) {
            LocalFileSystemBase.$$$reportNull$$$0(35);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            File copy = handler2.copy(file2, toDir, copyName);
            if (copy == null) continue;
            return true;
        }
        return false;
    }

    private boolean auxRename(@NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(36);
        }
        if (newName == null) {
            LocalFileSystemBase.$$$reportNull$$$0(37);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.rename(file2, newName)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateFile(@NotNull VirtualFile dir, @NotNull String name) throws IOException {
        if (dir == null) {
            LocalFileSystemBase.$$$reportNull$$$0(38);
        }
        if (name == null) {
            LocalFileSystemBase.$$$reportNull$$$0(39);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.createFile(dir, name)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateDirectory(@NotNull VirtualFile dir, @NotNull String name) throws IOException {
        if (dir == null) {
            LocalFileSystemBase.$$$reportNull$$$0(40);
        }
        if (name == null) {
            LocalFileSystemBase.$$$reportNull$$$0(41);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.createDirectory(dir, name)) continue;
            return true;
        }
        return false;
    }

    private void auxNotifyCompleted(@NotNull ThrowableConsumer<LocalFileOperationsHandler, IOException> consumer) {
        if (consumer == null) {
            LocalFileSystemBase.$$$reportNull$$$0(42);
        }
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            handler2.afterDone(consumer);
        }
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        File ioDir;
        if (parent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(43);
        }
        if (dir == null) {
            LocalFileSystemBase.$$$reportNull$$$0(44);
        }
        if (!this.isValidName(dir)) {
            throw new IOException(VfsBundle.message((String)"directory.invalid.name.error", (Object[])new Object[]{dir}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (parent.findChild(dir) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + dir}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        if (!(this.auxCreateDirectory(parent, dir) || (ioDir = new File(ioParent, dir)).mkdirs() || ioDir.isDirectory())) {
            throw new IOException(VfsBundle.message((String)"new.directory.failed.error", (Object[])new Object[]{ioDir.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.createDirectory(parent, dir)));
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(parent, dir);
        if (fakeVirtualFile == null) {
            LocalFileSystemBase.$$$reportNull$$$0(45);
        }
        return fakeVirtualFile;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        File ioFile;
        if (parent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(46);
        }
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(47);
        }
        if (!this.isValidName(file2)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{file2}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (parent.findChild(file2) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + file2}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        if (!this.auxCreateFile(parent, file2) && !FileUtil.createIfDoesntExist((File)(ioFile = new File(ioParent, file2)))) {
            throw new IOException(VfsBundle.message((String)"new.file.failed.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.createFile(parent, file2)));
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(parent, file2);
        if (fakeVirtualFile == null) {
            LocalFileSystemBase.$$$reportNull$$$0(48);
        }
        return fakeVirtualFile;
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        File ioFile;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(49);
        }
        if (file2.getParent() == null) {
            throw new IOException(VfsBundle.message((String)"cannot.delete.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!this.auxDelete(file2) && !FileUtil.delete((File)(ioFile = LocalFileSystemBase.convertToIOFile(file2)))) {
            throw new IOException(VfsBundle.message((String)"delete.failed.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.delete(file2)));
    }

    public boolean isCaseSensitive() {
        return SystemInfo.isFileSystemCaseSensitive;
    }

    public boolean isValidName(@NotNull String name) {
        if (name == null) {
            LocalFileSystemBase.$$$reportNull$$$0(50);
        }
        return PathUtilRt.isValidFileName((String)name, (boolean)false);
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(51);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file2)));
        if (bufferedInputStream == null) {
            LocalFileSystemBase.$$$reportNull$$$0(52);
        }
        return bufferedInputStream;
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        byte[] byArray;
        block15: {
            if (file2 == null) {
                LocalFileSystemBase.$$$reportNull$$$0(53);
            }
            try (FileInputStream stream = new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file2));){
                long l = file2.getLength();
                if (l >= (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                    throw new FileTooBigException(file2.getPath());
                }
                int length = (int)l;
                if (length < 0) {
                    throw new IOException("Invalid file length: " + length + ", " + file2);
                }
                byArray = LocalFileSystemBase.loadBytes(length <= 8192 ? stream : new BufferedInputStream(stream), length);
                if (byArray != null) break block15;
            }
            LocalFileSystemBase.$$$reportNull$$$0(54);
        }
        return byArray;
    }

    @NotNull
    private static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int count;
        int n;
        if (stream == null) {
            LocalFileSystemBase.$$$reportNull$$$0(55);
        }
        byte[] bytes = new byte[length];
        for (count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (count < length) {
            byte[] byArray = Arrays.copyOf(bytes, count);
            if (byArray == null) {
                LocalFileSystemBase.$$$reportNull$$$0(56);
            }
            return byArray;
        }
        if (bytes == null) {
            LocalFileSystemBase.$$$reportNull$$$0(57);
        }
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file2, Object requestor, long modStamp, long l) throws IOException {
        void timeStamp;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(58);
        }
        File ioFile = LocalFileSystemBase.convertToIOFileAndCheck(file2);
        Object stream = SafeWriteRequestor.shouldUseSafeWrite((Object)requestor) ? new SafeFileOutputStream(ioFile) : new FileOutputStream(ioFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)stream, (long)timeStamp, ioFile){
            final /* synthetic */ long val$timeStamp;
            final /* synthetic */ File val$ioFile;
            {
                this.val$timeStamp = l;
                this.val$ioFile = file2;
                super(x0);
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (this.val$timeStamp > 0L && this.val$ioFile.exists() && !this.val$ioFile.setLastModified(this.val$timeStamp)) {
                    LOG.warn("Failed: " + this.val$ioFile.getPath() + ", new:" + this.val$timeStamp + ", old:" + this.val$ioFile.lastModified());
                }
            }
        };
        if (bufferedOutputStream == null) {
            LocalFileSystemBase.$$$reportNull$$$0(59);
        }
        return bufferedOutputStream;
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(60);
        }
        if (newParent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(61);
        }
        String name = file2.getName();
        if (!file2.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (file2.getParent() == null) {
            throw new IOException(VfsBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(name) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + name}));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (FileSystemUtil.getAttributes((File)ioFile) == null) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        File ioTarget = new File(ioParent, name);
        if (ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxMove(file2, newParent) && !ioFile.renameTo(ioTarget)) {
            throw new IOException(VfsBundle.message((String)"move.failed.error", (Object[])new Object[]{ioFile.getPath(), ioParent.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.move(file2, newParent)));
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        boolean sameName;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(62);
        }
        if (newName == null) {
            LocalFileSystemBase.$$$reportNull$$$0(63);
        }
        if (!this.isValidName(newName)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        boolean bl = sameName = !this.isCaseSensitive() && newName.equalsIgnoreCase(file2.getName());
        if (!file2.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        VirtualFile parent = file2.getParent();
        if (parent == null) {
            throw new IOException(VfsBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!sameName && parent.findChild(newName) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + newName}));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (!ioFile.exists()) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        File ioTarget = new File(LocalFileSystemBase.convertToIOFile(parent), newName);
        if (!sameName && ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxRename(file2, newName) && !FileUtil.rename((File)ioFile, (String)newName)) {
            throw new IOException(VfsBundle.message((String)"rename.failed.error", (Object[])new Object[]{ioFile.getPath(), newName}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.rename(file2, newName)));
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(64);
        }
        if (newParent == null) {
            LocalFileSystemBase.$$$reportNull$$$0(65);
        }
        if (copyName == null) {
            LocalFileSystemBase.$$$reportNull$$$0(66);
        }
        if (!this.isValidName(copyName)) {
            throw new IOException(VfsBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{copyName}));
        }
        if (!file2.exists()) {
            throw new IOException(VfsBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(copyName) != null) {
            throw new IOException(VfsBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + copyName}));
        }
        FileAttributes attributes = this.getAttributes(file2);
        if (attributes == null) {
            throw new FileNotFoundException(VfsBundle.message((String)"file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (attributes.isSpecial()) {
            throw new FileNotFoundException("Not a file: " + file2);
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(VfsBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        File ioTarget = new File(ioParent, copyName);
        if (ioTarget.exists()) {
            throw new IOException(VfsBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxCopy(file2, newParent, copyName)) {
            try {
                File ioFile = LocalFileSystemBase.convertToIOFile(file2);
                FileUtil.copyFileOrDir((File)ioFile, (File)ioTarget, (boolean)attributes.isDirectory());
            }
            catch (IOException e) {
                FileUtil.delete((File)ioTarget);
                throw e;
            }
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.copy(file2, newParent, copyName)));
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(newParent, copyName);
        if (fakeVirtualFile == null) {
            LocalFileSystemBase.$$$reportNull$$$0(67);
        }
        return fakeVirtualFile;
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) {
        File ioFile;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(68);
        }
        if ((ioFile = LocalFileSystemBase.convertToIOFile(file2)).exists() && !ioFile.setLastModified(timeStamp)) {
            LOG.warn("Failed: " + file2.getPath() + ", new:" + timeStamp + ", old:" + ioFile.lastModified());
        }
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(69);
        }
        String path = FileUtil.toSystemDependentName((String)file2.getPath());
        FileUtil.setReadOnlyAttribute((String)path, (!writableFlag ? 1 : 0) != 0);
        if (FileUtil.canWrite((String)path) != writableFlag) {
            throw new IOException("Failed to change read-only flag for " + path);
        }
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            LocalFileSystemBase.$$$reportNull$$$0(70);
        }
        if (path.isEmpty()) {
            try {
                path = new File("").getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String customRootPath : ourRootPaths) {
            if (!path.startsWith(customRootPath)) continue;
            String string = customRootPath;
            if (string == null) {
                LocalFileSystemBase.$$$reportNull$$$0(71);
            }
            return string;
        }
        if (SystemInfo.isWindows) {
            if (path.length() >= 2 && path.charAt(1) == ':') {
                String string = StringUtil.toUpperCase((String)path.substring(0, 2));
                if (string == null) {
                    LocalFileSystemBase.$$$reportNull$$$0(72);
                }
                return string;
            }
            if (path.startsWith("//") || path.startsWith("\\\\")) {
                int idx;
                int slashCount = 0;
                for (idx = 2; idx < path.length() && slashCount < 2; ++idx) {
                    char c2 = path.charAt(idx);
                    if (c2 != '\\' && c2 != '/') continue;
                    ++slashCount;
                    --idx;
                }
                String string = path.substring(0, idx);
                if (string == null) {
                    LocalFileSystemBase.$$$reportNull$$$0(73);
                }
                return string;
            }
            if ("" == null) {
                LocalFileSystemBase.$$$reportNull$$$0(74);
            }
            return "";
        }
        String string = StringUtil.startsWithChar((CharSequence)path, (char)'/') ? "/" : "";
        if (string == null) {
            LocalFileSystemBase.$$$reportNull$$$0(75);
        }
        return string;
    }

    public int getRank() {
        return 1;
    }

    public boolean markNewFilesAsDirty() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file2) {
        String string;
        long t;
        block24: {
            String string2;
            block23: {
                String string3;
                block22: {
                    String string4;
                    block21: {
                        if (file2 == null) {
                            LocalFileSystemBase.$$$reportNull$$$0(76);
                        }
                        if (this.isCaseSensitive()) {
                            String string5 = super.getCanonicallyCasedName(file2);
                            if (string5 == null) {
                                LocalFileSystemBase.$$$reportNull$$$0(77);
                            }
                            return string5;
                        }
                        String originalFileName = file2.getName();
                        t = LOG.isTraceEnabled() ? System.nanoTime() : 0L;
                        try {
                            String[] canonicalFileNames;
                            File ioFile = LocalFileSystemBase.convertToIOFile(file2);
                            File canonicalFile = ioFile.getCanonicalFile();
                            String canonicalFileName = canonicalFile.getName();
                            if (!SystemInfo.isUnix) {
                                String string6 = canonicalFileName;
                                string4 = string6;
                                break block21;
                            }
                            if (canonicalFileName.compareToIgnoreCase(originalFileName) == 0) {
                                String string7 = canonicalFileName;
                                string3 = string7;
                                break block22;
                            }
                            File parentFile = ioFile.getParentFile();
                            if (parentFile != null && (canonicalFileNames = parentFile.list()) != null) {
                                for (String name : canonicalFileNames) {
                                    if (name.compareToIgnoreCase(originalFileName) != 0) continue;
                                    String string8 = name;
                                    string2 = string8;
                                    break block23;
                                }
                            }
                            String string9 = canonicalFileName;
                            string = string9;
                            break block24;
                        }
                        catch (IOException e) {
                            String string10 = originalFileName;
                            String string11 = string10;
                            if (string11 == null) {
                                LocalFileSystemBase.$$$reportNull$$$0(82);
                            }
                            return string11;
                        }
                    }
                    if (string4 == null) {
                        LocalFileSystemBase.$$$reportNull$$$0(78);
                    }
                    return string4;
                }
                if (string3 == null) {
                    LocalFileSystemBase.$$$reportNull$$$0(79);
                }
                return string3;
            }
            if (string2 == null) {
                LocalFileSystemBase.$$$reportNull$$$0(80);
            }
            return string2;
        }
        if (string == null) {
            LocalFileSystemBase.$$$reportNull$$$0(81);
        }
        return string;
        finally {
            if (t != 0L) {
                t = (System.nanoTime() - t) / 1000L;
                LOG.trace("getCanonicallyCasedName(" + file2 + "): " + t + " mks");
            }
        }
    }

    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        String path;
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(83);
        }
        if ((path = this.normalize(file2.getPath())) == null) {
            return null;
        }
        if (file2.getParent() == null && path.startsWith("//")) {
            return FAKE_ROOT_ATTRIBUTES;
        }
        return FileSystemUtil.getAttributes((String)FileUtil.toSystemDependentName((String)path));
    }

    public void refresh(boolean asynchronous) {
        RefreshQueue.getInstance().refresh(asynchronous, true, null, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LocalFileSystemBase.$$$reportNull$$$0(84);
        }
        if (file2.getParent() == null) {
            return true;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(file2.getPath(), new String[0]));){
            boolean bl = stream.iterator().hasNext();
            return bl;
        }
        catch (IOException | SecurityException | InvalidPathException e) {
            return true;
        }
    }

    static {
        Collections.sort(ourRootPaths, (o1, o2) -> o2.length() - o1.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 45: 
            case 48: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 45: 
            case 48: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 68: 
            case 69: 
            case 76: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 45: 
            case 48: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 35: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 37: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 38: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 39: 
            case 41: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToIOFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToIOFileAndCheck";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildFile";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPath";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicallyCasedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIoFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToIOFile";
                break;
            }
            case 5: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 45: 
            case 48: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToIOFileAndCheck";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAbsoluteFileOrDriveLetter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByIoFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "refreshIoFiles";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "refreshFiles";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "registerAuxiliaryFileOperationsHandler";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAuxiliaryFileOperationsHandler";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "auxDelete";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "auxMove";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "auxCopy";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "auxRename";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "auxCreateFile";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "auxCreateDirectory";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "auxNotifyCompleted";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicallyCasedName";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 45: 
            case 48: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

