/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibrarySettingsProvider {
    public static final ExtensionPointName<LibrarySettingsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.librarySettingsProvider");

    @NotNull
    public abstract LibraryKind getLibraryKind();

    public abstract Configurable getAdditionalSettingsConfigurable(Project var1);

    @Nullable
    public static Configurable getAdditionalSettingsConfigurable(Project project, LibraryKind libKind) {
        LibrarySettingsProvider provider = LibrarySettingsProvider.forLibraryType(libKind);
        if (provider == null) {
            return null;
        }
        return provider.getAdditionalSettingsConfigurable(project);
    }

    @Nullable
    public static LibrarySettingsProvider forLibraryType(LibraryKind libType) {
        for (LibrarySettingsProvider provider : EP_NAME.getExtensionList()) {
            if (!provider.getLibraryKind().equals(libType)) continue;
            return provider;
        }
        return null;
    }
}

