/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.ApplicationLibraryTable;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class LibraryTablesRegistrarImpl
extends LibraryTablesRegistrar
implements Disposable {
    private static final Map<String, LibraryTable> myLibraryTables = new HashMap<String, LibraryTable>();

    LibraryTablesRegistrarImpl() {
    }

    @NotNull
    public LibraryTable getLibraryTable() {
        ApplicationLibraryTable applicationLibraryTable = ApplicationLibraryTable.getApplicationTable();
        if (applicationLibraryTable == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(0);
        }
        return applicationLibraryTable;
    }

    @NotNull
    public LibraryTable getLibraryTable(@NotNull Project project) {
        if (project == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(1);
        }
        LibraryTable libraryTable = (LibraryTable)ServiceManager.getService((Project)project, ProjectLibraryTable.class);
        if (libraryTable == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(2);
        }
        return libraryTable;
    }

    public LibraryTable getLibraryTableByLevel(String level, @NotNull Project project) {
        if (project == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(3);
        }
        if ("project".equals(level)) {
            return this.getLibraryTable(project);
        }
        if ("application".equals(level)) {
            return this.getLibraryTable();
        }
        return myLibraryTables.get(level);
    }

    public void registerLibraryTable(@NotNull LibraryTable libraryTable) {
        String tableLevel;
        LibraryTable oldTable;
        if (libraryTable == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(4);
        }
        if ((oldTable = myLibraryTables.put(tableLevel = libraryTable.getTableLevel(), libraryTable)) != null) {
            throw new IllegalArgumentException("Library table '" + tableLevel + "' already registered.");
        }
    }

    @NotNull
    public List<LibraryTable> getCustomLibraryTables() {
        SmartList smartList = new SmartList(myLibraryTables.values());
        if (smartList == null) {
            LibraryTablesRegistrarImpl.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    public void dispose() {
        myLibraryTables.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryTable";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTablesRegistrarImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLibraryTables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryTable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryTableByLevel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerLibraryTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

