/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.remote.AbstractRemoteExternalSystemService;
import com.intellij.openapi.externalSystem.service.remote.RawExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J1\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/externalSystem/service/remote/RawExternalSystemProjectResolverImpl;", "S", "Lcom/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings;", "Lcom/intellij/openapi/externalSystem/service/remote/AbstractRemoteExternalSystemService;", "Lcom/intellij/openapi/externalSystem/service/remote/RawExternalSystemProjectResolver;", "resolverDelegate", "Lcom/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProjectResolver;", "(Lcom/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProjectResolver;)V", "cancelTask", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "resolveProjectInfo", "", "projectPath", "", "isPreviewMode", "settings", "(Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Ljava/lang/String;ZLcom/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings;)[B", "intellij.platform.externalSystem.impl"})
public final class RawExternalSystemProjectResolverImpl<S extends ExternalSystemExecutionSettings>
extends AbstractRemoteExternalSystemService<S>
implements RawExternalSystemProjectResolver<S> {
    private final RemoteExternalSystemProjectResolver<S> resolverDelegate;

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.resolverDelegate.cancelTask(id);
    }

    @Override
    @Nullable
    public byte[] resolveProjectInfo(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, boolean isPreviewMode, @Nullable S settings) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        DataNode<ProjectData> dataNode = this.resolverDelegate.resolveProjectInfo(id, projectPath, isPreviewMode, settings);
        if (dataNode == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull(dataNode, (String)"resolverDelegate.resolve\u2026 settings) ?: return null");
        DataNode<ProjectData> result2 = dataNode;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new ObjectOutputStream(outputStream).writeObject(result2);
        return outputStream.toByteArray();
    }

    public RawExternalSystemProjectResolverImpl(@NotNull RemoteExternalSystemProjectResolver<S> resolverDelegate) {
        Intrinsics.checkParameterIsNotNull(resolverDelegate, (String)"resolverDelegate");
        this.resolverDelegate = resolverDelegate;
    }
}

