/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.execution.rmi.RemoteServer;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemService;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RawExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RawExternalSystemProjectResolverImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolverImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManagerImpl;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemFacadeImpl<S extends ExternalSystemExecutionSettings>
extends RemoteServer
implements RemoteExternalSystemFacade<S> {
    private final ConcurrentMap<Class<?>, RemoteExternalSystemService<S>> myRemotes;
    private final AtomicReference<S> mySettings;
    private final AtomicReference<ExternalSystemTaskNotificationListener> myNotificationListener;
    @NotNull
    private final RemoteExternalSystemProjectResolverImpl<S> myProjectResolver;
    @NotNull
    private final RemoteExternalSystemTaskManagerImpl<S> myTaskManager;

    public AbstractExternalSystemFacadeImpl(@NotNull Class<ExternalSystemProjectResolver<S>> projectResolverClass, @NotNull Class<ExternalSystemTaskManager<S>> buildManagerClass) throws IllegalAccessException, InstantiationException {
        if (projectResolverClass == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(0);
        }
        if (buildManagerClass == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(1);
        }
        this.myRemotes = ContainerUtil.newConcurrentMap();
        this.mySettings = new AtomicReference();
        this.myNotificationListener = new AtomicReference<1>(new ExternalSystemTaskNotificationListenerAdapter(){});
        this.myProjectResolver = new RemoteExternalSystemProjectResolverImpl<S>(projectResolverClass.newInstance());
        this.myTaskManager = new RemoteExternalSystemTaskManagerImpl<S>(buildManagerClass.newInstance());
    }

    protected void init() throws RemoteException {
        this.applyProgressManager(RemoteExternalSystemProgressNotificationManager.NULL_OBJECT);
    }

    @Nullable
    protected S getSettings() {
        return (S)((ExternalSystemExecutionSettings)this.mySettings.get());
    }

    @NotNull
    protected ExternalSystemTaskNotificationListener getNotificationListener() {
        ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener = this.myNotificationListener.get();
        if (externalSystemTaskNotificationListener == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(2);
        }
        return externalSystemTaskNotificationListener;
    }

    @Override
    @NotNull
    public RemoteExternalSystemProjectResolver<S> getResolver() throws IllegalStateException {
        RemoteExternalSystemProjectResolver remoteExternalSystemProjectResolver;
        try {
            remoteExternalSystemProjectResolver = this.getService(RemoteExternalSystemProjectResolver.class, this.myProjectResolver);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't create '%s' service", RemoteExternalSystemProjectResolverImpl.class.getName()), e);
        }
        if (remoteExternalSystemProjectResolver == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(3);
        }
        return remoteExternalSystemProjectResolver;
    }

    @Override
    @NotNull
    public RawExternalSystemProjectResolver<S> getRawProjectResolver() throws IllegalStateException {
        RawExternalSystemProjectResolver rawExternalSystemProjectResolver;
        try {
            rawExternalSystemProjectResolver = this.getService(RawExternalSystemProjectResolver.class, new RawExternalSystemProjectResolverImpl<S>(this.myProjectResolver));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't create '%s' service", RawExternalSystemProjectResolverImpl.class.getName()), e);
        }
        if (rawExternalSystemProjectResolver == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(4);
        }
        return rawExternalSystemProjectResolver;
    }

    @Override
    @NotNull
    public RemoteExternalSystemTaskManager<S> getTaskManager() {
        RemoteExternalSystemTaskManager remoteExternalSystemTaskManager;
        try {
            remoteExternalSystemTaskManager = this.getService(RemoteExternalSystemTaskManager.class, this.myTaskManager);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't create '%s' service", ExternalSystemTaskManager.class.getName()), e);
        }
        if (remoteExternalSystemTaskManager == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(5);
        }
        return remoteExternalSystemTaskManager;
    }

    private <I extends RemoteExternalSystemService<S>, C extends I> I getService(@NotNull Class<I> interfaceClass, @NotNull C impl) throws ClassNotFoundException, IllegalAccessException, InstantiationException, RemoteException {
        Object cachedResult;
        if (interfaceClass == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(6);
        }
        if (impl == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(7);
        }
        if ((cachedResult = this.myRemotes.get(interfaceClass)) != null) {
            return (I)((RemoteExternalSystemService)cachedResult);
        }
        S settings = this.getSettings();
        if (settings != null) {
            impl.setNotificationListener(this.getNotificationListener());
            impl.setSettings(settings);
        }
        impl.setNotificationListener(this.getNotificationListener());
        try {
            I created = this.createService(interfaceClass, impl);
            RemoteExternalSystemService<S> stored = this.myRemotes.putIfAbsent(interfaceClass, (RemoteExternalSystemService<S>)created);
            return (I)(stored == null ? created : stored);
        }
        catch (RemoteException e) {
            Object raceResult = this.myRemotes.get(interfaceClass);
            if (raceResult != null) {
                return (I)((RemoteExternalSystemService)raceResult);
            }
            throw new IllegalStateException(String.format("Can't prepare remote service for interface '%s', implementation '%s'", interfaceClass, impl), e);
        }
    }

    protected abstract <I extends RemoteExternalSystemService<S>, C extends I> I createService(@NotNull Class<I> var1, @NotNull C var2) throws ClassNotFoundException, IllegalAccessException, InstantiationException, RemoteException;

    @Override
    public boolean isTaskInProgress(@NotNull ExternalSystemTaskId id) throws RemoteException {
        if (id == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(8);
        }
        for (RemoteExternalSystemService service : this.myRemotes.values()) {
            if (!service.isTaskInProgress(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> getTasksInProgress() throws RemoteException {
        Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> result2 = null;
        for (RemoteExternalSystemService service : this.myRemotes.values()) {
            Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> tasks = service.getTasksInProgress();
            if (tasks.isEmpty()) continue;
            if (result2 == null) {
                result2 = new HashMap<ExternalSystemTaskType, Set<ExternalSystemTaskId>>();
            }
            for (Map.Entry<ExternalSystemTaskType, Set<ExternalSystemTaskId>> entry : tasks.entrySet()) {
                Set<ExternalSystemTaskId> ids = result2.get(entry.getKey());
                if (ids == null) {
                    ids = new HashSet<ExternalSystemTaskId>();
                    result2.put(entry.getKey(), ids);
                }
                ids.addAll((Collection<ExternalSystemTaskId>)entry.getValue());
            }
        }
        if (result2 == null) {
            result2 = Collections.emptyMap();
        }
        Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> map2 = result2;
        if (map2 == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @Override
    public void applySettings(@NotNull S settings) throws RemoteException {
        if (settings == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(10);
        }
        this.mySettings.set(settings);
        ArrayList services = ContainerUtilRt.newArrayList(this.myRemotes.values());
        for (RemoteExternalSystemService service : services) {
            service.setSettings(settings);
        }
    }

    @Override
    public void applyProgressManager(@NotNull RemoteExternalSystemProgressNotificationManager progressManager) throws RemoteException {
        if (progressManager == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(11);
        }
        SwallowingNotificationListener listener2 = new SwallowingNotificationListener(progressManager);
        this.myNotificationListener.set(listener2);
        this.myProjectResolver.setNotificationListener(listener2);
        this.myTaskManager.setNotificationListener(listener2);
    }

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id) throws RemoteException {
        if (id == null) {
            AbstractExternalSystemFacadeImpl.$$$reportNull$$$0(12);
        }
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            return this.myProjectResolver.cancelTask(id);
        }
        return this.myTaskManager.cancelTask(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectResolverClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildManagerClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impl";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawProjectResolver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksInProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTaskInProgress";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applySettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyProgressManager";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cancelTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SwallowingNotificationListener
    implements ExternalSystemTaskNotificationListener {
        @NotNull
        private final RemoteExternalSystemProgressNotificationManager myManager;

        SwallowingNotificationListener(@NotNull RemoteExternalSystemProgressNotificationManager manager) {
            if (manager == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(0);
            }
            this.myManager = manager;
        }

        public void onQueued(@NotNull ExternalSystemTaskId id, String workingDir) {
            if (id == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(1);
            }
        }

        public void onStart(@NotNull ExternalSystemTaskId id, String workingDir) {
            if (id == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(2);
            }
        }

        public void onStart(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(3);
            }
        }

        public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
            if (event == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(4);
            }
            try {
                this.myManager.onStatusChange(event);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text2, boolean stdOut) {
            if (id == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(5);
            }
            if (text2 == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(6);
            }
            try {
                this.myManager.onTaskOutput(id, text2, stdOut);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void onEnd(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(7);
            }
        }

        public void onSuccess(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(8);
            }
        }

        public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception ex) {
            if (id == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(9);
            }
            if (ex == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(10);
            }
        }

        public void beforeCancel(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(11);
            }
        }

        public void onCancel(@NotNull ExternalSystemTaskId id) {
            if (id == null) {
                SwallowingNotificationListener.$$$reportNull$$$0(12);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ex";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/AbstractExternalSystemFacadeImpl$SwallowingNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onQueued";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onStart";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onStatusChange";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTaskOutput";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onEnd";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSuccess";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFailure";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeCancel";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCancel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

