/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ParallelActivity;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.concurrent.Executor;

final class Preloader
implements ApplicationInitializedListener {
    private static final Logger LOG = Logger.getInstance(Preloader.class);
    private final Executor myExecutor;
    private final ProgressIndicator myIndicator;
    private final ProgressIndicator myWrappingIndicator;

    Preloader() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment() || !Registry.is((String)"enable.activity.preloading")) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
        this.myIndicator = new ProgressIndicatorBase();
        Disposer.register((Disposable)app, () -> this.myIndicator.cancel());
        this.myExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Preloader Pool");
        this.myWrappingIndicator = new AbstractProgressIndicatorBase(){

            @Override
            public void checkCanceled() {
                Preloader.checkHeavyProcessRunning();
                Preloader.this.myIndicator.checkCanceled();
            }

            @Override
            public boolean isCanceled() {
                return Preloader.this.myIndicator.isCanceled();
            }
        };
    }

    private static void checkHeavyProcessRunning() {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            TimeoutUtil.sleep((long)1L);
        }
    }

    public void componentsInitialized() {
        ProgressManager progressManager = ProgressManager.getInstance();
        for (PreloadingActivity activity : PreloadingActivity.EP_NAME.getExtensionList()) {
            this.myExecutor.execute(() -> {
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                Preloader.checkHeavyProcessRunning();
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                progressManager.runProcess(() -> {
                    Activity measureActivity = ParallelActivity.PRELOAD_ACTIVITY.start(activity.getClass().getName());
                    try {
                        activity.preload(this.myWrappingIndicator);
                    }
                    catch (ProcessCanceledException ignore) {
                        return;
                    }
                    measureActivity.end();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(activity.getClass().getName() + " finished");
                    }
                }, this.myIndicator);
            });
        }
    }
}

