/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class MarkupModelWindow
extends UserDataHolderBase
implements MarkupModelEx {
    private final DocumentWindow myDocument;
    private final MarkupModelEx myHostModel;

    public MarkupModelWindow(MarkupModelEx editorMarkupModel, DocumentWindow document) {
        this.myDocument = document;
        this.myHostModel = editorMarkupModel;
    }

    @NotNull
    public Document getDocument() {
        DocumentWindow documentWindow = this.myDocument;
        if (documentWindow == null) {
            MarkupModelWindow.$$$reportNull$$$0(0);
        }
        return documentWindow;
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            MarkupModelWindow.$$$reportNull$$$0(1);
        }
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeHighlighter rangeHighlighter = this.myHostModel.addRangeHighlighter(hostRange.getStartOffset(), hostRange.getEndOffset(), layer, textAttributes, targetArea);
        if (rangeHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(2);
        }
        return rangeHighlighter;
    }

    @Override
    @NotNull
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        if (targetArea == null) {
            MarkupModelWindow.$$$reportNull$$$0(3);
        }
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeHighlighterEx rangeHighlighterEx = this.myHostModel.addRangeHighlighterAndChangeAttributes(hostRange.getStartOffset(), hostRange.getEndOffset(), layer, textAttributes, targetArea, isPersistent, changeAttributesAction);
        if (rangeHighlighterEx == null) {
            MarkupModelWindow.$$$reportNull$$$0(4);
        }
        return rangeHighlighterEx;
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter, @NotNull Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        if (highlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(5);
        }
        if (changeAttributesAction == null) {
            MarkupModelWindow.$$$reportNull$$$0(6);
        }
        this.myHostModel.changeAttributesInBatch(highlighter, changeAttributesAction);
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int line2, int layer, TextAttributes textAttributes) {
        int hostLine = this.myDocument.injectedToHostLine(line2);
        RangeHighlighter rangeHighlighter = this.myHostModel.addLineHighlighter(hostLine, layer, textAttributes);
        if (rangeHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(7);
        }
        return rangeHighlighter;
    }

    public void removeHighlighter(@NotNull RangeHighlighter rangeHighlighter) {
        if (rangeHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(8);
        }
        this.myHostModel.removeHighlighter(rangeHighlighter);
    }

    public void removeAllHighlighters() {
        this.myHostModel.removeAllHighlighters();
    }

    @NotNull
    public RangeHighlighter[] getAllHighlighters() {
        RangeHighlighter[] rangeHighlighterArray = this.myHostModel.getAllHighlighters();
        if (rangeHighlighterArray == null) {
            MarkupModelWindow.$$$reportNull$$$0(9);
        }
        return rangeHighlighterArray;
    }

    @Override
    public void dispose() {
        this.myHostModel.dispose();
    }

    @Override
    public RangeHighlighterEx addPersistentLineHighlighter(int line2, int layer, TextAttributes textAttributes) {
        int hostLine = this.myDocument.injectedToHostLine(line2);
        return this.myHostModel.addPersistentLineHighlighter(hostLine, layer, textAttributes);
    }

    @Override
    public boolean containsHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(10);
        }
        return this.myHostModel.containsHighlighter(highlighter);
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, @NotNull MarkupModelListener listener2) {
        if (parentDisposable == null) {
            MarkupModelWindow.$$$reportNull$$$0(11);
        }
        if (listener2 == null) {
            MarkupModelWindow.$$$reportNull$$$0(12);
        }
        this.myHostModel.addMarkupModelListener(parentDisposable, listener2);
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter, @NotNull TextAttributes textAttributes) {
        if (highlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(13);
        }
        if (textAttributes == null) {
            MarkupModelWindow.$$$reportNull$$$0(14);
        }
        this.myHostModel.setRangeHighlighterAttributes(highlighter, textAttributes);
    }

    @Override
    public boolean processRangeHighlightersOverlappingWith(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            MarkupModelWindow.$$$reportNull$$$0(15);
        }
        return false;
    }

    @Override
    public boolean processRangeHighlightersOutside(int start2, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            MarkupModelWindow.$$$reportNull$$$0(16);
        }
        return false;
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        MarkupIterator<RangeHighlighterEx> markupIterator = this.myHostModel.overlappingIterator(startOffset, endOffset);
        if (markupIterator == null) {
            MarkupModelWindow.$$$reportNull$$$0(17);
        }
        return markupIterator;
    }

    @Override
    public void fireAttributesChanged(@NotNull RangeHighlighterEx segmentHighlighter, boolean renderersChanged, boolean fontStyleChanged) {
        if (segmentHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(18);
        }
    }

    @Override
    public void fireAfterAdded(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(19);
        }
    }

    @Override
    public void fireBeforeRemoved(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            MarkupModelWindow.$$$reportNull$$$0(20);
        }
    }

    @Override
    public void addRangeHighlighter(@NotNull RangeHighlighterEx marker, int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (marker == null) {
            MarkupModelWindow.$$$reportNull$$$0(21);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/injected/editor/MarkupModelWindow";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetArea";
                break;
            }
            case 5: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeAttributesAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeHighlighter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentHighlighter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/injected/editor/MarkupModelWindow";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeHighlighterAndChangeAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addLineHighlighter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHighlighters";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "overlappingIterator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlighterAndChangeAttributes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changeAttributesInBatch";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlighter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsHighlighter";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addMarkupModelListener";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setRangeHighlighterAttributes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlightersOverlappingWith";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlightersOutside";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fireAttributesChanged";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterAdded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeRemoved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

