/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.DialogAppender;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharSequenceReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.LevelRangeFilter;
import org.apache.log4j.xml.DOMConfigurator;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.adapters.DOMAdapter;
import org.jdom.adapters.JAXPDOMAdapter;
import org.jdom.output.DOMOutputter;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class LoggerFactory
implements Logger.Factory {
    private static final String SYSTEM_MACRO = "$SYSTEM_DIR$";
    private static final String APPLICATION_MACRO = "$APPLICATION_DIR$";
    private static final String LOG_DIR_MACRO = "$LOG_DIR$";
    private static final String DOCUMENT_BUILDER_FACTORY_KEY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String DOCUMENT_BUILDER_FACTORY_IMPL = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";

    LoggerFactory() {
        try {
            LoggerFactory.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String name) {
        if (name == null) {
            LoggerFactory.$$$reportNull$$$0(0);
        }
        IdeaLogger ideaLogger = new IdeaLogger(Logger.getLogger((String)name));
        if (ideaLogger == null) {
            LoggerFactory.$$$reportNull$$$0(1);
        }
        return ideaLogger;
    }

    private static void init() throws Exception {
        System.setProperty("log4j.defaultInitOverride", "true");
        File xmlFile = PathManager.getLogFile();
        if (xmlFile != null) {
            LoggerFactory.loadFromXmlFile(xmlFile);
        } else {
            LoggerFactory.configureProgrammatically();
        }
    }

    private static void loadFromXmlFile(File xmlFile) throws Exception {
        String text2 = FileUtilRt.loadFile((File)xmlFile);
        text2 = StringUtil.replace((String)text2, (String)SYSTEM_MACRO, (String)StringUtil.replace((String)PathManager.getSystemPath(), (String)"\\", (String)"\\\\"));
        text2 = StringUtil.replace((String)text2, (String)APPLICATION_MACRO, (String)StringUtil.replace((String)PathManager.getHomePath(), (String)"\\", (String)"\\\\"));
        text2 = StringUtil.replace((String)text2, (String)LOG_DIR_MACRO, (String)StringUtil.replace((String)PathManager.getLogPath(), (String)"\\", (String)"\\\\"));
        File file2 = new File(PathManager.getLogPath());
        if (!file2.mkdirs() && !file2.exists()) {
            System.err.println("Cannot create log directory: " + file2);
        }
        Document document = JDOMUtil.loadDocument((Reader)new CharSequenceReader((CharSequence)text2));
        Element element = new DOMOutputter((DOMAdapter)new JAXPDOMAdapter(){

            public org.w3c.dom.Document createDocument() throws JDOMException {
                String property = System.setProperty(LoggerFactory.DOCUMENT_BUILDER_FACTORY_KEY, LoggerFactory.DOCUMENT_BUILDER_FACTORY_IMPL);
                try {
                    org.w3c.dom.Document document = super.createDocument();
                    return document;
                }
                finally {
                    if (property == null) {
                        System.clearProperty(LoggerFactory.DOCUMENT_BUILDER_FACTORY_KEY);
                    } else {
                        System.setProperty(LoggerFactory.DOCUMENT_BUILDER_FACTORY_KEY, property);
                    }
                }
            }
        }, null, null).output(document).getDocumentElement();
        new DOMConfigurator().doConfigure(element, LogManager.getLoggerRepository());
    }

    private static void configureProgrammatically() throws IOException {
        Logger root = LogManager.getRootLogger();
        root.removeAllAppenders();
        root.setLevel(Level.INFO);
        PatternLayout layout = new PatternLayout("%d [%7r] %6p - %30.30c - %m \n");
        RollingFileAppender ideaLog = new RollingFileAppender((Layout)layout, PathManager.getLogPath() + "/idea.log", true);
        ideaLog.setEncoding("UTF-8");
        ideaLog.setMaxBackupIndex(12);
        ideaLog.setMaximumFileSize(10000000L);
        root.addAppender((Appender)ideaLog);
        ConsoleAppender consoleWarn = new ConsoleAppender((Layout)layout, "System.err");
        LevelRangeFilter warnFilter = new LevelRangeFilter();
        warnFilter.setLevelMin(Level.WARN);
        consoleWarn.addFilter((Filter)warnFilter);
        root.addAppender((Appender)consoleWarn);
        DialogAppender appender = new DialogAppender();
        LevelRangeFilter filter = new LevelRangeFilter();
        filter.setLevelMin(Level.INFO);
        appender.addFilter((Filter)filter);
        root.addAppender((Appender)appender);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/LoggerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/LoggerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerInstance";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

