/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.intellij.MacIntelliJComboBoxUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class MacIntelliJComboBoxBorder
extends MacIntelliJTextBorder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        if (!(c2 instanceof JComponent)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            boolean focused = this.isFocused(c2);
            if (!DarculaUIUtil.isTableCellEditor(c2)) {
                g2.translate(x, y);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                Shape clip = g2.getClip();
                Area area = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
                area.subtract(this.getButtonBounds(c2));
                area.intersect(new Area(clip));
                g2.setClip(area);
                float arc = this.isRound(c2) ? ARC.getFloat() : 0.0f;
                float bw = BW.getFloat();
                float lw = MacIntelliJComboBoxBorder.LW(g2);
                Path2D.Float border = new Path2D.Float(0);
                border.append(new RoundRectangle2D.Double(bw, bw, (float)width - bw * 2.0f, (float)height - bw * 2.0f, arc, arc), false);
                border.append(new RoundRectangle2D.Double(bw + lw, bw + lw, (float)width - (bw + lw) * 2.0f, (float)height - (bw + lw) * 2.0f, arc - lw, arc - lw), false);
                g2.setColor((Color)Gray.xBC);
                g2.fill(border);
                g2.setClip(clip);
                this.clipForBorder(c2, g2, width, height);
                Object op = ((JComponent)c2).getClientProperty("JComponent.outline");
                if (c2.isEnabled() && op != null) {
                    DarculaUIUtil.paintOutlineBorder(g2, width, height, arc, this.isSymmetric(), focused, DarculaUIUtil.Outline.valueOf(op.toString()));
                } else if (focused) {
                    DarculaUIUtil.paintOutlineBorder(g2, width, height, arc, this.isSymmetric(), true, DarculaUIUtil.Outline.focus);
                }
            } else {
                DarculaUIUtil.paintCellEditorBorder(g2, c2, new Rectangle(x, y, width, height), focused);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return JBUI.insets((int)(DarculaUIUtil.isTableCellEditor(c2) ? 2 : 3)).asUIResource();
    }

    @Override
    protected boolean isFocused(Component c2) {
        if (c2 instanceof JComboBox) {
            JComboBox comboBox2 = (JComboBox)c2;
            if (!comboBox2.isEnabled()) {
                return false;
            }
            if (comboBox2.isEditable()) {
                ComboBoxEditor ed = comboBox2.getEditor();
                Component editorComponent = ed.getEditorComponent();
                Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                return focused != null && editorComponent != null && SwingUtilities.isDescendingFrom(focused, editorComponent);
            }
            return comboBox2.hasFocus();
        }
        return false;
    }

    Area getButtonBounds(Component c2) {
        Rectangle bounds2 = null;
        if (c2 instanceof JComboBox && ((JComboBox)c2).getUI() instanceof MacIntelliJComboBoxUI) {
            MacIntelliJComboBoxUI ui = (MacIntelliJComboBoxUI)((JComboBox)c2).getUI();
            bounds2 = ui.getArrowButtonBounds();
        }
        return bounds2 != null ? new Area(bounds2) : new Area();
    }

    boolean isRound(Component c2) {
        return c2 instanceof JComboBox && !((JComboBox)c2).isEditable();
    }

    @Override
    protected void clipForBorder(Component c2, Graphics2D g2, int width, int height) {
        float lw = MacIntelliJComboBoxBorder.LW(g2);
        float bw = BW.getFloat();
        Area area = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
        RectangularShape innerShape = this.isRound(c2) ? new RoundRectangle2D.Float(bw + lw, bw + lw, (float)width - (bw + lw) * 2.0f, (float)height - (bw + lw) * 2.0f, bw + lw, bw + lw) : new Rectangle2D.Float(bw + lw, bw + lw, (float)width - (bw + lw) * 2.0f, (float)height - (bw + lw) * 2.0f);
        area.subtract(new Area(innerShape));
        area.add(this.getButtonBounds(c2));
        Area clip = new Area(g2.getClip());
        area.intersect(clip);
        g2.setClip(area);
    }

    @Override
    protected boolean isSymmetric() {
        return false;
    }
}

