/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.ui.JBCachingScalableIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.dnd.DragSource;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Bookmark
implements Navigatable,
Comparable<Bookmark> {
    static final Icon DEFAULT_ICON = new MyCheckedIcon();
    private final VirtualFile myFile;
    @NotNull
    private OpenFileDescriptor myTarget;
    private final Project myProject;
    private Reference<RangeHighlighterEx> myHighlighterRef;
    @NotNull
    private String myDescription;
    private char myMnemonic;
    int index;

    public Bookmark(@NotNull Project project, @NotNull VirtualFile file2, int line2, @NotNull String description) {
        if (project == null) {
            Bookmark.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            Bookmark.$$$reportNull$$$0(1);
        }
        if (description == null) {
            Bookmark.$$$reportNull$$$0(2);
        }
        this.myFile = file2;
        this.myProject = project;
        this.myDescription = description;
        this.myTarget = new OpenFileDescriptor(project, file2, line2, -1, true);
        this.addHighlighter();
    }

    @NotNull
    public static Font getBookmarkFont() {
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        if (font == null) {
            Bookmark.$$$reportNull$$$0(3);
        }
        return font;
    }

    @Override
    public int compareTo(@NotNull Bookmark o) {
        int i;
        if (o == null) {
            Bookmark.$$$reportNull$$$0(4);
        }
        int n = this.myMnemonic != '\u0000' ? (o.myMnemonic != '\u0000' ? this.myMnemonic - o.myMnemonic : -1) : (i = o.myMnemonic != '\u0000' ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = this.myProject.getName().compareTo(o.myProject.getName());
        if (i != 0) {
            return i;
        }
        i = this.myFile.getName().compareTo(o.getFile().getName());
        if (i != 0) {
            return i;
        }
        return this.getTarget().compareTo(o.getTarget());
    }

    void updateHighlighter() {
        this.release();
        this.addHighlighter();
    }

    private void addHighlighter() {
        Document document = this.getCachedDocument();
        if (document != null) {
            this.createHighlighter((MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myProject, true));
        }
    }

    public RangeHighlighter createHighlighter(@NotNull MarkupModelEx markup) {
        RangeHighlighterEx highlighter;
        int line2;
        if (markup == null) {
            Bookmark.$$$reportNull$$$0(5);
        }
        if ((line2 = this.getLine()) >= 0) {
            highlighter = markup.addPersistentLineHighlighter(line2, 5001, null);
            if (highlighter != null) {
                highlighter.setGutterIconRenderer(new MyGutterIconRenderer(this));
                TextAttributes textAttributes = (TextAttributes)ObjectUtils.notNull((Object)EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BOOKMARKS_ATTRIBUTES), (Object)new TextAttributes());
                Color stripeColor = (Color)ObjectUtils.notNull((Object)textAttributes.getErrorStripeColor(), (Object)new JBColor(0, 0xDBDBDB));
                highlighter.setErrorStripeMarkColor(stripeColor);
                highlighter.setErrorStripeTooltip(this.getBookmarkTooltip());
                TextAttributes attributes = highlighter.getTextAttributes();
                if (attributes == null) {
                    attributes = new TextAttributes();
                }
                attributes.setBackgroundColor(textAttributes.getBackgroundColor());
                attributes.setForegroundColor(textAttributes.getForegroundColor());
                highlighter.setTextAttributes(attributes);
            }
        } else {
            highlighter = null;
        }
        this.myHighlighterRef = highlighter == null ? null : new WeakReference<RangeHighlighterEx>(highlighter);
        return highlighter;
    }

    @Deprecated
    @Nullable
    public Document getDocument() {
        return this.getCachedDocument();
    }

    Document getCachedDocument() {
        return FileDocumentManager.getInstance().getCachedDocument(this.getFile());
    }

    public void release() {
        int line2 = this.getLine();
        if (line2 < 0) {
            return;
        }
        Document document = this.getCachedDocument();
        if (document == null) {
            return;
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myProject, true);
        Document markupDocument = markup.getDocument();
        if (markupDocument.getLineCount() <= line2) {
            return;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        if (highlighter != null) {
            this.myHighlighterRef = null;
            highlighter.dispose();
        }
    }

    private RangeHighlighterEx findMyHighlighter() {
        Document document = this.getCachedDocument();
        if (document == null) {
            return null;
        }
        RangeHighlighterEx result2 = (RangeHighlighterEx)SoftReference.dereference(this.myHighlighterRef);
        if (result2 != null) {
            return result2;
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myProject, true);
        Document markupDocument = markup.getDocument();
        boolean startOffset = false;
        int endOffset = markupDocument.getTextLength();
        Ref found = new Ref();
        markup.processRangeHighlightersOverlappingWith(0, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            GutterIconRenderer renderer2 = highlighter.getGutterIconRenderer();
            if (renderer2 instanceof MyGutterIconRenderer && ((MyGutterIconRenderer)renderer2).myBookmark == this) {
                found.set(highlighter);
                return false;
            }
            return true;
        }));
        result2 = (RangeHighlighterEx)found.get();
        this.myHighlighterRef = result2 == null ? null : new WeakReference<RangeHighlighterEx>(result2);
        return result2;
    }

    public Icon getIcon() {
        return this.myMnemonic == '\u0000' ? DEFAULT_ICON : MnemonicIcon.getIcon(this.myMnemonic);
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            Bookmark.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setDescription(@NotNull String description) {
        if (description == null) {
            Bookmark.$$$reportNull$$$0(7);
        }
        this.myDescription = description;
    }

    public char getMnemonic() {
        return this.myMnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.myMnemonic = Character.toUpperCase(mnemonic);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            Bookmark.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    @Nullable
    String nullizeEmptyDescription() {
        return StringUtil.nullize((String)this.myDescription);
    }

    public boolean isValid() {
        if (!this.getFile().isValid()) {
            return false;
        }
        if (this.getLine() == -1) {
            return true;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        return highlighter != null && highlighter.isValid();
    }

    public boolean canNavigate() {
        return this.getTarget().canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getTarget().canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        this.getTarget().navigate(requestFocus);
    }

    public int getLine() {
        int targetLine = this.myTarget.getLine();
        if (targetLine == -1) {
            return -1;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        if (highlighter != null && highlighter.isValid()) {
            Document document = highlighter.getDocument();
            return document.getLineNumber(highlighter.getStartOffset());
        }
        RangeMarker marker = this.myTarget.getRangeMarker();
        if (marker != null && marker.isValid()) {
            Document document = marker.getDocument();
            return document.getLineNumber(marker.getStartOffset());
        }
        return targetLine;
    }

    @NotNull
    private OpenFileDescriptor getTarget() {
        int line2 = this.getLine();
        if (line2 != this.myTarget.getLine()) {
            this.myTarget = new OpenFileDescriptor(this.myProject, this.myFile, line2, -1, true);
        }
        OpenFileDescriptor openFileDescriptor = this.myTarget;
        if (openFileDescriptor == null) {
            Bookmark.$$$reportNull$$$0(9);
        }
        return openFileDescriptor;
    }

    public String toString() {
        String description;
        StringBuilder result2 = new StringBuilder(this.getQualifiedName());
        String text2 = this.nullizeEmptyDescription();
        String string = description = text2 == null ? null : StringUtil.escapeXmlEntities((String)text2);
        if (description != null) {
            result2.append(": ").append(description);
        }
        return result2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getQualifiedName() {
        String presentableUrl = this.myFile.getPresentableUrl();
        if (this.myFile.isDirectory()) {
            String string = presentableUrl;
            if (string == null) {
                Bookmark.$$$reportNull$$$0(10);
            }
            return string;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (psiFile == null) {
            String string = presentableUrl;
            if (string == null) {
                Bookmark.$$$reportNull$$$0(11);
            }
            return string;
        }
        StructureViewBuilder builder2 = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(psiFile);
        if (builder2 instanceof TreeBasedStructureViewBuilder) {
            ItemPresentation presentation;
            Object element;
            StructureViewModel model2 = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel(null);
            try {
                element = model2.getCurrentEditorElement();
            }
            finally {
                Disposer.dispose((Disposable)model2);
            }
            if (element instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
                presentableUrl = ((NavigationItem)element).getName() + " " + presentation.getLocationString();
            }
        }
        String string = IdeBundle.message((String)"bookmark.file.X.line.Y", (Object[])new Object[]{presentableUrl, this.getLine() + 1});
        if (string == null) {
            Bookmark.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private String getBookmarkTooltip() {
        String shortcutText;
        String text2;
        String description;
        StringBuilder result2 = new StringBuilder("Bookmark");
        if (this.myMnemonic != '\u0000') {
            result2.append(" ").append(this.myMnemonic);
        }
        String string = description = (text2 = this.nullizeEmptyDescription()) == null ? null : StringUtil.escapeXmlEntities((String)text2);
        if (description != null) {
            result2.append(": ").append(description);
        }
        StringBuilder shortcutDescription = new StringBuilder();
        if (this.myMnemonic != '\u0000') {
            String navigateShortcutText;
            shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)("ToggleBookmark" + this.myMnemonic));
            if (shortcutText.length() > 0) {
                shortcutDescription.append(shortcutText).append(" to toggle");
            }
            if ((navigateShortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)("GotoBookmark" + this.myMnemonic))).length() > 0) {
                if (shortcutDescription.length() > 0) {
                    shortcutDescription.append(", ");
                }
                shortcutDescription.append(navigateShortcutText).append(" to jump to");
            }
        }
        if (shortcutDescription.length() == 0 && (shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"ToggleBookmark")).length() > 0) {
            shortcutDescription.append(shortcutText).append(" to toggle");
        }
        if (shortcutDescription.length() > 0) {
            result2.append(" (").append((CharSequence)shortcutDescription).append(")");
        }
        String string2 = result2.toString();
        if (string2 == null) {
            Bookmark.$$$reportNull$$$0(13);
        }
        return string2;
    }

    private static boolean darkBackground() {
        Color gutterBackground = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        if (gutterBackground == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        return ColorUtil.isDark((Color)gutterBackground);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/bookmarks/Bookmark";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/bookmarks/Bookmark";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBookmarkFont";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBookmarkTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private final Bookmark myBookmark;

        MyGutterIconRenderer(@NotNull Bookmark bookmark) {
            if (bookmark == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(0);
            }
            this.myBookmark = bookmark;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myBookmark.getIcon();
            if (icon == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return icon;
        }

        @NotNull
        public String getTooltipText() {
            String string = this.myBookmark.getBookmarkTooltip();
            if (string == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public GutterDraggableObject getDraggableObject() {
            GutterDraggableObject gutterDraggableObject = new GutterDraggableObject(){

                public boolean copy(int line2, VirtualFile file2, int actionId) {
                    myBookmark.myTarget = new OpenFileDescriptor(myBookmark.myProject, file2, line2, -1, true);
                    myBookmark.updateHighlighter();
                    return true;
                }

                public Cursor getCursor(int line2, int actionId) {
                    return DragSource.DefaultMoveDrop;
                }
            };
            if (gutterDraggableObject == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(3);
            }
            return gutterDraggableObject;
        }

        @NotNull
        public String getAccessibleName() {
            String string = "icon: bookmark " + this.myBookmark.myMnemonic;
            if (string == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean equals(Object obj) {
            return obj instanceof MyGutterIconRenderer && Comparing.equal((String)this.getTooltipText(), (String)((MyGutterIconRenderer)((Object)obj)).getTooltipText()) && Comparing.equal((Object)this.getIcon(), (Object)((MyGutterIconRenderer)((Object)obj)).getIcon());
        }

        public int hashCode() {
            return this.getIcon().hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bookmark";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/bookmarks/Bookmark$MyGutterIconRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/bookmarks/Bookmark$MyGutterIconRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltipText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDraggableObject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyCheckedIcon
    extends JBCachingScalableIcon<MyCheckedIcon>
    implements RetrievableIcon {
        private MyCheckedIcon() {
        }

        @NotNull
        public Icon retrieveIcon() {
            Icon icon = IconUtil.scale((Icon)PlatformIcons.CHECK_ICON, null, (float)this.getScale());
            if (icon == null) {
                MyCheckedIcon.$$$reportNull$$$0(0);
            }
            return icon;
        }

        public void paintIcon(Component c2, Graphics g, int x, int y) {
            IconUtil.scale((Icon)PlatformIcons.CHECK_ICON, (Component)c2, (float)this.getScale()).paintIcon(c2, g, x, y);
        }

        public int getIconWidth() {
            return this.scale(PlatformIcons.CHECK_ICON.getIconWidth());
        }

        private int scale(int width) {
            return (int)Math.ceil(this.scaleVal(width, ScaleType.OBJ_SCALE));
        }

        public int getIconHeight() {
            return this.scale(PlatformIcons.CHECK_ICON.getIconHeight());
        }

        @NotNull
        public MyCheckedIcon copy() {
            MyCheckedIcon myCheckedIcon = new MyCheckedIcon();
            if (myCheckedIcon == null) {
                MyCheckedIcon.$$$reportNull$$$0(1);
            }
            return myCheckedIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/bookmarks/Bookmark$MyCheckedIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "retrieveIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class MnemonicIcon
    extends JBCachingScalableIcon<MnemonicIcon> {
        private static final MnemonicIcon[] cache = new MnemonicIcon[36];
        private final char myMnemonic;

        @NotNull
        public MnemonicIcon copy() {
            MnemonicIcon mnemonicIcon = new MnemonicIcon(this.myMnemonic);
            if (mnemonicIcon == null) {
                MnemonicIcon.$$$reportNull$$$0(0);
            }
            return mnemonicIcon;
        }

        @NotNull
        static MnemonicIcon getIcon(char mnemonic) {
            int index = mnemonic - 48;
            if (index > 9) {
                index -= 7;
            }
            if (index < 0 || index > cache.length - 1) {
                MnemonicIcon mnemonicIcon = new MnemonicIcon(mnemonic);
                if (mnemonicIcon == null) {
                    MnemonicIcon.$$$reportNull$$$0(1);
                }
                return mnemonicIcon;
            }
            if (cache[index] == null) {
                MnemonicIcon.cache[index] = new MnemonicIcon(mnemonic);
            }
            MnemonicIcon mnemonicIcon = cache[index];
            if (mnemonicIcon == null) {
                MnemonicIcon.$$$reportNull$$$0(2);
            }
            return mnemonicIcon;
        }

        private MnemonicIcon(char mnemonic) {
            this.myMnemonic = mnemonic;
        }

        public void paintIcon(Component c2, Graphics g, int x, int y) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            g.setColor((Color)new JBColor(() -> !Bookmark.darkBackground() ? new Color(0xFFFFCC) : new Color(6770995)));
            g.fillRect(x, y, width, height);
            g.setColor((Color)JBColor.GRAY);
            g.drawRect(x, y, width, height);
            g.setColor(EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground());
            UISettings.setupAntialiasing((Graphics)g);
            float startingFontSize = 40.0f;
            Font font = Bookmark.getBookmarkFont().deriveFont(startingFontSize);
            FontRenderContext fontRenderContext = ((Graphics2D)g).getFontRenderContext();
            double height40 = font.createGlyphVector(fontRenderContext, new char[]{'A'}).getVisualBounds().getHeight();
            font = font.deriveFont((float)((double)(startingFontSize * (float)height) / height40 * 0.7));
            GlyphVector gv = font.createGlyphVector(fontRenderContext, new char[]{this.myMnemonic});
            Rectangle2D bounds2 = gv.getVisualBounds();
            ((Graphics2D)g).drawGlyphVector(gv, (float)((double)x + ((double)width - bounds2.getWidth()) / 2.0 - bounds2.getX()), (float)((double)y + ((double)height - bounds2.getHeight()) / 2.0 - bounds2.getY()));
        }

        public int getIconWidth() {
            return this.scale(DEFAULT_ICON.getIconWidth());
        }

        private int scale(int width) {
            return (int)Math.ceil(this.scaleVal(width, ScaleType.OBJ_SCALE));
        }

        public int getIconHeight() {
            return this.scale(DEFAULT_ICON.getIconHeight());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MnemonicIcon that = (MnemonicIcon)((Object)o);
            return this.myMnemonic == that.myMnemonic;
        }

        public int hashCode() {
            return this.myMnemonic;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/bookmarks/Bookmark$MnemonicIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

