/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeStyle;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class InconsistentLineSeparatorsInspection
extends LocalInspectionTool {
    @NotNull
    private static final LocalQuickFix SET_PROJECT_LINE_SEPARATORS = new LocalQuickFix(){

        @NotNull
        public String getFamilyName() {
            if ("Convert to project line separators" == null) {
                2.$$$reportNull$$$0(0);
            }
            return "Convert to project line separators";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement;
            if (project == null) {
                2.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                2.$$$reportNull$$$0(2);
            }
            if (!((psiElement = descriptor2.getPsiElement()) instanceof PsiFile)) {
                return;
            }
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project);
            VirtualFile virtualFile = ((PsiFile)psiElement).getVirtualFile();
            if (virtualFile != null) {
                AbstractConvertLineSeparatorsAction.changeLineSeparators(project, virtualFile, lineSeparator);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeStyle/InconsistentLineSeparatorsInspection$2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeStyle/InconsistentLineSeparatorsInspection$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InconsistentLineSeparatorsInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitFile(PsiFile file2) {
                if (!file2.getLanguage().equals(file2.getViewProvider().getBaseLanguage())) {
                    return;
                }
                Project project = holder.getProject();
                String projectLineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project);
                VirtualFile virtualFile = file2.getVirtualFile();
                if (virtualFile == null || !AbstractConvertLineSeparatorsAction.shouldProcess(virtualFile, project)) {
                    return;
                }
                String curLineSeparator = LoadTextUtil.detectLineSeparator(virtualFile, true);
                if (curLineSeparator != null && !curLineSeparator.equals(projectLineSeparator)) {
                    holder.registerProblem((PsiElement)file2, "Line separators in the current file (" + StringUtil.escapeStringCharacters((String)curLineSeparator) + ") differ from the project defaults (" + StringUtil.escapeStringCharacters((String)projectLineSeparator) + ")", new LocalQuickFix[]{SET_PROJECT_LINE_SEPARATORS});
                }
            }
        };
        if (psiElementVisitor == null) {
            InconsistentLineSeparatorsInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeStyle/InconsistentLineSeparatorsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeStyle/InconsistentLineSeparatorsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

