/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveTemplateRunLogger {
    private static final String GROUP = "live.templates";

    LiveTemplateRunLogger() {
    }

    static void log(@NotNull TemplateImpl template, @NotNull Language language) {
        Triple<String, String, PluginInfo> keyGroupPluginToLog;
        if (template == null) {
            LiveTemplateRunLogger.$$$reportNull$$$0(0);
        }
        if (language == null) {
            LiveTemplateRunLogger.$$$reportNull$$$0(1);
        }
        if ((keyGroupPluginToLog = LiveTemplateRunLogger.getKeyGroupPluginToLog(template)) == null) {
            return;
        }
        FeatureUsageData data = new FeatureUsageData().addLanguage(language).addData("group", (String)keyGroupPluginToLog.getSecond());
        PluginInfo plugin = (PluginInfo)keyGroupPluginToLog.getThird();
        if (plugin != null) {
            data.addPluginInfo(plugin);
        }
        FUCounterUsageLogger.getInstance().logEvent(GROUP, (String)keyGroupPluginToLog.getFirst(), data);
    }

    @Nullable
    static Triple<String, String, PluginInfo> getKeyGroupPluginToLog(@NotNull TemplateImpl template) {
        String groupName;
        String key;
        if (template == null) {
            LiveTemplateRunLogger.$$$reportNull$$$0(2);
        }
        if (LiveTemplateRunLogger.isCreatedProgrammatically(key = template.getKey(), groupName = template.getGroupName())) {
            return null;
        }
        PluginInfo plugin = TemplateSettings.getInstance().findPluginForPredefinedTemplate(template);
        if (plugin == null) {
            key = "user.defined.template";
            groupName = "user.defined.group";
        } else if (!plugin.isSafeToReport()) {
            key = "custom.plugin.template";
            groupName = "custom.plugin.group";
        }
        return new Triple((Object)key, (Object)groupName, (Object)plugin);
    }

    private static boolean isCreatedProgrammatically(String key, String groupName) {
        return StringUtil.isEmpty((String)key) || StringUtil.isEmpty((String)groupName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/impl/LiveTemplateRunLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "log";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getKeyGroupPluginToLog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class LiveTemplateValidator
    extends CustomWhiteListRule {
        @Override
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "live_template".equals(ruleId) || "live_template_group".equals(ruleId);
        }

        @Override
        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            if (data == null) {
                LiveTemplateValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                LiveTemplateValidator.$$$reportNull$$$0(1);
            }
            ValidationResultType validationResultType = LiveTemplateValidator.validateKeyGroup(context.eventId, context.eventData.get("group"));
            if (validationResultType == null) {
                LiveTemplateValidator.$$$reportNull$$$0(2);
            }
            return validationResultType;
        }

        @NotNull
        public static ValidationResultType validateKeyGroup(String key, Object group) {
            block10: {
                ValidationResultType validationResultType;
                if (group == null) {
                    ValidationResultType validationResultType2 = ValidationResultType.REJECTED;
                    if (validationResultType2 == null) {
                        LiveTemplateValidator.$$$reportNull$$$0(3);
                    }
                    return validationResultType2;
                }
                if ("user.defined.template".equals(key) && "user.defined.group".equals(group)) {
                    ValidationResultType validationResultType3 = ValidationResultType.ACCEPTED;
                    if (validationResultType3 == null) {
                        LiveTemplateValidator.$$$reportNull$$$0(4);
                    }
                    return validationResultType3;
                }
                if ("custom.plugin.template".equals(key) && "custom.plugin.group".equals(group)) {
                    ValidationResultType validationResultType4 = ValidationResultType.ACCEPTED;
                    if (validationResultType4 == null) {
                        LiveTemplateValidator.$$$reportNull$$$0(5);
                    }
                    return validationResultType4;
                }
                try {
                    PluginInfo info;
                    TemplateImpl template = TemplateSettings.getInstance().getTemplate(key, group.toString());
                    if (template == null || (info = TemplateSettings.getInstance().findPluginForPredefinedTemplate(template)) == null || !info.isSafeToReport()) break block10;
                    validationResultType = ValidationResultType.ACCEPTED;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (validationResultType == null) {
                    LiveTemplateValidator.$$$reportNull$$$0(6);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                LiveTemplateValidator.$$$reportNull$$$0(7);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/impl/LiveTemplateRunLogger$LiveTemplateValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/impl/LiveTemplateRunLogger$LiveTemplateValidator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validateKeyGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

