/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.codeEditor.printing.ExportToHTMLDialog;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeEditor.printing.HTMLTextPainter;
import com.intellij.codeEditor.printing.PrintOption;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExportToHTMLManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeEditor.printing.ExportToHTMLManager");
    private static FileNotFoundException myLastException;

    private ExportToHTMLManager() {
    }

    public static void executeExport(DataContext dataContext) throws FileNotFoundException {
        PsiDirectory psiDirectory = null;
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement instanceof PsiDirectory) {
            psiDirectory = (PsiDirectory)psiElement;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        String shortFileName = null;
        String directoryName = null;
        if (psiFile != null || psiDirectory != null) {
            if (psiFile != null) {
                shortFileName = psiFile.getVirtualFile().getName();
                if (psiDirectory == null) {
                    psiDirectory = psiFile.getContainingDirectory();
                }
            }
            if (psiDirectory != null) {
                directoryName = psiDirectory.getVirtualFile().getPresentableUrl();
            }
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        boolean isSelectedTextEnabled = false;
        if (editor != null && editor.getSelectionModel().hasSelection()) {
            isSelectedTextEnabled = true;
        }
        ExportToHTMLDialog exportToHTMLDialog = new ExportToHTMLDialog(shortFileName, directoryName, isSelectedTextEnabled, project);
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(project);
        if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
            String baseDir = Objects.requireNonNull(project).getBasePath();
            exportToHTMLSettings.OUTPUT_DIRECTORY = baseDir != null ? baseDir + File.separator + "exportToHTML" : "";
        }
        exportToHTMLDialog.reset();
        if (!exportToHTMLDialog.showAndGet()) {
            return;
        }
        try {
            exportToHTMLDialog.apply();
        }
        catch (ConfigurationException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        String outputDirectoryName = exportToHTMLSettings.OUTPUT_DIRECTORY;
        if (exportToHTMLSettings.getPrintScope() != 4) {
            if (psiFile == null || psiFile.getText() == null) {
                return;
            }
            String dirName = ExportToHTMLManager.constructOutputDirectory(psiFile, outputDirectoryName);
            HTMLTextPainter textPainter = new HTMLTextPainter(psiFile, project, exportToHTMLSettings.PRINT_LINE_NUMBERS);
            if (exportToHTMLSettings.getPrintScope() == 2 && editor != null && editor.getSelectionModel().hasSelection()) {
                int firstLine = editor.getDocument().getLineNumber(editor.getSelectionModel().getSelectionStart());
                textPainter.setSegment(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), firstLine);
            }
            try {
                String htmlFile = ExportToHTMLManager.doPaint(dirName, textPainter, null);
                if (exportToHTMLSettings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((String)htmlFile);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        } else {
            myLastException = null;
            ExportRunnable exportRunnable = new ExportRunnable(exportToHTMLSettings, psiDirectory, outputDirectoryName, project);
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)exportRunnable, CodeEditorBundle.message("export.to.html.title", new Object[0]), true, project);
            if (myLastException != null) {
                throw myLastException;
            }
        }
    }

    @NotNull
    protected static String doPaint(@NotNull String dirName, @NotNull HTMLTextPainter textPainter, @Nullable TreeMap refMap) throws IOException {
        if (dirName == null) {
            ExportToHTMLManager.$$$reportNull$$$0(0);
        }
        if (textPainter == null) {
            ExportToHTMLManager.$$$reportNull$$$0(1);
        }
        String htmlFile = dirName + File.separator + ExportToHTMLManager.getHTMLFileName(textPainter.getPsiFile());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), StandardCharsets.UTF_8);){
            textPainter.paint(refMap, writer, true);
        }
        String string = htmlFile;
        if (string == null) {
            ExportToHTMLManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static boolean exportPsiFile(PsiFile psiFile, String outputDirectoryName, Project project, HashMap<PsiFile, PsiFile> filesMap) {
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(project);
        if (psiFile instanceof PsiBinaryFile) {
            return true;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!psiFile.isValid()) {
                return;
            }
            TreeMap<Integer, PsiReference> refMap = null;
            for (PrintOption printOption : PrintOption.EP_NAME.getExtensionList()) {
                TreeMap<Integer, PsiReference> map2 = printOption.collectReferences(psiFile, filesMap);
                if (map2 == null) continue;
                refMap = new TreeMap<Integer, PsiReference>((SortedMap<Integer, PsiReference>)map2);
            }
            String dirName = ExportToHTMLManager.constructOutputDirectory(psiFile, outputDirectoryName);
            try {
                ExportToHTMLManager.doPaint(dirName, new HTMLTextPainter(psiFile, project, exportToHTMLSettings.PRINT_LINE_NUMBERS), refMap);
            }
            catch (FileNotFoundException e) {
                myLastException = e;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
        return myLastException == null;
    }

    private static String constructOutputDirectory(PsiFile psiFile, String outputDirectoryName) {
        return ExportToHTMLManager.constructOutputDirectory(psiFile.getContainingDirectory(), outputDirectoryName);
    }

    private static String constructOutputDirectory(@NotNull PsiDirectory directory, String outputDirectoryName) {
        if (directory == null) {
            ExportToHTMLManager.$$$reportNull$$$0(3);
        }
        String qualifiedName = PsiDirectoryFactory.getInstance(directory.getProject()).getQualifiedName(directory, false);
        String dirName = outputDirectoryName;
        if (qualifiedName.length() > 0) {
            dirName = dirName + File.separator + qualifiedName.replace('.', File.separatorChar);
        }
        File dir = new File(dirName);
        dir.mkdirs();
        return dirName;
    }

    private static void addToPsiFileList(PsiDirectory psiDirectory, List<? super PsiFile> filesList, boolean isRecursive, String outputDirectoryName) throws FileNotFoundException {
        if (!psiDirectory.isValid()) {
            return;
        }
        PsiFile[] files2 = psiDirectory.getFiles();
        Collections.addAll(filesList, files2);
        ExportToHTMLManager.generateIndexHtml(psiDirectory, isRecursive, outputDirectoryName);
        if (isRecursive) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = psiDirectory.getSubdirectories()) {
                ExportToHTMLManager.addToPsiFileList(directory, filesList, isRecursive, outputDirectoryName);
            }
        }
    }

    private static void generateIndexHtml(PsiDirectory psiDirectory, boolean recursive, String outputDirectoryName) throws FileNotFoundException {
        String indexHtmlName = ExportToHTMLManager.constructOutputDirectory(psiDirectory, outputDirectoryName) + File.separator + "index.html";
        String title = PsiDirectoryFactory.getInstance(psiDirectory.getProject()).getQualifiedName(psiDirectory, true);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(indexHtmlName), StandardCharsets.UTF_8);){
            writer.write("<html><head><title>" + title + "</title></head><body>");
            if (recursive) {
                PsiDirectory[] directories;
                for (PsiDirectory psiDirectory2 : directories = psiDirectory.getSubdirectories()) {
                    writer.write("<a href=\"" + psiDirectory2.getName() + "/index.html\"><b>" + psiDirectory2.getName() + "</b></a><br />");
                }
            }
            PsiFile[] files2 = psiDirectory.getFiles();
            for (PsiDirectory psiDirectory3 : files2) {
                if (psiDirectory3 instanceof PsiBinaryFile) continue;
                writer.write("<a href=\"" + ExportToHTMLManager.getHTMLFileName((PsiFile)psiDirectory3) + "\">" + psiDirectory3.getVirtualFile().getName() + "</a><br />");
            }
            writer.write("</body></html>");
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    static String getHTMLFileName(PsiFile psiFile) {
        return psiFile.getVirtualFile().getName() + ".html";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textPainter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeEditor/printing/ExportToHTMLManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeEditor/printing/ExportToHTMLManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doPaint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doPaint";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "constructOutputDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExportRunnable
    implements Runnable {
        private final ExportToHTMLSettings myExportToHTMLSettings;
        private final PsiDirectory myPsiDirectory;
        private final String myOutputDirectoryName;
        private final Project myProject;

        ExportRunnable(ExportToHTMLSettings exportToHTMLSettings, PsiDirectory psiDirectory, String outputDirectoryName, Project project) {
            this.myExportToHTMLSettings = exportToHTMLSettings;
            this.myPsiDirectory = psiDirectory;
            this.myOutputDirectoryName = outputDirectoryName;
            this.myProject = project;
        }

        @Override
        public void run() {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            ArrayList filesList = new ArrayList();
            boolean isRecursive = this.myExportToHTMLSettings.isIncludeSubdirectories();
            ApplicationManager.getApplication().runReadAction(() -> {
                try {
                    ExportToHTMLManager.addToPsiFileList(this.myPsiDirectory, filesList, isRecursive, this.myOutputDirectoryName);
                }
                catch (FileNotFoundException e) {
                    myLastException = e;
                }
            });
            if (myLastException != null) {
                return;
            }
            HashMap<PsiFile, PsiFile> filesMap = new HashMap<PsiFile, PsiFile>();
            for (PsiFile psiFile : filesList) {
                filesMap.put(psiFile, psiFile);
            }
            for (int i = 0; i < filesList.size(); ++i) {
                PsiFile psiFile;
                psiFile = (PsiFile)filesList.get(i);
                if (progressIndicator.isCanceled()) {
                    return;
                }
                progressIndicator.setText(CodeEditorBundle.message("export.to.html.generating.file.progress", ExportToHTMLManager.getHTMLFileName(psiFile)));
                progressIndicator.setFraction((double)i / (double)filesList.size());
                if (ExportToHTMLManager.exportPsiFile(psiFile, this.myOutputDirectoryName, this.myProject, filesMap)) continue;
                return;
            }
            if (this.myExportToHTMLSettings.OPEN_IN_BROWSER) {
                String dirToShow = this.myExportToHTMLSettings.OUTPUT_DIRECTORY;
                if (!dirToShow.endsWith(File.separator)) {
                    dirToShow = dirToShow + File.separatorChar;
                }
                dirToShow = dirToShow + PsiDirectoryFactory.getInstance(this.myProject).getQualifiedName(this.myPsiDirectory, false).replace('.', File.separatorChar);
                BrowserUtil.browse((String)dirToShow);
            }
        }
    }
}

