/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.remote.ext.PathMappingType;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.ChangesTrackingTableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsManager;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteMappingsConfiguration {
    private static final PathMappingType USER_DEFINED = new PathMappingType(AllIcons.Ide.Readwrite, "User-defined");
    private static final PathMappingType HEADER = new PathMappingType(null, "Header");
    private static final int LOCAL_INDEX = 0;
    private static final int REMOTE_INDEX = 1;
    private static final int DISABLED = 2;
    public static final int VALIDATION_INTERVAL = 300;
    public static final Comparator<MappingWrapper> LOCAL_PATH_COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getMapping().getLocalRoot(), (String)o2.getMapping().getLocalRoot(), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0);
    public static final String HELP_ID = "remote.mappings";
    private ChangesTrackingTableView<MappingWrapper> myTable;
    @NotNull
    private final Project myProject;
    @Nullable
    private final RemoteCredentials myCredentials;
    private final boolean myWithDisabling;
    private final boolean myWithType;
    private ToolbarDecorator myToolbarDecorator;
    private JPanel myPanel;
    private boolean myValidatedOk;
    private Consumer<Boolean> myValidationCallback;
    private final Set<String> myDuplicateUserLocalPaths;
    private String myErrorText;

    public RemoteMappingsConfiguration(@NotNull Project project, @NotNull List<MappingWrapper> data, @Nullable RemoteCredentials credentials, boolean withDisabling, boolean withType, @NotNull Disposable disposable) {
        if (project == null) {
            RemoteMappingsConfiguration.$$$reportNull$$$0(0);
        }
        if (data == null) {
            RemoteMappingsConfiguration.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            RemoteMappingsConfiguration.$$$reportNull$$$0(2);
        }
        this.myValidatedOk = true;
        this.myProject = project;
        this.myCredentials = credentials;
        this.myWithDisabling = withDisabling;
        this.myWithType = withType;
        this.myDuplicateUserLocalPaths = new HashSet<String>();
        this.createUI(data, disposable);
    }

    public void setValidationCallback(Consumer<Boolean> validationCallback) {
        this.myValidationCallback = validationCallback;
    }

    private void validateTable() {
        ListTableModel model = this.myTable.getListTableModel();
        ArrayList items = new ArrayList(model.getItems());
        boolean editingLocal = false;
        int editingRow = -1;
        String editingValue = null;
        if (this.myTable.isEditing()) {
            editingLocal = this.myTable.getEditingColumn() == 0;
            editingRow = this.myTable.getEditingRow();
            Object value = this.myTable.getCellEditor() == null ? null : this.myTable.getCellEditor().getCellEditorValue();
            editingValue = value instanceof String ? (String)value : null;
        }
        HashSet<String> duplicateControl = new HashSet<String>();
        this.myDuplicateUserLocalPaths.clear();
        this.myErrorText = null;
        boolean validatedOk = true;
        for (int i = 0; i < items.size(); ++i) {
            String remoteRoot;
            MappingWrapper wrapper = (MappingWrapper)items.get(i);
            if (!USER_DEFINED.equals((Object)wrapper.getType())) continue;
            String localRoot = editingLocal && editingRow == i ? editingValue : wrapper.getMapping().getLocalRoot();
            String string = remoteRoot = !editingLocal && editingRow == i ? editingValue : wrapper.getMapping().getRemoteRoot();
            if (StringUtil.isEmptyOrSpaces((String)localRoot) || StringUtil.isEmptyOrSpaces((String)remoteRoot)) {
                validatedOk = false;
                this.myErrorText = "Some paths are empty";
            }
            if (duplicateControl.contains(localRoot)) {
                this.myDuplicateUserLocalPaths.add(localRoot);
                if (validatedOk) {
                    this.myErrorText = "There are duplicate local user-defined paths";
                }
                validatedOk = false;
            }
            duplicateControl.add(localRoot);
        }
        this.myTable.revalidate();
        this.myTable.repaint();
        this.myValidatedOk = validatedOk;
        if (this.myValidationCallback != null) {
            this.myValidationCallback.consume((Object)this.myValidatedOk);
        }
    }

    public boolean isValidatedOk() {
        return this.myValidatedOk;
    }

    public String getErrorText() {
        return this.myErrorText;
    }

    private void createUI(List<MappingWrapper> data, @NotNull Disposable disposable) {
        if (disposable == null) {
            RemoteMappingsConfiguration.$$$reportNull$$$0(3);
        }
        this.myTable = new ChangesTrackingTableView<MappingWrapper>(){

            protected void onCellValueChanged(int row, int column, Object value) {
                RemoteMappingsConfiguration.this.myValidatedOk = false;
            }

            protected void onEditingStopped() {
            }
        };
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myTable.setRowHeight(Math.max(UIUtil.getBalloonWarningIcon().getIconHeight() + 2, new JTextField().getPreferredSize().height + 2));
        ListTableModel model = new ListTableModel(this.createColumns(), new ArrayList<MappingWrapper>(data));
        model.setSortable(false);
        this.myTable.setModelAndUpdateColumns(model);
        this.myToolbarDecorator = ToolbarDecorator.createDecorator(this.myTable).setAddAction(button -> {
            ListTableModel model1 = this.myTable.getListTableModel();
            int newRow = model1.getRowCount() == 0 ? 0 : model1.getRowCount() - 1;
            for (int i = 0; i < model1.getRowCount(); ++i) {
                if (!HEADER.equals((Object)((MappingWrapper)model1.getRowValue(i)).getType())) continue;
                newRow = i;
                break;
            }
            model1.insertRow(newRow, (Object)new MappingWrapper(USER_DEFINED, new PathMappingSettings.PathMapping(null, null)));
            this.myTable.getSelectionModel().setSelectionInterval(newRow, newRow);
            this.myTable.editCellAt(newRow, 0);
            Component component = this.myTable.getCellEditor(newRow, 0).getTableCellEditorComponent((JTable)this.myTable, "", true, newRow, 0);
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(component, true);
            this.validateTable();
        }).setRemoveActionUpdater(e -> {
            List objects = this.myTable.getSelectedObjects();
            if (objects.isEmpty()) {
                return false;
            }
            for (MappingWrapper object : objects) {
                if (USER_DEFINED.equals((Object)object.getType())) continue;
                return false;
            }
            return true;
        }).disableUpDownActions();
        this.myPanel = this.myToolbarDecorator.createPanel();
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, disposable);
        alarm.addRequest(this.createValidateRequest(alarm), 300, ModalityState.any());
    }

    private Runnable createValidateRequest(Alarm alarm) {
        return () -> {
            this.validateTable();
            alarm.addRequest(this.createValidateRequest(alarm), 300, ModalityState.any());
        };
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private ColumnInfo[] createColumns() {
        if (!this.myWithDisabling && !this.myWithType) {
            return new ColumnInfo[]{this.createLocalPathColumn(), this.createRemotePathColumn()};
        }
        if (!this.myWithDisabling) {
            return new ColumnInfo[]{this.createIconColumn(), this.createLocalPathColumn(), this.createRemotePathColumn()};
        }
        if (!this.myWithType) {
            return new ColumnInfo[]{this.createLocalPathColumn(), this.createRemotePathColumn(), this.createDisabledColumn()};
        }
        return new ColumnInfo[]{this.createIconColumn(), this.createLocalPathColumn(), this.createRemotePathColumn(), this.createDisabledColumn()};
    }

    private ColumnInfo createDisabledColumn() {
        return new ColumnInfo<MappingWrapper, Boolean>("Disabled"){

            @Nullable
            public Boolean valueOf(MappingWrapper wrapper) {
                return !USER_DEFINED.equals((Object)wrapper.getType()) && wrapper.isDisabled();
            }

            public boolean isCellEditable(MappingWrapper wrapper) {
                return !USER_DEFINED.equals((Object)wrapper.getType());
            }

            public void setValue(MappingWrapper wrapper, Boolean value) {
                if (!USER_DEFINED.equals((Object)wrapper.getType())) {
                    wrapper.setDisabled(value);
                }
            }

            @Nullable
            public TableCellEditor getEditor(MappingWrapper wrapper) {
                return new BooleanTableCellEditor(false);
            }

            @Nullable
            public TableCellRenderer getRenderer(MappingWrapper wrapper) {
                return new BooleanTableCellRenderer();
            }
        };
    }

    private ColumnInfo createIconColumn() {
        return new ColumnInfo<MappingWrapper, Object>(" "){
            private final ColoredTableCellRenderer myRenderer;
            {
                this.myRenderer = new ColoredTableCellRenderer(){

                    protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                        if (value instanceof Icon) {
                            this.setIcon((Icon)value);
                        }
                    }
                };
            }

            @Nullable
            public Object valueOf(MappingWrapper wrapper) {
                return wrapper.getType().getIcon();
            }

            public int getWidth(JTable table) {
                return UIUtil.getBalloonWarningIcon().getIconWidth() + 2;
            }

            @Nullable
            public TableCellRenderer getRenderer(MappingWrapper wrapper) {
                return this.myRenderer;
            }
        };
    }

    @NotNull
    private ColumnInfo<MappingWrapper, String> createRemotePathColumn() {
        ColumnInfo<MappingWrapper, String> columnInfo = new ColumnInfo<MappingWrapper, String>("Remote Path"){
            private final Comparator<MappingWrapper> myComparator;
            {
                this.myComparator = (o1, o2) -> StringUtil.compare((String)o1.getMapping().getRemoteRoot(), (String)o2.getMapping().getRemoteRoot(), (boolean)false);
            }

            @Nullable
            public String valueOf(MappingWrapper mapping) {
                return mapping.getMapping().getRemoteRoot();
            }

            public boolean isCellEditable(MappingWrapper mapping) {
                return USER_DEFINED.equals((Object)mapping.myType);
            }

            public void setValue(MappingWrapper mapping, String value) {
                mapping.getMapping().setRemoteRoot(value);
            }

            @Nullable
            public TableCellEditor getEditor(MappingWrapper mapping) {
                if (RemoteMappingsConfiguration.this.myCredentials == null) {
                    return null;
                }
                return new LocalPathCellEditor(){

                    protected ActionListener createActionListener(JTable table) {
                        return e -> {
                            String file = RemoteSdkUtil.chooseRemoteFile(RemoteMappingsConfiguration.this.myProject, RemoteMappingsConfiguration.this.myCredentials, false);
                            if (!StringUtil.isEmptyOrSpaces((String)file)) {
                                ((JTextField)this.myComponent.getChildComponent()).setText(file);
                            }
                        };
                    }
                };
            }

            @Nullable
            public TableCellRenderer getRenderer(MappingWrapper wrapper) {
                return new MyTableCellRenderer();
            }

            @Nullable
            public Comparator<MappingWrapper> getComparator() {
                return this.myComparator;
            }
        };
        if (columnInfo == null) {
            RemoteMappingsConfiguration.$$$reportNull$$$0(4);
        }
        return columnInfo;
    }

    @NotNull
    private ColumnInfo<MappingWrapper, String> createLocalPathColumn() {
        ColumnInfo<MappingWrapper, String> columnInfo = new ColumnInfo<MappingWrapper, String>("Local Path"){
            private final Comparator<MappingWrapper> myComparator;
            {
                this.myComparator = LOCAL_PATH_COMPARATOR;
            }

            @Nullable
            public String valueOf(MappingWrapper mapping) {
                return mapping.getMapping().getLocalRoot();
            }

            public boolean isCellEditable(MappingWrapper mapping) {
                return USER_DEFINED.equals((Object)mapping.myType);
            }

            public void setValue(MappingWrapper mapping, String value) {
                mapping.getMapping().setLocalRoot(value);
            }

            @Nullable
            public TableCellEditor getEditor(MappingWrapper mapping) {
                return new LocalPathCellEditor("Choose local path", RemoteMappingsConfiguration.this.myProject);
            }

            @Nullable
            public Comparator<MappingWrapper> getComparator() {
                return this.myComparator;
            }

            @Nullable
            public TableCellRenderer getRenderer(MappingWrapper wrapper) {
                return new MyTableCellRenderer();
            }
        };
        if (columnInfo == null) {
            RemoteMappingsConfiguration.$$$reportNull$$$0(5);
        }
        return columnInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemotePathColumn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalPathColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUI";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTableCellRenderer
    extends SimpleColoredRenderer
    implements TableCellRenderer {
        private MyTableCellRenderer() {
        }

        protected boolean shouldPaintBackground() {
            return true;
        }

        protected SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes) {
            return attributes;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(null);
            if (value == null) {
                return this;
            }
            MappingWrapper mappingWrapper = (MappingWrapper)RemoteMappingsConfiguration.this.myTable.getListTableModel().getRowValue(row);
            if (mappingWrapper != null && !USER_DEFINED.equals((Object)mappingWrapper.getType())) {
                this.setBackground(UIUtil.getLabelBackground());
                this.setPaintFocusBorder(false);
            } else {
                this.setBackground(UIUtil.getTableBackground());
                if (column == 0 && mappingWrapper != null && RemoteMappingsConfiguration.this.myDuplicateUserLocalPaths.contains(StringUtil.notNullize((String)mappingWrapper.getMapping().getLocalRoot()))) {
                    this.setBorder(BorderFactory.createLineBorder((Color)JBColor.RED));
                }
            }
            if (mappingWrapper != null && HEADER.equals((Object)mappingWrapper.getType())) {
                this.append(value.toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else {
                this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            return this;
        }
    }

    private static class MappingWrapper {
        private final PathMappingType myType;
        private final PathMappingSettings.PathMapping myMapping;
        private boolean myIsDisabled;

        MappingWrapper(PathMappingType type, PathMappingSettings.PathMapping mapping) {
            this.myType = type;
            this.myMapping = mapping;
            this.myIsDisabled = false;
        }

        public boolean isDisabled() {
            return this.myIsDisabled;
        }

        public void setDisabled(boolean disabled) {
            this.myIsDisabled = disabled;
        }

        public PathMappingType getType() {
            return this.myType;
        }

        public PathMappingSettings.PathMapping getMapping() {
            return this.myMapping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappingWrapper wrapper = (MappingWrapper)o;
            if (this.myType != wrapper.myType) {
                return false;
            }
            return !(this.myMapping != null ? !this.myMapping.equals((Object)wrapper.myMapping) : wrapper.myMapping != null);
        }

        public int hashCode() {
            int result = this.myType != null ? this.myType.hashCode() : 0;
            result = 31 * result + (this.myMapping != null ? this.myMapping.hashCode() : 0);
            return result;
        }
    }

    public static class Builder {
        @NotNull
        private final Project myProject;
        @NotNull
        private final String myPrefix;
        @NotNull
        private final String myServerId;
        @NotNull
        private final RemoteSdkAdditionalData mySdkAdditionalData;
        @Nullable
        private final RemoteMappingsManager.Mappings myMappings;
        private final Map<PathMappingType, List<PathMappingSettings.PathMapping>> myMap;
        private boolean myWithDisabling;
        private boolean myWithType;
        private final Comparator<MappingWrapper> myMappingsComparator;
        private String myTooltipText;
        private JComponent myDescriptionComponent;

        public Builder(@NotNull Project project, @NotNull String prefix, @NotNull String serverId, @NotNull RemoteSdkAdditionalData sdkAdditionalData) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                Builder.$$$reportNull$$$0(1);
            }
            if (serverId == null) {
                Builder.$$$reportNull$$$0(2);
            }
            if (sdkAdditionalData == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myPrefix = prefix;
            this.myServerId = serverId;
            this.mySdkAdditionalData = sdkAdditionalData;
            this.myMappings = RemoteMappingsManager.getInstance(project).getForServer(prefix, serverId);
            this.myMap = new HashMap<PathMappingType, List<PathMappingSettings.PathMapping>>();
            this.myMappingsComparator = this.createMappingsComparator();
        }

        public Builder withMappings(@NotNull PathMappingType type, @NotNull List<PathMappingSettings.PathMapping> mappings) {
            if (type == null) {
                Builder.$$$reportNull$$$0(4);
            }
            if (mappings == null) {
                Builder.$$$reportNull$$$0(5);
            }
            if (USER_DEFINED.equals((Object)type)) {
                return null;
            }
            this.myMap.put(type, mappings);
            return this;
        }

        public Builder withDescriptionComponent(@NotNull JComponent component) {
            if (component == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myDescriptionComponent = component;
            return this;
        }

        public Builder setWithDisabling(boolean withDisabling) {
            this.myWithDisabling = withDisabling;
            return this;
        }

        public Builder setWithType(boolean withType) {
            this.myWithType = withType;
            return this;
        }

        @Nullable
        public String getPresentation() throws ExecutionException {
            return this.getPresentation(this.convertToWrappers(false));
        }

        @Nullable
        public String getPresentation(@NotNull Collection<MappingWrapper> mappings) throws ExecutionException {
            if (mappings == null) {
                Builder.$$$reportNull$$$0(7);
            }
            if (!mappings.isEmpty()) {
                ArrayList<MappingWrapper> list = new ArrayList<MappingWrapper>(mappings);
                Collections.sort(list, this.myMappingsComparator);
                StringBuilder sb = new StringBuilder();
                for (MappingWrapper wrapper : list) {
                    if (wrapper.isDisabled() || HEADER.equals((Object)wrapper.getType())) continue;
                    if (sb.length() > 0) {
                        sb.append("; ");
                    }
                    sb.append(this.present(wrapper.getMapping(), "<Project root>"));
                }
                if (sb.length() > 0) {
                    return sb.toString();
                }
                return "(Everything disabled)";
            }
            return null;
        }

        @NotNull
        private Comparator<MappingWrapper> createMappingsComparator() {
            Comparator baseComparator = (o1, o2) -> FileUtil.toSystemIndependentName((String)o1.getMapping().getLocalRoot()).compareTo(FileUtil.toSystemIndependentName((String)o2.getMapping().getLocalRoot()));
            if (this.myProject.getBasePath() == null) {
                Comparator comparator = baseComparator;
                if (comparator == null) {
                    Builder.$$$reportNull$$$0(8);
                }
                return comparator;
            }
            File projectFile = new File(this.myProject.getBasePath());
            Comparator comparator = (o1, o2) -> {
                if (!o1.getType().equals((Object)o2.getType())) {
                    return USER_DEFINED.equals((Object)o1.getType()) ? -1 : 1;
                }
                if (FileUtil.filesEqual((File)projectFile, (File)new File(o1.getMapping().getLocalRoot()))) {
                    return -1;
                }
                if (FileUtil.filesEqual((File)projectFile, (File)new File(o2.getMapping().getLocalRoot()))) {
                    return 1;
                }
                return baseComparator.compare(o1, o2);
            };
            if (comparator == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return comparator;
        }

        public String getTooltipText() {
            if (this.myTooltipText == null) {
                ArrayList<MappingWrapper> wrappers = new ArrayList<MappingWrapper>(this.convertToWrappers(true));
                StringBuilder sb = new StringBuilder();
                for (MappingWrapper wrapper : wrappers) {
                    if (wrapper.isDisabled()) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    if (HEADER.equals((Object)wrapper.getType())) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append("<b>").append(wrapper.getMapping().getLocalRoot()).append("</b>");
                        continue;
                    }
                    sb.append(this.present(wrapper.getMapping(), "&lt;Project root&gt;"));
                }
                this.myTooltipText = sb.toString();
            }
            return this.myTooltipText;
        }

        private String present(PathMappingSettings.PathMapping mapping, @NotNull String projectRoot) {
            if (projectRoot == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return RemoteMappingsUIUtil.present(this.myProject, mapping, projectRoot);
        }

        public String configureAndSelect() throws ExecutionException {
            List<MappingWrapper> list = this.convertToWrappers(true);
            Disposable disposable = Disposer.newDisposable();
            RemoteSdkCredentials credentials = null;
            if (!(this.mySdkAdditionalData.getRemoteConnectionType() instanceof CredentialsTypeEx) || ((CredentialsTypeEx)this.mySdkAdditionalData.getRemoteConnectionType()).useRemoteCredentials()) {
                try {
                    credentials = this.mySdkAdditionalData.getRemoteSdkCredentials(this.myProject, true);
                }
                catch (InterruptedException e) {
                    throw new ExecutionException((Throwable)e);
                }
            }
            RemoteMappingsConfiguration configuration = new RemoteMappingsConfiguration(this.myProject, list, (RemoteCredentials)credentials, this.myWithDisabling, this.myWithType, disposable);
            DialogBuilder builder = new DialogBuilder();
            builder.setTitle("Edit Project Path Mappings");
            JPanel wrapperPanel = new JPanel(new BorderLayout());
            wrapperPanel.add((Component)configuration.getPanel(), "Center");
            JPanel wrapperPanel2 = new JPanel(new BorderLayout());
            wrapperPanel.add((Component)wrapperPanel2, "South");
            if (this.myDescriptionComponent != null) {
                wrapperPanel2.add((Component)this.myDescriptionComponent, "East");
                this.myDescriptionComponent.setAlignmentX(1.0f);
            }
            builder.setCenterPanel((JComponent)wrapperPanel);
            builder.setDimensionServiceKey(RemoteMappingsConfiguration.class.getName());
            builder.setPreferredFocusComponent((JComponent)configuration.myTable);
            builder.addDisposable(disposable);
            builder.setHelpId(RemoteMappingsConfiguration.HELP_ID);
            configuration.setValidationCallback((Consumer<Boolean>)((Consumer)aBoolean -> {
                builder.setOkActionEnabled(aBoolean.booleanValue());
                builder.setErrorText(configuration.getErrorText(), (JComponent)configuration.getPanel());
            }));
            if (!builder.showAndGet()) {
                return null;
            }
            ListTableModel model = configuration.myTable.getListTableModel();
            ArrayList settings = new ArrayList();
            HashMap<String, String> disabled = new HashMap<String, String>();
            for (MappingWrapper wrapper : model.getItems()) {
                if (USER_DEFINED.equals((Object)wrapper.getType())) {
                    settings.add(wrapper.getMapping());
                    continue;
                }
                if (!wrapper.isDisabled()) continue;
                disabled.put(wrapper.getMapping().getLocalRoot(), wrapper.getMapping().getRemoteRoot());
            }
            RemoteMappingsManager.Mappings newMappings = RemoteMappingsManager.getInstance(this.myProject).create(this.myPrefix, this.myServerId, settings.isEmpty() ? Collections.emptyList() : settings);
            if (!disabled.isEmpty()) {
                newMappings.setDisabled(disabled);
            }
            RemoteMappingsManager.getInstance(this.myProject).setForServer(newMappings);
            return this.getPresentation(model.getItems());
        }

        @NotNull
        private List<MappingWrapper> convertToWrappers(boolean withHeaders) {
            Map disabled = this.myMappings == null ? Collections.emptyMap() : this.myMappings.getDisabled();
            ArrayList<MappingWrapper> list = new ArrayList<MappingWrapper>();
            PairConsumer adder = (type, mapping) -> {
                MappingWrapper wrapper = new MappingWrapper((PathMappingType)type, (PathMappingSettings.PathMapping)mapping);
                wrapper.setDisabled(Comparing.equal((String)((String)disabled.get(mapping.getLocalRoot())), (String)mapping.getRemoteRoot()));
                list.add(wrapper);
            };
            if (this.myMappings != null) {
                for (PathMappingSettings.PathMapping pathMapping : this.myMappings.getSettings()) {
                    adder.consume((Object)USER_DEFINED, (Object)pathMapping);
                }
            }
            for (Map.Entry entry : this.myMap.entrySet()) {
                PathMappingType type2 = (PathMappingType)entry.getKey();
                List mappingsList = (List)entry.getValue();
                if (mappingsList.isEmpty()) continue;
                if (withHeaders) {
                    list.add(new MappingWrapper(HEADER, new PathMappingSettings.PathMapping(type2.getTooltip(), "")));
                }
                for (PathMappingSettings.PathMapping mapping3 : mappingsList) {
                    adder.consume((Object)type2, (Object)mapping3);
                }
            }
            ArrayList<MappingWrapper> arrayList = list;
            if (arrayList == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkAdditionalData";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappings";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/RemoteMappingsConfiguration$Builder";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMappingsComparator";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToWrappers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withMappings";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "withDescriptionComponent";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "present";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

