/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.channels.SftpChannel;
import com.jetbrains.plugins.remotesdk.CheckConnectionModalTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u0006\u001a\u00020\u0001*\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0005\u001a&\u0010\n\u001a\u00020\u000b*\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"doCheckConnection", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "checkConnection", "project", "Lcom/intellij/openapi/project/Project;", "checkConnectionInBackground", "waitForConnection", "", "Ljava/util/concurrent/Future;", "Lcom/intellij/remote/RemoteSdkException;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "intellij.remoteRun"})
@JvmName(name="RemoteSdkSessionUtil")
public final class RemoteSdkSessionUtil {
    public static final void checkConnection(@NotNull ConnectionBuilder $this$checkConnection, @Nullable Project project) throws RemoteSdkException {
        Intrinsics.checkParameterIsNotNull((Object)$this$checkConnection, (String)"$this$checkConnection");
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
        if (progressIndicator != null) {
            RemoteSdkSessionUtil.doCheckConnection(progressIndicator, $this$checkConnection);
        } else {
            CheckConnectionModalTask task = new CheckConnectionModalTask(project, $this$checkConnection);
            ApplicationManager.getApplication().invokeAndWait(new Runnable(task){
                final /* synthetic */ CheckConnectionModalTask $task;

                public final void run() {
                    ProgressManager.getInstance().run((Task)this.$task);
                }
                {
                    this.$task = checkConnectionModalTask;
                }
            });
            task.checkConnectionResult();
        }
    }

    public static /* synthetic */ void checkConnection$default(ConnectionBuilder connectionBuilder, Project project, int n, Object object) throws RemoteSdkException {
        if ((n & 1) != 0) {
            project = null;
        }
        RemoteSdkSessionUtil.checkConnection(connectionBuilder, project);
    }

    public static final void checkConnectionInBackground(@NotNull ConnectionBuilder $this$checkConnectionInBackground) throws RemoteSdkException {
        Intrinsics.checkParameterIsNotNull((Object)$this$checkConnectionInBackground, (String)"$this$checkConnectionInBackground");
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        RemoteSdkSessionUtil.doCheckConnection(progressManager.getProgressIndicator(), $this$checkConnectionInBackground);
    }

    private static final void doCheckConnection(ProgressIndicator pi, ConnectionBuilder connectionBuilder) throws ProcessCanceledException, RemoteSdkException {
        String host = connectionBuilder.getHost();
        Future future = ApplicationManager.getApplication().executeOnPooledThread((Callable)new Callable<RemoteSdkException>(pi, host, connectionBuilder){
            final /* synthetic */ ProgressIndicator $pi;
            final /* synthetic */ String $host;
            final /* synthetic */ ConnectionBuilder $connectionBuilder;

            @Nullable
            public final RemoteSdkException call() {
                ProgressIndicator progressIndicator = this.$pi;
                if (progressIndicator != null) {
                    progressIndicator.setText("Connecting to " + this.$host + "...");
                }
                try {
                    SftpChannel channel = this.$connectionBuilder.openSftpChannel(60);
                    channel.disconnect();
                }
                catch (Exception e) {
                    return new RemoteSdkException("Error connecting to remote host " + this.$host, (Throwable)e);
                }
                return null;
            }
            {
                this.$pi = progressIndicator;
                this.$host = string;
                this.$connectionBuilder = connectionBuilder;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)future, (String)"ApplicationManager.getAp\u2026, e)\n    }\n\n    null\n  })");
        Future connectionFuture2 = future;
        while (!RemoteSdkSessionUtil.waitForConnection$default(connectionFuture2, 100L, null, 2, null)) {
            ProgressIndicator progressIndicator = pi;
            if (progressIndicator == null) continue;
            progressIndicator.checkCanceled();
        }
    }

    private static final boolean waitForConnection(@NotNull Future<RemoteSdkException> $this$waitForConnection, long timeout, TimeUnit unit) throws ProcessCanceledException, RemoteSdkException {
        try {
            RemoteSdkException exception = $this$waitForConnection.get(timeout, unit);
            if (exception != null) {
                throw (Throwable)exception;
            }
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (InterruptedException e) {
            throw (Throwable)new ProcessCanceledException((Throwable)e);
        }
        catch (CancellationException e) {
            throw (Throwable)new ProcessCanceledException((Throwable)e);
        }
    }

    static /* synthetic */ boolean waitForConnection$default(Future future, long l, TimeUnit timeUnit, int n, Object object) throws ProcessCanceledException, RemoteSdkException {
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return RemoteSdkSessionUtil.waitForConnection(future, l, timeUnit);
    }

    public static final /* synthetic */ void access$doCheckConnection(ProgressIndicator pi, ConnectionBuilder connectionBuilder) {
        RemoteSdkSessionUtil.doCheckConnection(pi, connectionBuilder);
    }
}

