/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.settings.mappings;

import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.StatusText;
import com.jetbrains.jsonSchema.JsonMappingKind;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.settings.mappings.JsonMappingsTableCellEditor;
import com.jetbrains.jsonSchema.settings.mappings.JsonSchemaMappingsView;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;

class JsonMappingsTableView
extends TableView<UserDefinedJsonSchemaConfiguration.Item> {
    private final StatusText myEmptyText = new StatusText(){

        protected boolean isStatusVisible() {
            return JsonMappingsTableView.this.isEmpty();
        }
    };

    JsonMappingsTableView(JsonSchemaMappingsView.MyAddActionButtonRunnable runnable) {
        this.myEmptyText.setText("No schema mappings defined").appendSecondaryText("Add mapping for a ", SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
        JsonMappingKind[] values = JsonMappingKind.values();
        for (int i = 0; i < values.length; ++i) {
            JsonMappingKind kind = values[i];
            this.myEmptyText.appendSecondaryText(kind.getDescription(), SimpleTextAttributes.LINK_ATTRIBUTES, e -> runnable.doRun(kind));
            if (i >= values.length - 1) continue;
            this.myEmptyText.appendSecondaryText(", ", SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
        }
        this.setFocusTraversalKeysEnabled(false);
    }

    public void setCellEditor(TableCellEditor anEditor) {
        super.setCellEditor(anEditor);
        if (anEditor != null) {
            ((JsonMappingsTableCellEditor)((Object)anEditor)).myComponent.getTextField().requestFocus();
        }
    }

    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myEmptyText;
        if (statusText == null) {
            JsonMappingsTableView.$$$reportNull$$$0(0);
        }
        return statusText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/settings/mappings/JsonMappingsTableView", "getEmptyText"));
    }
}

