/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.HiddenPathsManager;
import com.jetbrains.plugins.webDeployment.ui.PropertyProvider;
import com.jetbrains.plugins.webDeployment.ui.WebServerToolWindowPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class WebServerToolWindowFactory
implements ToolWindowFactory,
Condition<Project>,
DumbAware {
    public static final String SERVER_BROWSER_TOOLWINDOW = WDBundle.message("web.server.browser", new Object[0]);
    public static final DeploymentNotifier.ToolWindowIdProvider SERVER_BROWSER_TOOLWINDOW_ID_PROVIDER = new DeploymentNotifier.ToolWindowIdProvider(SERVER_BROWSER_TOOLWINDOW);
    private static final String STATE_KEY = "WebServerToolWindowFactoryState";
    private final HiddenPathsManager myHiddenPathsManager = new HiddenPathsManager();

    public static WebServerToolWindowFactory getInstance() {
        for (ToolWindowEP ep : ToolWindowEP.EP_NAME.getExtensionList()) {
            if (!ep.factoryClass.equals(WebServerToolWindowFactory.class.getName())) continue;
            return (WebServerToolWindowFactory)ep.getToolWindowFactory();
        }
        return null;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            WebServerToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            WebServerToolWindowFactory.$$$reportNull$$$0(1);
        }
        toolWindow.setAvailable(true, null);
        WebServerToolWindowFactory.setAvailable(project, true);
        WebServerToolWindowPanel component = new WebServerToolWindowPanel(project, this.myHiddenPathsManager);
        component.installGearActions((ToolWindowEx)toolWindow);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)component), "", false);
        content.setHelpId("reference.tool.window.remote.host");
        content.setDisposer((Disposable)component);
        toolWindow.getContentManager().addContent(content);
    }

    public boolean value(Project project) {
        return Boolean.valueOf(WebServerToolWindowFactory.getAvailabilityStateProvider(project).readValue());
    }

    private static PropertyProvider getAvailabilityStateProvider(Project project) {
        boolean defaultValue = GroupedServersConfigManager.getInstance(project).getFlattenedServers().stream().anyMatch(server -> server.needsTransfer());
        return new PropertyProvider(project, STATE_KEY, String.valueOf(defaultValue));
    }

    public static void setAvailable(Project project, boolean available) {
        WebServerToolWindowFactory.getAvailabilityStateProvider(project).saveValue(String.valueOf(available));
    }

    public ToolWindow getWebServerToolWindow(Project project) {
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = manager.getToolWindow(SERVER_BROWSER_TOOLWINDOW);
        if (toolWindow == null) {
            toolWindow = manager.registerToolWindow(SERVER_BROWSER_TOOLWINDOW, true, ToolWindowAnchor.RIGHT, (Disposable)project, true);
            this.createToolWindowContent(project, toolWindow);
        }
        toolWindow.setAvailable(true, null);
        return toolWindow;
    }

    public void addHiddenPath(WebServerConfig server, String path) {
        this.myHiddenPathsManager.addHiddenPath(server, path);
    }

    public void removeHiddenPath(WebServerConfig server, String path) {
        this.myHiddenPathsManager.removeHiddenPath(server, path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "toolWindow";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowFactory";
        objectArray[2] = "createToolWindowContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

