/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.util.text.StringUtil;

public class ServerSettingsUsageTriggerCollector {
    private static final String GROUP_ID = "deployment.serverSettingsUI";

    public static void logGroup(boolean created, boolean projectLevel) {
        FeatureUsageData data = new FeatureUsageData().addData("level", projectLevel ? "project" : "IDE");
        String eventId = "NewGroupVisibility" + (created ? "Created" : "Switched");
        FUCounterUsageLogger.getInstance().logEvent(GROUP_ID, eventId, data);
    }

    public static void logAutodetect() {
        FUCounterUsageLogger.getInstance().logEvent(GROUP_ID, "AutodetectPathClicked");
    }

    public static void logProjectIDELevelCheckBoxClick() {
        FUCounterUsageLogger.getInstance().logEvent(GROUP_ID, "ProjectIDELevelCheckBoxClicked");
    }

    public static void logDefaultServerSettingWithAutoUploadOn(boolean changeVsDisable, Decision decision) {
        FeatureUsageData data = new FeatureUsageData().addData("decision", StringUtil.toLowerCase((String)decision.name()));
        String eventId = "defaultServerSettingWithAutoUploadOn" + (changeVsDisable ? "Switched" : "Disabled");
        FUCounterUsageLogger.getInstance().logEvent(GROUP_ID, eventId, data);
    }

    public static enum Decision {
        EXPLICIT,
        SILENT,
        CANCELLED;

    }
}

