/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.troubleshooting.TroubleInfoCollector;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentTroubleInfoCollector
implements TroubleInfoCollector {
    @NotNull
    public String collectInfo(@NotNull Project project) {
        if (project == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(0);
        }
        StringBuilder output = new StringBuilder(2000);
        DeploymentTroubleInfoCollector.collectDeployment(project, output, true);
        String string = output.toString();
        if (string == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String toString() {
        return "Deployment";
    }

    public static void collectDeployment(@NotNull Project project, @NotNull StringBuilder output, boolean additionalSettings) {
        if (project == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(2);
        }
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(3);
        }
        output.append("=====DEPLOYMENT SETTINGS=====\n");
        PluginId id = PluginId.getId((String)"com.jetbrains.plugins.webDeployment");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin((PluginId)id);
        if (PluginManager.isPluginInstalled((PluginId)id) && ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled()) {
            PublishConfig publishConfig = PublishConfig.getInstance(project);
            List<WebServerGroupingWrap> wraps = GroupedServersConfigManager.getInstance(project).getGroupedServers();
            DeploymentTroubleInfoCollector.appendEntry("Default Server", publishConfig.getDefaultServerOrGroupName(), output);
            for (WebServerGroupingWrap wrap : wraps) {
                if (wrap.isSingleServer()) {
                    DeploymentTroubleInfoCollector.writeServerStatus(output, additionalSettings, publishConfig, wrap.getAsSingleServer());
                    continue;
                }
                output.append("** Group ").append(wrap.getName()).append("**\n");
                DeploymentTroubleInfoCollector.appendEntry("Project level", wrap.isProjectLevel(), output);
                for (WebServerConfig server : wrap.getServers()) {
                    DeploymentTroubleInfoCollector.writeServerStatus(output, additionalSettings, publishConfig, server);
                }
                output.append("*********\n");
            }
            if (additionalSettings) {
                output.append("=====ADDITIONAL SETTINGS=====\n");
                DeploymentTroubleInfoCollector.appendEntry("Exclude items by name", publishConfig.getExcludeMask(), output);
                DeploymentTroubleInfoCollector.appendEntry("Operations logging", publishConfig.getTraceLevel().name(), output);
                DeploymentTroubleInfoCollector.appendEntry("Stop operation on the first error", publishConfig.isStopOnFirstError(), output);
                DeploymentTroubleInfoCollector.appendEntry("Overwrite up-to-date files", publishConfig.isOverwriteAll(), output);
                DeploymentTroubleInfoCollector.appendEntry("Preserve file timestamps", publishConfig.isPreserveTimestamps(), output);
                DeploymentTroubleInfoCollector.appendEntry("Delete target items when source do not exist", publishConfig.isDeleteMissingItems(), output);
                DeploymentTroubleInfoCollector.appendEntry("Create empty directories", publishConfig.isCreateEmptyDirectories(), output);
                DeploymentTroubleInfoCollector.appendEntry("Prompt when overwriting or deleting local items", publishConfig.isPromptOnLocalOverwrite(), output);
                DeploymentTroubleInfoCollector.appendEntry("Upload changed files automatically", publishConfig.getAutoUploadState().getPresentableName(), output);
                DeploymentTroubleInfoCollector.appendEntry("Upload external changes", publishConfig.isAutoUploadExternalChanges(), output);
                DeploymentTroubleInfoCollector.appendEntry("Override default permissions on files", publishConfig.getFilePermissions(), output);
                DeploymentTroubleInfoCollector.appendEntry("Override default permissions on folders", publishConfig.getFolderPermissions(), output);
                DeploymentTroubleInfoCollector.appendEntry("Warn when uploading over newer file", publishConfig.getPromptOnRemoteOverwrite().name(), output);
                DeploymentTroubleInfoCollector.appendEntry("Notify of remote changes", publishConfig.isNotifyRemoteChanges(), output);
            }
        }
    }

    private static void writeServerStatus(@NotNull StringBuilder output, boolean additionalSettings, PublishConfig publishConfig, WebServerConfig server) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(4);
        }
        output.append("------------------------\n");
        FileTransferConfig transferConfig = server.getFileTransferConfig();
        DeploymentTroubleInfoCollector.appendEntry("Server name", server.getName(), output);
        DeploymentTroubleInfoCollector.appendEntry("Server type", transferConfig.getAccessType().getTitle(), output);
        DeploymentTroubleInfoCollector.appendEntry("Project level", server.isProjectLevel(), output);
        DeploymentTroubleInfoCollector.appendEntry("Host", transferConfig.getHost(), output);
        DeploymentTroubleInfoCollector.appendEntry("Port", transferConfig.getPort(), output);
        DeploymentTroubleInfoCollector.appendEscapedEntry("Root path", transferConfig.getRootFolder(), output);
        DeploymentTroubleInfoCollector.appendEscapedEntry("Web URL", server.getUrl(), output);
        List<DeploymentPathMapping> mappings = publishConfig.getPathMappings(server.getId());
        DeploymentTroubleInfoCollector.appendEntry("Mappings", "", output);
        for (DeploymentPathMapping deploymentPathMapping : mappings) {
            DeploymentTroubleInfoCollector.appendEscapedMappingEntry(deploymentPathMapping.getLocalPath(), deploymentPathMapping.getDeployPath(), output);
        }
        DeploymentTroubleInfoCollector.appendEntry("Excluded paths", "", output);
        List<ExcludedPath> excludedMappings = publishConfig.getExcludedPaths(server.getId());
        for (ExcludedPath mapping : excludedMappings) {
            DeploymentTroubleInfoCollector.appendEscapedMappingEntry(mapping.getPath(), "", output);
        }
        AccessType accessType = server.getFileTransferConfig().getAccessType();
        if (additionalSettings && accessType != AccessType.LOCAL && accessType != AccessType.MOUNT) {
            if (accessType == AccessType.SFTP) {
                DeploymentTroubleInfoCollector.appendEntry("Auth Type", server.getFileTransferConfig().getAuthType().toString(), output);
                DeploymentTroubleInfoCollector.appendEntry("Ignore info messages", transferConfig.getAdvancedOptions().isMuteSftpMessages(), output);
            }
            if (accessType == AccessType.FTP) {
                DeploymentTroubleInfoCollector.appendEntry("Compatibility mode", transferConfig.getAdvancedOptions().isCompatibilityMode(), output);
            }
            if (accessType == AccessType.FTPS) {
                DeploymentTroubleInfoCollector.appendEntry("Protect data chanel", transferConfig.getAdvancedOptions().getDataChannelProtectionLevel().getPresentableValue(), output);
            }
            if (accessType == AccessType.FTP || accessType == AccessType.FTPS) {
                DeploymentTroubleInfoCollector.appendEntry("Passive mode", transferConfig.getAdvancedOptions().isPassiveMode(), output);
                DeploymentTroubleInfoCollector.appendEntry("Show and process hidden files", transferConfig.getAdvancedOptions().isShowHiddenFiles(), output);
                DeploymentTroubleInfoCollector.appendEntry("Retrieve accurate files timestamps", transferConfig.getAdvancedOptions().getAccurateTimestamps().name(), output);
                DeploymentTroubleInfoCollector.appendEntry("Use keep alive command", transferConfig.getAdvancedOptions().getKeepAliveFtpCommand().getCommand(), output);
                DeploymentTroubleInfoCollector.appendEntry("Always use LIST command", transferConfig.getAdvancedOptions().isForceListCommand(), output);
            }
            DeploymentTroubleInfoCollector.appendEntry("Control encoding", transferConfig.getAdvancedOptions().getControlEncoding(), output);
            int connections = transferConfig.getAdvancedOptions().getMaxConnections();
            DeploymentTroubleInfoCollector.appendEntry("Limit concurrent connections", connections == Integer.MAX_VALUE ? 0 : connections, output);
            DeploymentTroubleInfoCollector.appendEntry("Send keep alive messages each (s)", transferConfig.getAdvancedOptions().getKeepAliveTimeout() / 1000, output);
        }
    }

    public static void appendEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(5);
        }
        output.append(key).append(" : ").append(value).append("\n");
    }

    private static void appendEntry(@Nullable String key, int value, @NotNull StringBuilder output) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(6);
        }
        DeploymentTroubleInfoCollector.appendEntry(key, String.valueOf(value), output);
    }

    private static void appendEntry(@Nullable String key, boolean value, @NotNull StringBuilder output) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(7);
        }
        DeploymentTroubleInfoCollector.appendEntry(key, String.valueOf(value), output);
    }

    private static void appendEscapedEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(8);
        }
        output.append(key).append(" : \"").append(value).append("\"\n");
    }

    private static void appendEscapedMappingEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(9);
        }
        output.append("\"").append(key).append("\" : \"").append(value).append("\"\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/DeploymentTroubleInfoCollector";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/DeploymentTroubleInfoCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectDeployment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeServerStatus";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendEntry";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedEntry";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedMappingEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

