/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.internal.corext.template.java.IJavaContext;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class NameResolver
extends TemplateVariableResolver {
    private final String fDefaultType;

    public NameResolver() {
        this("java.lang.Object");
    }

    NameResolver(String defaultType) {
        this.fDefaultType = defaultType;
    }

    public void resolve(TemplateVariable variable, TemplateContext context) {
        List params = variable.getVariableType().getParams();
        String param = params.size() == 0 ? this.fDefaultType : (String)params.get(0);
        IJavaContext jc = (IJavaContext)context;
        TemplateVariable ref = jc.getTemplateVariable(param);
        MultiVariable mv = (MultiVariable)variable;
        if (ref instanceof MultiVariable) {
            MultiVariable refVar = (MultiVariable)ref;
            jc.addDependency(refVar, mv);
            refVar.getAllChoices();
            Object[] types = this.flatten(refVar.getAllChoices());
            int i = 0;
            while (i < types.length) {
                Object[] names = jc.suggestVariableNames(mv.toString(types[i]));
                mv.setChoices(types[i], names);
                ++i;
            }
            mv.setKey(refVar.getCurrentChoice());
            jc.markAsUsed(mv.getDefaultValue());
        } else {
            jc.addImport(param);
            Object[] names = jc.suggestVariableNames(param);
            mv.setChoices(names);
            jc.markAsUsed((String)names[0]);
        }
    }

    private Object[] flatten(Object[][] allValues) {
        ArrayList<Object> flattened = new ArrayList<Object>(allValues.length);
        int i = 0;
        while (i < allValues.length) {
            flattened.addAll(Arrays.asList(allValues[i]));
            ++i;
        }
        return flattened.toArray(new Object[flattened.size()]);
    }
}

