/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ui.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tips.core.ITipManager;
import org.eclipse.tips.core.internal.LogUtil;
import org.eclipse.tips.core.internal.TipManager;
import org.eclipse.tips.ui.internal.Messages;
import org.eclipse.tips.ui.internal.TipDialog;

public abstract class DefaultTipManager
extends TipManager {
    private TipDialog fTipDialog;

    public ITipManager open(boolean startUp) {
        return this.open(startUp, null);
    }

    public ITipManager open(boolean startUp, IDialogSettings dialogSettings) {
        if (this.isOpen() && !this.isDialogOpen()) {
            this.setOpen(false);
        } else if (this.isOpen() && this.isDialogOpen()) {
            if (this.fTipDialog.getShell().getMinimized()) {
                this.fTipDialog.getShell().setMinimized(false);
            }
            this.fTipDialog.getShell().forceActive();
            return this;
        }
        try {
            Assert.isTrue((!this.isOpen() ? 1 : 0) != 0, (String)Messages.DefaultTipManager_0);
        }
        catch (Exception e) {
            this.log(LogUtil.error(((Object)((Object)this)).getClass(), (Throwable)e));
            throw e;
        }
        if (!this.mustOpen(startUp)) {
            return this;
        }
        this.setOpen(true);
        this.fTipDialog = new TipDialog(Display.getCurrent().getActiveShell(), this, -1, dialogSettings);
        this.fTipDialog.open();
        this.fTipDialog.getShell().addDisposeListener(pE -> this.dispose());
        return this;
    }

    private boolean isDialogOpen() {
        return this.fTipDialog != null && this.fTipDialog.getShell() != null && !this.fTipDialog.getShell().isDisposed();
    }

    private boolean mustOpen(boolean startUp) {
        if (!startUp) {
            return true;
        }
        if (startUp && this.getStartupBehavior() == 0) {
            return this.hasContent();
        }
        return false;
    }
}

