/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.action.file;

import java.io.InputStream;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionException;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.file.TGSongPersistenceActionBase;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGSongReaderHandle;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.util.TGContext;

public class TGReadSongAction
extends TGSongPersistenceActionBase {
    public static final String NAME = "action.song.read";
    public static final String ATTRIBUTE_INPUT_STREAM = InputStream.class.getName();

    public TGReadSongAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        try {
            InputStream stream = (InputStream)context.getAttribute(ATTRIBUTE_INPUT_STREAM);
            TGFileFormat tgFileFormat = (TGFileFormat)context.getAttribute(ATTRIBUTE_FORMAT);
            TGSongManager tgSongManager = this.getSongManager(context);
            TGSongReaderHandle tgSongLoaderHandle = new TGSongReaderHandle();
            tgSongLoaderHandle.setFactory(tgSongManager.getFactory());
            tgSongLoaderHandle.setFormat(tgFileFormat);
            tgSongLoaderHandle.setInputStream(stream);
            tgSongLoaderHandle.setContext(this.findSongStreamContext(context));
            tgSongLoaderHandle.getContext().setAttribute("mimeType", context.getAttribute("mimeType"));
            tgSongLoaderHandle.getContext().setAttribute("formatCode", context.getAttribute("formatCode"));
            TGFileFormatManager.getInstance((TGContext)this.getContext()).read(tgSongLoaderHandle);
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)tgSongLoaderHandle.getSong());
            context.setAttribute(ATTRIBUTE_FORMAT, (Object)tgSongLoaderHandle.getFormat());
            TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
            tgActionManager.execute("action.song.load", context);
        }
        catch (TGFileFormatException e) {
            throw new TGActionException((Throwable)e);
        }
    }
}

